/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.DiskQueryRelay;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFilePointerCapableFileSystem;
import com.intellij.openapi.vfs.impl.local.FileWatcher;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemBase;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemEelUtil;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemTimestampEvaluator;
import com.intellij.openapi.vfs.impl.local.SymbolicLinkRefresher;
import com.intellij.openapi.vfs.impl.local.WatchRootsManager;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.BatchingFileSystem;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.PlatformNioHelper;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemDependent;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public class LocalFileSystemImpl
extends LocalFileSystemBase
implements Disposable,
BatchingFileSystem,
VirtualFilePointerCapableFileSystem {
    private static final Logger WATCH_ROOTS_LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.WatchRoots");
    private static final int STATUS_UPDATE_PERIOD = 1000;
    private static final FileAttributes UNC_ROOT_ATTRIBUTES = new FileAttributes(true, false, false, false, 0L, 0L, false, FileAttributes.CaseSensitivity.INSENSITIVE);
    private final ManagingFS myManagingFS;
    private final FileWatcher myWatcher;
    private final WatchRootsManager myWatchRootsManager;
    private volatile boolean myDisposed;
    private final ThreadLocal<Pair<VirtualFile, Map<String, FileAttributes>>> myFileAttributesCache = new ThreadLocal();
    private final DiskQueryRelay<VirtualFile, String[]> myChildrenGetter = new DiskQueryRelay<VirtualFile, String[]>(dir -> LocalFileSystemImpl.listChildren(dir));
    private final DiskQueryRelay<VirtualFile, Object> myContentGetter = new DiskQueryRelay<VirtualFile, Object>(file2 -> LocalFileSystemImpl.readContent(file2));
    private final DiskQueryRelay<VirtualFile, FileAttributes> myAttributeGetter = new DiskQueryRelay<VirtualFile, FileAttributes>(file2 -> LocalFileSystemImpl.readAttributes(file2));
    private final DiskQueryRelay<Pair<VirtualFile, @Nullable Set<String>>, Map<String, FileAttributes>> myChildrenAttrGetter = new DiskQueryRelay<Pair, Map>(pair -> LocalFileSystemEelUtil.listWithAttributesUsingEel((VirtualFile)pair.first, (Set)pair.second));
    private final DiskQueryRelay<Pair<VirtualFile, String>, FileAttributes.CaseSensitivity> caseSensitivityGetter = new DiskQueryRelay<Pair, FileAttributes.CaseSensitivity>(it -> super.fetchCaseSensitivity((VirtualFile)it.first, (String)it.second));

    protected LocalFileSystemImpl() {
        this.myManagingFS = ManagingFS.getInstance();
        this.myWatcher = new FileWatcher(this.myManagingFS, () -> AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(() -> {
            Application application = ApplicationManager.getApplication();
            if (application != null && !application.isDisposed()) {
                this.storeRefreshStatusToFiles();
            }
        }, 1000L, 1000L, TimeUnit.MILLISECONDS));
        this.myWatchRootsManager = new WatchRootsManager(this.myWatcher, this);
        Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)this);
        new SymbolicLinkRefresher(this).refresh();
    }

    public void onDisconnecting() {
        this.myWatchRootsManager.clear();
    }

    @NotNull
    public FileWatcher getFileWatcher() {
        FileWatcher fileWatcher = this.myWatcher;
        if (fileWatcher == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(0);
        }
        return fileWatcher;
    }

    public void dispose() {
        this.myDisposed = true;
        this.myWatcher.dispose();
    }

    private void storeRefreshStatusToFiles() {
        if (this.myWatcher.isOperational()) {
            FileWatcher.DirtyPaths dirtyPaths = this.myWatcher.getDirtyPaths();
            boolean marked = this.markPathsDirty(dirtyPaths.dirtyPaths) | this.markFlatDirsDirty(dirtyPaths.dirtyDirectories) | this.markRecursiveDirsDirty(dirtyPaths.dirtyPathsRecursive);
            if (marked) {
                this.statusRefreshed();
            }
        }
    }

    protected void statusRefreshed() {
    }

    private boolean markPathsDirty(Iterable<String> dirtyPaths) {
        boolean marked = false;
        for (String dirtyPath : dirtyPaths) {
            VirtualFile file2 = this.findFileByPathIfCached(dirtyPath);
            if (!(file2 instanceof NewVirtualFile)) continue;
            NewVirtualFile nvf = (NewVirtualFile)file2;
            nvf.markDirty();
            marked = true;
        }
        return marked;
    }

    private boolean markFlatDirsDirty(Iterable<String> dirtyPaths) {
        boolean marked = false;
        for (String dirtyPath : dirtyPaths) {
            Pair exactOrParent = LocalFileSystemImpl.findCachedFileByPath((NewVirtualFileSystem)this, (String)dirtyPath);
            if (exactOrParent.first != null) {
                ((NewVirtualFile)exactOrParent.first).markDirty();
                for (VirtualFile child : ((NewVirtualFile)exactOrParent.first).getCachedChildren()) {
                    ((NewVirtualFile)child).markDirty();
                    marked = true;
                }
                continue;
            }
            if (exactOrParent.second == null) continue;
            ((NewVirtualFile)exactOrParent.second).markDirty();
            marked = true;
        }
        return marked;
    }

    private boolean markRecursiveDirsDirty(Iterable<String> dirtyPaths) {
        boolean marked = false;
        for (String dirtyPath : dirtyPaths) {
            Pair exactOrParent = LocalFileSystemImpl.findCachedFileByPath((NewVirtualFileSystem)this, (String)dirtyPath);
            if (exactOrParent.first != null) {
                ((NewVirtualFile)exactOrParent.first).markDirtyRecursively();
                marked = true;
                continue;
            }
            if (exactOrParent.second == null) continue;
            ((NewVirtualFile)exactOrParent.second).markDirty();
            marked = true;
        }
        return marked;
    }

    public void markSuspiciousFilesDirty(@NotNull List<? extends VirtualFile> files2) {
        if (files2 == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(1);
        }
        this.storeRefreshStatusToFiles();
        if (this.myWatcher.isOperational()) {
            for (String string : this.myWatcher.getManualWatchRoots()) {
                VirtualFile suspiciousRoot = this.findFileByPathIfCached(string);
                if (suspiciousRoot == null) continue;
                ((NewVirtualFile)suspiciousRoot).markDirtyRecursively();
            }
        } else {
            for (VirtualFile virtualFile2 : files2) {
                if (virtualFile2.getFileSystem() != this) continue;
                ((NewVirtualFile)virtualFile2).markDirtyRecursively();
            }
        }
    }

    @NotNull
    public @Unmodifiable @NotNull Iterable<@NotNull VirtualFile> findCachedFilesForPath(@NotNull String path) {
        if (path == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(2);
        }
        List list2 = ContainerUtil.mapNotNull(this.getAliasedPaths(path), path1 -> this.findFileByPathIfCached((String)path1));
        if (list2 == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(3);
        }
        return list2;
    }

    private List<@SystemDependent String> getAliasedPaths(String path) {
        path = FileUtil.toSystemDependentName((String)path);
        ArrayList<String> aliases = new ArrayList<String>(this.getFileWatcher().mapToAllSymlinks(path));
        assert (!aliases.contains(path));
        aliases.add(0, path);
        return aliases;
    }

    @NotNull
    public Set<LocalFileSystem.WatchRequest> replaceWatchedRoots(@NotNull Collection<LocalFileSystem.WatchRequest> watchRequestsToRemove, @Nullable Collection<String> recursiveRootsToAdd, @Nullable Collection<String> flatRootsToAdd) {
        if (watchRequestsToRemove == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(4);
        }
        if (this.myDisposed) {
            Set<LocalFileSystem.WatchRequest> set = Set.of();
            if (set == null) {
                LocalFileSystemImpl.$$$reportNull$$$0(5);
            }
            return set;
        }
        List nonNullWatchRequestsToRemove = ContainerUtil.skipNulls(watchRequestsToRemove);
        LOG.assertTrue(nonNullWatchRequestsToRemove.size() == watchRequestsToRemove.size(), (Object)"watch requests collection should not contain `null` elements");
        if ((recursiveRootsToAdd != null || flatRootsToAdd != null) && WATCH_ROOTS_LOG.isTraceEnabled()) {
            WATCH_ROOTS_LOG.trace((Throwable)new Exception("LocalFileSystemImpl#replaceWatchedRoots:\n  recursive: " + String.valueOf(recursiveRootsToAdd != null ? recursiveRootsToAdd : "[]") + "\n  flat: " + String.valueOf(flatRootsToAdd != null ? flatRootsToAdd : "[]")));
        }
        Set<LocalFileSystem.WatchRequest> set = this.myWatchRootsManager.replaceWatchedRoots(nonNullWatchRequestsToRemove, Objects.requireNonNullElse(recursiveRootsToAdd, List.of()), Objects.requireNonNullElse(flatRootsToAdd, List.of()));
        if (set == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(6);
        }
        return set;
    }

    public void refreshWithoutFileWatcher(boolean asynchronous) {
        Runnable heavyRefresh = () -> {
            for (VirtualFile root : this.myManagingFS.getRoots((NewVirtualFileSystem)this)) {
                ((NewVirtualFile)root).markDirtyRecursively();
            }
            this.refresh(asynchronous);
        };
        if (asynchronous && this.myWatcher.isOperational()) {
            RefreshQueue.getInstance().refresh(true, true, heavyRefresh, this.myManagingFS.getRoots((NewVirtualFileSystem)this));
        } else {
            heavyRefresh.run();
        }
    }

    @ApiStatus.Internal
    public final void symlinkUpdated(int fileId, @Nullable VirtualFile parent, @NotNull CharSequence name2, @NotNull String linkPath, @Nullable String linkTarget) {
        if (name2 == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(7);
        }
        if (linkPath == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(8);
        }
        if (linkTarget == null || !LocalFileSystemImpl.isRecursiveOrCircularSymlink(parent, name2, linkTarget)) {
            this.myWatchRootsManager.updateSymlink(fileId, linkPath, linkTarget);
        }
    }

    @ApiStatus.Internal
    public final void symlinkRemoved(int fileId) {
        this.myWatchRootsManager.removeSymlink(fileId);
    }

    @Override
    @TestOnly
    public void cleanupForNextTest() {
        super.cleanupForNextTest();
        this.myWatchRootsManager.clear();
    }

    private static boolean isRecursiveOrCircularSymlink(@Nullable VirtualFile parent, CharSequence name2, String symlinkTarget) {
        if (LocalFileSystemImpl.startsWith(parent, name2, symlinkTarget)) {
            return true;
        }
        if (!(parent instanceof VirtualFileSystemEntry)) {
            return false;
        }
        for (VirtualFileSystemEntry p = (VirtualFileSystemEntry)parent; p != null; p = p.getParent()) {
            String parentResolved;
            if (!p.thisOrParentHaveSymlink()) {
                return false;
            }
            if (!p.is(VFileProperty.SYMLINK) || !symlinkTarget.equals(parentResolved = p.getCanonicalPath())) continue;
            return true;
        }
        return false;
    }

    private static boolean startsWith(@Nullable VirtualFile parent, CharSequence name2, String symlinkTarget) {
        return parent != null ? VfsUtilCore.isAncestorOrSelf((String)StringUtil.trimEnd((String)symlinkTarget, (String)("/" + String.valueOf(name2))), (VirtualFile)parent) : StringUtil.equal((CharSequence)name2, (CharSequence)symlinkTarget, (boolean)SystemInfo.isFileSystemCaseSensitive);
    }

    @Override
    public String @NotNull [] list(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(9);
        }
        if (!file2.isDirectory()) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                LocalFileSystemImpl.$$$reportNull$$$0(10);
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String[] stringArray = this.myChildrenGetter.accessDiskWithCheckCanceled(file2);
        if (stringArray == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(11);
        }
        return stringArray;
    }

    @Override
    @NotNull
    public FileAttributes.CaseSensitivity fetchCaseSensitivity(@NotNull VirtualFile parent, @NotNull String childName) {
        if (parent == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(12);
        }
        if (childName == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(13);
        }
        FileAttributes.CaseSensitivity caseSensitivity = this.caseSensitivityGetter.accessDiskWithCheckCanceled((Pair<VirtualFile, String>)Pair.createNonNull((Object)parent, (Object)childName));
        if (caseSensitivity == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(14);
        }
        return caseSensitivity;
    }

    @Override
    public byte @NotNull [] contentsToByteArray(@NotNull VirtualFile file2) throws IOException {
        if (file2 == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(15);
        }
        if (SystemInfo.isUnix && file2.is(VFileProperty.SPECIAL)) {
            throw new NoSuchFileException(file2.getPath(), null, "Not a file");
        }
        Object result2 = this.myContentGetter.accessDiskWithCheckCanceled(file2);
        if (result2 instanceof IOException) {
            IOException e = (IOException)result2;
            throw e;
        }
        byte[] byArray = (byte[])result2;
        if (byArray == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(16);
        }
        return byArray;
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    public final String @NotNull [] listWithCaching(@NotNull VirtualFile dir, @Nullable Set<String> filter2) {
        Pair<VirtualFile, Map<String, FileAttributes>> cache2;
        if (dir == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(17);
        }
        if ((cache2 = this.myFileAttributesCache.get()) != null) {
            LOG.error("unordered access to " + String.valueOf(dir) + " without cleaning after " + String.valueOf(cache2.first));
        }
        Map<String, FileAttributes> result2 = this.myChildrenAttrGetter.accessDiskWithCheckCanceled((Pair<VirtualFile, Set<String>>)new Pair((Object)dir, filter2));
        this.myFileAttributesCache.set((Pair<VirtualFile, Map<String, FileAttributes>>)new Pair((Object)dir, result2));
        String[] stringArray = ArrayUtil.toStringArray(result2.keySet());
        if (stringArray == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(18);
        }
        return stringArray;
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    public void clearListCache() {
        this.myFileAttributesCache.remove();
    }

    @Override
    public FileAttributes getAttributes(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(19);
        }
        if (SystemInfo.isWindows && file2.getParent() == null && file2.getPath().startsWith("//")) {
            return UNC_ROOT_ATTRIBUTES;
        }
        Pair<VirtualFile, Map<String, FileAttributes>> cache2 = this.myFileAttributesCache.get();
        if (cache2 != null) {
            if (!((VirtualFile)cache2.first).equals(file2.getParent())) {
                LOG.error("unordered access to " + String.valueOf(file2) + " outside " + String.valueOf(cache2.first));
            } else {
                return (FileAttributes)((Map)cache2.second).get(file2.getName());
            }
        }
        return this.myAttributeGetter.accessDiskWithCheckCanceled(file2);
    }

    private static String[] listChildren(VirtualFile dir) {
        block11: {
            String[] stringArray;
            block10: {
                if (!dir.isDirectory()) {
                    return ArrayUtil.EMPTY_STRING_ARRAY;
                }
                DirectoryStream<Path> dirStream = Files.newDirectoryStream(Path.of(LocalFileSystemImpl.toIoPath(dir), new String[0]));
                try {
                    stringArray = (String[])StreamSupport.stream(dirStream.spliterator(), false).map(it -> it.getFileName().toString()).toArray(String[]::new);
                    if (dirStream == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (dirStream != null) {
                            try {
                                dirStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (AccessDeniedException | NoSuchFileException e) {
                        LOG.debug((Throwable)e);
                        break block11;
                    }
                    catch (IOException | RuntimeException e) {
                        LOG.warn((Throwable)e);
                    }
                }
                dirStream.close();
            }
            return stringArray;
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @NotNull
    public @NotNull Map<@NotNull String, @NotNull FileAttributes> listWithAttributes(@NotNull VirtualFile dir, @Nullable Set<String> childrenNames) {
        if (dir == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(20);
        }
        if (!dir.isDirectory()) {
            Map<String, FileAttributes> map2 = Collections.emptyMap();
            if (map2 == null) {
                LocalFileSystemImpl.$$$reportNull$$$0(21);
            }
            return map2;
        }
        Map<String, FileAttributes> map3 = this.myChildrenAttrGetter.accessDiskWithCheckCanceled((Pair<VirtualFile, Set<String>>)new Pair((Object)dir, childrenNames));
        if (map3 == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(22);
        }
        return map3;
    }

    private static Map<String, FileAttributes> listWithAttributesImpl(@NotNull VirtualFile dir, @Nullable Set<String> filter2) {
        if (dir == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(23);
        }
        if (!dir.isDirectory()) {
            return Collections.emptyMap();
        }
        return LocalFileSystemImpl.listWithAttributesImpl(Path.of(LocalFileSystemImpl.toIoPath(dir), new String[0]), filter2);
    }

    protected static Map<String, FileAttributes> listWithAttributesImpl(@NotNull Path dir, @Nullable Set<String> filter2) {
        if (dir == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(24);
        }
        try {
            int expectedSize = filter2 == null ? 10 : filter2.size();
            Map childrenWithAttributes = CollectionFactory.createFilePathMap((int)expectedSize, (boolean)true);
            PlatformNioHelper.visitDirectory(dir, filter2, (file2, ioAttributesHolder) -> {
                try {
                    FileAttributes attributes = LocalFileSystemImpl.amendAttributes(file2, FileAttributes.fromNio((Path)file2, (BasicFileAttributes)((BasicFileAttributes)ioAttributesHolder.get())));
                    childrenWithAttributes.put(file2.getFileName().toString(), attributes);
                }
                catch (Exception e) {
                    LOG.debug((Throwable)e);
                }
                return true;
            });
            return childrenWithAttributes;
        }
        catch (AccessDeniedException | NoSuchFileException e) {
            LOG.debug((Throwable)e);
        }
        catch (IOException | RuntimeException e) {
            LOG.warn((Throwable)e);
        }
        return Map.of();
    }

    private static Object readContent(VirtualFile file2) {
        try {
            Path nioFile = Path.of(LocalFileSystemImpl.toIoPath(file2), new String[0]);
            return LocalFileSystemImpl.readIfNotTooLarge(nioFile);
        }
        catch (IOException e) {
            return e;
        }
    }

    @Nullable
    private static FileAttributes readAttributes(VirtualFile file2) {
        try {
            Path nioFile = Path.of(LocalFileSystemImpl.toIoPath(file2), new String[0]);
            FileAttributes attributes = LocalFileSystemEelUtil.readAttributesUsingEel(nioFile);
            return LocalFileSystemImpl.amendAttributes(nioFile, attributes);
        }
        catch (NoSuchFileException e) {
            LOG.debug("File doesn't exist: " + e.getMessage());
        }
        catch (AccessDeniedException e) {
            LOG.debug((Throwable)e);
        }
        catch (IOException | RuntimeException e) {
            LOG.warn((Throwable)e);
        }
        return null;
    }

    private static FileAttributes amendAttributes(Path file2, FileAttributes attributes) {
        for (LocalFileSystemTimestampEvaluator provider : LocalFileSystemTimestampEvaluator.EP_NAME.getExtensionList()) {
            Long customTS = provider.getTimestamp(file2);
            if (customTS == null) continue;
            return attributes.withTimeStamp(customTS.longValue());
        }
        return attributes;
    }

    public String toString() {
        return "LocalFileSystem";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 7, 8, 9, 12, 13, 15, 17, 19, 20, 23, 24 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/local/LocalFileSystemImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watchRequestsToRemove";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkPath";
                break;
            }
            case 9: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childName";
                break;
            }
            case 17: 
            case 20: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileWatcher";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/local/LocalFileSystemImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findCachedFilesForPath";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceWatchedRoots";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchCaseSensitivity";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "listWithCaching";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "listWithAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "markSuspiciousFilesDirty";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findCachedFilesForPath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "replaceWatchedRoots";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "symlinkUpdated";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "fetchCaseSensitivity";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "contentsToByteArray";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "listWithCaching";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "listWithAttributes";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "listWithAttributesImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 7, 8, 9, 12, 13, 15, 17, 19, 20, 23, 24 -> new IllegalArgumentException(string);
        };
    }
}

