/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class CachedFileType {
    private static final ConcurrentMap<FileType, CachedFileType> ourInterner = new ConcurrentHashMap<FileType, CachedFileType>();
    private static final StampedLock ourInternerLock = new StampedLock();
    @Nullable
    private FileType fileType;

    private CachedFileType(@NotNull FileType fileType2) {
        if (fileType2 == null) {
            CachedFileType.$$$reportNull$$$0(0);
        }
        this.fileType = fileType2;
    }

    @Nullable
    FileType getUpToDateOrNull() {
        return this.fileType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CachedFileType forType(@NotNull FileType fileType2) {
        if (fileType2 == null) {
            CachedFileType.$$$reportNull$$$0(1);
        }
        long stamp = ourInternerLock.readLock();
        try {
            CachedFileType cachedFileType = ourInterner.computeIfAbsent(fileType2, CachedFileType::new);
            return cachedFileType;
        }
        finally {
            ourInternerLock.unlockRead(stamp);
        }
    }

    public static void clearCache() {
        long stamp = ourInternerLock.writeLock();
        try {
            ourInterner.forEach((type, cachedType) -> {
                cachedType.fileType = null;
            });
            ourInterner.clear();
        }
        finally {
            ourInternerLock.unlockWrite(stamp);
        }
    }

    @NotNull
    public static @NotNull Supplier<@NotNull Boolean> getFileTypeChangeChecker() {
        CachedFileType type = CachedFileType.forType((FileType)PlainTextFileType.INSTANCE);
        Supplier<Boolean> supplier = () -> type.getUpToDateOrNull() != null;
        if (supplier == null) {
            CachedFileType.$$$reportNull$$$0(2);
        }
        return supplier;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/impl/CachedFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/impl/CachedFileType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeChangeChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "forType";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    static final class ReparseListener
    implements BulkFileListener {
        ReparseListener() {
        }

        public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
            if (events == null) {
                ReparseListener.$$$reportNull$$$0(0);
            }
            for (VFileEvent vFileEvent : events) {
                if (!"FileContentUtilCore.saveOrReload".equals(vFileEvent.getRequestor())) continue;
                CachedFileType.clearCache();
                break;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/vfs/newvfs/impl/CachedFileType$ReparseListener", "after"));
        }
    }

    static final class PsiListener
    implements PsiModificationTracker.Listener {
        PsiListener() {
        }

        public void modificationCountChanged() {
            CachedFileType.clearCache();
        }
    }
}

