/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class FileDeletedException
extends RuntimeException {
    private final int deletedFileId;

    public FileDeletedException(int fileId) {
        super("file[#" + fileId + "] already is deleted");
        this.deletedFileId = fileId;
    }

    public FileDeletedException(int fileId, String message) {
        super("file[#" + fileId + "]: " + message);
        this.deletedFileId = fileId;
    }

    public FileDeletedException(int fileId, String message, Throwable cause) {
        super("file[#" + fileId + "]: " + message, cause);
        this.deletedFileId = fileId;
    }

    public int getDeletedFileId() {
        return this.deletedFileId;
    }
}

