/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent.mapped;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecordsImpl;
import com.intellij.openapi.vfs.newvfs.persistent.mapped.MappedFileStorageHelper;
import com.intellij.util.io.CleanableStorage;
import com.intellij.util.io.Unmappable;
import java.io.Closeable;
import java.io.IOException;
import java.util.function.IntUnaryOperator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class FastFileAttributes {
    private FastFileAttributes() {
        throw new AssertionError((Object)"Not for instantiation");
    }

    @NotNull
    public static Int4FileAttribute int4FileAttributes(@NotNull FSRecordsImpl vfs, @NotNull String storageName, int version) throws IOException {
        if (vfs == null) {
            FastFileAttributes.$$$reportNull$$$0(0);
        }
        if (storageName == null) {
            FastFileAttributes.$$$reportNull$$$0(1);
        }
        MappedFileStorageHelper helper = MappedFileStorageHelper.openHelperAndVerifyVersions(vfs, storageName, version, 16);
        Int4FileAttribute attribute = new Int4FileAttribute(helper);
        vfs.addCloseable(attribute);
        vfs.addFileIdIndexedStorage(attribute);
        Int4FileAttribute int4FileAttribute = attribute;
        if (int4FileAttribute == null) {
            FastFileAttributes.$$$reportNull$$$0(2);
        }
        return int4FileAttribute;
    }

    public static TimestampedBooleanAttributeAccessor timestampedBoolean(@NotNull FileAttribute attribute) throws IOException {
        if (attribute == null) {
            FastFileAttributes.$$$reportNull$$$0(3);
        }
        return FastFileAttributes.timestampedBoolean(FSRecords.getInstance(), attribute);
    }

    public static TimestampedBooleanAttributeAccessor timestampedBoolean(@NotNull FSRecordsImpl vfs, @NotNull FileAttribute attribute) throws IOException {
        if (vfs == null) {
            FastFileAttributes.$$$reportNull$$$0(4);
        }
        if (attribute == null) {
            FastFileAttributes.$$$reportNull$$$0(5);
        }
        MappedFileStorageHelper helper = MappedFileStorageHelper.openHelperAndVerifyVersions(vfs, attribute.getId(), attribute.getVersion(), 8);
        TimestampedBooleanAttributeAccessorImpl accessor = new TimestampedBooleanAttributeAccessorImpl(helper);
        vfs.addCloseable(accessor);
        vfs.addFileIdIndexedStorage(accessor);
        return accessor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vfs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/mapped/FastFileAttributes";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/mapped/FastFileAttributes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "int4FileAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "int4FileAttributes";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "timestampedBoolean";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static final class Int4FileAttribute
    implements FSRecordsImpl.FileIdIndexedStorage,
    Closeable,
    Unmappable,
    CleanableStorage {
        public static final int FIELDS = 4;
        public static final int ROW_SIZE = 16;
        private final MappedFileStorageHelper storageHelper;

        public Int4FileAttribute(@NotNull MappedFileStorageHelper helper) {
            if (helper == null) {
                Int4FileAttribute.$$$reportNull$$$0(0);
            }
            this.storageHelper = helper;
        }

        public int readField(@NotNull VirtualFile vFile, int fieldNo) throws IOException {
            if (vFile == null) {
                Int4FileAttribute.$$$reportNull$$$0(1);
            }
            return this.storageHelper.readIntField(vFile, Int4FileAttribute.fieldOffset(fieldNo));
        }

        public int readField(int fileId, int fieldNo) throws IOException {
            return this.storageHelper.readIntField(fileId, Int4FileAttribute.fieldOffset(fieldNo));
        }

        public void write(@NotNull VirtualFile vFile, int fieldNo, int value) throws IOException {
            if (vFile == null) {
                Int4FileAttribute.$$$reportNull$$$0(2);
            }
            this.storageHelper.writeIntField(vFile, Int4FileAttribute.fieldOffset(fieldNo), value);
        }

        public void write(int fileId, int fieldNo, int value) throws IOException {
            this.storageHelper.writeIntField(fileId, Int4FileAttribute.fieldOffset(fieldNo), value);
        }

        public void update(@NotNull VirtualFile vFile, int fieldNo, @NotNull IntUnaryOperator updater) throws IOException {
            if (vFile == null) {
                Int4FileAttribute.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                Int4FileAttribute.$$$reportNull$$$0(4);
            }
            this.storageHelper.updateIntField(vFile, Int4FileAttribute.fieldOffset(fieldNo), updater);
        }

        @Override
        public void clear(int fileId) throws IOException {
            this.storageHelper.writeIntField(fileId, 0, 0);
            this.storageHelper.writeIntField(fileId, 1, 0);
            this.storageHelper.writeIntField(fileId, 2, 0);
            this.storageHelper.writeIntField(fileId, 3, 0);
        }

        private static int fieldOffset(int fieldNo) {
            if (fieldNo < 0 || fieldNo >= 4) {
                throw new IllegalArgumentException("fieldNo(=" + fieldNo + ") must be in [0,4)");
            }
            return fieldNo * 4;
        }

        @Override
        public void close() throws IOException {
            this.storageHelper.close();
        }

        public void closeAndUnsafelyUnmap() throws IOException {
            this.storageHelper.closeAndUnsafelyUnmap();
        }

        public void closeAndClean() throws IOException {
            this.storageHelper.closeAndClean();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vFile";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/mapped/FastFileAttributes$Int4FileAttribute";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "readField";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "write";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface TimestampedBooleanAttributeAccessor {
        @Nullable
        public Boolean readIfActual(VirtualFile var1) throws IOException;

        public void write(VirtualFile var1, boolean var2) throws IOException;
    }

    private static final class TimestampedBooleanAttributeAccessorImpl
    implements TimestampedBooleanAttributeAccessor,
    FSRecordsImpl.FileIdIndexedStorage,
    Unmappable,
    CleanableStorage,
    Closeable {
        public static final int ROW_SIZE = 8;
        private final MappedFileStorageHelper storageHelper;

        private TimestampedBooleanAttributeAccessorImpl(MappedFileStorageHelper helper) {
            this.storageHelper = helper;
        }

        @Override
        @Nullable
        public Boolean readIfActual(VirtualFile vFile) throws IOException {
            boolean value;
            long stamp = vFile.getTimeStamp();
            long fieldValue = this.storageHelper.readLongField(vFile, 0);
            long timestamp = Math.abs(fieldValue);
            boolean bl = value = fieldValue < 0L;
            if (timestamp == stamp) {
                return value;
            }
            return null;
        }

        @Override
        public void write(VirtualFile vFile, boolean value) throws IOException {
            long stamp = vFile.getTimeStamp();
            long fieldValue = value ? -stamp : stamp;
            this.storageHelper.writeLongField(vFile, 0, fieldValue);
        }

        @Override
        public void clear(int fileId) throws IOException {
            this.storageHelper.writeLongField(fileId, 0, 0L);
        }

        @Override
        public void close() throws IOException {
            this.storageHelper.close();
        }

        public void closeAndUnsafelyUnmap() throws IOException {
            this.storageHelper.closeAndUnsafelyUnmap();
        }

        public void closeAndClean() throws IOException {
            this.storageHelper.closeAndClean();
        }
    }
}

