/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent.namecache;

import com.intellij.openapi.vfs.newvfs.persistent.namecache.FileNameCache;
import com.intellij.openapi.vfs.newvfs.persistent.namecache.SLRUFileNameCache;
import com.intellij.platform.diagnostic.telemetry.PlatformScopesKt;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.DataEnumeratorEx;
import io.opentelemetry.api.metrics.BatchCallback;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import java.io.IOException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class MRUFileNameCache
implements FileNameCache {
    private static final boolean TRACK_STATS = SystemProperties.getBooleanProperty((String)"vfs.name-cache.track-stats", (boolean)true);
    private static final int TRACK_EACH_NTH_LOOKUP_STATS = 64;
    private static final int TRACK_STATS_MASK = 63;
    private static final int TRACK_STATS_SALT = ThreadLocalRandom.current().nextInt(64);
    private static final int MRU_CACHE_SIZE = 73728;
    private final CacheEntryNameWithId[] mruCache;
    @NotNull
    private final DataEnumeratorEx<String> namesEnumerator;
    private final boolean checkFileNamesSanity;
    private final AtomicInteger cacheHitsCount;
    private final AtomicInteger cacheMissesCount;
    @Nullable
    private final BatchCallback otelHandlerToClose;

    public MRUFileNameCache(@NotNull DataEnumeratorEx<String> namesEnumerator) {
        if (namesEnumerator == null) {
            MRUFileNameCache.$$$reportNull$$$0(0);
        }
        this(namesEnumerator, SLRUFileNameCache.isFileNameSanityCheckEnabledByDefault());
    }

    public MRUFileNameCache(@NotNull DataEnumeratorEx<String> namesEnumerator, boolean checkFileNamesSanity) {
        if (namesEnumerator == null) {
            MRUFileNameCache.$$$reportNull$$$0(1);
        }
        this.mruCache = new CacheEntryNameWithId[73728];
        this.cacheHitsCount = new AtomicInteger();
        this.cacheMissesCount = new AtomicInteger();
        this.namesEnumerator = namesEnumerator;
        this.checkFileNamesSanity = checkFileNamesSanity;
        this.otelHandlerToClose = TRACK_STATS ? this.setupReportingToOpenTelemetry() : null;
    }

    @Override
    public int tryEnumerate(@NotNull String name2) throws IOException {
        int nameId;
        if (name2 == null) {
            MRUFileNameCache.$$$reportNull$$$0(2);
        }
        if ((nameId = this.namesEnumerator.tryEnumerate((Object)name2)) != 0) {
            this.cacheData(nameId, name2);
        }
        return nameId;
    }

    @Override
    public int enumerate(@NotNull String name2) throws IOException {
        if (name2 == null) {
            MRUFileNameCache.$$$reportNull$$$0(3);
        }
        if (this.checkFileNamesSanity) {
            SLRUFileNameCache.assertShortFileName(name2);
        }
        int nameId = this.namesEnumerator.enumerate((Object)name2);
        this.cacheData(nameId, name2);
        return nameId;
    }

    private void cacheData(int nameId, @Nullable String name2) {
        int mruCacheEntryIndex = MRUFileNameCache.toIndex(nameId);
        CacheEntryNameWithId entry = this.mruCache[mruCacheEntryIndex];
        if (entry != null && entry.nameId == nameId) {
            return;
        }
        this.mruCache[mruCacheEntryIndex] = new CacheEntryNameWithId(nameId, name2);
    }

    @Override
    @NotNull
    public String valueOf(int nameId) throws IOException {
        String name2;
        assert (nameId > 0) : nameId;
        boolean trackLookup = MRUFileNameCache.shouldTrackLookup(nameId);
        int mruCacheEntryIndex = MRUFileNameCache.toIndex(nameId);
        CacheEntryNameWithId entry = this.mruCache[mruCacheEntryIndex];
        if (entry != null && entry.nameId == nameId) {
            if (trackLookup) {
                this.cacheHitsCount.incrementAndGet();
            }
            String string = entry.name;
            if (string == null) {
                MRUFileNameCache.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (trackLookup) {
            this.cacheMissesCount.incrementAndGet();
        }
        if ((name2 = (String)this.namesEnumerator.valueOf(nameId)) == null) {
            throw new IOException("VFS name enumerator corrupted: nameId(=" + nameId + ") is not found in enumerator (=null)");
        }
        this.mruCache[mruCacheEntryIndex] = new CacheEntryNameWithId(nameId, name2);
        String string = name2;
        if (string == null) {
            MRUFileNameCache.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static boolean shouldTrackLookup(int nameId) {
        return TRACK_STATS && (nameId & 0x3F) == TRACK_STATS_SALT;
    }

    private static int toIndex(int nameId) {
        int hash = Math.abs(nameId * -1640531527);
        return hash % 73728;
    }

    @Override
    public void close() throws Exception {
        if (this.otelHandlerToClose != null) {
            this.otelHandlerToClose.close();
        }
    }

    private BatchCallback setupReportingToOpenTelemetry() {
        Meter meter = TelemetryManager.getInstance().getMeter(PlatformScopesKt.VFS);
        ObservableLongMeasurement queriesCounter = meter.counterBuilder("FileNameCache.queries").buildObserver();
        ObservableLongMeasurement totalMissesCounter = meter.counterBuilder("FileNameCache.totalMisses").buildObserver();
        return meter.batchCallback(() -> {
            long cacheMisses = this.cacheMissesCount.longValue() * 64L;
            long totalCacheRequestsServed = this.cacheHitsCount.longValue() * 64L + cacheMisses;
            queriesCounter.record(totalCacheRequestsServed);
            totalMissesCounter.record(cacheMisses);
        }, (ObservableMeasurement)queriesCounter, new ObservableMeasurement[]{totalMissesCounter});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namesEnumerator";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/namecache/MRUFileNameCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/namecache/MRUFileNameCache";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "valueOf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "tryEnumerate";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "enumerate";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }

    private static final class CacheEntryNameWithId {
        public final int nameId;
        public final String name;

        CacheEntryNameWithId(int nameId, String name2) {
            this.nameId = nameId;
            this.name = name2;
        }
    }
}

