/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.Objects;
import javax.swing.border.Border;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public abstract class ContentLayout {
    ToolWindowContentUi ui;
    BaseLabel idLabel;

    ContentLayout(@NotNull ToolWindowContentUi ui) {
        if (ui == null) {
            ContentLayout.$$$reportNull$$$0(0);
        }
        this.ui = ui;
    }

    public abstract void init(@NotNull ContentManager var1);

    public abstract void reset();

    public abstract void layout();

    public void paintComponent(Graphics g) {
    }

    public abstract void update();

    public abstract void rebuild();

    public abstract int getMinimumWidth();

    public void contentAdded(@NotNull ContentManagerEvent event) {
        if (event == null) {
            ContentLayout.$$$reportNull$$$0(1);
        }
    }

    public void contentRemoved(@NotNull ContentManagerEvent event) {
        if (event == null) {
            ContentLayout.$$$reportNull$$$0(2);
        }
    }

    protected void updateIdLabel(BaseLabel label2) {
        Border oldBorder;
        Object title2 = this.ui.window.getStripeTitle();
        String suffix = this.getTitleSuffix();
        if (ExperimentalUI.isNewUI()) {
            suffix = null;
        }
        if (suffix != null) {
            title2 = (String)title2 + suffix;
        }
        label2.setText((String)title2);
        Object border = JBUI.Borders.empty((int)0, (int)2, (int)0, (int)7);
        if (ExperimentalUI.isNewUI()) {
            Border border2 = border = this.shouldShowId() ? JBUI.Borders.empty((Insets)JBUI.CurrentTheme.ToolWindow.headerLabelLeftRightInsets()) : JBUI.Borders.empty((Insets)JBUI.CurrentTheme.ToolWindow.headerTabLeftRightInsets());
        }
        if ((oldBorder = label2.getBorder()) == null || !Objects.equals(oldBorder.getClass(), border.getClass()) || !oldBorder.getBorderInsets(label2).equals(border.getBorderInsets(label2))) {
            label2.setBorder((Border)border);
        }
        label2.setVisible(this.shouldShowId());
    }

    protected int getTabToolbarPreferredWidth() {
        ActionToolbar tabToolbar = this.ui.getTabToolbar();
        return tabToolbar == null ? 0 : tabToolbar.getComponent().getPreferredSize().width;
    }

    private String getTitleSuffix() {
        ContentManager manager2 = this.ui.getContentManager();
        return switch (manager2.getContentCount()) {
            case 0 -> null;
            case 1 -> {
                Content content = manager2.getContent(0);
                if (content == null) {
                    yield null;
                }
                String text = content.getDisplayName();
                if (text != null && !text.trim().isEmpty() && manager2.canCloseContents()) {
                    yield ":";
                }
                yield null;
            }
            default -> ":";
        };
    }

    public abstract void showContentPopup(ListPopup var1);

    @NlsActions.ActionText
    public abstract String getCloseActionName();

    @NlsActions.ActionText
    public abstract String getCloseAllButThisActionName();

    @NlsActions.ActionText
    public abstract String getPreviousContentActionName();

    @NlsActions.ActionText
    public abstract String getNextContentActionName();

    protected boolean shouldShowId() {
        Component component2 = ComponentUtil.findParentByCondition((Component)this.ui.getComponent(), c -> ClientProperty.get((Component)c, (Object)"HideIdLabel") != null);
        return component2 == null || !"true".equals(ClientProperty.get((Component)component2, (Object)"HideIdLabel"));
    }

    public boolean isIdVisible() {
        return this.idLabel.isVisible();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/wm/impl/content/ContentLayout";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "contentAdded";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "contentRemoved";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

