/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.CloseAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.UiCompatibleDataProvider;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.actionSystem.toolbarLayout.ToolbarLayoutStrategy;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.openapi.wm.impl.content.ComboContentLayout;
import com.intellij.openapi.wm.impl.content.ContentLayout;
import com.intellij.openapi.wm.impl.content.SelectContentStep;
import com.intellij.openapi.wm.impl.content.SingleContentLayout;
import com.intellij.openapi.wm.impl.content.SingleContentSupplier;
import com.intellij.openapi.wm.impl.content.TabContentLayout;
import com.intellij.openapi.wm.impl.content.ToolWindowInEditorSupport;
import com.intellij.toolWindow.InternalDecoratorImpl;
import com.intellij.toolWindow.ToolWindowEventSource;
import com.intellij.toolWindow.ToolWindowHeader;
import com.intellij.toolWindow.ToolWindowPane;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.MouseDragHelper;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.ContentUI;
import com.intellij.ui.content.TabGroupId;
import com.intellij.ui.content.TabbedContent;
import com.intellij.ui.content.tabs.PinToolwindowTabAction;
import com.intellij.ui.content.tabs.TabbedContentAction;
import com.intellij.ui.tabs.impl.MorePopupAware;
import com.intellij.util.Alarm;
import com.intellij.util.ContentUtilEx;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.LocationOnDragTracker;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ToolWindowContentUi
implements ContentUI,
UiCompatibleDataProvider {
    @NonNls
    public static final String HIDE_ID_LABEL = "HideIdLabel";
    @NonNls
    public static final Key<Boolean> DONT_HIDE_TOOLBAR_IN_HEADER = Key.create((String)"DontHideToolbarInHeader");
    @NonNls
    private static final String TOOLWINDOW_UI_INSTALLED = "ToolWindowUiInstalled";
    public static final DataKey<BaseLabel> SELECTED_CONTENT_TAB_LABEL = DataKey.create((String)"SELECTED_CONTENT_TAB_LABEL");
    @ApiStatus.Internal
    public static final String HEADER_ICON = "HeaderIcon";
    @ApiStatus.Internal
    public static final DataKey<ToolWindowContentUi> DATA_KEY = DataKey.create((String)"ToolWindowContentUi");
    @ApiStatus.Experimental
    public static final Key<Boolean> NOT_SELECTED_TAB_ICON_TRANSPARENT = Key.create((String)"NotSelectedIconTransparent");
    @NotNull
    private final ContentManager contentManager;
    int dropOverIndex;
    int dropOverWidth;
    private final JPanel contentComponent;
    final ToolWindowImpl window;
    private final TabContentLayout tabsLayout;
    private ContentLayout comboLayout;
    private ToolWindowContentUiType type;
    public Predicate<Point> isResizableArea;
    private final JPanel tabComponent;
    private final DefaultActionGroup tabActionGroup;
    private ActionToolbar tabToolbar;
    @Deprecated
    @NonNls
    public static final Key<Boolean> ALLOW_DND_FOR_TABS = Key.create((String)"AllowDragAndDropForTabs");
    private static final Key<ToolWindowInEditorSupport> TOOLWINDOW_IN_EDITOR_SUPPORT = Key.create((String)"ToolWindowInEditorSupport");

    @NotNull
    public ContentManager getContentManager() {
        ContentManager contentManager = this.contentManager;
        if (contentManager == null) {
            ToolWindowContentUi.$$$reportNull$$$0(0);
        }
        return contentManager;
    }

    public ToolWindowContentUi(final @NotNull ToolWindowImpl window, final @NotNull ContentManager contentManager, final @NotNull JPanel contentComponent) {
        if (window == null) {
            ToolWindowContentUi.$$$reportNull$$$0(1);
        }
        if (contentManager == null) {
            ToolWindowContentUi.$$$reportNull$$$0(2);
        }
        if (contentComponent == null) {
            ToolWindowContentUi.$$$reportNull$$$0(3);
        }
        this.dropOverIndex = -1;
        this.dropOverWidth = 0;
        this.isResizableArea = __ -> true;
        this.tabComponent = new TabPanel();
        this.tabActionGroup = new DefaultActionGroup();
        this.tabToolbar = null;
        this.contentManager = contentManager;
        this.type = window.getWindowInfo().getContentUiType();
        this.tabsLayout = new SingleContentLayout(this);
        this.window = window;
        this.contentComponent = contentComponent;
        this.getCurrentLayout().init(contentManager);
        this.getCurrentLayout().rebuild();
        final ContentManagerListener contentManagerListener = new ContentManagerListener(){
            private final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    if ("component".equals(event.getPropertyName())) {
                        ToolWindowContentUi.this.ensureSelectedContentVisible();
                    }
                    ToolWindowContentUi.this.update();
                }
            };

            public void contentAdded(@NotNull ContentManagerEvent event) {
                Content content2;
                ContentManager manager2;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((manager2 = (content2 = event.getContent()).getManager()) != null && !(content2 instanceof SingleContentLayout.SubContent)) {
                    Content mainContent;
                    JComponent component2;
                    SingleContentSupplier supplier;
                    List contents = manager2.getContentsRecursively();
                    List<Content> mainContents = contents.stream().filter(c -> !(c instanceof SingleContentLayout.SubContent)).toList();
                    List<Content> subContents = contents.stream().filter(c -> c instanceof SingleContentLayout.SubContent).toList();
                    if (mainContents.size() == 1 && (supplier = SingleContentSupplier.Companion.getSupplierFrom(component2 = (mainContent = mainContents.get(0)).getComponent())) != null && supplier.getSubContents().containsAll(subContents)) {
                        for (Content subContent : subContents) {
                            ContentManager m = subContent.getManager();
                            if (m != null) {
                                m.removeContent(subContent, false);
                            }
                            ((SingleContentLayout.SubContent)subContent).getInfo().setHidden(false);
                        }
                    }
                }
                ToolWindowContentUi.this.getCurrentLayout().contentAdded(event);
                content2.addPropertyChangeListener(this.propertyChangeListener);
                ToolWindowContentUi.this.rebuild();
                if (window.isToHideOnEmptyContent()) {
                    window.setAvailable(true);
                }
            }

            public void contentRemoved(@NotNull ContentManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (window.isDisposed() || window.toolWindowManager.getProject().isDisposed()) {
                    return;
                }
                Content content2 = event.getContent();
                if (!((Boolean)Content.TEMPORARY_REMOVED_KEY.get((UserDataHolder)content2, (Object)false)).booleanValue()) {
                    SingleContentSupplier.removeSubContentsOfContent(content2, false);
                }
                content2.removePropertyChangeListener(this.propertyChangeListener);
                ToolWindowContentUi.this.getCurrentLayout().contentRemoved(event);
                ToolWindowContentUi.this.ensureSelectedContentVisible();
                ToolWindowContentUi.this.rebuild();
                if (contentManager.isEmpty() && contentManager == window.getContentManager() && !((Boolean)Content.TEMPORARY_REMOVED_KEY.get((UserDataHolder)content2, (Object)false)).booleanValue()) {
                    boolean removeFromStripe;
                    if (window.isToHideOnEmptyContent()) {
                        removeFromStripe = true;
                    } else if (window.canCloseContents() && StatusText.getDefaultEmptyText().equals(window.getEmptyText().getText())) {
                        removeFromStripe = false;
                    } else {
                        return;
                    }
                    window.toolWindowManager.hideToolWindow(window.getId(), false, true, removeFromStripe, null);
                }
            }

            public void selectionChanged(@NotNull ContentManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                ToolWindowContentUi.this.ensureSelectedContentVisible();
                ToolWindowContentUi.this.update();
                contentComponent.revalidate();
                contentComponent.repaint();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/openapi/wm/impl/content/ToolWindowContentUi$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "selectionChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        contentManager.addContentManagerListener(contentManagerListener);
        Disposer.register((Disposable)window.getDisposable(), (Disposable)new Disposable(){

            public void dispose() {
                contentManager.removeContentManagerListener(contentManagerListener);
            }
        });
        ToolWindowContentUi.initMouseListeners(this.tabComponent, this, true);
        MouseDragHelper.setComponentDraggable((JComponent)this.tabComponent, (boolean)true);
    }

    @NotNull
    public String getToolWindowId() {
        String string = this.window.getId();
        if (string == null) {
            ToolWindowContentUi.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public ToolWindow getWindow() {
        ToolWindowImpl toolWindowImpl = this.window;
        if (toolWindowImpl == null) {
            ToolWindowContentUi.$$$reportNull$$$0(5);
        }
        return toolWindowImpl;
    }

    @NotNull
    public JPanel getTabComponent() {
        JPanel jPanel = this.tabComponent;
        if (jPanel == null) {
            ToolWindowContentUi.$$$reportNull$$$0(6);
        }
        return jPanel;
    }

    @NotNull
    public DefaultActionGroup getTabToolbarActions() {
        DefaultActionGroup defaultActionGroup = this.tabActionGroup;
        if (defaultActionGroup == null) {
            ToolWindowContentUi.$$$reportNull$$$0(7);
        }
        return defaultActionGroup;
    }

    @Nullable
    public ActionToolbar getTabToolbar() {
        return this.tabToolbar;
    }

    public void connectTabToolbar() {
        if (this.tabToolbar != null) {
            this.tabComponent.add(this.tabToolbar.getComponent());
        }
    }

    public void disconnectTabToolbar() {
        if (this.tabToolbar != null) {
            this.tabComponent.remove(this.tabToolbar.getComponent());
        }
    }

    private boolean isResizeable() {
        if (this.window.getType() == ToolWindowType.FLOATING || this.window.getType() == ToolWindowType.WINDOWED) {
            return false;
        }
        if (this.window.getAnchor() == ToolWindowAnchor.BOTTOM) {
            return true;
        }
        if (this.window.getAnchor() == ToolWindowAnchor.TOP || !this.window.isSplitMode()) {
            return false;
        }
        ToolWindowManagerImpl manager2 = this.window.toolWindowManager;
        for (String id2 : manager2.getIdsOn(this.window.getAnchor())) {
            ToolWindow window;
            if (id2.equals(this.window.getId()) || (window = manager2.getToolWindow(id2)) == null || !window.isVisible() || window.getType() != ToolWindowType.DOCKED && window.getType() != ToolWindowType.SLIDING) continue;
            return true;
        }
        return false;
    }

    private boolean isResizeable(@NotNull Point point) {
        if (point == null) {
            ToolWindowContentUi.$$$reportNull$$$0(8);
        }
        return this.isResizableArea.test(point);
    }

    public void setType(@NotNull ToolWindowContentUiType type) {
        if (type == null) {
            ToolWindowContentUi.$$$reportNull$$$0(9);
        }
        if (this.type == type) {
            return;
        }
        if (this.type != null) {
            this.getCurrentLayout().reset();
        }
        this.type = type;
        this.getCurrentLayout().init(this.contentManager);
        this.rebuild();
    }

    @ApiStatus.Internal
    @NotNull
    public ContentLayout getCurrentLayout() {
        if (this.type == ToolWindowContentUiType.TABBED) {
            TabContentLayout tabContentLayout = this.tabsLayout;
            if (tabContentLayout == null) {
                ToolWindowContentUi.$$$reportNull$$$0(10);
            }
            return tabContentLayout;
        }
        if (this.comboLayout == null) {
            this.comboLayout = new ComboContentLayout(this);
        }
        ContentLayout contentLayout = this.comboLayout;
        if (contentLayout == null) {
            ToolWindowContentUi.$$$reportNull$$$0(11);
        }
        return contentLayout;
    }

    public JComponent getComponent() {
        return this.contentComponent;
    }

    public void setManager(@NotNull ContentManager manager2) {
        if (manager2 == null) {
            ToolWindowContentUi.$$$reportNull$$$0(12);
        }
        throw new UnsupportedOperationException();
    }

    private void ensureSelectedContentVisible() {
        Component visible;
        Content selected = this.contentManager.getSelectedContent();
        if (selected == null) {
            this.contentComponent.removeAll();
            return;
        }
        if (this.contentComponent.getComponentCount() == 1 && (visible = this.contentComponent.getComponent(0)) == selected.getComponent()) {
            return;
        }
        JComponent replacement = (JComponent)selected.getUserData(Content.REPLACEMENT_COMPONENT);
        JComponent newComponent = replacement != null ? replacement : selected.getComponent();
        this.contentComponent.removeAll();
        this.contentComponent.add((Component)newComponent, "Center");
        this.contentComponent.revalidate();
        this.contentComponent.repaint();
    }

    public void dropCaches() {
        this.tabsLayout.dropCaches();
    }

    @ApiStatus.Internal
    public void rebuild() {
        this.getCurrentLayout().rebuild();
        this.getCurrentLayout().update();
        this.tabComponent.revalidate();
        this.tabComponent.repaint();
    }

    public void update() {
        this.getCurrentLayout().update();
        this.getCurrentLayout().layout();
        this.tabComponent.revalidate();
        this.tabComponent.repaint();
    }

    public boolean isSingleSelection() {
        return true;
    }

    public boolean isToSelectAddedContent() {
        return false;
    }

    public boolean canBeEmptySelection() {
        return false;
    }

    public boolean canChangeSelectionTo(@NotNull Content content2, boolean implicit) {
        if (content2 == null) {
            ToolWindowContentUi.$$$reportNull$$$0(13);
        }
        return true;
    }

    @NotNull
    public String getCloseActionName() {
        String string = this.getCurrentLayout().getCloseActionName();
        if (string == null) {
            ToolWindowContentUi.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public String getCloseAllButThisActionName() {
        String string = this.getCurrentLayout().getCloseAllButThisActionName();
        if (string == null) {
            ToolWindowContentUi.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public String getPreviousContentActionName() {
        String string = this.getCurrentLayout().getPreviousContentActionName();
        if (string == null) {
            ToolWindowContentUi.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public String getNextContentActionName() {
        String string = this.getCurrentLayout().getNextContentActionName();
        if (string == null) {
            ToolWindowContentUi.$$$reportNull$$$0(17);
        }
        return string;
    }

    public void setTabDoubleClickActions(@NotNull List<AnAction> actions) {
        if (actions == null) {
            ToolWindowContentUi.$$$reportNull$$$0(18);
        }
        this.tabsLayout.setTabDoubleClickActions(actions);
    }

    public static void initMouseListeners(final @NotNull JComponent c, final @NotNull ToolWindowContentUi ui, final boolean allowResize) {
        if (c == null) {
            ToolWindowContentUi.$$$reportNull$$$0(19);
        }
        if (ui == null) {
            ToolWindowContentUi.$$$reportNull$$$0(20);
        }
        if (c.getClientProperty(TOOLWINDOW_UI_INSTALLED) != null) {
            return;
        }
        MouseAdapter mouseAdapter2 = new MouseAdapter(){
            final Ref<Point> myLastPoint = Ref.create();
            final Ref<Point> myPressPoint = Ref.create();
            final Ref<Integer> myInitialHeight = Ref.create((Object)0);
            final Ref<Boolean> myIsLastComponent = Ref.create();
            final Ref<LocationOnDragTracker> myDragTracker = Ref.create();

            private Component getActualSplitter() {
                if (!allowResize || !ui.isResizeable()) {
                    return null;
                }
                Container component2 = c;
                for (Container parent = component2.getParent(); parent != null; parent = parent.getParent()) {
                    if (parent instanceof ThreeComponentsSplitter && ((ThreeComponentsSplitter)parent).getOrientation() && component2 != ((ThreeComponentsSplitter)parent).getFirstComponent()) {
                        return parent;
                    }
                    if (parent instanceof Splitter && ((Splitter)parent).isVertical() && ((Splitter)parent).getSecondComponent() == component2 && ((Splitter)parent).getFirstComponent() != null) {
                        return parent;
                    }
                    if (parent instanceof ToolWindowPane) {
                        return parent;
                    }
                    component2 = parent;
                }
                return null;
            }

            private void arm(Component c2) {
                Component component2;
                Component component3 = component2 = c2 != null ? this.getActualSplitter() : null;
                if (component2 instanceof ThreeComponentsSplitter) {
                    ThreeComponentsSplitter splitter2 = (ThreeComponentsSplitter)component2;
                    this.myIsLastComponent.set((Object)SwingUtilities.isDescendingFrom(c2, splitter2.getLastComponent()));
                    this.myInitialHeight.set((Object)((Boolean)this.myIsLastComponent.get() != false ? splitter2.getLastSize() : splitter2.getFirstSize()));
                    return;
                }
                if (component2 instanceof Splitter) {
                    Splitter splitter3 = (Splitter)component2;
                    this.myIsLastComponent.set((Object)true);
                    this.myInitialHeight.set((Object)splitter3.getSecondComponent().getHeight());
                    return;
                }
                if (component2 instanceof ToolWindowPane) {
                    this.myIsLastComponent.set((Object)(ui.window.getAnchor() == ToolWindowAnchor.BOTTOM || ui.window.getAnchor() == ToolWindowAnchor.RIGHT ? 1 : 0));
                    this.myInitialHeight.set((Object)(ui.window.getAnchor().isHorizontal() ? ui.window.getDecorator().getHeight() : ui.window.getDecorator().getWidth()));
                    return;
                }
                this.myIsLastComponent.set(null);
                this.myInitialHeight.set(null);
                this.myPressPoint.set(null);
                this.myDragTracker.set(null);
            }

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (e.isPopupTrigger() || UIUtil.isCloseClick((MouseEvent)e)) {
                    return;
                }
                if (!this.isToolWindowDrag(e)) {
                    this.myLastPoint.set((Object)e.getLocationOnScreen());
                    this.myPressPoint.set((Object)((Point)this.myLastPoint.get()));
                    this.myDragTracker.set((Object)LocationOnDragTracker.startDrag((MouseEvent)e));
                    if (allowResize && ui.isResizeable()) {
                        this.arm(c.getComponentAt(e.getPoint()) == c && ui.isResizeable(e.getPoint()) ? c : null);
                    }
                }
                ui.window.fireActivated(ToolWindowEventSource.ToolWindowHeader);
            }

            @Override
            public void mouseReleased(@NotNull MouseEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (!e.isPopupTrigger()) {
                    if (UIUtil.isCloseClick((MouseEvent)e, (int)502)) {
                        ui.processHide(e);
                    }
                    this.arm(null);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (this.isToolWindowDrag(e)) {
                    c.setCursor(Cursor.getDefaultCursor());
                    return;
                }
                c.setCursor(allowResize && ui.isResizeable() && this.getActualSplitter() != null && c.getComponentAt(e.getPoint()) == c && ui.isResizeable(e.getPoint()) ? Cursor.getPredefinedCursor(8) : Cursor.getDefaultCursor());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                c.setCursor(null);
            }

            private boolean isToolWindowDrag(MouseEvent e) {
                if (!AdvancedSettings.getBoolean((String)"ide.tool.window.header.dnd")) {
                    return false;
                }
                Component realMouseTarget = SwingUtilities.getDeepestComponentAt(e.getComponent(), e.getX(), e.getY());
                InternalDecoratorImpl decorator = InternalDecoratorImpl.findTopLevelDecorator(realMouseTarget);
                if (decorator == null || ui.window.getType() == ToolWindowType.FLOATING || ui.window.getType() == ToolWindowType.WINDOWED) {
                    return false;
                }
                return ui.window.getAnchor() != ToolWindowAnchor.BOTTOM || SwingUtilities.convertMouseEvent(e.getComponent(), e, (Component)((Object)decorator)).getY() > ToolWindowPane.Companion.getHeaderResizeArea();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                ThreeComponentsSplitter splitter2;
                if (this.myLastPoint.isNull() || this.myPressPoint.isNull() || this.myDragTracker.isNull()) {
                    return;
                }
                Point newMouseLocation = e.getLocationOnScreen();
                Window window = SwingUtilities.windowForComponent(c);
                if (!(window instanceof IdeFrame)) {
                    ((LocationOnDragTracker)this.myDragTracker.get()).updateLocationOnDrag((Component)window, newMouseLocation);
                }
                this.myLastPoint.set((Object)newMouseLocation);
                Component component2 = this.getActualSplitter();
                if (this.isToolWindowDrag(e)) {
                    return;
                }
                if (component2 instanceof ThreeComponentsSplitter) {
                    splitter2 = (ThreeComponentsSplitter)component2;
                    if (this.myIsLastComponent.get() == Boolean.TRUE) {
                        splitter2.setLastSize((Integer)this.myInitialHeight.get() + ((Point)this.myPressPoint.get()).y - ((Point)this.myLastPoint.get()).y);
                    } else {
                        splitter2.setFirstSize((Integer)this.myInitialHeight.get() + ((Point)this.myLastPoint.get()).y - ((Point)this.myPressPoint.get()).y);
                    }
                }
                if (component2 instanceof Splitter) {
                    splitter2 = (Splitter)component2;
                    splitter2.setProportion(Math.max(0.0f, Math.min(1.0f, 1.0f - (float)((Integer)this.myInitialHeight.get() + ((Point)this.myPressPoint.get()).y - ((Point)this.myLastPoint.get()).y) / (float)splitter2.getHeight())));
                }
                if (component2 instanceof ToolWindowPane) {
                    if (ui.window.getType() == ToolWindowType.SLIDING) {
                        ui.window.getDecorator().updateBounds(e);
                    } else {
                        Dimension size2 = ui.window.getDecorator().getSize();
                        if (ui.window.getAnchor().isHorizontal()) {
                            size2.height = (Integer)this.myInitialHeight.get() - ((Point)this.myLastPoint.get()).y + ((Point)this.myPressPoint.get()).y;
                        }
                        ui.window.getDecorator().setSize(size2);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/openapi/wm/impl/content/ToolWindowContentUi$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mousePressed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mouseReleased";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        c.addMouseMotionListener(mouseAdapter2);
        c.addMouseListener(mouseAdapter2);
        c.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                Content content2 = c instanceof BaseLabel ? ((BaseLabel)c).getContent() : null;
                ui.showContextMenu(comp, x, y, ui.window.createPopupGroup(false), content2);
            }
        });
        c.putClientProperty(TOOLWINDOW_UI_INSTALLED, Boolean.TRUE);
    }

    private void initActionGroup(@NotNull DefaultActionGroup group2, @Nullable Content content2) {
        TabGroupId groupId;
        if (group2 == null) {
            ToolWindowContentUi.$$$reportNull$$$0(21);
        }
        if (content2 == null) {
            return;
        }
        ActionManager actionManager = ActionManager.getInstance();
        group2.addSeparator();
        group2.add((AnAction)new TabbedContentAction.CloseAction(content2));
        group2.add(actionManager.getAction("TW.CloseAllTabs"));
        group2.add(actionManager.getAction("TW.CloseOtherTabs"));
        group2.addSeparator();
        if (this.window.canSplitTabs()) {
            group2.add(actionManager.getAction("TW.SplitRight"));
            group2.add(actionManager.getAction("TW.SplitAndMoveRight"));
            group2.add(actionManager.getAction("TW.SplitDown"));
            group2.add(actionManager.getAction("TW.SplitAndMoveDown"));
            group2.add(actionManager.getAction("TW.Unsplit"));
            group2.addSeparator();
        }
        if (content2.isPinnable()) {
            group2.add(PinToolwindowTabAction.getPinAction());
            group2.addSeparator();
        }
        group2.add(actionManager.getAction("NextTab"));
        group2.add(actionManager.getAction("PreviousTab"));
        group2.add(actionManager.getAction("ShowContent"));
        if (content2 instanceof TabbedContent && ((TabbedContent)content2).hasMultipleTabs()) {
            group2.addAction(ToolWindowContentUi.createSplitTabsAction((TabbedContent)content2));
        }
        if (Boolean.TRUE == content2.getUserData(Content.TABBED_CONTENT_KEY) && (groupId = (TabGroupId)content2.getUserData(Content.TAB_GROUP_ID_KEY)) != null) {
            group2.addAction(ToolWindowContentUi.createMergeTabsAction(this.contentManager, groupId));
        }
        group2.addSeparator();
    }

    public void showContextMenu(Component comp, int x, int y, ActionGroup toolWindowGroup, @Nullable Content selectedContent) {
        if (selectedContent == null && toolWindowGroup == null) {
            return;
        }
        DefaultActionGroup configuredGroup = (DefaultActionGroup)ActionManager.getInstance().getAction("ToolWindowContextMenu");
        DefaultActionGroup group2 = new DefaultActionGroup();
        group2.copyFromGroup(configuredGroup);
        if (selectedContent != null) {
            this.initActionGroup(group2, selectedContent);
        }
        if (toolWindowGroup != null) {
            group2.add((AnAction)toolWindowGroup);
        }
        ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("ToolwindowPopup", (ActionGroup)group2);
        popupMenu.getComponent().show(comp, x, y);
    }

    @NotNull
    private static AnAction createSplitTabsAction(final @NotNull TabbedContent content2) {
        if (content2 == null) {
            ToolWindowContentUi.$$$reportNull$$$0(22);
        }
        return new DumbAwareAction(IdeBundle.message((String)"action.text.split.group", (Object[])new Object[]{content2.getTitlePrefix()})){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                content2.split();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/content/ToolWindowContentUi$5", "actionPerformed"));
            }
        };
    }

    @NotNull
    private static AnAction createMergeTabsAction(final @NotNull ContentManager manager2, final @NotNull TabGroupId groupId) {
        if (manager2 == null) {
            ToolWindowContentUi.$$$reportNull$$$0(23);
        }
        if (groupId == null) {
            ToolWindowContentUi.$$$reportNull$$$0(24);
        }
        return new DumbAwareAction(IdeBundle.message((String)"action.text.merge.tabs.to.group", (Object[])new Object[]{groupId.getDisplayName()})){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                ContentUtilEx.mergeTabs(manager2, groupId);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/content/ToolWindowContentUi$6", "actionPerformed"));
            }
        };
    }

    private void processHide(@NotNull MouseEvent e) {
        if (e == null) {
            ToolWindowContentUi.$$$reportNull$$$0(25);
        }
        IdeEventQueue.getInstance().blockNextEvents(e);
        Component c = e.getComponent();
        if (c instanceof BaseLabel) {
            BaseLabel tab = (BaseLabel)c;
            if (tab.getContent() != null) {
                if (this.contentManager.canCloseContents() && tab.getContent().isCloseable()) {
                    this.contentManager.removeContent(tab.getContent(), true, true, true);
                } else if (this.contentManager.getContentCount() == 1) {
                    this.hideWindow(e);
                }
            } else {
                this.hideWindow(e);
            }
        } else {
            this.hideWindow(e);
        }
    }

    private void hideWindow(@NotNull MouseEvent e) {
        if (e == null) {
            ToolWindowContentUi.$$$reportNull$$$0(26);
        }
        if (e.isControlDown()) {
            this.window.fireHiddenSide(ToolWindowEventSource.ToolWindowHeaderAltClick);
        } else {
            this.window.fireHidden(ToolWindowEventSource.ToolWindowHeader);
        }
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            ToolWindowContentUi.$$$reportNull$$$0(27);
        }
        sink.set(PlatformDataKeys.TOOL_WINDOW, (Object)this.window);
        sink.set(PlatformCoreDataKeys.HELP_ID, (Object)this.window.getHelpId());
        sink.set(CommonDataKeys.PROJECT, (Object)this.window.toolWindowManager.getProject());
        sink.set(CloseAction.CloseTarget.KEY, (Object)ToolWindowContentUi.computeCloseTarget(this.window));
        ContentLayout contentLayout = this.getCurrentLayout();
        if (contentLayout instanceof MorePopupAware) {
            MorePopupAware o = (MorePopupAware)contentLayout;
            sink.set(MorePopupAware.KEY_TOOLWINDOW_TITLE, (Object)o);
        }
        if (this.type == ToolWindowContentUiType.TABBED) {
            sink.set(SELECTED_CONTENT_TAB_LABEL, (Object)this.tabsLayout.findTabLabelByContent(this.contentManager.getSelectedContent()));
        }
    }

    public void setTabActions(@NotNull List<AnAction> actions) {
        if (actions == null) {
            ToolWindowContentUi.$$$reportNull$$$0(28);
        }
        if (this.tabToolbar == null) {
            this.tabToolbar = ActionManager.getInstance().createActionToolbar("ToolwindowTitle", (ActionGroup)new DefaultActionGroup(new AnAction[]{this.tabActionGroup}), true);
            ActionToolbarImpl tabToolbarImpl = (ActionToolbarImpl)this.tabToolbar;
            ToolWindowHeader header = (ToolWindowHeader)((Object)ComponentUtil.getParentOfType(ToolWindowHeader.class, (Component)this.tabComponent));
            tabToolbarImpl.setTargetComponent((JComponent)((Object)header));
            tabToolbarImpl.setForceMinimumSize(true);
            tabToolbarImpl.setLayoutStrategy(ToolbarLayoutStrategy.NOWRAP_STRATEGY);
            tabToolbarImpl.setReservePlaceAutoPopupIcon(false);
            tabToolbarImpl.setOpaque(false);
            tabToolbarImpl.setBorder((Border)JBUI.Borders.empty());
            if (this.tabComponent.isShowing()) {
                this.tabComponent.add(tabToolbarImpl);
            }
        }
        this.tabActionGroup.removeAll();
        this.tabActionGroup.addSeparator();
        this.tabActionGroup.addAll(actions);
        if (this.tabComponent.isShowing()) {
            this.tabToolbar.updateActionsAsync();
        }
    }

    @ApiStatus.Internal
    @NotNull
    public static CloseAction.CloseTarget computeCloseTarget(@NotNull ToolWindow toolWindow2) {
        Content selected;
        ContentManager contentManager;
        if (toolWindow2 == null) {
            ToolWindowContentUi.$$$reportNull$$$0(29);
        }
        if ((contentManager = toolWindow2.getContentManager()).canCloseContents() && (selected = contentManager.getSelectedContent()) != null && selected.isCloseable()) {
            return new CloseContentTarget(selected);
        }
        return new HideToolwindowTarget(toolWindow2);
    }

    boolean isCurrent(ContentLayout layout2) {
        return this.getCurrentLayout() == layout2;
    }

    public static void toggleContentPopup(@NotNull ToolWindowContentUi content2, @NotNull ContentManager contentManager) {
        if (content2 == null) {
            ToolWindowContentUi.$$$reportNull$$$0(30);
        }
        if (contentManager == null) {
            ToolWindowContentUi.$$$reportNull$$$0(31);
        }
        SelectContentStep step2 = new SelectContentStep(contentManager.getContents());
        Content selectedContent = contentManager.getSelectedContent();
        if (selectedContent != null) {
            step2.setDefaultOptionIndex(contentManager.getIndexOfContent(selectedContent));
        }
        ListPopup popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step2);
        content2.getCurrentLayout().showContentPopup(popup2);
        if (selectedContent instanceof TabbedContent) {
            new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)popup2).addRequest(() -> popup2.handleSelect(false), 50);
        }
    }

    public void setDropInfoIndex(int dropIndex, int dropWidth) {
        if (dropIndex != this.dropOverIndex || dropWidth != this.dropOverWidth) {
            this.dropOverIndex = dropIndex;
            this.dropOverWidth = dropWidth;
            this.dropCaches();
            this.rebuild();
        }
    }

    @ApiStatus.Internal
    public Boolean isActive() {
        return UIUtil.isFocusAncestor((Component)this.contentComponent);
    }

    @Deprecated
    public static void setAllowTabsReordering(@NotNull ToolWindow toolWindow2, boolean allow) {
        if (toolWindow2 == null) {
            ToolWindowContentUi.$$$reportNull$$$0(32);
        }
        toolWindow2.setTabsSplittingAllowed(allow);
    }

    @Deprecated
    public static boolean isTabsReorderingAllowed(@NotNull ToolWindow window) {
        if (window == null) {
            ToolWindowContentUi.$$$reportNull$$$0(33);
        }
        return window.canSplitTabs();
    }

    @ApiStatus.Internal
    public static void setToolWindowInEditorSupport(@NotNull ToolWindow window, @Nullable ToolWindowInEditorSupport support) {
        if (window == null) {
            ToolWindowContentUi.$$$reportNull$$$0(34);
        }
        window.getComponent().putClientProperty(TOOLWINDOW_IN_EDITOR_SUPPORT, support);
    }

    @ApiStatus.Internal
    public static ToolWindowInEditorSupport getToolWindowInEditorSupport(@NotNull ToolWindow window) {
        if (window == null) {
            ToolWindowContentUi.$$$reportNull$$$0(35);
        }
        return (ToolWindowInEditorSupport)ClientProperty.get((Component)window.getComponent(), TOOLWINDOW_IN_EDITOR_SUPPORT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 8, 9, 12, 13, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/content/ToolWindowContentUi";
                break;
            }
            case 1: 
            case 33: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 2: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentComponent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 13: 
            case 22: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 18: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentManager";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/content/ToolWindowContentUi";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindowId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getWindow";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabToolbarActions";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentLayout";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCloseActionName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getCloseAllButThisActionName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviousContentActionName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextContentActionName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isResizeable";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setManager";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "canChangeSelectionTo";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setTabDoubleClickActions";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "initMouseListeners";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "initActionGroup";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createSplitTabsAction";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createMergeTabsAction";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processHide";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "hideWindow";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setTabActions";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "computeCloseTarget";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "toggleContentPopup";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setAllowTabsReordering";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isTabsReorderingAllowed";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "setToolWindowInEditorSupport";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getToolWindowInEditorSupport";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 8, 9, 12, 13, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35 -> new IllegalArgumentException(string);
        };
    }

    public final class TabPanel
    extends NonOpaquePanel
    implements UISettingsListener {
        private TabPanel() {
            this.setBorder((Border)JBUI.Borders.emptyRight((int)2));
            if (ExperimentalUI.isNewUI()) {
                this.setBorder((Border)JBUI.Borders.empty());
            }
        }

        public void uiSettingsChanged(@NotNull UISettings uiSettings) {
            if (uiSettings == null) {
                TabPanel.$$$reportNull$$$0(0);
            }
            this.revalidate();
            this.repaint();
        }

        public void doLayout() {
            ToolWindowContentUi.this.getCurrentLayout().layout();
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            ToolWindowContentUi.this.getCurrentLayout().paintComponent(g);
        }

        public Dimension getMinimumSize() {
            Insets insets = this.getInsets();
            return new Dimension(insets.left + insets.right + ToolWindowContentUi.this.getCurrentLayout().getMinimumWidth(), super.getMinimumSize().height);
        }

        public Dimension getPreferredSize() {
            Dimension size2 = new Dimension();
            size2.height = 0;
            size2.width = this.getTabLayoutStart() + this.getInsets().left + this.getInsets().right;
            for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
                Component each = this.getComponent(i2);
                if (!each.isVisible() && (ToolWindowContentUi.this.tabToolbar == null || each != ToolWindowContentUi.this.tabToolbar.getComponent())) continue;
                size2.height = Math.max(each.getPreferredSize().height, size2.height);
                size2.width += each.getPreferredSize().width;
            }
            size2.width = Math.max(size2.width, this.getMinimumSize().width);
            return size2;
        }

        private int getTabLayoutStart() {
            if (ToolWindowContentUi.this.type == ToolWindowContentUiType.TABBED) {
                return ToolWindowContentUi.this.tabsLayout.getTabLayoutStart();
            }
            return TabContentLayout.defaultTabLayoutStart();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiSettings", "com/intellij/openapi/wm/impl/content/ToolWindowContentUi$TabPanel", "uiSettingsChanged"));
        }
    }

    private static final class CloseContentTarget
    implements CloseAction.CloseTarget {
        private final Content myContent;

        private CloseContentTarget(Content content2) {
            this.myContent = content2;
        }

        @Override
        public void close() {
            ContentManager contentManager = this.myContent.getManager();
            if (contentManager != null) {
                contentManager.removeContent(this.myContent, true, true, true);
            }
        }
    }

    private static final class HideToolwindowTarget
    implements CloseAction.CloseTarget {
        private final ToolWindow myToolWindow;

        private HideToolwindowTarget(ToolWindow toolWindow2) {
            this.myToolWindow = toolWindow2;
        }

        @Override
        public void close() {
            ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myToolWindow.getProject());
            if (toolWindowManager instanceof ToolWindowManagerImpl) {
                ToolWindowManagerImpl impl = (ToolWindowManagerImpl)toolWindowManager;
                impl.hideToolWindow(this.myToolWindow.getId(), false, true, false, ToolWindowEventSource.CloseAction);
            }
        }
    }
}

