/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.updateSettings.impl.UpdateCheckerFacade;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.wm.WelcomeScreen;
import com.intellij.openapi.wm.impl.welcomeScreen.BottomLineBorder;
import com.intellij.openapi.wm.impl.welcomeScreen.FlatWelcomeFrame;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomePane;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenColors;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.components.ActionLink;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;

public final class NewWelcomeScreen
extends JPanel
implements WelcomeScreen {
    public NewWelcomeScreen() {
        super(new BorderLayout());
        this.add((Component)NewWelcomeScreen.createHeaderPanel(), "North");
        this.add((Component)NewWelcomeScreen.createFooterPanel(), "South");
        this.add((Component)NewWelcomeScreen.createInnerPanel(this), "Center");
    }

    private static WelcomePane createInnerPanel(WelcomeScreen screen) {
        WelcomeScreenGroup root = new WelcomeScreenGroup(null, IdeBundle.message((String)"welcome.screen.quick.start.action.text", (Object[])new Object[0]), new AnAction[0]);
        ActionManager actionManager = ActionManager.getInstance();
        ActionGroup quickStart = (ActionGroup)actionManager.getAction("WelcomeScreen.QuickStart");
        for (AnAction child : quickStart.getChildren(null)) {
            root.add(child);
        }
        root.add((AnAction)NewWelcomeScreen.buildRootGroup(AllIcons.General.Settings, IdeBundle.message((String)"welcome.screen.configure.action.text", (Object[])new Object[0]), "WelcomeScreen.Configure"));
        root.add((AnAction)NewWelcomeScreen.buildRootGroup(AllIcons.Actions.Help, IdeBundle.message((String)"welcome.screen.action.docs.how.tos.action.text", (Object[])new Object[0]), "WelcomeScreen.Documentation"));
        return new WelcomePane((ActionGroup)root, screen);
    }

    private static WelcomeScreenGroup buildRootGroup(@NotNull Icon groupIcon, @NotNull @NlsActions.ActionText String groupText, @NotNull String groupId) {
        if (groupIcon == null) {
            NewWelcomeScreen.$$$reportNull$$$0(0);
        }
        if (groupText == null) {
            NewWelcomeScreen.$$$reportNull$$$0(1);
        }
        if (groupId == null) {
            NewWelcomeScreen.$$$reportNull$$$0(2);
        }
        WelcomeScreenGroup result2 = new WelcomeScreenGroup(groupIcon, groupText, new AnAction[0]);
        ActionGroup docsActions = (ActionGroup)ActionManager.getInstance().getAction(groupId);
        for (AnAction child : docsActions.getChildren(null)) {
            result2.add(child);
        }
        return result2;
    }

    private static JPanel createFooterPanel() {
        JLabel versionLabel = new JLabel(IdeBundle.message((String)"label.version.0.1.build.2", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName(), ApplicationInfo.getInstance().getFullVersion(), ApplicationInfo.getInstance().getBuild().asStringWithoutProductCode()}));
        NewWelcomeScreen.makeSmallFont(versionLabel);
        versionLabel.setForeground(WelcomeScreenColors.FOOTER_FOREGROUND);
        JPanel footerPanel = new JPanel(new FlowLayout(0, 0, 0));
        footerPanel.setBackground(WelcomeScreenColors.FOOTER_BACKGROUND);
        footerPanel.setBorder(new EmptyBorder(2, 5, 2, 5){

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                g.setColor(WelcomeScreenColors.BORDER_COLOR);
                g.drawLine(x, y, x + width, y);
            }
        });
        footerPanel.add(versionLabel);
        footerPanel.add(NewWelcomeScreen.makeSmallFont(new JLabel(".  ")));
        footerPanel.add(NewWelcomeScreen.makeSmallFont((JComponent)new ActionLink(IdeBundle.message((String)"link.check", (Object[])new Object[0]), e -> UpdateCheckerFacade.getInstance().updateAndShowResult(null))));
        footerPanel.add(NewWelcomeScreen.makeSmallFont(new JLabel(IdeBundle.message((String)"welcome.screen.check.for.updates.comment", (Object[])new Object[0]))));
        return footerPanel;
    }

    private static JComponent makeSmallFont(JComponent label2) {
        label2.setFont(label2.getFont().deriveFont(10.0f));
        return label2;
    }

    private static JPanel createHeaderPanel() {
        JPanel header = new JPanel(new BorderLayout());
        JLabel welcome = new JLabel(IdeBundle.message((String)"label.welcome.to.0", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()}), IconLoader.getIcon((String)ApplicationInfoEx.getInstanceEx().getApplicationSvgIconUrl(), (ClassLoader)NewWelcomeScreen.class.getClassLoader()), 2);
        welcome.setBorder(new EmptyBorder(10, 15, 10, 15));
        welcome.setFont(welcome.getFont().deriveFont(32.0f));
        welcome.setIconTextGap(20);
        welcome.setForeground(WelcomeScreenColors.WELCOME_HEADER_FOREGROUND);
        header.add(welcome);
        header.setBackground(WelcomeScreenColors.WELCOME_HEADER_BACKGROUND);
        header.setBorder(new BottomLineBorder());
        return header;
    }

    public JComponent getWelcomePanel() {
        return this;
    }

    public void setupFrame(JFrame frame) {
        frame.setResizable(false);
        frame.pack();
        Point location = DimensionService.getInstance().getLocation("WELCOME_SCREEN", null);
        Rectangle screenBounds = ScreenUtil.getScreenRectangle((Point)(location != null ? location : new Point(0, 0)));
        frame.setLocation(new Point(screenBounds.x + (screenBounds.width - frame.getWidth()) / 2, screenBounds.y + (screenBounds.height - frame.getHeight()) / 3));
    }

    public void dispose() {
    }

    public static boolean isNewWelcomeScreen(@NotNull AnActionEvent e) {
        if (e == null) {
            NewWelcomeScreen.$$$reportNull$$$0(3);
        }
        return "WelcomeScreen".equals(e.getPlace());
    }

    public static void updateNewProjectIconIfWelcomeScreen(@NotNull AnActionEvent e) {
        if (e == null) {
            NewWelcomeScreen.$$$reportNull$$$0(4);
        }
        if (NewWelcomeScreen.isNewWelcomeScreen(e)) {
            Presentation presentation2 = e.getPresentation();
            presentation2.setIcon(AllIcons.General.Add);
            if (FlatWelcomeFrame.USE_TABBED_WELCOME_SCREEN) {
                presentation2.setIcon(AllIcons.Welcome.CreateNewProjectTab);
                presentation2.setSelectedIcon(AllIcons.Welcome.CreateNewProjectTabSelected);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupIcon";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupText";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/wm/impl/welcomeScreen/NewWelcomeScreen";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildRootGroup";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isNewWelcomeScreen";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "updateNewProjectIconIfWelcomeScreen";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class WelcomeScreenGroup
    extends DefaultActionGroup {
        private WelcomeScreenGroup(Icon icon2, @NlsActions.ActionText String text2, AnAction ... actions) {
            super(text2, true);
            for (AnAction action2 : actions) {
                this.add(action2);
            }
            this.getTemplatePresentation().setText(text2);
            this.getTemplatePresentation().setIcon(icon2);
        }
    }
}

