/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.formatting.CoreFormatterUtil;
import com.intellij.formatting.FormatTextRange;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormatterEx;
import com.intellij.formatting.FormatterTagHandler;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.FormattingProgressCallback;
import com.intellij.formatting.FormattingProgressCallbackFactory;
import com.intellij.formatting.InjectedFormattingOptionsProvider;
import com.intellij.formatting.VirtualFormattingImplKt;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.VirtualFormattingListener;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.DocumentBasedFormattingModel;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeFormattingData;
import com.intellij.psi.impl.source.codeStyle.ContextFormattingRangesExtender;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.TextRangeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CodeFormatterFacade {
    private static final Logger LOG = Logger.getInstance(CodeFormatterFacade.class);
    private final CodeStyleSettings mySettings;
    private final FormatterTagHandler myTagHandler;
    private final boolean myCanChangeWhitespaceOnly;
    public static final ThreadLocal<Boolean> FORMATTING_CANCELLED_FLAG = ThreadLocal.withInitial(() -> false);

    public CodeFormatterFacade(CodeStyleSettings settings, @Nullable Language language) {
        this(settings, language, false);
    }

    public CodeFormatterFacade(CodeStyleSettings settings, @Nullable Language language, boolean canChangeWhitespaceOnly) {
        this.mySettings = settings;
        this.myTagHandler = new FormatterTagHandler(settings);
        this.myCanChangeWhitespaceOnly = canChangeWhitespaceOnly;
    }

    public ASTNode processElement(ASTNode element) {
        TextRange range = element.getTextRange();
        return this.processRange(element, range.getStartOffset(), range.getEndOffset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ASTNode processRange(ASTNode element, int startOffset, int endOffset) {
        FormattingModelBuilder builder;
        PsiElement psiElement = SourceTreeToPsiMap.treeElementToPsi((ASTNode)element);
        assert (psiElement != null);
        PsiFile file2 = psiElement.getContainingFile();
        Document document2 = file2.getViewProvider().getDocument();
        boolean delegateToTopLevel = CodeFormatterFacade.shouldDelegateToTopLevel(document2, file2);
        PsiElement elementToFormat = delegateToTopLevel ? InjectedLanguageManager.getInstance((Project)file2.getProject()).getTopLevelFile((PsiElement)file2) : psiElement;
        PsiFile fileToFormat = elementToFormat.getContainingFile();
        VirtualFormattingListener listener2 = VirtualFormattingImplKt.getVirtualFormattingListener((PsiElement)file2);
        try {
            if (listener2 != null) {
                VirtualFormattingImplKt.setVirtualFormattingListener((PsiElement)fileToFormat, listener2);
            }
            builder = LanguageFormatting.INSTANCE.forContext((PsiElement)fileToFormat);
        }
        finally {
            if (listener2 != null) {
                VirtualFormattingImplKt.setVirtualFormattingListener((PsiElement)fileToFormat, null);
            }
        }
        if (builder != null) {
            RangeMarker rangeMarker = null;
            CodeFormattingData codeFormattingData = CodeFormattingData.getOrCreate(fileToFormat);
            try {
                if (document2 != null && endOffset < document2.getTextLength()) {
                    rangeMarker = document2.createRangeMarker(startOffset, endOffset);
                }
                TextRange range = this.preprocess(codeFormattingData, element, TextRange.create((int)startOffset, (int)endOffset));
                if (delegateToTopLevel) {
                    range = ((DocumentWindow)document2).injectedToHost(range);
                }
                FormattingModel model2 = CoreFormatterUtil.buildModel(builder, elementToFormat, range, this.mySettings, FormattingMode.REFORMAT);
                if (file2.getTextLength() > 0) {
                    try {
                        FormatTextRanges ranges = new FormatTextRanges(range, true);
                        this.setDisabledRanges(fileToFormat, ranges);
                        FormatterEx.getInstanceEx().format(model2, this.mySettings, CodeFormatterFacade.getIndentOptions(this.mySettings, file2.getProject(), file2, document2, range), ranges);
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
                if (!psiElement.isValid()) {
                    if (rangeMarker != null) {
                        PsiElement at = file2.findElementAt(rangeMarker.getStartOffset());
                        PsiElement result2 = PsiTreeUtil.getParentOfType((PsiElement)at, (Class)psiElement.getClass(), (boolean)false);
                        assert (result2 != null);
                        rangeMarker.dispose();
                        ASTNode aSTNode = result2.getNode();
                        return aSTNode;
                    }
                    assert (false);
                }
            }
            finally {
                if (rangeMarker != null) {
                    rangeMarker.dispose();
                }
                codeFormattingData.dispose();
            }
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processText(@NotNull PsiFile file2, FormatTextRanges ranges, boolean doPostponedFormatting) {
        FormattingModelBuilder builder;
        if (file2 == null) {
            CodeFormatterFacade.$$$reportNull$$$0(0);
        }
        Project project2 = file2.getProject();
        Document document2 = file2.getViewProvider().getDocument();
        List<FormatTextRange> textRanges = ranges.getRanges();
        if (document2 instanceof DocumentWindow) {
            DocumentWindow documentWindow = (DocumentWindow)document2;
            if (CodeFormatterFacade.shouldDelegateToTopLevel(file2)) {
                file2 = InjectedLanguageManager.getInstance((Project)file2.getProject()).getTopLevelFile((PsiElement)file2);
                for (FormatTextRange range : textRanges) {
                    range.setTextRange(documentWindow.injectedToHost(range.getTextRange()));
                }
                document2 = documentWindow.getDelegate();
            }
        }
        if ((builder = LanguageFormatting.INSTANCE.forContext((PsiElement)file2)) != null && file2.getTextLength() > 0) {
            LOG.assertTrue(document2 != null);
            if (ranges.isExtendToContext()) {
                ranges.setExtendedRanges(new ContextFormattingRangesExtender(document2, file2).getExtendedRanges(ranges.getTextRanges()));
            }
            CodeFormattingData formattingData = CodeFormattingData.getOrCreate(file2);
            try {
                FormattingProgressCallback progressCallback;
                ASTNode containingNode = CodeFormatterFacade.findContainingNode(file2, ranges.getBoundRange());
                if (containingNode != null) {
                    for (FormatTextRange range : ranges.getRanges()) {
                        TextRange rangeToUse = this.preprocess(formattingData, containingNode, range.getTextRange());
                        range.setTextRange(rangeToUse);
                    }
                }
                if (doPostponedFormatting) {
                    CodeFormatterFacade.invokePostponedFormatting(file2, document2, textRanges);
                }
                if (FORMATTING_CANCELLED_FLAG.get().booleanValue()) {
                    return;
                }
                TextRange formattingModelRange = (TextRange)ObjectUtils.notNull((Object)ranges.getBoundRange(), (Object)file2.getTextRange());
                FormattingModel originalModel = CoreFormatterUtil.buildModel(builder, (PsiElement)file2, formattingModelRange, this.mySettings, FormattingMode.REFORMAT);
                DocumentBasedFormattingModel model2 = new DocumentBasedFormattingModel(originalModel, document2, project2, this.mySettings, file2.getFileType(), file2);
                FormatterEx formatter2 = FormatterEx.getInstanceEx();
                if (CodeStyleManager.getInstance((Project)project2).isSequentialProcessingAllowed() && (progressCallback = FormattingProgressCallbackFactory.getInstance().createProgressCallback(project2, file2, document2)) != null) {
                    formatter2.setProgressTask(progressCallback);
                }
                CommonCodeStyleSettings.IndentOptions indentOptions = CodeFormatterFacade.getIndentOptions(this.mySettings, project2, file2, document2, textRanges.size() == 1 ? textRanges.get(0).getTextRange() : null);
                this.setDisabledRanges(file2, ranges);
                formatter2.format((FormattingModel)model2, this.mySettings, indentOptions, ranges);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
            finally {
                formattingData.dispose();
            }
        }
    }

    @NotNull
    static CommonCodeStyleSettings.IndentOptions getIndentOptions(@NotNull CodeStyleSettings settings, @NotNull Project project2, @NotNull PsiFile psiFile, @Nullable Document document2, @Nullable TextRange textRange) {
        VirtualFile virtualFile2;
        if (settings == null) {
            CodeFormatterFacade.$$$reportNull$$$0(1);
        }
        if (project2 == null) {
            CodeFormatterFacade.$$$reportNull$$$0(2);
        }
        if (psiFile == null) {
            CodeFormatterFacade.$$$reportNull$$$0(3);
        }
        CommonCodeStyleSettings.IndentOptions indentOptions = (virtualFile2 = CodeFormatterFacade.getVirtualFile(psiFile, document2)) != null ? settings.getIndentOptionsByFile(project2, virtualFile2, textRange) : settings.getIndentOptions(psiFile.getFileType());
        if (indentOptions == null) {
            CodeFormatterFacade.$$$reportNull$$$0(4);
        }
        return indentOptions;
    }

    @Nullable
    private static VirtualFile getVirtualFile(@NotNull PsiFile psiFile, @Nullable Document document2) {
        VirtualFile file2;
        if (psiFile == null) {
            CodeFormatterFacade.$$$reportNull$$$0(5);
        }
        if ((file2 = psiFile.getVirtualFile()) != null) {
            return file2;
        }
        if (document2 != null) {
            return FileDocumentManager.getInstance().getFile(document2);
        }
        return null;
    }

    private void setDisabledRanges(@NotNull PsiFile file2, FormatTextRanges ranges) {
        if (file2 == null) {
            CodeFormatterFacade.$$$reportNull$$$0(6);
        }
        Iterable excludedRangesIterable = TextRangeUtil.excludeRanges((TextRange)file2.getTextRange(), this.myTagHandler.getEnabledRanges((ASTNode)file2.getNode(), file2.getTextRange()));
        ranges.setDisabledRanges((Collection)excludedRangesIterable);
    }

    private static void invokePostponedFormatting(@NotNull PsiFile file2, Document document2, List<? extends FormatTextRange> textRanges) {
        if (file2 == null) {
            CodeFormatterFacade.$$$reportNull$$$0(7);
        }
        RangeMarker[] markers = new RangeMarker[textRanges.size()];
        int i2 = 0;
        for (FormatTextRange formatTextRange : textRanges) {
            TextRange textRange = formatTextRange.getTextRange();
            int start2 = textRange.getStartOffset();
            int end = textRange.getEndOffset();
            if (start2 < 0 || end <= start2 || end > document2.getTextLength()) continue;
            markers[i2] = document2.createRangeMarker(textRange);
            markers[i2].setGreedyToLeft(true);
            markers[i2].setGreedyToRight(true);
            ++i2;
        }
        PostprocessReformattingAspect component2 = PostprocessReformattingAspect.getInstance((Project)file2.getProject());
        FORMATTING_CANCELLED_FLAG.set(false);
        component2.doPostponedFormatting(file2.getViewProvider());
        i2 = 0;
        for (FormatTextRange formatTextRange : textRanges) {
            RangeMarker marker = markers[i2];
            if (marker != null) {
                formatTextRange.setTextRange(marker.getTextRange());
                marker.dispose();
            }
            ++i2;
        }
    }

    @Nullable
    static ASTNode findContainingNode(@NotNull PsiFile file2, @Nullable TextRange range) {
        if (file2 == null) {
            CodeFormatterFacade.$$$reportNull$$$0(8);
        }
        Language language = file2.getLanguage();
        if (range == null) {
            return null;
        }
        FileViewProvider viewProvider = file2.getViewProvider();
        PsiElement startElement = viewProvider.findElementAt(range.getStartOffset(), language);
        PsiElement endElement = viewProvider.findElementAt(range.getEndOffset() - 1, language);
        PsiElement commonParent = startElement != null && endElement != null ? PsiTreeUtil.findCommonParent((PsiElement)startElement, (PsiElement)endElement) : null;
        ASTNode node = null;
        if (commonParent != null) {
            node = commonParent.getNode();
            for (ASTNode parent = node.getTreeParent(); parent != null && parent.getTextRange().equals((Object)commonParent.getTextRange()); parent = parent.getTreeParent()) {
                node = parent;
            }
        }
        if (node == null) {
            node = file2.getNode();
        }
        return node;
    }

    private TextRange preprocess(@NotNull CodeFormattingData formattingData, @NotNull ASTNode node, @NotNull TextRange range) {
        if (formattingData == null) {
            CodeFormatterFacade.$$$reportNull$$$0(9);
        }
        if (node == null) {
            CodeFormatterFacade.$$$reportNull$$$0(10);
        }
        if (range == null) {
            CodeFormatterFacade.$$$reportNull$$$0(11);
        }
        TextRange result2 = range;
        PsiElement psi = node.getPsi();
        if (!psi.isValid()) {
            return result2;
        }
        PsiFile file2 = psi.getContainingFile();
        Set<TextRange> injectedFileRangesSet = formattingData.getInjectedRanges(range);
        if (!injectedFileRangesSet.isEmpty()) {
            ArrayList<TextRange> ranges = new ArrayList<TextRange>(injectedFileRangesSet);
            Collections.reverse(ranges);
            for (TextRange injectedFileRange : ranges) {
                TextRange initialInjectedRange;
                PsiFile injected;
                int startHostOffset = injectedFileRange.getStartOffset();
                int endHostOffset = injectedFileRange.getEndOffset();
                if (startHostOffset < range.getStartOffset() || endHostOffset > range.getEndOffset() || (injected = InjectedLanguageUtilBase.findInjectedPsiNoCommit((PsiFile)file2, (int)startHostOffset)) == null) continue;
                TextRange injectedRange = initialInjectedRange = TextRange.create((int)0, (int)injected.getTextLength());
                for (PreFormatProcessor processor2 : PreFormatProcessor.EP_NAME.getExtensionList()) {
                    if (!processor2.changesWhitespacesOnly() && this.myCanChangeWhitespaceOnly) continue;
                    injectedRange = processor2.process((ASTNode)injected.getNode(), injectedRange);
                }
                if ((initialInjectedRange.getStartOffset() <= injectedRange.getStartOffset() || initialInjectedRange.getStartOffset() <= 0) && (initialInjectedRange.getEndOffset() >= injectedRange.getEndOffset() || initialInjectedRange.getEndOffset() >= injected.getTextLength())) continue;
                range = TextRange.create((int)(range.getStartOffset() + injectedRange.getStartOffset() - initialInjectedRange.getStartOffset()), (int)(range.getEndOffset() + initialInjectedRange.getEndOffset() - injectedRange.getEndOffset()));
            }
        }
        if (!this.mySettings.FORMATTER_TAGS_ENABLED) {
            for (PreFormatProcessor processor3 : PreFormatProcessor.EP_NAME.getExtensionList()) {
                if (!processor3.changesWhitespacesOnly() && this.myCanChangeWhitespaceOnly) continue;
                result2 = processor3.process(node, result2);
            }
        } else {
            result2 = this.preprocessEnabledRanges(node, result2);
        }
        return result2;
    }

    private TextRange preprocessEnabledRanges(@NotNull ASTNode node, @NotNull TextRange range) {
        if (node == null) {
            CodeFormatterFacade.$$$reportNull$$$0(12);
        }
        if (range == null) {
            CodeFormatterFacade.$$$reportNull$$$0(13);
        }
        TextRange result2 = TextRange.create((int)range.getStartOffset(), (int)range.getEndOffset());
        List<TextRange> enabledRanges = this.myTagHandler.getEnabledRanges(node, result2);
        int delta = 0;
        for (TextRange enabledRange : enabledRanges) {
            enabledRange = enabledRange.shiftRight(delta);
            for (PreFormatProcessor processor2 : PreFormatProcessor.EP_NAME.getExtensionList()) {
                if (!processor2.changesWhitespacesOnly() && this.myCanChangeWhitespaceOnly) continue;
                TextRange processedRange = processor2.process(node, enabledRange);
                delta += processedRange.getLength() - enabledRange.getLength();
            }
        }
        result2 = result2.grown(delta);
        return result2;
    }

    public static boolean shouldDelegateToTopLevel(@NotNull PsiFile file2) {
        if (file2 == null) {
            CodeFormatterFacade.$$$reportNull$$$0(14);
        }
        for (InjectedFormattingOptionsProvider provider : InjectedFormattingOptionsProvider.EP_NAME.getExtensionList()) {
            Boolean result2 = provider.shouldDelegateToTopLevel(file2);
            if (result2 == null) continue;
            return result2;
        }
        return true;
    }

    static boolean shouldDelegateToTopLevel(Document document2, @NotNull PsiFile file2) {
        if (file2 == null) {
            CodeFormatterFacade.$$$reportNull$$$0(15);
        }
        return document2 instanceof DocumentWindow && CodeFormatterFacade.shouldDelegateToTopLevel(file2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/codeStyle/CodeFormatterFacade";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattingData";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/CodeFormatterFacade";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processText";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIndentOptions";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setDisabledRanges";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invokePostponedFormatting";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findContainingNode";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "preprocess";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "preprocessEnabledRanges";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "shouldDelegateToTopLevel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

