/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.statistics.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.psi.statistics.impl.StatisticsUnit;
import com.intellij.psi.statistics.impl.WrongFormatException;
import com.intellij.util.ScrambledInputStream;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t2\u0006\u0010\u0004\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u000b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"UNIT_COUNT", "", "loadUnit", "Lcom/intellij/psi/statistics/impl/StatisticsUnit;", "unitNumber", "getUnitNumber", "key1", "", "getPathToUnit", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "storeDir", "getStoreDir", "()Ljava/nio/file/Path;", "intellij.platform.ide.impl"})
public final class StatisticsManagerImplKt {
    private static final int UNIT_COUNT = 997;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final StatisticsUnit loadUnit(int unitNumber) {
        StatisticsUnit unit = new StatisticsUnit(unitNumber);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return unit;
        }
        Path path = StatisticsManagerImplKt.getPathToUnit(unitNumber);
        try {
            Intrinsics.checkNotNull((Object)path);
            OpenOption[] openOptionArray = new OpenOption[]{};
            InputStream inputStream = Files.newInputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
            Closeable closeable = inputStream;
            int n = 8192;
            closeable = new ScrambledInputStream(closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n));
            Throwable throwable = null;
            try {
                ScrambledInputStream it = (ScrambledInputStream)closeable;
                boolean bl = false;
                unit.read(it);
                Unit unit2 = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException iOException) {
        }
        catch (WrongFormatException wrongFormatException) {
            // empty catch block
        }
        return unit;
    }

    private static final int getUnitNumber(String key1) {
        return Math.abs(key1.hashCode() % 997);
    }

    private static final Path getPathToUnit(int unitNumber) {
        return StatisticsManagerImplKt.getStoreDir().resolve("unit." + unitNumber);
    }

    private static final Path getStoreDir() {
        Path path = PathManager.getSystemDir().resolve("stat");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    public static final /* synthetic */ int access$getUnitNumber(String key1) {
        return StatisticsManagerImplKt.getUnitNumber(key1);
    }

    public static final /* synthetic */ StatisticsUnit access$loadUnit(int unitNumber) {
        return StatisticsManagerImplKt.loadUnit(unitNumber);
    }

    public static final /* synthetic */ Path access$getPathToUnit(int unitNumber) {
        return StatisticsManagerImplKt.getPathToUnit(unitNumber);
    }
}

