/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serialization;

import com.amazon.ion.IonType;
import com.amazon.ion.IonWriter;
import com.intellij.serialization.BaseCollectionBinding;
import com.intellij.serialization.BindingInitializationContext;
import com.intellij.serialization.MutableAccessor;
import com.intellij.serialization.ReadContext;
import com.intellij.serialization.WriteContext;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J'\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t2\u0006\u0010\u0004\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\nH\u0016\u00a2\u0006\u0002\u0010\rJ \u0010\b\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u000bH\u0016J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u0013H\u0016J'\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t2\u0006\u0010\u0004\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\nH\u0002\u00a2\u0006\u0002\u0010\rR\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/serialization/ArrayBinding;", "Lcom/intellij/serialization/BaseCollectionBinding;", "itemClass", "Ljava/lang/Class;", "context", "Lcom/intellij/serialization/BindingInitializationContext;", "<init>", "(Ljava/lang/Class;Lcom/intellij/serialization/BindingInitializationContext;)V", "deserialize", "", "", "Lcom/intellij/serialization/ReadContext;", "hostObject", "(Lcom/intellij/serialization/ReadContext;Ljava/lang/Object;)[Ljava/lang/Object;", "", "property", "Lcom/intellij/serialization/MutableAccessor;", "serialize", "obj", "Lcom/intellij/serialization/WriteContext;", "readArray", "intellij.platform.objectSerializer"})
public final class ArrayBinding
extends BaseCollectionBinding {
    @NotNull
    private final Class<?> itemClass;

    public ArrayBinding(@NotNull Class<?> itemClass, @NotNull BindingInitializationContext context2) {
        Intrinsics.checkNotNullParameter(itemClass, (String)"itemClass");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(itemClass, context2);
        this.itemClass = itemClass;
    }

    @NotNull
    public Object[] deserialize(@NotNull ReadContext context2, @Nullable Object hostObject) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return this.readArray(context2, hostObject);
    }

    @Override
    public void deserialize(@NotNull Object hostObject, @NotNull MutableAccessor property, @NotNull ReadContext context2) {
        Intrinsics.checkNotNullParameter((Object)hostObject, (String)"hostObject");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        IonType type = context2.getReader().getType();
        if (type == IonType.NULL) {
            property.set(hostObject, null);
        } else if (type != IonType.INT) {
            property.set(hostObject, (Object)this.readArray(context2, hostObject));
        }
    }

    @Override
    public void serialize(@NotNull Object obj2, @NotNull WriteContext context2) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object[] array = (Object[])obj2;
        IonWriter writer = context2.writer;
        if (context2.filter.getSkipEmptyArray() && array.length == 0) {
            writer.writeInt(0L);
            return;
        }
        writer.stepIn(IonType.LIST);
        Function1<Object, Unit> consumer = this.createItemConsumer(context2);
        for (Object item : array) {
            consumer.invoke(item);
        }
        writer.stepOut();
    }

    private final Object[] readArray(ReadContext context2, Object hostObject) {
        ArrayList list2 = new ArrayList();
        this.readInto(hostObject, list2, context2);
        Object[] objectArray = ArrayUtil.newArray(this.itemClass, (int)list2.size());
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"newArray(...)");
        Object[] result2 = objectArray;
        list2.toArray(result2);
        return result2;
    }
}

