/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.toolWindow;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.impl.AnchoredButton;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBInsets;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.metal.MetalToggleButtonUI;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/toolWindow/StripeButtonUi;", "Ljavax/swing/plaf/metal/MetalToggleButtonUI;", "<init>", "()V", "iconRect", "Ljava/awt/Rectangle;", "textRect", "viewRect", "ourViewInsets", "Ljava/awt/Insets;", "getPreferredSize", "Ljava/awt/Dimension;", "c", "Ljavax/swing/JComponent;", "update", "", "g", "Ljava/awt/Graphics;", "Companion", "intellij.platform.ide.impl"})
public final class StripeButtonUi
extends MetalToggleButtonUI {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Rectangle iconRect = new Rectangle();
    @NotNull
    private final Rectangle textRect = new Rectangle();
    @NotNull
    private final Rectangle viewRect = new Rectangle();
    @NotNull
    private Insets ourViewInsets;
    @NotNull
    private static final Color FOREGROUND_COLOR;
    @NotNull
    private static final Color BACKGROUND_COLOR;
    @NotNull
    private static final Color SELECTED_BACKGROUND_COLOR;
    @NotNull
    private static final Color SELECTED_FOREGROUND_COLOR;

    public StripeButtonUi() {
        JBInsets jBInsets = JBInsets.emptyInsets();
        Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"emptyInsets(...)");
        this.ourViewInsets = (Insets)jBInsets;
    }

    @Override
    @NotNull
    public Dimension getPreferredSize(@NotNull JComponent c) {
        Dimension dimension;
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        AnchoredButton button2 = (AnchoredButton)c;
        Dimension dimension2 = super.getPreferredSize(button2);
        dimension2.width = (int)((float)JBUIScale.scale((int)4) + (float)dimension2.width * 1.1f);
        dimension2.height += JBUIScale.scale((int)2);
        ToolWindowAnchor anchor = button2.getAnchor();
        if (Intrinsics.areEqual((Object)ToolWindowAnchor.LEFT, (Object)anchor) || Intrinsics.areEqual((Object)ToolWindowAnchor.RIGHT, (Object)anchor)) {
            dimension = new Dimension(dimension2.height, dimension2.width);
        } else {
            Dimension dimension3 = dimension2;
            Intrinsics.checkNotNull((Object)dimension3);
            dimension = dimension3;
        }
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(@NotNull Graphics g, @NotNull JComponent c) {
        Icon icon2;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        AnchoredButton button2 = (AnchoredButton)c;
        String text2 = button2.getText();
        Icon icon3 = icon2 = button2.isEnabled() ? button2.getIcon() : button2.getDisabledIcon();
        if (text2 == null && icon2 == null) {
            return;
        }
        FontMetrics fm = button2.getFontMetrics(button2.getFont());
        Insets insets = c.getInsets(this.ourViewInsets);
        Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"getInsets(...)");
        this.ourViewInsets = insets;
        this.viewRect.x = this.ourViewInsets.left;
        this.viewRect.y = this.ourViewInsets.top;
        ToolWindowAnchor anchor = button2.getAnchor();
        if (Intrinsics.areEqual((Object)ToolWindowAnchor.RIGHT, (Object)anchor) || Intrinsics.areEqual((Object)ToolWindowAnchor.LEFT, (Object)anchor)) {
            this.viewRect.height = c.getWidth() - (this.ourViewInsets.left + this.ourViewInsets.right);
            this.viewRect.width = c.getHeight() - (this.ourViewInsets.top + this.ourViewInsets.bottom);
        } else {
            this.viewRect.height = c.getHeight() - (this.ourViewInsets.left + this.ourViewInsets.right);
            this.viewRect.width = c.getWidth() - (this.ourViewInsets.top + this.ourViewInsets.bottom);
        }
        this.iconRect.x = this.iconRect.y = (this.iconRect.width = (this.iconRect.height = 0));
        this.textRect.x = this.textRect.y = (this.textRect.width = (this.textRect.height = 0));
        String clippedText = SwingUtilities.layoutCompoundLabel(c, fm, text2, icon2, button2.getVerticalAlignment(), button2.getHorizontalAlignment(), button2.getVerticalTextPosition(), button2.getHorizontalTextPosition(), this.viewRect, this.iconRect, this.textRect, button2.getText() == null ? 0 : button2.getIconTextGap());
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2 = (Graphics2D)graphics;
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            ButtonModel model2 = button2.getModel();
            int off = JBUIScale.scale((int)1);
            Rectangle rectangle = this.iconRect;
            rectangle.x -= JBUIScale.scale((int)2);
            rectangle = this.textRect;
            rectangle.x -= JBUIScale.scale((int)2);
            if (model2.isArmed() && model2.isPressed() || model2.isSelected() || model2.isRollover()) {
                if (Intrinsics.areEqual((Object)anchor, (Object)ToolWindowAnchor.LEFT)) {
                    g2.translate(-off, 0);
                }
                if (anchor.isHorizontal()) {
                    g2.translate(0, -off);
                }
                g2.setColor(model2.isSelected() ? SELECTED_BACKGROUND_COLOR : BACKGROUND_COLOR);
                g2.fillRect(0, 0, button2.getWidth(), button2.getHeight());
                if (Intrinsics.areEqual((Object)anchor, (Object)ToolWindowAnchor.LEFT)) {
                    g2.translate(off, 0);
                }
                if (anchor.isHorizontal()) {
                    g2.translate(0, off);
                }
            }
            if (Intrinsics.areEqual((Object)ToolWindowAnchor.RIGHT, (Object)anchor) || Intrinsics.areEqual((Object)ToolWindowAnchor.LEFT, (Object)anchor)) {
                if (Intrinsics.areEqual((Object)ToolWindowAnchor.RIGHT, (Object)anchor)) {
                    Icon icon4 = icon2;
                    if (icon4 != null) {
                        icon4.paintIcon(c, g2, this.iconRect.y, this.iconRect.x);
                    }
                    g2.rotate(1.5707963267948966);
                    g2.translate(0, -c.getWidth());
                } else {
                    Icon icon5 = icon2;
                    if (icon5 != null) {
                        icon5.paintIcon(c, g2, this.iconRect.y, c.getHeight() - this.iconRect.x - icon2.getIconHeight());
                    }
                    g2.rotate(-1.5707963267948966);
                    g2.translate(-c.getHeight(), 0);
                }
            } else {
                Icon icon6 = icon2;
                if (icon6 != null) {
                    icon6.paintIcon(c, g2, this.iconRect.x, this.iconRect.y);
                }
            }
            UISettings.Companion.setupAntialiasing((Graphics)g2);
            if (text2 != null) {
                if (model2.isEnabled()) {
                    g2.setColor(model2.isSelected() ? SELECTED_FOREGROUND_COLOR : c.getForeground());
                } else {
                    g2.setColor(this.getDisabledTextColor());
                }
                BasicGraphicsUtils.drawString(g2, clippedText, button2.getMnemonic2(), this.textRect.x, this.textRect.y + fm.getAscent());
            }
        }
        finally {
            g2.dispose();
        }
    }

    static {
        JBColor jBColor = JBColor.namedColor((String)"ToolWindow.Button.foreground", (int)5922155, (int)10330280);
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
        FOREGROUND_COLOR = (Color)jBColor;
        JBColor jBColor2 = JBColor.namedColor((String)"ToolWindow.Button.hoverBackground", (Color)((Color)new JBColor(Gray.x55.withAlpha(40), Gray.x0F.withAlpha(40))));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor2, (String)"namedColor(...)");
        BACKGROUND_COLOR = (Color)jBColor2;
        JBColor jBColor3 = JBColor.namedColor((String)"ToolWindow.Button.selectedBackground", (Color)((Color)new JBColor(Gray.x55.withAlpha(85), Gray.x0F.withAlpha(85))));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor3, (String)"namedColor(...)");
        SELECTED_BACKGROUND_COLOR = (Color)jBColor3;
        JBColor jBColor4 = JBColor.namedColor((String)"ToolWindow.Button.selectedForeground", (Color)((Color)new JBColor((Color)Gray.x00, (Color)Gray.xFF)));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor4, (String)"namedColor(...)");
        SELECTED_FOREGROUND_COLOR = (Color)jBColor4;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/intellij/toolWindow/StripeButtonUi$Companion;", "", "<init>", "()V", "FOREGROUND_COLOR", "Ljava/awt/Color;", "getFOREGROUND_COLOR", "()Ljava/awt/Color;", "BACKGROUND_COLOR", "getBACKGROUND_COLOR", "SELECTED_BACKGROUND_COLOR", "getSELECTED_BACKGROUND_COLOR", "SELECTED_FOREGROUND_COLOR", "getSELECTED_FOREGROUND_COLOR", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Color getFOREGROUND_COLOR() {
            return FOREGROUND_COLOR;
        }

        @NotNull
        public final Color getBACKGROUND_COLOR() {
            return BACKGROUND_COLOR;
        }

        @NotNull
        public final Color getSELECTED_BACKGROUND_COLOR() {
            return SELECTED_BACKGROUND_COLOR;
        }

        @NotNull
        public final Color getSELECTED_FOREGROUND_COLOR() {
            return SELECTED_FOREGROUND_COLOR;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

