/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.toolWindow;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.WindowInfo;
import com.intellij.openapi.wm.impl.AbstractDroppableStripe;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.toolWindow.Stripe;
import com.intellij.toolWindow.StripeButton;
import com.intellij.toolWindow.StripeButtonManager;
import com.intellij.toolWindow.ToolWindowButtonManager;
import com.intellij.toolWindow.ToolWindowPane;
import com.intellij.toolWindow.ToolWindowPaneState;
import com.intellij.ui.awt.DevicePoint;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0015H\u0016J\b\u0010 \u001a\u00020\u0013H\u0016J\b\u0010!\u001a\u00020\u0013H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\u001f\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010(J\"\u0010$\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020)2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010-\u001a\u00020#2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010.\u001a\u00020#2\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010/\u001a\u00020\u0013H\u0016J\b\u00100\u001a\u00020\u0013H\u0016J\b\u00101\u001a\u00020\u0013H\u0016J\"\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u000109H\u0016J\b\u0010:\u001a\u00020\u0010H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000b\u001a&\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00070\u0007 \r*\u0012\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011\u00a8\u0006;"}, d2={"Lcom/intellij/toolWindow/ToolWindowPaneOldButtonManager;", "Lcom/intellij/toolWindow/ToolWindowButtonManager;", "paneId", "", "<init>", "(Ljava/lang/String;)V", "leftStripe", "Lcom/intellij/toolWindow/Stripe;", "rightStripe", "bottomStripe", "topStripe", "stripes", "", "kotlin.jvm.PlatformType", "", "isNewUi", "", "()Z", "setupToolWindowPane", "", "pane", "Ljavax/swing/JComponent;", "wrapWithControls", "Lcom/intellij/toolWindow/ToolWindowPane;", "updateToolStripesVisibility", "showButtons", "state", "Lcom/intellij/toolWindow/ToolWindowPaneState;", "layout", "size", "Ljava/awt/Dimension;", "layeredPane", "validateAndRepaint", "revalidateNotEmptyStripes", "getBottomHeight", "", "getStripeFor", "anchor", "Lcom/intellij/openapi/wm/ToolWindowAnchor;", "isSplit", "(Lcom/intellij/openapi/wm/ToolWindowAnchor;Ljava/lang/Boolean;)Lcom/intellij/toolWindow/Stripe;", "Lcom/intellij/openapi/wm/impl/AbstractDroppableStripe;", "devicePoint", "Lcom/intellij/ui/awt/DevicePoint;", "preferred", "getStripeWidth", "getStripeHeight", "startDrag", "stopDrag", "reset", "createStripeButton", "Lcom/intellij/toolWindow/StripeButtonManager;", "toolWindow", "Lcom/intellij/openapi/wm/impl/ToolWindowImpl;", "info", "Lcom/intellij/openapi/wm/WindowInfo;", "task", "Lcom/intellij/openapi/wm/RegisterToolWindowTask;", "hasButtons", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nToolWindowPaneOldButtonManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolWindowPaneOldButtonManager.kt\ncom/intellij/toolWindow/ToolWindowPaneOldButtonManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,213:1\n296#2,2:214\n1915#2,2:216\n*S KotlinDebug\n*F\n+ 1 ToolWindowPaneOldButtonManager.kt\ncom/intellij/toolWindow/ToolWindowPaneOldButtonManager\n*L\n135#1:214,2\n169#1:216,2\n*E\n"})
public final class ToolWindowPaneOldButtonManager
implements ToolWindowButtonManager {
    @NotNull
    private final Stripe leftStripe;
    @NotNull
    private final Stripe rightStripe;
    @NotNull
    private final Stripe bottomStripe;
    @NotNull
    private final Stripe topStripe;
    private final List<Stripe> stripes;

    public ToolWindowPaneOldButtonManager(@NotNull String paneId) {
        Intrinsics.checkNotNullParameter((Object)paneId, (String)"paneId");
        this.leftStripe = new Stripe(paneId, 2);
        this.rightStripe = new Stripe(paneId, 4);
        this.bottomStripe = new Stripe(paneId, 3);
        this.topStripe = new Stripe(paneId, 1);
        this.stripes = List.of(this.topStripe, this.leftStripe, this.bottomStripe, this.rightStripe);
    }

    @Override
    public boolean isNewUi() {
        return false;
    }

    @Override
    public void setupToolWindowPane(@NotNull JComponent pane2) {
        Intrinsics.checkNotNullParameter((Object)pane2, (String)"pane");
        pane2.add((Component)((Object)this.topStripe), JLayeredPane.POPUP_LAYER, -1);
        pane2.add((Component)((Object)this.leftStripe), JLayeredPane.POPUP_LAYER, -1);
        pane2.add((Component)((Object)this.bottomStripe), JLayeredPane.POPUP_LAYER, -1);
        pane2.add((Component)((Object)this.rightStripe), JLayeredPane.POPUP_LAYER, -1);
    }

    @Override
    @NotNull
    public JComponent wrapWithControls(@NotNull ToolWindowPane pane2) {
        Intrinsics.checkNotNullParameter((Object)pane2, (String)"pane");
        return pane2;
    }

    @Override
    public boolean updateToolStripesVisibility(boolean showButtons, @NotNull ToolWindowPaneState state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        boolean oldVisible = this.leftStripe.isVisible();
        boolean visible = showButtons || state2.isStripesOverlaid();
        this.leftStripe.setVisible(visible);
        this.rightStripe.setVisible(visible);
        this.topStripe.setVisible(visible);
        this.bottomStripe.setVisible(visible);
        if (!Registry.Companion.is("disable.toolwindow.overlay")) {
            boolean overlaid = !showButtons && state2.isStripesOverlaid();
            this.leftStripe.setOverlaid(overlaid);
            this.rightStripe.setOverlaid(overlaid);
            this.topStripe.setOverlaid(overlaid);
            this.bottomStripe.setOverlaid(overlaid);
        }
        return oldVisible != visible;
    }

    @Override
    public void layout(@NotNull Dimension size2, @NotNull JComponent layeredPane2) {
        Intrinsics.checkNotNullParameter((Object)size2, (String)"size");
        Intrinsics.checkNotNullParameter((Object)layeredPane2, (String)"layeredPane");
        Dimension dimension = this.topStripe.getPreferredSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
        Dimension topSize = dimension;
        Dimension dimension2 = this.bottomStripe.getPreferredSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"getPreferredSize(...)");
        Dimension bottomSize = dimension2;
        Dimension dimension3 = this.leftStripe.getPreferredSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension3, (String)"getPreferredSize(...)");
        Dimension leftSize = dimension3;
        Dimension dimension4 = this.rightStripe.getPreferredSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension4, (String)"getPreferredSize(...)");
        Dimension rightSize = dimension4;
        Rectangle topBounds = new Rectangle(0, 0, size2.width, topSize.height);
        int height = size2.height - topSize.height - bottomSize.height;
        Rectangle leftBounds = new Rectangle(0, topSize.height, leftSize.width, height);
        Rectangle rightBounds = new Rectangle(size2.width - rightSize.width, topSize.height, rightSize.width, height);
        Rectangle bottomBounds = new Rectangle(0, size2.height - bottomSize.height, size2.width, bottomSize.height);
        this.topStripe.putClientProperty(Stripe.VIRTUAL_BOUNDS, topBounds);
        this.leftStripe.putClientProperty(Stripe.VIRTUAL_BOUNDS, leftBounds);
        this.rightStripe.putClientProperty(Stripe.VIRTUAL_BOUNDS, rightBounds);
        this.bottomStripe.putClientProperty(Stripe.VIRTUAL_BOUNDS, bottomBounds);
        if (this.topStripe.isVisible()) {
            this.topStripe.setBounds(topBounds);
            this.leftStripe.setBounds(leftBounds);
            this.rightStripe.setBounds(rightBounds);
            this.bottomStripe.setBounds(bottomBounds);
            UISettings uiSettings = UISettings.Companion.getInstance();
            if (uiSettings.getHideToolStripes() || uiSettings.getPresentationMode()) {
                layeredPane2.setBounds(0, 0, size2.width, size2.height);
            } else {
                int width = size2.width - leftSize.width - rightSize.width;
                layeredPane2.setBounds(leftSize.width, topSize.height, width, height);
            }
        } else {
            this.topStripe.setBounds(0, 0, 0, 0);
            this.bottomStripe.setBounds(0, 0, 0, 0);
            this.leftStripe.setBounds(0, 0, 0, 0);
            this.rightStripe.setBounds(0, 0, 0, 0);
            layeredPane2.setBounds(0, 0, size2.width, size2.height);
        }
    }

    @Override
    public void validateAndRepaint() {
        for (Stripe stripe : this.stripes) {
            stripe.revalidate();
            stripe.repaint();
        }
    }

    @Override
    public void revalidateNotEmptyStripes() {
        for (Stripe stripe : this.stripes) {
            if (!(!((Collection)stripe.getButtons()).isEmpty())) continue;
            stripe.revalidate();
        }
    }

    @Override
    public int getBottomHeight() {
        return this.bottomStripe.isVisible() ? this.bottomStripe.getHeight() : 0;
    }

    @Override
    @NotNull
    public Stripe getStripeFor(@NotNull ToolWindowAnchor anchor, @Nullable Boolean isSplit) {
        Stripe stripe;
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        ToolWindowAnchor toolWindowAnchor = anchor;
        if (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.TOP)) {
            stripe = this.topStripe;
        } else if (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.BOTTOM)) {
            stripe = this.bottomStripe;
        } else if (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.LEFT)) {
            stripe = this.leftStripe;
        } else if (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.RIGHT)) {
            stripe = this.rightStripe;
        } else {
            throw new IllegalArgumentException("Anchor=" + anchor);
        }
        return stripe;
    }

    @Override
    @Nullable
    public AbstractDroppableStripe getStripeFor(@NotNull DevicePoint devicePoint, @NotNull AbstractDroppableStripe preferred, @NotNull JComponent pane2) {
        Intrinsics.checkNotNullParameter((Object)devicePoint, (String)"devicePoint");
        Intrinsics.checkNotNullParameter((Object)((Object)preferred), (String)"preferred");
        Intrinsics.checkNotNullParameter((Object)pane2, (String)"pane");
        Point screenPoint = devicePoint.getLocationOnScreen((Component)pane2);
        if (new Rectangle(pane2.getLocationOnScreen(), pane2.getSize()).contains(screenPoint)) {
            Object v1;
            block3: {
                if (preferred.containsPoint(screenPoint)) {
                    return preferred;
                }
                List<Stripe> list2 = this.stripes;
                Intrinsics.checkNotNullExpressionValue(list2, (String)"stripes");
                Iterable $this$firstOrNull$iv = list2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Stripe it = (Stripe)((Object)element$iv);
                    boolean bl = false;
                    if (!it.containsPoint(screenPoint)) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            return v1;
        }
        return null;
    }

    @Override
    public int getStripeWidth(@NotNull ToolWindowAnchor anchor) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Stripe stripe = this.getStripeFor(anchor, null);
        return stripe.isVisible() && stripe.isShowing() ? stripe.getWidth() : 0;
    }

    @Override
    public int getStripeHeight(@NotNull ToolWindowAnchor anchor) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        if (Intrinsics.areEqual((Object)anchor, (Object)ToolWindowAnchor.TOP)) {
            return 0;
        }
        Stripe stripe = this.getStripeFor(anchor, null);
        return stripe.isVisible() && stripe.isShowing() ? stripe.getHeight() : 0;
    }

    @Override
    public void startDrag() {
        for (Stripe s : this.stripes) {
            if (!s.isVisible()) continue;
            s.startDrag();
        }
    }

    @Override
    public void stopDrag() {
        for (Stripe s : this.stripes) {
            if (!s.isVisible()) continue;
            s.stopDrag();
        }
    }

    @Override
    public void reset() {
        List<Stripe> list2 = this.stripes;
        Intrinsics.checkNotNullExpressionValue(list2, (String)"stripes");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Stripe p0 = (Stripe)((Object)element$iv);
            boolean bl = false;
            p0.reset();
        }
    }

    @Override
    @NotNull
    public StripeButtonManager createStripeButton(@NotNull ToolWindowImpl toolWindow2, @NotNull WindowInfo info, @Nullable RegisterToolWindowTask task) {
        Intrinsics.checkNotNullParameter((Object)toolWindow2, (String)"toolWindow");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        StripeButton button2 = new StripeButton(toolWindow2);
        button2.setSelected(info.isVisible());
        button2.updatePresentation();
        Stripe stripe = this.getStripeFor(info.getAnchor(), info.isSplit());
        StripeButtonManager manager2 = new StripeButtonManager(toolWindow2, button2, stripe){
            private final String id;
            private final ToolWindowImpl toolWindow;
            final /* synthetic */ ToolWindowImpl $toolWindow;
            final /* synthetic */ StripeButton $button;
            final /* synthetic */ Stripe $stripe;
            {
                this.$toolWindow = $toolWindow;
                this.$button = $button;
                this.$stripe = $stripe;
                this.id = $toolWindow.getId();
                this.toolWindow = $toolWindow;
            }

            public String getId() {
                return this.id;
            }

            public ToolWindowImpl getToolWindow() {
                return this.toolWindow;
            }

            public WindowInfo getWindowDescriptor() {
                return this.$toolWindow.getWindowInfo();
            }

            public StripeButton getComponent() {
                return this.$button;
            }

            public void updateState(ToolWindowImpl toolWindow2) {
                Intrinsics.checkNotNullParameter((Object)toolWindow2, (String)"toolWindow");
                this.$button.setSelected(toolWindow2.isVisible());
                this.$button.updateState$intellij_platform_ide_impl(toolWindow2);
            }

            public void updatePresentation() {
                this.$button.updatePresentation();
            }

            public void updateIcon(Icon icon2) {
                this.$button.updateIcon(icon2);
            }

            public void remove(ToolWindowAnchor anchor, boolean split) {
                Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
                this.$stripe.removeButton(this);
            }
        };
        stripe.addButton(manager2);
        return manager2;
    }

    @Override
    public boolean hasButtons() {
        return !((Collection)this.leftStripe.getButtons()).isEmpty() || !((Collection)this.rightStripe.getButtons()).isEmpty() || !((Collection)this.bottomStripe.getButtons()).isEmpty() || !((Collection)this.topStripe.getButtons()).isEmpty();
    }
}

