/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.AbstractFontCombo;
import com.intellij.ui.GroupedComboBoxRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FontInfo;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.basic.ComboPopup;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class FontComboBox
extends AbstractFontCombo {
    private Model myModel;
    private final JBDimension mySize;

    public FontComboBox() {
        this(false);
    }

    public FontComboBox(boolean withAllStyles) {
        this(withAllStyles, true, false);
    }

    public FontComboBox(boolean withAllStyles, boolean filterNonLatin, boolean noFontItem) {
        super(new Model(withAllStyles, filterNonLatin, noFontItem));
        Dimension size2 = super.getPreferredSize();
        size2.width = size2.height * 8;
        this.mySize = JBDimension.create((Dimension)size2, (boolean)true);
        this.setSwingPopup(false);
        this.setRenderer(new GroupedComboBoxRenderer((JComponent)((Object)this)){

            @Nullable
            public ListSeparator separatorFor(Object value) {
                ComboBoxModel comboBoxModel = FontComboBox.this.getModel();
                if (comboBoxModel instanceof Model) {
                    Model m = (Model)comboBoxModel;
                    if (value instanceof FontInfo) {
                        FontInfo info = (FontInfo)value;
                        if (!m.myMonoFonts.isEmpty() && m.myMonoFonts.get(0) == info) {
                            return new ListSeparator(ApplicationBundle.message((String)"settings.editor.font.monospaced", (Object[])new Object[0]));
                        }
                        if (!m.myAllFonts.isEmpty() && ContainerUtil.find(m.myAllFonts, f -> !f.isMonospaced()) == info) {
                            return new ListSeparator(ApplicationBundle.message((String)"settings.editor.font.proportional", (Object[])new Object[0]));
                        }
                    }
                }
                return null;
            }

            public void customize(@NotNull SimpleColoredComponent item, Object value, int index, boolean isSelected, boolean hasFocus) {
                if (item == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (value instanceof FontInfo) {
                    FontInfo info = (FontInfo)value;
                    item.setFont((Font)(index == -1 ? JBUI.Fonts.label() : info.getFont()));
                    item.append(info.toString());
                } else if (value instanceof Model.NoFontItem) {
                    Model.NoFontItem nfi = (Model.NoFontItem)value;
                    item.append(nfi.toString());
                } else if (value instanceof Model.LoadingFontsItem) {
                    Model.LoadingFontsItem lfi = (Model.LoadingFontsItem)value;
                    item.append(lfi.toString(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                } else if (value instanceof String) {
                    String s = (String)value;
                    item.append(s);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/ui/FontComboBox$1", "customize"));
            }
        });
        this.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                if (e.getIndex0() != -42 || e.getIndex1() != -42) {
                    return;
                }
                ComboPopup popup2 = FontComboBox.this.getPopup();
                if (popup2 != null && popup2.isVisible()) {
                    popup2.hide();
                    popup2.show();
                }
            }
        });
    }

    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        return this.mySize.size();
    }

    @Override
    public boolean isMonospacedOnly() {
        return this.myModel.myMonospacedOnly;
    }

    @Override
    public boolean isMonospacedOnlySupported() {
        return true;
    }

    @Override
    public void setMonospacedOnly(boolean monospaced) {
        this.myModel.setMonospacedOnly(monospaced);
    }

    @Override
    public String getFontName() {
        Object item = this.myModel.getSelectedItem();
        return item == null ? null : item.toString();
    }

    @Override
    public void setFontName(@NlsSafe @Nullable String item) {
        this.myModel.setSelectedItem(item);
    }

    @Override
    public boolean isNoFontSelected() {
        return this.myModel.isNoFontSelected();
    }

    public void setModel(ComboBoxModel model2) {
        if (!(model2 instanceof Model)) {
            throw new UnsupportedOperationException();
        }
        this.myModel = (Model)model2;
        super.setModel(model2);
    }

    private static final class Model
    extends AbstractListModel
    implements ComboBoxModel {
        private final NoFontItem myNoFontItem;
        private LoadingFontsItem myLoadingFontsItem = null;
        private volatile List<FontInfo> myAllFonts = Collections.emptyList();
        private volatile List<FontInfo> myMonoFonts = Collections.emptyList();
        private boolean myMonospacedOnly;
        private Object mySelectedItem;

        private Model(boolean withAllStyles, boolean filterNonLatin, boolean noFontItem) {
            this.myNoFontItem = noFontItem ? new NoFontItem() : null;
            Application application = ApplicationManager.getApplication();
            if (application == null || application.isUnitTestMode()) {
                this.setFonts(FontInfo.getAll((boolean)withAllStyles), filterNonLatin);
            } else {
                this.myLoadingFontsItem = new LoadingFontsItem();
                application.executeOnPooledThread(() -> {
                    List all = FontInfo.getAll((boolean)withAllStyles);
                    application.invokeLater(() -> {
                        this.myLoadingFontsItem = null;
                        this.setFonts(all, filterNonLatin);
                        this.onModelToggled();
                    }, ModalityState.any());
                });
            }
        }

        private void setFonts(List<FontInfo> all, boolean filterNonLatin) {
            ArrayList<FontInfo> allFonts = new ArrayList<FontInfo>(all.size());
            ArrayList<FontInfo> monoFonts = new ArrayList<FontInfo>();
            for (FontInfo info : all) {
                if (filterNonLatin && info.getFont().canDisplayUpTo(info.toString()) != -1) continue;
                allFonts.add(info);
                if (!info.isMonospaced()) continue;
                monoFonts.add(info);
            }
            this.myAllFonts = allFonts;
            this.myMonoFonts = monoFonts;
        }

        public void setMonospacedOnly(boolean monospaced) {
            if (this.myMonospacedOnly != monospaced) {
                this.myMonospacedOnly = monospaced;
                this.onModelToggled();
            }
        }

        void onModelToggled() {
            Object item = this.getSelectedItem();
            this.setSelectedItem(null);
            this.setSelectedItem(item);
            this.fireContentsChanged(this, -42, -42);
        }

        @Override
        public Object getSelectedItem() {
            return this.mySelectedItem;
        }

        @Override
        public void setSelectedItem(@Nullable Object item) {
            if (item == null && this.myNoFontItem != null) {
                item = this.myNoFontItem;
            } else {
                FontInfo info;
                if (item instanceof FontInfo && (info = this.getInfo(item)) == null) {
                    List<FontInfo> list2 = this.myMonospacedOnly ? this.myMonoFonts : this.myAllFonts;
                    Object object = item = list2.isEmpty() ? null : list2.get(0);
                }
                if (item instanceof String && (info = this.getInfo(item)) != null) {
                    item = info;
                }
            }
            if (!Comparing.equal((Object)this.mySelectedItem, (Object)item) || item == this.myNoFontItem) {
                this.mySelectedItem = item;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public boolean isNoFontSelected() {
            return this.getSelectedItem() == this.myNoFontItem;
        }

        @Override
        public int getSize() {
            return this.getAllElements().size();
        }

        @Override
        public Object getElementAt(int index) {
            List<Object> items2 = this.getAllElements();
            return 0 <= index && index < items2.size() ? items2.get(index) : null;
        }

        @NotNull
        private @Unmodifiable List<Object> getAllElements() {
            ArrayList<List<Object>> groups = new ArrayList<List<Object>>();
            if (this.myNoFontItem != null) {
                groups.add(Collections.singletonList(this.myNoFontItem));
            }
            groups.add(this.myMonospacedOnly ? this.myMonoFonts : this.myAllFonts);
            if (this.mySelectedItem instanceof String) {
                groups.add(Collections.singletonList(this.mySelectedItem));
            }
            if (this.myLoadingFontsItem != null) {
                groups.add(Collections.singletonList(this.myLoadingFontsItem));
            }
            List list2 = ContainerUtil.concat(groups);
            if (list2 == null) {
                Model.$$$reportNull$$$0(0);
            }
            return list2;
        }

        private FontInfo getInfo(Object item) {
            for (FontInfo info : this.myMonospacedOnly ? this.myMonoFonts : this.myAllFonts) {
                if (!(item instanceof String ? info.toString().equalsIgnoreCase((String)item) : info.equals(item))) continue;
                return info;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/FontComboBox$Model", "getAllElements"));
        }

        private static final class LoadingFontsItem {
            private LoadingFontsItem() {
            }

            @NlsSafe
            public String toString() {
                return ApplicationBundle.message((String)"settings.editor.font.loading", (Object[])new Object[0]);
            }
        }

        private static final class NoFontItem {
            private NoFontItem() {
            }

            @NlsSafe
            public String toString() {
                return ApplicationBundle.message((String)"settings.editor.font.none", (Object[])new Object[0]);
            }
        }
    }
}

