/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.ui.UISettings;
import com.intellij.internal.statistic.service.fus.collectors.UIEventLogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.client.ClientSystemInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.speedSearch.SpeedSearchActivator;
import com.intellij.ui.speedSearch.SpeedSearchInputMethodRequests;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.text.NameUtilCore;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.im.InputMethodRequests;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.AttributedCharacterIterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpeedSearchBase<Comp extends JComponent>
extends SpeedSearchSupply
implements SpeedSearchActivator {
    private static final Logger LOG = Logger.getInstance(SpeedSearchBase.class);
    private static final Key<String> SEARCH_TEXT_KEY = Key.create((String)"SpeedSearch.searchText");
    @ApiStatus.Internal
    protected SearchPopup mySearchPopup;
    private JLayeredPane myPopupLayeredPane;
    protected final Comp myComponent;
    private final ToolWindowManagerListener myToolWindowListener;
    private final PropertyChangeSupport myChangeSupport;
    private String myRecentEnteredPrefix;
    private SpeedSearchComparator myComparator;
    private boolean myClearSearchOnNavigateNoMatch;
    private Disposable myListenerDisposable;
    private InputMethodRequests myInputMethodRequests;
    private final boolean myElementAtImplemented;

    private static JBInsets borderInsets() {
        return JBUI.insets((String)"SpeedSearch.borderInsets", (JBInsets)JBUI.emptyInsets());
    }

    protected SpeedSearchBase(Comp component2, Void sig) {
        boolean elementAtImplemented;
        this.myToolWindowListener = new ToolWindowManagerListener(){

            @Override
            public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
                if (toolWindowManager == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!this.isInsideActiveToolWindow(toolWindowManager)) {
                    SpeedSearchBase.this.manageSearchPopup(null);
                }
            }

            private boolean isInsideActiveToolWindow(@NotNull ToolWindowManager toolWindowManager) {
                ToolWindow toolWindow2;
                if (toolWindowManager == null) {
                    1.$$$reportNull$$$0(1);
                }
                return (toolWindow2 = toolWindowManager.getToolWindow(toolWindowManager.getActiveToolWindowId())) != null && SwingUtilities.isDescendingFrom(SpeedSearchBase.this.myComponent, toolWindow2.getComponent());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "toolWindowManager";
                objectArray2[1] = "com/intellij/ui/SpeedSearchBase$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "stateChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isInsideActiveToolWindow";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myChangeSupport = new PropertyChangeSupport((Object)this);
        this.myComparator = new SpeedSearchComparator(false);
        try {
            elementAtImplemented = ReflectionUtil.getMethodDeclaringClass(((Object)((Object)this)).getClass(), (String)"getElementAt", (Class[])new Class[]{Integer.TYPE}) != SpeedSearchBase.class;
        }
        catch (Exception ex) {
            elementAtImplemented = false;
        }
        this.myElementAtImplemented = elementAtImplemented;
        boolean elementIteratorImplemented = false;
        boolean elementCountImplemented = false;
        try {
            elementCountImplemented = ReflectionUtil.getMethodDeclaringClass(((Object)((Object)this)).getClass(), (String)"getElementCount", (Class[])new Class[0]) != SpeedSearchBase.class;
            elementIteratorImplemented = ReflectionUtil.getMethodDeclaringClass(((Object)((Object)this)).getClass(), (String)"getElementIterator", (Class[])new Class[]{Integer.TYPE}) != SpeedSearchBase.class;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!(elementIteratorImplemented || elementAtImplemented && elementCountImplemented)) {
            LOG.warn("Please implement getElementAt(int)" + (elementCountImplemented ? "" : " and getElementCount()") + " in " + ((Object)((Object)this)).getClass().getName());
        }
        this.myComponent = component2;
    }

    @Deprecated
    public SpeedSearchBase(@NotNull Comp component2) {
        boolean elementAtImplemented;
        if (component2 == null) {
            SpeedSearchBase.$$$reportNull$$$0(0);
        }
        this.myToolWindowListener = new /* invalid duplicate definition of identical inner class */;
        this.myChangeSupport = new PropertyChangeSupport((Object)this);
        this.myComparator = new SpeedSearchComparator(false);
        try {
            elementAtImplemented = ReflectionUtil.getMethodDeclaringClass(((Object)((Object)this)).getClass(), (String)"getElementAt", (Class[])new Class[]{Integer.TYPE}) != SpeedSearchBase.class;
        }
        catch (Exception ex) {
            elementAtImplemented = false;
        }
        this.myElementAtImplemented = elementAtImplemented;
        boolean elementIteratorImplemented = false;
        boolean elementCountImplemented = false;
        try {
            elementCountImplemented = ReflectionUtil.getMethodDeclaringClass(((Object)((Object)this)).getClass(), (String)"getElementCount", (Class[])new Class[0]) != SpeedSearchBase.class;
            elementIteratorImplemented = ReflectionUtil.getMethodDeclaringClass(((Object)((Object)this)).getClass(), (String)"getElementIterator", (Class[])new Class[]{Integer.TYPE}) != SpeedSearchBase.class;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!(elementIteratorImplemented || elementAtImplemented && elementCountImplemented)) {
            LOG.warn("Please implement getElementAt(int)" + (elementCountImplemented ? "" : " and getElementCount()") + " in " + ((Object)((Object)this)).getClass().getName());
        }
        this.myComponent = component2;
        this.setupListeners();
    }

    public boolean supportsNavigation() {
        return true;
    }

    public void setupListeners() {
        ((Component)this.myComponent).addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent event) {
                SpeedSearchBase.this.manageSearchPopup(null);
            }

            @Override
            public void componentMoved(ComponentEvent event) {
                SpeedSearchBase.this.moveSearchPopup();
            }

            @Override
            public void componentResized(ComponentEvent event) {
                SpeedSearchBase.this.moveSearchPopup();
            }
        });
        ((Component)this.myComponent).addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!SpeedSearchBase.this.keepEvenWhenFocusLost()) {
                    SpeedSearchBase.this.manageSearchPopup(null);
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                if (!SpeedSearchBase.this.isStickySearch()) {
                    return;
                }
                String text2 = (String)ClientProperty.get(SpeedSearchBase.this.myComponent, SEARCH_TEXT_KEY);
                if (Strings.isEmpty((String)text2)) {
                    return;
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (((Component)SpeedSearchBase.this.myComponent).hasFocus()) {
                        SpeedSearchBase.this.manageSearchPopup(SpeedSearchBase.this.createPopup(text2));
                    }
                });
            }
        });
        ((Component)this.myComponent).addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                WriteIntentReadAction.run(() -> SpeedSearchBase.this.processKeyEvent(e));
            }

            @Override
            public void keyPressed(KeyEvent e) {
                WriteIntentReadAction.run(() -> SpeedSearchBase.this.processKeyEvent(e));
            }
        });
        if (this.allowInputMethodsInSpeedSearch()) {
            ((Component)this.myComponent).addInputMethodListener(new InputMethodListener(){

                @Override
                public void inputMethodTextChanged(InputMethodEvent e) {
                    SpeedSearchBase.this.processInputMethodEvent(e);
                }

                @Override
                public void caretPositionChanged(InputMethodEvent e) {
                    SpeedSearchBase.this.processInputMethodEvent(e);
                }
            });
            ((Component)this.myComponent).enableInputMethods(true);
        }
        new DumbAwareAction(){

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            public void actionPerformed(@NotNull AnActionEvent e) {
                String prefix;
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                if ((prefix = SpeedSearchBase.this.getEnteredPrefix()) == null) {
                    return;
                }
                @NotNull List strings = NameUtilCore.splitNameIntoWordList((String)prefix);
                if (strings.isEmpty()) {
                    return;
                }
                String last = (String)strings.getLast();
                int i2 = prefix.lastIndexOf(last);
                SpeedSearchBase.this.mySearchPopup.mySearchField.setText(prefix.substring(0, i2).trim());
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabled(SpeedSearchBase.this.isPopupActive() && Strings.isNotEmpty((String)SpeedSearchBase.this.getEnteredPrefix()));
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    6.$$$reportNull$$$0(2);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ui/SpeedSearchBase$6";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ui/SpeedSearchBase$6";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{ClientSystemInfo.isMac() ? "meta BACK_SPACE" : "control BACK_SPACE"}), this.myComponent);
        ActionManager.getInstance().getAction("SpeedSearch").registerCustomShortcutSet(this.myComponent, null);
        this.installSupplyTo((JComponent)this.myComponent);
    }

    protected boolean isStickySearch() {
        return false;
    }

    protected boolean keepEvenWhenFocusLost() {
        return false;
    }

    protected boolean allowInputMethodsInSpeedSearch() {
        return true;
    }

    public InputMethodRequests getInputMethodRequests() {
        if (!this.allowInputMethodsInSpeedSearch()) {
            return null;
        }
        if (this.myInputMethodRequests == null) {
            this.myInputMethodRequests = new SpeedSearchInputMethodRequests(){

                protected void ensurePopupIsShown() {
                    if (SpeedSearchBase.this.mySearchPopup == null) {
                        SpeedSearchBase.this.showPopup();
                    }
                }

                protected InputMethodRequests getDelegate() {
                    JTextField field = SpeedSearchBase.this.getSearchField();
                    if (field == null) {
                        return null;
                    }
                    return field.getInputMethodRequests();
                }
            };
        }
        return this.myInputMethodRequests;
    }

    public void selectTextRange(int begin, int length) {
        JTextField field = this.getSearchField();
        if (field != null) {
            field.select(begin, begin + length);
        }
    }

    @Nullable
    public JTextField getSearchField() {
        if (this.mySearchPopup != null) {
            return this.mySearchPopup.mySearchField;
        }
        return null;
    }

    public static boolean hasActiveSpeedSearch(JComponent component2) {
        return SpeedSearchBase.getSupply((JComponent)component2) != null;
    }

    public void setClearSearchOnNavigateNoMatch(boolean clearSearchOnNavigateNoMatch) {
        this.myClearSearchOnNavigateNoMatch = clearSearchOnNavigateNoMatch;
    }

    public boolean isPopupActive() {
        ThreadingAssertions.assertEventDispatchThread();
        return this.mySearchPopup != null && this.mySearchPopup.isVisible() || this.isStickySearch() && Strings.isNotEmpty(this.myComponent == null ? null : (String)ClientProperty.get(this.myComponent, SEARCH_TEXT_KEY));
    }

    public Iterable<TextRange> matchingFragments(@NotNull String text2) {
        if (text2 == null) {
            SpeedSearchBase.$$$reportNull$$$0(1);
        }
        if (!this.isPopupActive()) {
            return null;
        }
        SpeedSearchComparator comparator = this.getComparator();
        String recentSearchText = comparator.getRecentSearchText();
        return Strings.isNotEmpty((String)recentSearchText) ? comparator.matchingFragments(recentSearchText, text2) : null;
    }

    protected abstract int getSelectedIndex();

    @Deprecated(forRemoval=true)
    protected Object @NotNull [] getAllElements() {
        throw new UnsupportedOperationException("See `SpeedSearchBase.getElementIterator(int)` javadoc");
    }

    @Nullable
    protected abstract String getElementText(Object var1);

    protected int getElementCount() {
        LOG.warn("Please implement getElementCount() and getElementAt(int) in " + ((Object)((Object)this)).getClass().getName());
        return this.getAllElements().length;
    }

    protected Object getElementAt(int viewIndex) {
        throw new UnsupportedOperationException();
    }

    @Deprecated(forRemoval=true)
    protected int convertIndexToModel(int viewIndex) {
        return viewIndex;
    }

    protected abstract void selectElement(Object var1, String var2);

    @NotNull
    protected ListIterator<Object> getElementIterator(int startingViewIndex) {
        return new MyListIterator(this, startingViewIndex);
    }

    public void addChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            SpeedSearchBase.$$$reportNull$$$0(2);
        }
        this.myChangeSupport.addPropertyChangeListener(listener2);
    }

    public void removeChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            SpeedSearchBase.$$$reportNull$$$0(3);
        }
        this.myChangeSupport.removePropertyChangeListener(listener2);
    }

    @ApiStatus.Internal
    protected void fireStateChanged() {
        String enteredPrefix = this.getEnteredPrefix();
        this.myChangeSupport.firePropertyChange("enteredPrefix", this.myRecentEnteredPrefix, enteredPrefix);
        this.myRecentEnteredPrefix = enteredPrefix;
    }

    protected boolean isMatchingElement(Object element, String pattern) {
        String str = this.getElementText(element);
        return str != null && this.compare(str, pattern);
    }

    protected boolean compare(@NotNull String text2, @Nullable String pattern) {
        if (text2 == null) {
            SpeedSearchBase.$$$reportNull$$$0(4);
        }
        return pattern != null && this.myComparator.matchingFragments(pattern, text2) != null;
    }

    public SpeedSearchComparator getComparator() {
        return this.myComparator;
    }

    public void setComparator(SpeedSearchComparator comparator) {
        this.myComparator = comparator;
    }

    @Nullable
    protected Object findNextElement(String s) {
        Object current;
        int selectedIndex = this.getSelectedIndex();
        ListIterator<Object> it = this.getElementIterator(selectedIndex + 1);
        if (it.hasPrevious()) {
            current = it.previous();
            it.next();
        } else {
            current = null;
        }
        String _s = s.trim();
        while (it.hasNext()) {
            Object element = it.next();
            if (!this.isMatchingElement(element, _s)) continue;
            return element;
        }
        if (UISettings.getInstance().getCycleScrolling()) {
            ListIterator<Object> i2 = this.getElementIterator(0);
            while (i2.hasNext()) {
                Object element = i2.next();
                if (!this.isMatchingElement(element, _s)) continue;
                return element;
            }
        }
        return current != null && this.isMatchingElement(current, _s) ? current : null;
    }

    @Nullable
    protected Object findPreviousElement(@NotNull String s) {
        Object current;
        int selectedIndex;
        if (s == null) {
            SpeedSearchBase.$$$reportNull$$$0(5);
        }
        if ((selectedIndex = this.getSelectedIndex()) < 0) {
            return null;
        }
        ListIterator<Object> it = this.getElementIterator(selectedIndex);
        if (it.hasNext()) {
            current = it.next();
            it.previous();
        } else {
            current = null;
        }
        String _s = s.trim();
        while (it.hasPrevious()) {
            Object element = it.previous();
            if (!this.isMatchingElement(element, _s)) continue;
            return element;
        }
        if (UISettings.getInstance().getCycleScrolling()) {
            ListIterator<Object> i2 = this.getElementIterator(this.getElementCount());
            while (i2.hasPrevious()) {
                Object element = i2.previous();
                if (!this.isMatchingElement(element, _s)) continue;
                return element;
            }
        }
        return this.isMatchingElement(current, _s) ? current : null;
    }

    @Nullable
    protected Object findElement(@NotNull String s) {
        Object element;
        int selectedIndex;
        if (s == null) {
            SpeedSearchBase.$$$reportNull$$$0(6);
        }
        if ((selectedIndex = this.getSelectedIndex()) < 0) {
            selectedIndex = 0;
        }
        ListIterator<Object> it = this.getElementIterator(selectedIndex);
        String _s = s.trim();
        while (it.hasNext()) {
            element = it.next();
            if (!this.isMatchingElement(element, _s)) continue;
            return element;
        }
        if (selectedIndex > 0) {
            while (it.hasPrevious()) {
                it.previous();
            }
            while (it.hasNext() && it.nextIndex() != selectedIndex) {
                element = it.next();
                if (!this.isMatchingElement(element, _s)) continue;
                return element;
            }
        }
        return null;
    }

    @Nullable
    private Object findFirstElement(String s) {
        String _s = s.trim();
        ListIterator<Object> it = this.getElementIterator(0);
        while (it.hasNext()) {
            Object element = it.next();
            if (!this.isMatchingElement(element, _s)) continue;
            return element;
        }
        return null;
    }

    @Nullable
    private Object findLastElement(String s) {
        String _s = s.trim();
        ListIterator<Object> it = this.getElementIterator(this.getElementCount());
        while (it.hasPrevious()) {
            Object element = it.previous();
            if (!this.isMatchingElement(element, _s)) continue;
            return element;
        }
        return null;
    }

    public void showPopup(String searchText) {
        this.manageSearchPopup(this.createPopup(searchText));
        if (this.mySearchPopup != null && ((Component)this.myComponent).isDisplayable()) {
            this.mySearchPopup.refreshSelection();
        }
    }

    public void showPopup() {
        this.showPopup("");
    }

    public void hidePopup() {
        JTextField field = this.getSearchField();
        if (field != null) {
            field.setText("");
        }
        this.manageSearchPopup(null);
    }

    protected void processKeyEvent(KeyEvent e) {
        if (e.isAltDown() && SpeedSearchBase.getNavigationKeyCode(e) == 0) {
            return;
        }
        if (e.isShiftDown() && SpeedSearchBase.isNavigationKey(e.getKeyCode())) {
            return;
        }
        if (this.mySearchPopup != null) {
            this.mySearchPopup.processKeyEvent(e);
            return;
        }
        if (!this.isSpeedSearchEnabled()) {
            return;
        }
        if (e.getID() == 400) {
            if (!UIUtil.isReallyTypedEvent((KeyEvent)e)) {
                return;
            }
            char c = e.getKeyChar();
            if (Character.isLetterOrDigit(c) || !Character.isWhitespace(c) && "*_-+\"'/.#$>: ,;?!@%^&".indexOf(c) != -1) {
                this.showPopup(String.valueOf(c));
                e.consume();
            }
        }
    }

    public void processInputMethodEvent(InputMethodEvent e) {
        AttributedCharacterIterator text2;
        if (!this.isSpeedSearchEnabled()) {
            return;
        }
        if (this.mySearchPopup == null && e.getID() == 1100 && (text2 = e.getText()) != null && text2.first() != '\uffff') {
            this.showPopup();
        }
        if (this.mySearchPopup != null) {
            this.mySearchPopup.processInputMethodEvent(e);
        }
    }

    @NotNull
    protected SearchPopup createPopup(String s) {
        return new SearchPopup(s);
    }

    public Comp getComponent() {
        return this.myComponent;
    }

    public boolean isSupported() {
        return true;
    }

    protected boolean isSpeedSearchEnabled() {
        return true;
    }

    @ApiStatus.Internal
    public boolean isAvailable() {
        return this.isSpeedSearchEnabled();
    }

    public boolean isActive() {
        return this.isPopupActive();
    }

    @Nullable
    public JComponent getTextField() {
        return this.getSearchField();
    }

    public void activate() {
        this.showPopup();
    }

    @Nullable
    @NlsSafe
    public String getEnteredPrefix() {
        return this.mySearchPopup != null ? this.mySearchPopup.mySearchField.getText() : null;
    }

    public void refreshSelection() {
        if (this.mySearchPopup != null) {
            this.mySearchPopup.refreshSelection();
        }
    }

    public void findAndSelectElement(@NotNull String searchQuery) {
        if (searchQuery == null) {
            SpeedSearchBase.$$$reportNull$$$0(7);
        }
        if (this.mySearchPopup != null) {
            this.mySearchPopup.updateSelection(this.findElement(searchQuery), searchQuery);
        } else {
            this.selectElement(this.findElement(searchQuery), searchQuery);
        }
    }

    public boolean adjustSelection(int keyCode, @NotNull String searchQuery) {
        if (searchQuery == null) {
            SpeedSearchBase.$$$reportNull$$$0(8);
        }
        if (SpeedSearchBase.isUpDownHomeEnd(keyCode)) {
            UIEventLogger.IncrementalSearchNextPrevItemSelected.log(this.myComponent.getClass());
            Object element = this.findTargetElement(keyCode, searchQuery);
            if (element != null) {
                this.selectElement(element, searchQuery);
                return true;
            }
        }
        return false;
    }

    @Nullable
    private Object findTargetElement(int keyCode, @NotNull String searchPrefix) {
        if (searchPrefix == null) {
            SpeedSearchBase.$$$reportNull$$$0(9);
        }
        if (keyCode == 38) {
            return this.findPreviousElement(searchPrefix);
        }
        if (keyCode == 40) {
            return this.findNextElement(searchPrefix);
        }
        if (keyCode == 36) {
            return this.findFirstElement(searchPrefix);
        }
        assert (keyCode == 35);
        return this.findLastElement(searchPrefix);
    }

    private void mouseButtonInTheSearchFieldPressed() {
        if (this.keepEvenWhenFocusLost() && ((Component)this.myComponent).isVisible() && !((Component)this.myComponent).isFocusOwner()) {
            ((JComponent)this.myComponent).requestFocus();
        }
    }

    private static int getNavigationKeyCode(KeyEvent e) {
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
        if (SpeedSearchBase.isUpDownHomeEnd(e.getKeyCode())) {
            return e.getKeyCode();
        }
        KeymapManager keymapManager = KeymapManager.getInstance();
        if (keymapManager != null) {
            String[] actionIds;
            String[] stringArray = actionIds = keymapManager.getActiveKeymap().getActionIds(keyStroke);
            int n = stringArray.length;
            for (int j = 0; j < n; ++j) {
                String id2;
                switch (id2 = stringArray[j]) {
                    case "EditorUp": 
                    case "FindPrevious": {
                        return 38;
                    }
                    case "EditorDown": 
                    case "FindNext": {
                        return 40;
                    }
                    case "EditorLineStart": {
                        return 36;
                    }
                    case "EditorLineEnd": {
                        return 35;
                    }
                }
            }
        }
        return 0;
    }

    protected void onSearchFieldUpdated(String pattern) {
        if (Strings.isEmpty((String)pattern) && Registry.is((String)"ide.speed.search.close.when.empty")) {
            this.hidePopup();
        }
    }

    @Nullable
    protected ExtendableTextComponent.Extension createSearchFieldExtension() {
        return null;
    }

    private static boolean isUpDownHomeEnd(int keyCode) {
        return keyCode == 36 || keyCode == 35 || keyCode == 38 || keyCode == 40;
    }

    private static boolean isPgUpPgDown(int keyCode) {
        return keyCode == 33 || keyCode == 34;
    }

    private static boolean isNavigationKey(int keyCode) {
        return SpeedSearchBase.isPgUpPgDown(keyCode) || SpeedSearchBase.isUpDownHomeEnd(keyCode);
    }

    @ApiStatus.Internal
    protected void manageSearchPopup(@Nullable SearchPopup searchPopup) {
        if (this.mySearchPopup != null) {
            project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)((JComponent)this.myComponent).getRootPane()));
            UIEventLogger.IncrementalSearchCancelled.log(project, this.myComponent.getClass());
            if (this.myPopupLayeredPane != null) {
                this.myPopupLayeredPane.remove(this.mySearchPopup);
                this.myPopupLayeredPane.validate();
                this.myPopupLayeredPane.repaint();
                this.myPopupLayeredPane = null;
            }
            if (this.myListenerDisposable != null) {
                Disposer.dispose((Disposable)this.myListenerDisposable);
                this.myListenerDisposable = null;
            }
            if (this.isStickySearch()) {
                ((JComponent)this.myComponent).putClientProperty(SEARCH_TEXT_KEY, Strings.nullize((String)this.getEnteredPrefix()));
            }
        } else if (searchPopup != null) {
            project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)((JComponent)this.myComponent).getRootPane()));
            FeatureUsageTracker.getInstance().triggerFeatureUsed("ui.tree.speedsearch");
            UIEventLogger.IncrementalSearchActivated.log(project, this.myComponent.getClass());
        }
        this.mySearchPopup = ((Component)this.myComponent).isShowing() ? searchPopup : null;
        this.fireStateChanged();
        if (this.mySearchPopup == null || !((Component)this.myComponent).isDisplayable()) {
            return;
        }
        JRootPane rootPane = ((JComponent)this.myComponent).getRootPane();
        Project project2 = ProjectUtil.getProjectForComponent(rootPane);
        if (project2 != null && !project2.isDefault() && !project2.isDisposed()) {
            this.myListenerDisposable = Disposer.newDisposable();
            project2.getMessageBus().connect(this.myListenerDisposable).subscribe(ToolWindowManagerListener.TOPIC, (Object)this.myToolWindowListener);
        }
        JLayeredPane jLayeredPane = this.myPopupLayeredPane = rootPane == null ? null : rootPane.getLayeredPane();
        if (this.myPopupLayeredPane == null) {
            LOG.error(String.valueOf((Object)this) + " in " + String.valueOf(this.myComponent));
            return;
        }
        this.myPopupLayeredPane.add((Component)this.mySearchPopup, JLayeredPane.POPUP_LAYER);
        this.moveSearchPopup();
    }

    @ApiStatus.Internal
    protected void moveSearchPopup() {
        RelativeRectangle relativeRectangle;
        SpeedSearchSupply.SpeedSearchLocator locator;
        if (this.myComponent == null || this.mySearchPopup == null || this.myPopupLayeredPane == null) {
            return;
        }
        Point lPaneP = this.myPopupLayeredPane.getLocationOnScreen();
        Point componentP = this.getComponentLocationOnScreen();
        Rectangle r = this.getComponentVisibleRect();
        Dimension prefSize = this.mySearchPopup.getPreferredSize();
        Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this.myComponent);
        Point windowP = window instanceof JDialog ? ((JDialog)window).getContentPane().getLocationOnScreen() : (window instanceof JFrame ? ((JFrame)window).getContentPane().getLocationOnScreen() : window.getLocationOnScreen());
        int y = r.y + componentP.y - lPaneP.y - prefSize.height;
        y = Math.max(y, windowP.y - lPaneP.y);
        Point location = new Point(componentP.x - lPaneP.x + r.x, y);
        if (Registry.is((String)"ide.speed.search.allow.custom.location") && (locator = (SpeedSearchSupply.SpeedSearchLocator)DataManager.getInstance().getDataContext(this.myComponent).getData(PlatformDataKeys.SPEED_SEARCH_LOCATOR)) != null && (relativeRectangle = locator.getSizeAndLocation(this.myComponent)) != null) {
            Rectangle rect = relativeRectangle.getRectangleOn((Component)this.myPopupLayeredPane);
            location = rect.getLocation();
            prefSize = rect.getSize();
            this.mySearchPopup.setPreferredSize(prefSize);
        }
        this.mySearchPopup.setLocation(location);
        this.mySearchPopup.setSize(prefSize);
        this.mySearchPopup.setVisible(true);
        this.mySearchPopup.validate();
    }

    protected Rectangle getComponentVisibleRect() {
        return ((JComponent)this.myComponent).getVisibleRect();
    }

    protected Point getComponentLocationOnScreen() {
        return ((Component)this.myComponent).getLocationOnScreen();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchQuery";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchPrefix";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/SpeedSearchBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "matchingFragments";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addChangeListener";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "removeChangeListener";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "compare";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findPreviousElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "findAndSelectElement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustSelection";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "findTargetElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected class SearchPopup
    extends JPanel {
        @NotNull
        protected final SearchField mySearchField;
        private String myLastPattern = "";
        private boolean myFiringCallback = false;

        protected SearchPopup(String initialString) {
            this.mySearchField = new SearchField();
            this.mySearchField.setBorder(null);
            this.mySearchField.setBackground((Color)BACKGROUND_COLOR);
            this.mySearchField.setForeground((Color)FOREGROUND_COLOR);
            this.mySearchField.setDocument(new PlainDocument(){

                @Override
                public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                    String oldText;
                    try {
                        oldText = this.getText(0, this.getLength());
                    }
                    catch (BadLocationException e1) {
                        oldText = "";
                    }
                    String newText = oldText.substring(0, offs) + str + oldText.substring(offs);
                    super.insertString(offs, str, a);
                    SearchPopup.this.handleInsert(newText);
                    SearchPopup.this.updateSelection(SpeedSearchBase.this.findElement(newText), SearchPopup.this.mySearchField.getText());
                }
            });
            Border lineBorder = JBUI.Borders.customLine((Color)BORDER_COLOR);
            if (ExperimentalUI.isNewUI()) {
                this.setBorder(JBUI.Borders.compound((Border)lineBorder, (Border)new EmptyBorder((Insets)SpeedSearchBase.borderInsets())));
            } else {
                this.setBorder(lineBorder);
            }
            this.setBackground((Color)BACKGROUND_COLOR);
            this.setLayout(new BorderLayout());
            this.add((Component)((Object)this.mySearchField), "Center");
            this.mySearchField.setText(initialString);
            this.mySearchField.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    super.mousePressed(e);
                    if (e.getButton() == 1) {
                        SpeedSearchBase.this.mouseButtonInTheSearchFieldPressed();
                    }
                }
            });
            this.updateLastPattern();
        }

        private void updateLastPattern() {
            String pattern = Strings.notNullize((String)this.mySearchField.getText());
            if (!pattern.equals(this.myLastPattern)) {
                this.myLastPattern = pattern;
                SpeedSearchBase.this.onSearchFieldUpdated(pattern);
            }
        }

        protected void handleInsert(String newText) {
            if (SpeedSearchBase.this.findElement(newText) == null) {
                this.mySearchField.setForeground((Color)ERROR_FOREGROUND_COLOR);
            } else {
                this.mySearchField.setForeground((Color)FOREGROUND_COLOR);
            }
        }

        @Override
        public void processKeyEvent(KeyEvent e) {
            this.mySearchField.processKeyEvent(e);
            if (e.isConsumed()) {
                Object element;
                this.updateLastPattern();
                String s = this.mySearchField.getText();
                int navKeyCode = SpeedSearchBase.getNavigationKeyCode(e);
                if (navKeyCode != 0) {
                    element = SpeedSearchBase.this.findTargetElement(navKeyCode, s);
                    if (SpeedSearchBase.this.myClearSearchOnNavigateNoMatch && element == null) {
                        SpeedSearchBase.this.manageSearchPopup(null);
                        element = SpeedSearchBase.this.findTargetElement(navKeyCode, "");
                    }
                } else {
                    UIEventLogger.IncrementalSearchKeyTyped.log(SpeedSearchBase.this.myComponent.getClass());
                    element = SpeedSearchBase.this.findElement(s);
                }
                this.updateSelection(element, this.mySearchField.getText());
            }
        }

        @Override
        public void processInputMethodEvent(InputMethodEvent e) {
            this.mySearchField.processInputMethodEvent(e);
            if (e.isConsumed()) {
                this.updateLastPattern();
                String s = this.mySearchField.getText();
                this.updateSelection(SpeedSearchBase.this.findElement(s), s);
            }
        }

        @ApiStatus.Internal
        public void refreshSelection() {
            SpeedSearchBase.this.findAndSelectElement(this.mySearchField.getText());
        }

        @ApiStatus.Internal
        protected void updateSelection(Object element, String selectedText) {
            if (element != null) {
                SpeedSearchBase.this.selectElement(element, selectedText);
                this.mySearchField.setForeground((Color)FOREGROUND_COLOR);
            } else {
                this.mySearchField.setForeground((Color)ERROR_FOREGROUND_COLOR);
            }
            if (SpeedSearchBase.this.mySearchPopup != null) {
                SpeedSearchBase.this.mySearchPopup.setSize(SpeedSearchBase.this.mySearchPopup.getPreferredSize());
                SpeedSearchBase.this.mySearchPopup.validate();
            }
            if (this.myFiringCallback) {
                return;
            }
            this.myFiringCallback = true;
            try {
                SpeedSearchBase.this.fireStateChanged();
            }
            finally {
                this.myFiringCallback = false;
            }
        }
    }

    protected final class SearchField
    extends ExtendableTextField {
        SearchField() {
            this.setFocusable(false);
            ExtendableTextComponent.Extension leftExtension = new ExtendableTextComponent.Extension(){

                public Icon getIcon(boolean hovered) {
                    return AllIcons.Actions.Search;
                }

                public boolean isIconBeforeText() {
                    return true;
                }

                public int getIconGap() {
                    return JBUIScale.scale((int)10);
                }
            };
            this.addExtension(leftExtension);
            ExtendableTextComponent.Extension rightExtension = SpeedSearchBase.this.createSearchFieldExtension();
            if (rightExtension != null) {
                this.addExtension(rightExtension);
            }
            this.getEmptyText().setText(ApplicationBundle.message((String)"editorsearch.search.hint", (Object[])new Object[0]));
        }

        public void addNotify() {
            super.addNotify();
            this.getCaret().setVisible(true);
        }

        public void removeNotify() {
            this.getCaret().setVisible(false);
            super.removeNotify();
        }

        public void setForeground(Color color) {
            super.setForeground(color);
        }

        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            Insets m = this.getMargin();
            FontMetrics fm = this.getFontMetrics(this.getFont());
            String text2 = this.getText();
            String emptyText = this.getEmptyText().getText();
            dim.width = Math.max(fm.stringWidth(text2), fm.stringWidth(emptyText)) + 10 + m.left + m.right;
            return dim;
        }

        public void processKeyEvent(KeyEvent e) {
            int i2 = e.getKeyCode();
            if (i2 == 8 && this.getDocument().getLength() == 0) {
                e.consume();
                return;
            }
            if (i2 == 10 || i2 == 33 || i2 == 34 || i2 == 37 || i2 == 39) {
                if (!SpeedSearchBase.this.isStickySearch()) {
                    SpeedSearchBase.this.manageSearchPopup(null);
                }
                return;
            }
            if (i2 == 27) {
                SpeedSearchBase.this.hidePopup();
                e.consume();
                return;
            }
            if (SpeedSearchBase.isUpDownHomeEnd(i2)) {
                e.consume();
                return;
            }
            if (e.getID() == 400 && !UIUtil.isReallyTypedEvent((KeyEvent)e)) {
                return;
            }
            super.processKeyEvent(e);
            if (!e.isConsumed() && SpeedSearchBase.getNavigationKeyCode(e) != 0) {
                e.consume();
            }
            if (i2 == 8) {
                e.consume();
            }
        }

        public void processInputMethodEvent(InputMethodEvent e) {
            super.processInputMethodEvent(e);
        }

        protected void processFocusEvent(FocusEvent e) {
            super.processFocusEvent(e);
            if (this.isShowing()) {
                this.getCaret().setVisible(true);
            }
        }
    }

    private static final class MyListIterator
    implements ListIterator<Object> {
        private final SpeedSearchBase<?> mySpeedSearch;
        private int myCurrentIndex;
        private final int myElementCount;
        private Object[] myElements;

        MyListIterator(@NotNull SpeedSearchBase<?> speedSearch2, int startIndex) {
            if (speedSearch2 == null) {
                MyListIterator.$$$reportNull$$$0(0);
            }
            this.mySpeedSearch = speedSearch2;
            this.myCurrentIndex = startIndex;
            if (!this.mySpeedSearch.myElementAtImplemented) {
                this.myElements = speedSearch2.getAllElements();
                this.myElementCount = this.myElements.length;
            } else {
                this.myElementCount = speedSearch2.getElementCount();
            }
            if (startIndex < 0 || startIndex > this.myElementCount) {
                throw new IndexOutOfBoundsException("Index: " + startIndex + " in: " + String.valueOf(((Object)speedSearch2).getClass()));
            }
        }

        @Override
        public boolean hasPrevious() {
            return this.myCurrentIndex != 0;
        }

        @Override
        public Object previous() {
            int i2 = this.myCurrentIndex - 1;
            if (i2 < 0) {
                throw new NoSuchElementException();
            }
            Object previous = this.getElementAt(i2);
            this.myCurrentIndex = i2;
            return previous;
        }

        private Object getElementAt(int i2) {
            if (this.mySpeedSearch.myElementAtImplemented) {
                return this.mySpeedSearch.getElementAt(i2);
            }
            int index = this.mySpeedSearch.convertIndexToModel(i2);
            return this.myElements[index];
        }

        @Override
        public int nextIndex() {
            return this.myCurrentIndex;
        }

        @Override
        public int previousIndex() {
            return this.myCurrentIndex - 1;
        }

        @Override
        public boolean hasNext() {
            return this.myCurrentIndex != this.myElementCount;
        }

        @Override
        public Object next() {
            if (this.myCurrentIndex + 1 > this.myElementCount) {
                throw new NoSuchElementException();
            }
            return this.getElementAt(this.myCurrentIndex++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not implemented in: " + this.getClass().getCanonicalName());
        }

        @Override
        public void set(Object o) {
            throw new UnsupportedOperationException("Not implemented in: " + this.getClass().getCanonicalName());
        }

        @Override
        public void add(Object o) {
            throw new UnsupportedOperationException("Not implemented in: " + this.getClass().getCanonicalName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "speedSearch", "com/intellij/ui/SpeedSearchBase$MyListIterator", "<init>"));
        }
    }
}

