/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.charts;

import java.awt.geom.Path2D;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0006H\u0002\u001a\u001c\u0010\u0007\u001a\u00020\u0001*\u00020\u00042\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002\u00a8\u0006\n"}, d2={"curveTo", "", "Ljava/awt/geom/Path2D$Double;", "neighbour", "", "orZero", "", "shiftLeftByTwo", "first", "second", "intellij.platform.ide.ui"})
@SourceDebugExtension(value={"SMAP\nLineChart.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineChart.kt\ncom/intellij/ui/charts/LineChartKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,307:1\n1#2:308\n*E\n"})
public final class LineChartKt {
    private static final void curveTo(Path2D.Double $this$curveTo, double[] neighbour) {
        boolean bl;
        boolean bl2 = bl = neighbour.length == 8;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Array must contain 4 points in format (x0, y0, x1, y1, x2, y2, x3, y3)";
            throw new AssertionError((Object)string);
        }
        double x0 = neighbour[0];
        double y0 = neighbour[1];
        double x1 = neighbour[2];
        double y1 = neighbour[3];
        double x2 = neighbour[4];
        double y2 = neighbour[5];
        double x3 = neighbour[6];
        double y3 = neighbour[7];
        double slope0 = LineChartKt.orZero((y1 - y0) / (x1 - x0));
        double slope1 = LineChartKt.orZero((y2 - y1) / (x2 - x1));
        double slope2 = LineChartKt.orZero((y3 - y2) / (x3 - x2));
        double tan1 = slope0 * slope1 <= 0.0 ? 0.0 : (slope0 + slope1) / (double)2;
        double tan2 = slope1 * slope2 <= 0.0 ? 0.0 : (slope1 + slope2) / (double)2;
        if (slope1 == 0.0) {
            tan1 = 0.0;
            tan2 = 0.0;
        } else {
            double a = tan1 / slope1;
            double b = tan2 / slope1;
            double h = Math.hypot(a, b);
            if (h > 3.0) {
                double t = 3.0 / h;
                tan1 = t * a * slope1;
                tan2 = t * b * slope1;
            }
        }
        double delta2 = (x2 - x1) / (double)3;
        double cx0 = x1 + delta2;
        double cy0 = y1 + delta2 * tan1;
        if (Double.isNaN(x0) || Double.isNaN(y0)) {
            cx0 = x1;
            cy0 = y1;
        }
        double delta0 = (x2 - x1) / (double)3;
        double cx1 = x2 - delta0;
        double cy1 = y2 - delta0 * tan2;
        if (Double.isNaN(x3) || Double.isNaN(y3)) {
            cx1 = x2;
            cy1 = y2;
        }
        $this$curveTo.curveTo(cx0, cy0, cx1, cy1, x2, y2);
    }

    private static final double orZero(double $this$orZero) {
        return Double.isNaN($this$orZero) ? 0.0 : $this$orZero;
    }

    private static final void shiftLeftByTwo(double[] $this$shiftLeftByTwo, double first, double second) {
        int n = $this$shiftLeftByTwo.length;
        for (int j = 2; j < n; ++j) {
            $this$shiftLeftByTwo[j - 2] = $this$shiftLeftByTwo[j];
        }
        $this$shiftLeftByTwo[$this$shiftLeftByTwo.length - 2] = first;
        $this$shiftLeftByTwo[$this$shiftLeftByTwo.length - 1] = second;
    }

    public static final /* synthetic */ void access$shiftLeftByTwo(double[] $receiver, double first, double second) {
        LineChartKt.shiftLeftByTwo($receiver, first, second);
    }

    public static final /* synthetic */ void access$curveTo(Path2D.Double $receiver, double[] neighbour) {
        LineChartKt.curveTo($receiver, neighbour);
    }
}

