/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.dsl.builder.impl;

import com.intellij.openapi.observable.properties.AtomicBooleanProperty;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.IndentedIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00140\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0014J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0014H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR+\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012*\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ui/dsl/builder/impl/CollapsibleTitledSeparatorImpl;", "Lcom/intellij/ui/TitledSeparator;", "title", "", "<init>", "(Ljava/lang/String;)V", "expandedProperty", "Lcom/intellij/openapi/observable/properties/AtomicBooleanProperty;", "getExpandedProperty", "()Lcom/intellij/openapi/observable/properties/AtomicBooleanProperty;", "<set-?>", "", "expanded", "getExpanded$delegate", "(Lcom/intellij/ui/dsl/builder/impl/CollapsibleTitledSeparatorImpl;)Ljava/lang/Object;", "getExpanded", "()Z", "setExpanded", "(Z)V", "onAction", "", "listener", "Lkotlin/Function1;", "createLabel", "Lcom/intellij/ui/components/JBLabel;", "getAccessibleContext", "Ljavax/accessibility/AccessibleContext;", "updateIcon", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class CollapsibleTitledSeparatorImpl
extends TitledSeparator {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final AtomicBooleanProperty expandedProperty;

    public CollapsibleTitledSeparatorImpl(@NlsContexts.Separator @NotNull String title2) {
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        super(title2);
        this.expandedProperty = new AtomicBooleanProperty(true);
        this.updateIcon();
        this.expandedProperty.afterChange(arg_0 -> CollapsibleTitledSeparatorImpl._init_$lambda$0(this, arg_0));
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.setExpanded(!this.getExpanded());
            }
        });
    }

    @NotNull
    public final AtomicBooleanProperty getExpandedProperty() {
        return this.expandedProperty;
    }

    public final boolean getExpanded() {
        return (Boolean)this.expandedProperty.getValue((Object)this, $$delegatedProperties[0]);
    }

    public final void setExpanded(boolean bl) {
        this.expandedProperty.setValue((Object)this, $$delegatedProperties[0], (Object)bl);
    }

    private static Object getExpanded$delegate(CollapsibleTitledSeparatorImpl collapsibleTitledSeparatorImpl) {
        return collapsibleTitledSeparatorImpl.expandedProperty;
    }

    public final void onAction(@NotNull Function1<? super Boolean, Unit> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.expandedProperty.afterChange(listener2);
    }

    @NotNull
    protected JBLabel createLabel() {
        return new JBLabel(this){
            final /* synthetic */ CollapsibleTitledSeparatorImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public AccessibleContext getAccessibleContext() {
                if (this.accessibleContext == null) {
                    this.accessibleContext = (AccessibleContext)((Object)new AccessibleAction(this, this.this$0){
                        final /* synthetic */ CollapsibleTitledSeparatorImpl this$0;
                        {
                            this.this$0 = $receiver2;
                            super((JLabel)((Object)$receiver));
                        }

                        public AccessibleStateSet getAccessibleStateSet() {
                            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
                            CollapsibleTitledSeparatorImpl collapsibleTitledSeparatorImpl = this.this$0;
                            AccessibleStateSet $this$getAccessibleStateSet_u24lambda_u240 = accessibleStateSet;
                            boolean bl = false;
                            $this$getAccessibleStateSet_u24lambda_u240.add(AccessibleState.EXPANDABLE);
                            $this$getAccessibleStateSet_u24lambda_u240.add(collapsibleTitledSeparatorImpl.getExpanded() ? AccessibleState.EXPANDED : AccessibleState.COLLAPSED);
                            return accessibleStateSet;
                        }

                        public String getAccessibleName() {
                            if (!SystemInfoRt.isMac) {
                                return super.getAccessibleName();
                            }
                            Object[] objectArray = new Object[]{super.getAccessibleName()};
                            return UIBundle.message((String)(this.this$0.getExpanded() ? "collapsible.titled.separator.expanded.accessible.name" : "collapsible.titled.separator.collapsed.accessible.name"), (Object[])objectArray);
                        }

                        public AccessibleRole getAccessibleRole() {
                            return SystemInfoRt.isMac ? AccessibleRole.PUSH_BUTTON : super.getAccessibleRole();
                        }

                        public AccessibleAction getAccessibleAction() {
                            return this;
                        }

                        public int getAccessibleActionCount() {
                            return 1;
                        }

                        public String getAccessibleActionDescription(int i2) {
                            return i2 == 0 ? UIManager.getString("AbstractButton.clickText") : null;
                        }

                        public boolean doAccessibleAction(int i2) {
                            if (i2 == 0) {
                                this.this$0.setExpanded(!this.this$0.getExpanded());
                                return true;
                            }
                            return false;
                        }
                    });
                }
                return this.accessibleContext;
            }
        };
    }

    @Nullable
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JPanel.AccessibleJPanel(this){};
        }
        return this.accessibleContext;
    }

    private final void updateIcon() {
        Icon icon2 = UIUtil.getTreeExpandedIcon();
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"getTreeExpandedIcon(...)");
        Icon treeExpandedIcon = icon2;
        Icon icon3 = UIUtil.getTreeCollapsedIcon();
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"getTreeCollapsedIcon(...)");
        Icon treeCollapsedIcon = icon3;
        int width = Math.max(treeExpandedIcon.getIconWidth(), treeCollapsedIcon.getIconWidth());
        Icon icon4 = this.getExpanded() ? treeExpandedIcon : treeCollapsedIcon;
        int extraSpace = width - icon4.getIconWidth();
        if (extraSpace > 0) {
            int left = extraSpace / 2;
            icon4 = (Icon)new IndentedIcon(icon4, new Insets(0, left, 0, extraSpace - left));
        }
        this.getLabel().setIcon(icon4);
        this.getLabel().setDisabledIcon(IconLoader.getTransparentIcon((Icon)icon4, (float)0.5f));
    }

    private static final Unit _init_$lambda$0(CollapsibleTitledSeparatorImpl this$0, boolean it) {
        this$0.updateIcon();
        return Unit.INSTANCE;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(CollapsibleTitledSeparatorImpl.class, "expanded", "getExpanded()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

