/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.filterField;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.filterField.FilterApplier;
import com.intellij.ui.filterField.FilterItem;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ui/filterField/FilterMultiSelectAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "attribute", "", "title", "owner", "Ljava/awt/Component;", "items", "", "Lcom/intellij/ui/filterField/FilterItem;", "selectedValues", "", "applier", "Lcom/intellij/ui/filterField/FilterApplier;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/awt/Component;Ljava/util/List;Ljava/util/Collection;Lcom/intellij/ui/filterField/FilterApplier;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "computeNotBiggerDimension", "Ljava/awt/Dimension;", "ofContent", "locationOnScreen", "Ljava/awt/Point;", "intellij.platform.ide.impl"})
public final class FilterMultiSelectAction
extends AnAction {
    @NotNull
    private final String attribute;
    @NotNull
    private final String title;
    @NotNull
    private final Component owner;
    @NotNull
    private final List<FilterItem> items;
    @NotNull
    private final Collection<String> selectedValues;
    @NotNull
    private final FilterApplier applier;

    public FilterMultiSelectAction(@NotNull String attribute, @Nls(capitalization=Nls.Capitalization.Title) @NotNull String title2, @NotNull Component owner, @NotNull List<FilterItem> items2, @NotNull Collection<String> selectedValues, @NotNull FilterApplier applier) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter(items2, (String)"items");
        Intrinsics.checkNotNullParameter(selectedValues, (String)"selectedValues");
        Intrinsics.checkNotNullParameter((Object)applier, (String)"applier");
        super(IdeBundle.message((String)"filters.select", (Object[])new Object[0]));
        this.attribute = attribute;
        this.title = title2;
        this.owner = owner;
        this.items = items2;
        this.selectedValues = selectedValues;
        this.applier = applier;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        CheckBoxList checkboxList = new CheckBoxList();
        checkboxList.setItems(this.items, arg_0 -> FilterMultiSelectAction.actionPerformed$lambda$1(FilterMultiSelectAction::actionPerformed$lambda$0, arg_0));
        for (FilterItem item : this.items) {
            if (!this.selectedValues.contains(item.getValue())) continue;
            checkboxList.setItemSelected((Object)item, true);
        }
        if (!((Collection)this.items).isEmpty()) {
            checkboxList.addSelectionInterval(0, 0);
        }
        checkboxList.setCheckBoxListListener((arg_0, arg_1) -> FilterMultiSelectAction.actionPerformed$lambda$2(this, checkboxList, arg_0, arg_1));
        JBScrollPane scrollPane = new JBScrollPane((Component)checkboxList);
        scrollPane.setBorder((Border)JBUI.Borders.empty());
        Dimension dimension = checkboxList.getPreferredSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
        scrollPane.setPreferredSize(this.computeNotBiggerDimension(dimension, this.owner.getLocationOnScreen()));
        JBPopup jBPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)scrollPane, (JComponent)checkboxList).setTitle(this.title).setRequestFocus(true).createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"createPopup(...)");
        JBPopup popup2 = jBPopup;
        popup2.setMinimumSize((Dimension)new JBDimension(250, 0));
        popup2.showUnderneathOf(this.owner);
    }

    private final Dimension computeNotBiggerDimension(Dimension ofContent, Point locationOnScreen) {
        int resultHeight;
        Dimension maxSize = new Dimension(Integer.MAX_VALUE, 600);
        int n = resultHeight = ofContent.height > maxSize.height ? maxSize.height : ofContent.height;
        if (locationOnScreen != null) {
            Rectangle rectangle = ScreenUtil.getScreenRectangle((Point)locationOnScreen);
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getScreenRectangle(...)");
            Rectangle r = rectangle;
            resultHeight = RangesKt.coerceAtMost((int)resultHeight, (int)(r.height - r.height / 4));
        }
        int resultWidth = RangesKt.coerceAtMost((int)ofContent.width, (int)maxSize.width);
        if (ofContent.height > maxSize.height) {
            resultWidth += (int)ScrollPaneFactory.createScrollPane().getVerticalScrollBar().getPreferredSize().getWidth();
        }
        return new Dimension(resultWidth, resultHeight);
    }

    private static final String actionPerformed$lambda$0(FilterItem it) {
        return it.getTitle();
    }

    private static final String actionPerformed$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final void actionPerformed$lambda$2(FilterMultiSelectAction this$0, CheckBoxList $checkboxList, int n, boolean bl) {
        Set selected = new LinkedHashSet();
        for (FilterItem item : this$0.items) {
            if (!$checkboxList.isItemSelected((Object)item)) continue;
            selected.add(item.getValue());
        }
        this$0.applier.applyFilter(this$0.attribute, selected);
    }
}

