/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.CommonBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.RegistryManager;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.util.LazyInitializer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

final class JBCefAppArmorUtils {
    private static final Logger LOG = Logger.getInstance(JBCefAppArmorUtils.class);
    private static final LazyInitializer.LazyValue<Boolean> myUnprivilegedUserNameSpacesRestricted = LazyInitializer.create(() -> JBCefAppArmorUtils.areUnprivilegedUserNameSpacesRestrictedImpl());

    JBCefAppArmorUtils() {
    }

    public static boolean areUnprivilegedUserNamespacesRestricted() {
        return (Boolean)myUnprivilegedUserNameSpacesRestricted.get();
    }

    public static void showUnprivilegedUserNamespacesRestrictedDialog(Component parentComponent) {
        UIUtil.invokeLaterIfNeeded(() -> {
            int chose = Messages.showDialog((Component)parentComponent, (String)IdeBundle.message((String)"notification.content.jcef.enable.browser.dialog.message", (Object[])new Object[0]), (String)IdeBundle.message((String)"notification.content.jcef.enable.browser.dialog.title", (Object[])new Object[0]), (String[])new String[]{IdeBundle.message((String)"notification.content.jcef.unprivileged.userns.restricted.action.add.apparmor.profile", (Object[])new Object[0]), IdeBundle.message((String)"notification.content.jcef.unprivileged.userns.restricted.action.disable.sandbox", (Object[])new Object[0]), CommonBundle.getCancelButtonText()}, (int)0, (Icon)Messages.getQuestionIcon());
            switch (chose) {
                case 0: {
                    JBCefAppArmorUtils.installAppArmorProfile();
                    break;
                }
                case 1: {
                    RegistryManager.getInstance().get("ide.browser.jcef.sandbox.enable").setValue(false);
                    ApplicationManager.getApplication().restart();
                }
            }
        });
    }

    public static JPanel getUnprivilegedUserNamespacesRestrictedStubPanel() {
        final JPanel stubPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 10;
        gbc.gridwidth = 0;
        JLabel label2 = new JLabel(IdeBundle.message((String)"notification.content.jcef.browser.suspended.text", (Object[])new Object[0]));
        JButton button2 = new JButton(IdeBundle.message((String)"notification.content.jcef.enable.browser.button", (Object[])new Object[0]));
        button2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JBCefAppArmorUtils.showUnprivilegedUserNamespacesRestrictedDialog(stubPanel);
            }
        });
        stubPanel.add((Component)label2, gbc);
        stubPanel.add((Component)button2, gbc);
        return stubPanel;
    }

    @Deprecated(forRemoval=true)
    static boolean areUnprivilegedUserNameSpacesAllowed() {
        return (Boolean)myUnprivilegedUserNameSpacesRestricted.get() == false;
    }

    private static boolean areUnprivilegedUserNameSpacesRestrictedImpl() {
        if (!SystemInfoRt.isLinux) {
            return false;
        }
        GeneralCommandLine cl = new GeneralCommandLine().withExePath("unshare").withParameters(new String[]{"--user", "--map-root-user", "echo"});
        try {
            CapturingProcessHandler handler2 = new CapturingProcessHandler(cl);
            ProcessOutput output = handler2.runProcess();
            if (output.getExitCode() == 0) {
                return false;
            }
            LOG.warn("Unprivileged user namespaces check failed: " + output.getStderr());
            return true;
        }
        catch (ExecutionException e) {
            LOG.warn("Failed to check unprivileged user namespaces restrictions(considered as restricted): " + e.getMessage());
            return true;
        }
    }

    private static String getApparmorProfile() {
        String executablePath = ProcessHandle.current().info().command().orElse(null);
        if (executablePath == null) {
            LOG.warn("Can't generate the apparmor profile for JCEF: failed to find the executable path");
            return null;
        }
        executablePath = executablePath.replace("\"", "\\\"");
        return "# This profile is autogenerated by %s to allow running sandboxed JCEF\nabi <abi/4.0>,\ninclude <tunables/global>\n\nprofile \"%s\" flags=(unconfined) {\n  userns,\n\n  include if exists <local/chrome>\n}\n".formatted(ApplicationNamesInfo.getInstance().getFullProductNameWithEdition(), executablePath).stripIndent();
    }

    private static String getApplicationName() {
        return (ApplicationNamesInfo.getInstance().getProductName() + "-" + ApplicationNamesInfo.getInstance().getEditionName()).toLowerCase(Locale.ROOT).replaceAll("[^a-z0-9]", "-");
    }

    private static String getApparmorProfilePath() {
        Path configDirPath = Path.of("/etc/apparmor.d", new String[0]);
        if (!Files.exists(configDirPath, new LinkOption[0]) || !Files.isDirectory(configDirPath, new LinkOption[0])) {
            LOG.warn("Can't generate the apparmor profile for CEF: /etc/apparmor.d doesn't exists");
            return null;
        }
        String appName = JBCefAppArmorUtils.getApplicationName();
        for (int i2 = 0; i2 <= 1000; ++i2) {
            String fileName = appName + (String)(i2 == 0 ? "" : "-" + i2);
            Path configPath = configDirPath.resolve(fileName);
            if (Files.exists(configPath, new LinkOption[0])) continue;
            return configPath.toString();
        }
        LOG.warn("Can't generate the apparmor profile for CEF: failed to find the filename");
        return null;
    }

    private static void installAppArmorProfile() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            String installationPath = JBCefAppArmorUtils.getApparmorProfilePath();
            String profileText = JBCefAppArmorUtils.getApparmorProfile();
            try {
                JBCefAppArmorUtils.installAppArmorProfile(installationPath, profileText);
            }
            catch (ExecutionException | IOException ex) {
                Notification notification2 = JBCefApp.getNotificationGroup().createNotification(IdeBundle.message((String)"notification.content.jcef.failed.to.install.apparmor.profile", (Object[])new Object[0]), ex.getMessage(), NotificationType.ERROR);
                Notifications.Bus.notify((Notification)notification2);
                return;
            }
            ApplicationManager.getApplication().restart();
        });
    }

    private static void installAppArmorProfile(String path, String content2) throws IOException, ExecutionException {
        File tmpPrifile = FileUtil.createTempFile((String)"apparmor_profile", null, (boolean)true);
        FileUtil.writeToFile((File)tmpPrifile, (String)content2);
        File installScript = FileUtil.createTempFile((String)"install_apparmor_profile.sh", null, (boolean)true);
        FileUtil.writeToFile((File)installScript, (String)"#!/bin/sh\nset -e\ncp %s %s\napparmor_parser -r %s\n".formatted(tmpPrifile, path, path).stripIndent());
        GeneralCommandLine commandLine = new GeneralCommandLine().withExePath("sh").withParameters(new String[]{installScript.toString()});
        commandLine = ExecUtil.sudoCommand((GeneralCommandLine)commandLine, (String)IdeBundle.message((String)"notification.content.jcef.unprivileged.userns.restricted.install.apparmor.profile.prompt", (Object[])new Object[0]).formatted(ApplicationNamesInfo.getInstance().getFullProductNameWithEdition()));
        ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)commandLine);
        if (output.getExitCode() != 0) {
            throw new ExecutionException(output.getStderr());
        }
    }

    static AnAction getInstallInstallAppArmorProfileAction(Runnable onComplete) {
        String installationPath = JBCefAppArmorUtils.getApparmorProfilePath();
        String profileText = JBCefAppArmorUtils.getApparmorProfile();
        if (installationPath == null || profileText == null) {
            return null;
        }
        return new InstallAppArmorProfileAction(installationPath, profileText, onComplete);
    }

    private static class InstallAppArmorProfileAction
    extends DumbAwareAction {
        private final String path;
        private final String profileContent;
        private final Runnable onComplete;

        InstallAppArmorProfileAction(String path, String content2, Runnable onComplete) {
            super(IdeBundle.message((String)"notification.content.jcef.unprivileged.userns.restricted.action.add.apparmor.profile", (Object[])new Object[0]));
            this.path = path;
            this.profileContent = content2;
            this.onComplete = onComplete;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                InstallAppArmorProfileAction.$$$reportNull$$$0(0);
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    JBCefAppArmorUtils.installAppArmorProfile(this.path, this.profileContent);
                }
                catch (ExecutionException | IOException ex) {
                    Notification notification2 = JBCefApp.getNotificationGroup().createNotification(IdeBundle.message((String)"notification.content.jcef.failed.to.install.apparmor.profile", (Object[])new Object[0]), ex.getMessage(), NotificationType.ERROR);
                    Notifications.Bus.notify((Notification)notification2);
                    return;
                }
                this.onComplete.run();
                ApplicationManager.getApplication().restart();
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/jcef/JBCefAppArmorUtils$InstallAppArmorProfileAction", "actionPerformed"));
        }
    }
}

