/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.RegistryManager;
import com.intellij.ui.jcef.DisposeHelper;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.ui.jcef.JBCefDisposable;
import com.intellij.ui.jcef.JBCefJSQuery;
import com.intellij.ui.jcef.PropertiesHelper;
import com.intellij.util.ObjectUtils;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import org.cef.CefClient;
import org.cef.CefSettings;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.callback.CefAuthCallback;
import org.cef.callback.CefBeforeDownloadCallback;
import org.cef.callback.CefCallback;
import org.cef.callback.CefContextMenuParams;
import org.cef.callback.CefDownloadItem;
import org.cef.callback.CefDownloadItemCallback;
import org.cef.callback.CefDragData;
import org.cef.callback.CefFileDialogCallback;
import org.cef.callback.CefJSDialogCallback;
import org.cef.callback.CefMediaAccessCallback;
import org.cef.callback.CefMenuModel;
import org.cef.callback.CefRunContextMenuCallback;
import org.cef.handler.CefContextMenuHandler;
import org.cef.handler.CefDialogHandler;
import org.cef.handler.CefDisplayHandler;
import org.cef.handler.CefDownloadHandler;
import org.cef.handler.CefDragHandler;
import org.cef.handler.CefFocusHandler;
import org.cef.handler.CefJSDialogHandler;
import org.cef.handler.CefKeyboardHandler;
import org.cef.handler.CefLifeSpanHandler;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefPermissionHandler;
import org.cef.handler.CefRequestHandler;
import org.cef.handler.CefResourceRequestHandler;
import org.cef.misc.BoolRef;
import org.cef.network.CefRequest;
import org.cef.security.CefSSLInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JBCefClient
implements JBCefDisposable {
    private static final Logger LOG = Logger.getInstance(JBCefClient.class);
    @NotNull
    private final PropertiesHelper myPropertiesHelper;
    private static final int JS_QUERY_POOL_DEFAULT_SIZE = RegistryManager.getInstance().intValue("ide.browser.jcef.jsQueryPoolSize");
    private static final int JS_QUERY_POOL_MAX_SIZE = 10000;
    @NotNull
    private final CefClient myCefClient;
    @NotNull
    private final DisposeHelper myDisposeHelper;
    @Nullable
    private volatile JSQueryPool myJSQueryPool;
    @NotNull
    private final AtomicInteger myJSQueryCounter;
    private final HandlerSupport<CefContextMenuHandler> myContextMenuHandler;
    private final HandlerSupport<CefDialogHandler> myDialogHandler;
    private final HandlerSupport<CefDisplayHandler> myDisplayHandler;
    private final HandlerSupport<CefDownloadHandler> myDownloadHandler;
    private final HandlerSupport<CefDragHandler> myDragHandler;
    private final HandlerSupport<CefPermissionHandler> myPermissionHandler;
    private final HandlerSupport<CefFocusHandler> myFocusHandler;
    private final HandlerSupport<CefJSDialogHandler> myJSDialogHandler;
    private final HandlerSupport<CefKeyboardHandler> myKeyboardHandler;
    private final HandlerSupport<CefLifeSpanHandler> myLifeSpanHandler;
    private final HandlerSupport<CefLoadHandler> myLoadHandler;
    private final HandlerSupport<CefRequestHandler> myRequestHandler;

    JBCefClient(@NotNull CefClient client2) {
        if (client2 == null) {
            JBCefClient.$$$reportNull$$$0(0);
        }
        this.myPropertiesHelper = new PropertiesHelper();
        this.myDisposeHelper = new DisposeHelper();
        this.myJSQueryCounter = new AtomicInteger(0);
        this.myContextMenuHandler = new HandlerSupport();
        this.myDialogHandler = new HandlerSupport();
        this.myDisplayHandler = new HandlerSupport();
        this.myDownloadHandler = new HandlerSupport();
        this.myDragHandler = new HandlerSupport();
        this.myPermissionHandler = new HandlerSupport();
        this.myFocusHandler = new HandlerSupport();
        this.myJSDialogHandler = new HandlerSupport();
        this.myKeyboardHandler = new HandlerSupport();
        this.myLifeSpanHandler = new HandlerSupport();
        this.myLoadHandler = new HandlerSupport();
        this.myRequestHandler = new HandlerSupport();
        this.myCefClient = client2;
        Disposer.register((Disposable)JBCefApp.getInstance().getDisposable(), (Disposable)this);
        Runnable createPool = () -> {
            if (this.myJSQueryPool != null) {
                LOG.warn("JSQueryPool has already been created, this request will be ignored");
                return;
            }
            this.myJSQueryPool = JSQueryPool.create(this);
        };
        this.addPropertyChangeListener("JBCefClient.JSQuery.poolSize", evt -> {
            if (evt.getNewValue() != null) {
                createPool.run();
            }
        });
        if (JS_QUERY_POOL_DEFAULT_SIZE > 0) {
            createPool.run();
        }
    }

    @NotNull
    public CefClient getCefClient() {
        CefClient cefClient = this.myCefClient;
        if (cefClient == null) {
            JBCefClient.$$$reportNull$$$0(1);
        }
        return cefClient;
    }

    public void dispose() {
        this.myDisposeHelper.dispose(() -> {
            try {
                this.myCefClient.dispose();
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        });
    }

    @Override
    public boolean isDisposed() {
        return this.myDisposeHelper.isDisposed();
    }

    public void setProperty(@NotNull String name2, @Nullable Object value) {
        if (name2 == null) {
            JBCefClient.$$$reportNull$$$0(2);
        }
        this.myPropertiesHelper.setProperty(name2, value);
    }

    @Nullable
    public Object getProperty(@NotNull String name2) {
        if (name2 == null) {
            JBCefClient.$$$reportNull$$$0(3);
        }
        return this.myPropertiesHelper.getProperty(name2);
    }

    void addPropertyChangeListener(@NotNull String name2, @NotNull PropertyChangeListener listener2) {
        if (name2 == null) {
            JBCefClient.$$$reportNull$$$0(4);
        }
        if (listener2 == null) {
            JBCefClient.$$$reportNull$$$0(5);
        }
        this.myPropertiesHelper.addPropertyChangeListener(name2, listener2);
    }

    void removePropertyChangeListener(@NotNull String name2, @NotNull PropertyChangeListener listener2) {
        if (name2 == null) {
            JBCefClient.$$$reportNull$$$0(6);
        }
        if (listener2 == null) {
            JBCefClient.$$$reportNull$$$0(7);
        }
        this.myPropertiesHelper.removePropertyChangeListener(name2, listener2);
    }

    @Nullable
    JSQueryPool getJSQueryPool() {
        return this.myJSQueryPool;
    }

    int nextJSQueryIndex() {
        return this.myJSQueryCounter.incrementAndGet();
    }

    public JBCefClient addContextMenuHandler(@NotNull CefContextMenuHandler handler2, @NotNull CefBrowser browser) {
        if (handler2 == null) {
            JBCefClient.$$$reportNull$$$0(8);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(9);
        }
        return this.myContextMenuHandler.add(handler2, browser, () -> this.myCefClient.addContextMenuHandler(new CefContextMenuHandler(){

            public void onBeforeContextMenu(CefBrowser browser, CefFrame frame, CefContextMenuParams params, CefMenuModel model2) {
                JBCefClient.this.myContextMenuHandler.handleAll(browser, handler2 -> handler2.onBeforeContextMenu(browser, frame, params, model2));
            }

            public boolean runContextMenu(CefBrowser browser, CefFrame frame, CefContextMenuParams params, CefMenuModel model2, CefRunContextMenuCallback callback) {
                return JBCefClient.this.myContextMenuHandler.handleBooleanFirst(browser, handler2 -> handler2.runContextMenu(browser, frame, params, model2, callback));
            }

            public boolean onContextMenuCommand(CefBrowser browser, CefFrame frame, CefContextMenuParams params, int commandId, int eventFlags) {
                return JBCefClient.this.myContextMenuHandler.handleBooleanReturnAnyOf(browser, handler2 -> handler2.onContextMenuCommand(browser, frame, params, commandId, eventFlags));
            }

            public void onContextMenuDismissed(CefBrowser browser, CefFrame frame) {
                JBCefClient.this.myContextMenuHandler.handleAll(browser, handler2 -> handler2.onContextMenuDismissed(browser, frame));
            }
        }));
    }

    public void removeContextMenuHandler(@NotNull CefContextMenuHandler handler2, @NotNull CefBrowser browser) {
        if (handler2 == null) {
            JBCefClient.$$$reportNull$$$0(10);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(11);
        }
        this.myContextMenuHandler.remove(handler2, browser, () -> this.myCefClient.removeContextMenuHandler());
    }

    public JBCefClient addDialogHandler(@NotNull CefDialogHandler handler2, @NotNull CefBrowser browser) {
        if (handler2 == null) {
            JBCefClient.$$$reportNull$$$0(12);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(13);
        }
        return this.myDialogHandler.add(handler2, browser, () -> this.myCefClient.addDialogHandler(new CefDialogHandler(){

            public boolean onFileDialog(CefBrowser browser, CefDialogHandler.FileDialogMode mode, String title2, String defaultFilePath, Vector<String> acceptFilters, Vector<String> acceptExtensions, Vector<String> acceptDescriptions, CefFileDialogCallback callback) {
                return JBCefClient.this.myDialogHandler.handleBooleanFirst(browser, handler2 -> handler2.onFileDialog(browser, mode, title2, defaultFilePath, acceptFilters, acceptExtensions, acceptDescriptions, callback));
            }
        }));
    }

    public void removeDialogHandler(@NotNull CefDialogHandler handler2, @NotNull CefBrowser browser) {
        if (handler2 == null) {
            JBCefClient.$$$reportNull$$$0(14);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(15);
        }
        this.myDialogHandler.remove(handler2, browser, () -> this.myCefClient.removeDialogHandler());
    }

    public JBCefClient addDisplayHandler(@NotNull CefDisplayHandler handler2, @NotNull CefBrowser browser) {
        if (handler2 == null) {
            JBCefClient.$$$reportNull$$$0(16);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(17);
        }
        return this.myDisplayHandler.add(handler2, browser, () -> this.myCefClient.addDisplayHandler(new CefDisplayHandler(){

            public void onAddressChange(CefBrowser browser, CefFrame frame, String url) {
                JBCefClient.this.myDisplayHandler.handleAll(browser, handler2 -> handler2.onAddressChange(browser, frame, url));
            }

            public void onTitleChange(CefBrowser browser, String title2) {
                JBCefClient.this.myDisplayHandler.handleAll(browser, handler2 -> handler2.onTitleChange(browser, title2));
            }

            public void onFullscreenModeChange(CefBrowser browser, boolean fullscreen) {
            }

            public boolean onTooltip(CefBrowser browser, String text2) {
                return JBCefClient.this.myDisplayHandler.handleBooleanReturnAnyOf(browser, handler2 -> handler2.onTooltip(browser, text2));
            }

            public void onStatusMessage(CefBrowser browser, String value) {
                JBCefClient.this.myDisplayHandler.handleAll(browser, handler2 -> handler2.onStatusMessage(browser, value));
            }

            public boolean onConsoleMessage(CefBrowser browser, CefSettings.LogSeverity level, String message, String source, int line) {
                return JBCefClient.this.myDisplayHandler.handleBooleanReturnAnyOf(browser, handler2 -> handler2.onConsoleMessage(browser, level, message, source, line));
            }

            public boolean onCursorChange(CefBrowser browser, int cursorType) {
                return JBCefClient.this.myDisplayHandler.handleBooleanReturnAnyOf(browser, handler2 -> handler2.onCursorChange(browser, cursorType));
            }
        }));
    }

    public void removeDisplayHandler(@NotNull CefDisplayHandler handler2, @NotNull CefBrowser browser) {
        if (handler2 == null) {
            JBCefClient.$$$reportNull$$$0(18);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(19);
        }
        this.myDisplayHandler.remove(handler2, browser, () -> this.myCefClient.removeDisplayHandler());
    }

    public JBCefClient addDownloadHandler(@NotNull CefDownloadHandler handler2, @NotNull CefBrowser browser) {
        if (handler2 == null) {
            JBCefClient.$$$reportNull$$$0(20);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(21);
        }
        return this.myDownloadHandler.add(handler2, browser, () -> this.myCefClient.addDownloadHandler(new CefDownloadHandler(){

            public boolean onBeforeDownload(CefBrowser browser, CefDownloadItem downloadItem, String suggestedName, CefBeforeDownloadCallback callback) {
                return JBCefClient.this.myDownloadHandler.handleBooleanReturnAnyOf(browser, handler2 -> handler2.onBeforeDownload(browser, downloadItem, suggestedName, callback));
            }

            public void onDownloadUpdated(CefBrowser browser, CefDownloadItem downloadItem, CefDownloadItemCallback callback) {
                JBCefClient.this.myDownloadHandler.handleAll(browser, handler2 -> handler2.onDownloadUpdated(browser, downloadItem, callback));
            }
        }));
    }

    public void removeDownloadHandle(@NotNull CefDownloadHandler handler2, @NotNull CefBrowser browser) {
        if (handler2 == null) {
            JBCefClient.$$$reportNull$$$0(22);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(23);
        }
        this.myDownloadHandler.remove(handler2, browser, () -> this.myCefClient.removeDownloadHandler());
    }

    public JBCefClient addDragHandler(@NotNull CefDragHandler handler2, @NotNull CefBrowser browser) {
        if (handler2 == null) {
            JBCefClient.$$$reportNull$$$0(24);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(25);
        }
        return this.myDragHandler.add(handler2, browser, () -> this.myCefClient.addDragHandler(new CefDragHandler(){

            public boolean onDragEnter(CefBrowser browser, CefDragData dragData, int mask) {
                return JBCefClient.this.myDragHandler.handleBooleanReturnAnyOf(browser, handler2 -> handler2.onDragEnter(browser, dragData, mask));
            }
        }));
    }

    public void removeDragHandler(@NotNull CefDragHandler handler2, @NotNull CefBrowser browser) {
        if (handler2 == null) {
            JBCefClient.$$$reportNull$$$0(26);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(27);
        }
        this.myDragHandler.remove(handler2, browser, () -> this.myCefClient.removeDragHandler());
    }

    public JBCefClient addPermissionHandler(@NotNull CefPermissionHandler handler2, @NotNull CefBrowser browser) {
        if (handler2 == null) {
            JBCefClient.$$$reportNull$$$0(28);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(29);
        }
        return this.myPermissionHandler.add(handler2, browser, () -> this.myCefClient.addPermissionHandler(new CefPermissionHandler(){

            public boolean onRequestMediaAccessPermission(CefBrowser browser, CefFrame frame, String requesting_url, int requested_permissions, CefMediaAccessCallback callback) {
                Boolean res = JBCefClient.this.myPermissionHandler.handleBooleanFirst(browser, handler2 -> handler2.onRequestMediaAccessPermission(browser, frame, requesting_url, requested_permissions, callback));
                return (Boolean)ObjectUtils.notNull((Object)res, (Object)false);
            }
        }));
    }

    public JBCefClient addFocusHandler(@NotNull CefFocusHandler handler2, @NotNull CefBrowser browser) {
        if (handler2 == null) {
            JBCefClient.$$$reportNull$$$0(30);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(31);
        }
        return this.myFocusHandler.add(handler2, browser, () -> this.myCefClient.addFocusHandler(new CefFocusHandler(){

            public void onTakeFocus(CefBrowser browser, boolean next) {
                JBCefClient.this.myFocusHandler.handleAll(browser, handler2 -> handler2.onTakeFocus(browser, next));
            }

            public boolean onSetFocus(CefBrowser browser, CefFocusHandler.FocusSource source) {
                return JBCefClient.this.myFocusHandler.handleBooleanReturnAnyOf(browser, handler2 -> handler2.onSetFocus(browser, source));
            }

            public void onGotFocus(CefBrowser browser) {
                JBCefClient.this.myFocusHandler.handleAll(browser, handler2 -> handler2.onGotFocus(browser));
            }
        }));
    }

    public void removeFocusHandler(@NotNull CefFocusHandler handler2, @NotNull CefBrowser browser) {
        if (handler2 == null) {
            JBCefClient.$$$reportNull$$$0(32);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(33);
        }
        this.myFocusHandler.remove(handler2, browser, () -> this.myCefClient.removeFocusHandler());
    }

    public JBCefClient addJSDialogHandler(@NotNull CefJSDialogHandler handler2, @NotNull CefBrowser browser) {
        if (handler2 == null) {
            JBCefClient.$$$reportNull$$$0(34);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(35);
        }
        return this.myJSDialogHandler.add(handler2, browser, () -> this.myCefClient.addJSDialogHandler(new CefJSDialogHandler(){

            public boolean onJSDialog(CefBrowser browser, String origin_url, CefJSDialogHandler.JSDialogType dialog_type, String message_text, String default_prompt_text, CefJSDialogCallback callback, BoolRef suppress_message) {
                return JBCefClient.this.myJSDialogHandler.handleBooleanFirst(browser, handler2 -> handler2.onJSDialog(browser, origin_url, dialog_type, message_text, default_prompt_text, callback, suppress_message));
            }

            public boolean onBeforeUnloadDialog(CefBrowser browser, String message_text, boolean is_reload, CefJSDialogCallback callback) {
                return JBCefClient.this.myJSDialogHandler.handleBooleanFirst(browser, handler2 -> handler2.onBeforeUnloadDialog(browser, message_text, is_reload, callback));
            }

            public void onResetDialogState(CefBrowser browser) {
                JBCefClient.this.myJSDialogHandler.handleAll(browser, handler2 -> handler2.onResetDialogState(browser));
            }

            public void onDialogClosed(CefBrowser browser) {
                JBCefClient.this.myJSDialogHandler.handleAll(browser, handler2 -> handler2.onDialogClosed(browser));
            }
        }));
    }

    public void removeJSDialogHandler(@NotNull CefJSDialogHandler handler2, @NotNull CefBrowser browser) {
        if (handler2 == null) {
            JBCefClient.$$$reportNull$$$0(36);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(37);
        }
        this.myJSDialogHandler.remove(handler2, browser, () -> this.myCefClient.removeJSDialogHandler());
    }

    public JBCefClient addKeyboardHandler(@NotNull CefKeyboardHandler handler2, @NotNull CefBrowser browser) {
        if (handler2 == null) {
            JBCefClient.$$$reportNull$$$0(38);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(39);
        }
        return this.myKeyboardHandler.add(handler2, browser, () -> this.myCefClient.addKeyboardHandler(new CefKeyboardHandler(){

            public boolean onPreKeyEvent(CefBrowser browser, CefKeyboardHandler.CefKeyEvent event, BoolRef is_keyboard_shortcut) {
                return JBCefClient.this.myKeyboardHandler.handleBooleanReturnAnyOf(browser, handler2 -> handler2.onPreKeyEvent(browser, event, is_keyboard_shortcut));
            }

            public boolean onKeyEvent(CefBrowser browser, CefKeyboardHandler.CefKeyEvent event) {
                return JBCefClient.this.myKeyboardHandler.handleBooleanReturnAnyOf(browser, handler2 -> handler2.onKeyEvent(browser, event));
            }
        }));
    }

    public void removeKeyboardHandler(@NotNull CefKeyboardHandler handler2, @NotNull CefBrowser browser) {
        if (handler2 == null) {
            JBCefClient.$$$reportNull$$$0(40);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(41);
        }
        this.myKeyboardHandler.remove(handler2, browser, () -> this.myCefClient.removeKeyboardHandler());
    }

    public JBCefClient addLifeSpanHandler(@NotNull CefLifeSpanHandler handler2, @NotNull CefBrowser browser) {
        if (handler2 == null) {
            JBCefClient.$$$reportNull$$$0(42);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(43);
        }
        return this.myLifeSpanHandler.add(handler2, browser, () -> this.myCefClient.addLifeSpanHandler(new CefLifeSpanHandler(){

            public boolean onBeforePopup(CefBrowser browser, CefFrame frame, String target_url, String target_frame_name) {
                return JBCefClient.this.myLifeSpanHandler.handleBooleanReturnAnyOf(browser, handler2 -> handler2.onBeforePopup(browser, frame, target_url, target_frame_name));
            }

            public void onAfterCreated(CefBrowser browser) {
                JBCefClient.this.myLifeSpanHandler.handleAll(browser, handler2 -> handler2.onAfterCreated(browser));
            }

            public void onAfterParentChanged(CefBrowser browser) {
                JBCefClient.this.myLifeSpanHandler.handleAll(browser, handler2 -> handler2.onAfterParentChanged(browser));
            }

            public boolean doClose(CefBrowser browser) {
                return JBCefClient.this.myLifeSpanHandler.handleBooleanReturnAnyOf(browser, handler2 -> handler2.doClose(browser));
            }

            public void onBeforeClose(CefBrowser browser) {
                JBCefClient.this.myLifeSpanHandler.handleAll(browser, handler2 -> handler2.onBeforeClose(browser));
            }
        }));
    }

    public void removeLifeSpanHandler(@NotNull CefLifeSpanHandler handler2, @NotNull CefBrowser browser) {
        if (handler2 == null) {
            JBCefClient.$$$reportNull$$$0(44);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(45);
        }
        this.myLifeSpanHandler.remove(handler2, browser, () -> this.myCefClient.removeLifeSpanHandler());
    }

    public JBCefClient addLoadHandler(@NotNull CefLoadHandler handler2, @NotNull CefBrowser browser) {
        if (handler2 == null) {
            JBCefClient.$$$reportNull$$$0(46);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(47);
        }
        return this.myLoadHandler.add(handler2, browser, () -> this.myCefClient.addLoadHandler(new CefLoadHandler(){

            public void onLoadingStateChange(CefBrowser browser, boolean isLoading, boolean canGoBack, boolean canGoForward) {
                JBCefClient.this.myLoadHandler.handleAll(browser, handler2 -> handler2.onLoadingStateChange(browser, isLoading, canGoBack, canGoForward));
            }

            public void onLoadStart(CefBrowser browser, CefFrame frame, CefRequest.TransitionType transitionType) {
                JBCefClient.this.myLoadHandler.handleAll(browser, handler2 -> handler2.onLoadStart(browser, frame, transitionType));
            }

            public void onLoadEnd(CefBrowser browser, CefFrame frame, int httpStatusCode) {
                JBCefClient.this.myLoadHandler.handleAll(browser, handler2 -> handler2.onLoadEnd(browser, frame, httpStatusCode));
            }

            public void onLoadError(CefBrowser browser, CefFrame frame, CefLoadHandler.ErrorCode errorCode, String errorText, String failedUrl) {
                JBCefClient.this.myLoadHandler.handleAll(browser, handler2 -> handler2.onLoadError(browser, frame, errorCode, errorText, failedUrl));
            }
        }));
    }

    public void removeLoadHandler(@NotNull CefLoadHandler handler2, @NotNull CefBrowser browser) {
        if (handler2 == null) {
            JBCefClient.$$$reportNull$$$0(48);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(49);
        }
        this.myLoadHandler.remove(handler2, browser, () -> this.myCefClient.removeLoadHandler());
    }

    public JBCefClient addRequestHandler(@NotNull CefRequestHandler handler2, @NotNull CefBrowser browser) {
        if (handler2 == null) {
            JBCefClient.$$$reportNull$$$0(50);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(51);
        }
        return this.myRequestHandler.add(handler2, browser, () -> this.myCefClient.addRequestHandler(new CefRequestHandler(){

            public boolean onBeforeBrowse(CefBrowser browser, CefFrame frame, CefRequest request, boolean user_gesture, boolean is_redirect) {
                return JBCefClient.this.myRequestHandler.handleBooleanReturnAnyOf(browser, handler2 -> handler2.onBeforeBrowse(browser, frame, request, user_gesture, is_redirect));
            }

            public boolean onOpenURLFromTab(CefBrowser browser, CefFrame frame, String target_url, boolean user_gesture) {
                return JBCefClient.this.myRequestHandler.handleBooleanReturnAnyOf(browser, handler2 -> handler2.onOpenURLFromTab(browser, frame, target_url, user_gesture));
            }

            @Nullable
            public CefResourceRequestHandler getResourceRequestHandler(CefBrowser browser, CefFrame frame, CefRequest request, boolean isNavigation, boolean isDownload, String requestInitiator, BoolRef disableDefaultHandling) {
                return JBCefClient.this.myRequestHandler.handleFirst(browser, handler2 -> handler2.getResourceRequestHandler(browser, frame, request, isNavigation, isDownload, requestInitiator, disableDefaultHandling));
            }

            public boolean getAuthCredentials(CefBrowser browser, String origin_url, boolean isProxy, String host, int port, String realm, String scheme, CefAuthCallback callback) {
                return JBCefClient.this.myRequestHandler.handleBooleanFirst(browser, handler2 -> handler2.getAuthCredentials(browser, origin_url, isProxy, host, port, realm, scheme, callback));
            }

            public boolean onCertificateError(CefBrowser browser, CefLoadHandler.ErrorCode cert_error, String request_url, CefSSLInfo sslInfo, CefCallback callback) {
                List<CefRequestHandler> handlers = JBCefClient.this.myRequestHandler.get(browser);
                if (handlers == null) {
                    return false;
                }
                boolean result2 = false;
                for (CefRequestHandler handler2 : handlers) {
                    result2 |= handler2.onCertificateError(browser, cert_error, request_url, sslInfo, callback);
                }
                return result2;
            }

            public void onRenderProcessTerminated(CefBrowser browser, CefRequestHandler.TerminationStatus status2, int error_code, String error_string) {
                JBCefClient.this.myRequestHandler.handleAll(browser, handler2 -> handler2.onRenderProcessTerminated(browser, status2, error_code, error_string));
            }
        }));
    }

    public void removeRequestHandler(@NotNull CefRequestHandler handler2, @NotNull CefBrowser browser) {
        if (handler2 == null) {
            JBCefClient.$$$reportNull$$$0(52);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(53);
        }
        this.myRequestHandler.remove(handler2, browser, () -> this.myCefClient.removeRequestHandler());
    }

    public void removeAllHandlers(CefBrowser browser) {
        this.myContextMenuHandler.removeAll(browser);
        this.myDialogHandler.removeAll(browser);
        this.myDisplayHandler.removeAll(browser);
        this.myDownloadHandler.removeAll(browser);
        this.myDragHandler.removeAll(browser);
        this.myPermissionHandler.removeAll(browser);
        this.myFocusHandler.removeAll(browser);
        this.myJSDialogHandler.removeAll(browser);
        this.myKeyboardHandler.removeAll(browser);
        this.myLifeSpanHandler.removeAll(browser);
        this.myLoadHandler.removeAll(browser);
        this.myRequestHandler.removeAll(browser);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/jcef/JBCefClient";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/jcef/JBCefClient";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCefClient";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setProperty";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getProperty";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addContextMenuHandler";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeContextMenuHandler";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addDialogHandler";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeDialogHandler";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addDisplayHandler";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeDisplayHandler";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addDownloadHandler";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "removeDownloadHandle";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addDragHandler";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "removeDragHandler";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addPermissionHandler";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addFocusHandler";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "removeFocusHandler";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "addJSDialogHandler";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "removeJSDialogHandler";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "addKeyboardHandler";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "removeKeyboardHandler";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "addLifeSpanHandler";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "removeLifeSpanHandler";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "addLoadHandler";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "removeLoadHandler";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "addRequestHandler";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "removeRequestHandler";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private class HandlerSupport<T> {
        private volatile Map<CefBrowser, List<T>> myMap;

        private HandlerSupport() {
        }

        private synchronized void syncInitMap() {
            if (this.myMap == null) {
                this.myMap = Collections.synchronizedMap(new LinkedHashMap());
            }
        }

        private synchronized List<T> syncInitList(@NotNull CefBrowser browser, @NotNull Runnable onInit) {
            List<Object> list2;
            if (browser == null) {
                HandlerSupport.$$$reportNull$$$0(0);
            }
            if (onInit == null) {
                HandlerSupport.$$$reportNull$$$0(1);
            }
            if ((list2 = this.myMap.get(browser)) == null) {
                if (this.myMap.isEmpty()) {
                    onInit.run();
                }
                list2 = Collections.synchronizedList(new LinkedList());
                this.myMap.put(browser, list2);
            }
            return list2;
        }

        private synchronized void syncRemoveFromMap(@NotNull List<T> list2, @NotNull CefBrowser browser, @NotNull Runnable onClear) {
            if (list2 == null) {
                HandlerSupport.$$$reportNull$$$0(2);
            }
            if (browser == null) {
                HandlerSupport.$$$reportNull$$$0(3);
            }
            if (onClear == null) {
                HandlerSupport.$$$reportNull$$$0(4);
            }
            if (list2.isEmpty()) {
                this.myMap.remove(browser);
                if (this.myMap.isEmpty()) {
                    onClear.run();
                }
            }
        }

        public JBCefClient add(@NotNull T handler2, @NotNull CefBrowser browser, @NotNull Runnable onInit) {
            List<T> list2;
            if (handler2 == null) {
                HandlerSupport.$$$reportNull$$$0(5);
            }
            if (browser == null) {
                HandlerSupport.$$$reportNull$$$0(6);
            }
            if (onInit == null) {
                HandlerSupport.$$$reportNull$$$0(7);
            }
            if (this.myMap == null) {
                this.syncInitMap();
            }
            if ((list2 = this.myMap.get(browser)) == null) {
                list2 = this.syncInitList(browser, onInit);
            }
            list2.add(handler2);
            return JBCefClient.this;
        }

        public void remove(@NotNull T handler2, @NotNull CefBrowser browser, @NotNull Runnable onClear) {
            List<T> list2;
            if (handler2 == null) {
                HandlerSupport.$$$reportNull$$$0(8);
            }
            if (browser == null) {
                HandlerSupport.$$$reportNull$$$0(9);
            }
            if (onClear == null) {
                HandlerSupport.$$$reportNull$$$0(10);
            }
            if (this.myMap != null && (list2 = this.myMap.get(browser)) != null) {
                list2.remove(handler2);
                if (list2.isEmpty()) {
                    this.syncRemoveFromMap(list2, browser, onClear);
                }
            }
        }

        public void clear() {
            if (this.myMap != null) {
                this.myMap.clear();
            }
        }

        public void removeAll(CefBrowser browser) {
            if (this.myMap != null) {
                this.myMap.remove(browser);
            }
        }

        @Nullable
        public List<T> get(@NotNull CefBrowser browser) {
            if (browser == null) {
                HandlerSupport.$$$reportNull$$$0(11);
            }
            return this.myMap != null ? this.myMap.get(browser) : null;
        }

        public void handleAll(@NotNull CefBrowser browser, @NotNull HandlerRunnable<T> runnable2) {
            List<Object> list2;
            if (browser == null) {
                HandlerSupport.$$$reportNull$$$0(12);
            }
            if (runnable2 == null) {
                HandlerSupport.$$$reportNull$$$0(13);
            }
            if ((list2 = this.get(browser)) == null) {
                return;
            }
            list2.forEach(handler2 -> runnable2.handle(handler2));
        }

        public boolean handleBooleanReturnAnyOf(@NotNull CefBrowser browser, @NotNull HandlerCallable<T, Boolean> callable) {
            List<T> list2;
            if (browser == null) {
                HandlerSupport.$$$reportNull$$$0(14);
            }
            if (callable == null) {
                HandlerSupport.$$$reportNull$$$0(15);
            }
            if ((list2 = this.get(browser)) == null) {
                return false;
            }
            boolean result2 = false;
            for (T handler2 : list2) {
                result2 |= Boolean.TRUE.equals(callable.handle(handler2));
            }
            return result2;
        }

        public boolean handleBooleanFirst(@NotNull CefBrowser browser, @NotNull HandlerCallable<T, Boolean> callable) {
            List<T> list2;
            if (browser == null) {
                HandlerSupport.$$$reportNull$$$0(16);
            }
            if (callable == null) {
                HandlerSupport.$$$reportNull$$$0(17);
            }
            if ((list2 = this.get(browser)) == null) {
                return false;
            }
            boolean result2 = false;
            for (T handler2 : list2) {
                if (!Boolean.TRUE.equals(callable.handle(handler2))) continue;
                return true;
            }
            return false;
        }

        public <R> R handleFirst(@NotNull CefBrowser browser, @NotNull HandlerCallable<T, R> callable) {
            List<T> list2;
            if (browser == null) {
                HandlerSupport.$$$reportNull$$$0(18);
            }
            if (callable == null) {
                HandlerSupport.$$$reportNull$$$0(19);
            }
            if ((list2 = this.get(browser)) == null) {
                return null;
            }
            for (T handler2 : list2) {
                R result2 = callable.handle(handler2);
                if (result2 == null) continue;
                return result2;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "browser";
                    break;
                }
                case 1: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "onInit";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 4: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "onClear";
                    break;
                }
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
                case 15: 
                case 17: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callable";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/jcef/JBCefClient$HandlerSupport";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "syncInitList";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "syncRemoveFromMap";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "add";
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "remove";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "get";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleAll";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleBooleanReturnAnyOf";
                    break;
                }
                case 16: 
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleBooleanFirst";
                    break;
                }
                case 18: 
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleFirst";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class Properties {
        @NotNull
        public static final String JS_QUERY_POOL_SIZE = "JBCefClient.JSQuery.poolSize";

        static {
            PropertiesHelper.setType(JS_QUERY_POOL_SIZE, Integer.class);
        }
    }

    static class JSQueryPool {
        private final List<JBCefJSQuery.JSQueryFunc> myPool;
        private final int mySizeLimit;

        @Nullable
        static JSQueryPool create(@NotNull JBCefClient client2) {
            int poolSize;
            if (client2 == null) {
                JSQueryPool.$$$reportNull$$$0(0);
            }
            if ((poolSize = client2.myPropertiesHelper.intValue("JBCefClient.JSQuery.poolSize", JS_QUERY_POOL_DEFAULT_SIZE)) > 0) {
                poolSize = Math.min(poolSize, 10000);
                return new JSQueryPool(client2, poolSize);
            }
            return null;
        }

        JSQueryPool(@NotNull JBCefClient client2, int poolSize) {
            if (client2 == null) {
                JSQueryPool.$$$reportNull$$$0(1);
            }
            this.mySizeLimit = poolSize;
            this.myPool = Collections.synchronizedList(new LinkedList());
            for (int i2 = 0; i2 < poolSize; ++i2) {
                this.myPool.add(i2, new JBCefJSQuery.JSQueryFunc(client2, i2, true));
            }
        }

        @Nullable
        public JBCefJSQuery.JSQueryFunc useFreeSlot() {
            if (this.myPool.isEmpty()) {
                LOG.warn("JavaScript query pool is over [size: " + this.mySizeLimit + "]", new Throwable());
                return null;
            }
            return this.myPool.remove(0);
        }

        public void releaseUsedSlot(@NotNull JBCefJSQuery.JSQueryFunc func) {
            if (func == null) {
                JSQueryPool.$$$reportNull$$$0(2);
            }
            this.myPool.add(func);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "client";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "func";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/jcef/JBCefClient$JSQueryPool";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "releaseUsedSlot";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static interface HandlerRunnable<T> {
        public void handle(T var1);
    }

    private static interface HandlerCallable<T, R> {
        @Nullable
        public R handle(T var1);
    }
}

