/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import java.io.PrintStream;
import java.util.LinkedList;

class JBCefFpsHelper {
    private final LinkedList<Event> onPaint = new LinkedList();
    private final LinkedList<Event> paintFrame = new LinkedList();

    JBCefFpsHelper() {
    }

    void onPaintStarted() {
        Event e = new Event();
        e.startNs = System.nanoTime();
        this.onPaint.add(e);
    }

    void onPaintFinished(long pixCount) {
        Event e = this.onPaint.getLast();
        e.endNs = System.nanoTime();
        e.data = pixCount;
    }

    void paintFrameStarted() {
        Event e = new Event();
        e.startNs = System.nanoTime();
        this.paintFrame.add(e);
    }

    void paintFrameFinished(int fps) {
        Event e = this.paintFrame.getLast();
        e.endNs = System.nanoTime();
        e.data = fps;
        System.out.println(fps);
    }

    void reset() {
        this.onPaint.clear();
        this.paintFrame.clear();
    }

    void writeCsv(PrintStream ps) {
        if (ps == null) {
            return;
        }
        String sep = ";";
        ps.print("onPaint.duration;");
        for (Event e : this.onPaint) {
            ps.printf("%.1f%s", Float.valueOf((float)e.durationNs() / 1000000.0f), ";");
        }
        ps.println();
        ps.print("onPaint.pixelsKb;");
        for (Event e : this.onPaint) {
            ps.printf("%.1f%s", Float.valueOf((float)(e.data * 4L) / 1024.0f), ";");
        }
        ps.println();
        ps.print("paintFrame.duration;");
        for (Event e : this.paintFrame) {
            ps.printf("%.1f%s", Float.valueOf((float)e.durationNs() / 1000000.0f), ";");
        }
        ps.println();
        ps.print("paintFrame.fps;");
        for (Event e : this.paintFrame) {
            ps.print(String.valueOf(e.data) + ";");
        }
        ps.println();
    }

    static class Event {
        long startNs;
        long endNs;
        long data;

        Event() {
        }

        long durationNs() {
            return this.endNs - this.startNs;
        }
    }
}

