/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.jcef.DisposeHelper;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.ui.jcef.JBCefBrowserBase;
import com.intellij.ui.jcef.JBCefClient;
import com.intellij.ui.jcef.JBCefDisposable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.browser.CefMessageRouter;
import org.cef.callback.CefQueryCallback;
import org.cef.handler.CefMessageRouterHandler;
import org.cef.handler.CefMessageRouterHandlerAdapter;
import org.cef.misc.CefLog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JBCefJSQuery
implements JBCefDisposable {
    private static final boolean DEBUG_JS = Boolean.getBoolean("ide.browser.jcef.debug.js");
    @NotNull
    private final JSQueryFunc myFunc;
    @NotNull
    private final JBCefClient myJBCefClient;
    @NotNull
    private final DisposeHelper myDisposeHelper;
    @NotNull
    private final Map<Function<? super String, ? extends Response>, CefMessageRouterHandler> myHandlerMap;

    private JBCefJSQuery(@NotNull JBCefBrowserBase browser, @NotNull JSQueryFunc func) {
        if (browser == null) {
            JBCefJSQuery.$$$reportNull$$$0(0);
        }
        if (func == null) {
            JBCefJSQuery.$$$reportNull$$$0(1);
        }
        this.myDisposeHelper = new DisposeHelper();
        this.myHandlerMap = Collections.synchronizedMap(new HashMap());
        this.myFunc = func;
        this.myJBCefClient = browser.getJBCefClient();
        Disposer.register((Disposable)browser.getJBCefClient(), (Disposable)this);
    }

    @NotNull
    public String getFuncName() {
        String string = this.myFunc.myFuncName;
        if (string == null) {
            JBCefJSQuery.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static JBCefJSQuery create(@NotNull JBCefBrowserBase browser) {
        JSQueryFunc slot;
        if (browser == null) {
            JBCefJSQuery.$$$reportNull$$$0(3);
        }
        Function<Void, JBCefJSQuery> create2 = v -> new JBCefJSQuery(browser, new JSQueryFunc(browser.getJBCefClient()));
        if (!browser.isCefBrowserCreateStarted()) {
            JBCefJSQuery jBCefJSQuery = create2.apply(null);
            if (jBCefJSQuery == null) {
                JBCefJSQuery.$$$reportNull$$$0(4);
            }
            return jBCefJSQuery;
        }
        JBCefClient.JSQueryPool pool = browser.getJBCefClient().getJSQueryPool();
        if (pool != null && (slot = pool.useFreeSlot()) != null) {
            return new JBCefJSQuery(browser, slot);
        }
        Logger.getInstance(JBCefJSQuery.class).warn("Set the property JBCefClient.Properties.JS_QUERY_POOL_SIZE to use JBCefJSQuery after the browser has been created", (Throwable)new IllegalStateException());
        JBCefJSQuery jBCefJSQuery = create2.apply(null);
        if (jBCefJSQuery == null) {
            JBCefJSQuery.$$$reportNull$$$0(5);
        }
        return jBCefJSQuery;
    }

    @Deprecated(forRemoval=true)
    public static JBCefJSQuery create(@NotNull JBCefBrowser browser) {
        if (browser == null) {
            JBCefJSQuery.$$$reportNull$$$0(6);
        }
        return JBCefJSQuery.create((JBCefBrowserBase)browser);
    }

    @NotNull
    public String inject(@Nullable String queryResult) {
        String string = this.inject(queryResult, "function(response) {}", "function(error_code, error_message) {}");
        if (string == null) {
            JBCefJSQuery.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String inject(@Nullable String queryResult, @NotNull String onSuccessCallback, @NotNull String onFailureCallback) {
        if (onSuccessCallback == null) {
            JBCefJSQuery.$$$reportNull$$$0(8);
        }
        if (onFailureCallback == null) {
            JBCefJSQuery.$$$reportNull$$$0(9);
        }
        this.checkDisposed();
        if (queryResult != null && queryResult.isEmpty()) {
            queryResult = "''";
        }
        String string = "window." + this.myFunc.myFuncName + "({request: '' + " + queryResult + ",onSuccess: " + onSuccessCallback + ",onFailure: " + onFailureCallback + "});";
        if (string == null) {
            JBCefJSQuery.$$$reportNull$$$0(10);
        }
        return string;
    }

    public void addHandler(final @NotNull Function<? super String, ? extends Response> handler2) {
        if (handler2 == null) {
            JBCefJSQuery.$$$reportNull$$$0(11);
        }
        this.checkDisposed();
        CefMessageRouterHandlerAdapter cefHandler = new CefMessageRouterHandlerAdapter(this){

            public boolean onQuery(CefBrowser browser, CefFrame frame, long query_id, String request, boolean persistent, CefQueryCallback callback) {
                if (DEBUG_JS) {
                    CefLog.Debug((String)"onQuery: browser=%s, frame=%s, qid=%d, request=%s", (Object[])new Object[]{browser, frame, query_id, request});
                }
                Response response = (Response)handler2.apply(request);
                if (callback != null && response != null) {
                    if (response.isSuccess() && response.hasResponse()) {
                        callback.success(response.response());
                    } else {
                        callback.failure(response.errCode(), response.errMsg());
                    }
                } else if (callback != null) {
                    callback.success("");
                }
                return true;
            }

            public void onQueryCanceled(CefBrowser browser, CefFrame frame, long queryId) {
                if (DEBUG_JS) {
                    CefLog.Debug((String)"onQueryCanceled: browser=%s, frame=%s, qid=%d", (Object[])new Object[]{browser, frame, queryId});
                }
            }
        };
        this.myFunc.myRouter.addHandler((CefMessageRouterHandler)cefHandler, false);
        this.myHandlerMap.put(handler2, (CefMessageRouterHandler)cefHandler);
    }

    public void removeHandler(@NotNull Function<? super String, ? extends Response> function) {
        CefMessageRouterHandler cefHandler;
        if (function == null) {
            JBCefJSQuery.$$$reportNull$$$0(12);
        }
        if ((cefHandler = this.myHandlerMap.remove(function)) != null) {
            this.myFunc.myRouter.removeHandler(cefHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearHandlers() {
        ArrayList functions = new ArrayList(this.myHandlerMap.size());
        Map<Function<? super String, ? extends Response>, CefMessageRouterHandler> map2 = this.myHandlerMap;
        synchronized (map2) {
            this.myHandlerMap.forEach((func, handler2) -> functions.add(func));
        }
        functions.forEach(func -> this.removeHandler((Function<? super String, ? extends Response>)func));
    }

    public void dispose() {
        this.myDisposeHelper.dispose(() -> {
            JBCefClient.JSQueryPool pool;
            if (this.myFunc.myIsSlot && (pool = this.myJBCefClient.getJSQueryPool()) != null) {
                this.clearHandlers();
                pool.releaseUsedSlot(this.myFunc);
                return;
            }
            this.myJBCefClient.getCefClient().removeMessageRouter(this.myFunc.myRouter);
            this.myFunc.myRouter.dispose();
            this.myHandlerMap.clear();
        });
    }

    @Override
    public boolean isDisposed() {
        return this.myDisposeHelper.isDisposed();
    }

    private void checkDisposed() {
        if (this.isDisposed()) {
            throw new IllegalStateException("the JS query has been disposed");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5, 7, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browser";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "func";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/jcef/JBCefJSQuery";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSuccessCallback";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onFailureCallback";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/jcef/JBCefJSQuery";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFuncName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 7: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "inject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 10: {
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "inject";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addHandler";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeHandler";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5, 7, 10 -> new IllegalStateException(string);
        };
    }

    static class JSQueryFunc {
        @NotNull
        final CefMessageRouter myRouter;
        @NotNull
        final String myFuncName;
        final boolean myIsSlot;

        JSQueryFunc(@NotNull JBCefClient client2) {
            if (client2 == null) {
                JSQueryFunc.$$$reportNull$$$0(0);
            }
            this(client2, client2.nextJSQueryIndex(), false);
        }

        JSQueryFunc(@NotNull JBCefClient client2, int index, boolean isSlot) {
            if (client2 == null) {
                JSQueryFunc.$$$reportNull$$$0(1);
            }
            String postfix = client2.hashCode() + "_" + (isSlot ? "slot_" : "") + index;
            this.myIsSlot = isSlot;
            this.myFuncName = "cefQuery_" + postfix;
            CefMessageRouter.CefMessageRouterConfig config = new CefMessageRouter.CefMessageRouterConfig();
            config.jsQueryFunction = this.myFuncName;
            config.jsCancelFunction = "cefQuery_cancel_" + postfix;
            this.myRouter = JBCefApp.getInstance().createMessageRouter(config);
            client2.getCefClient().addMessageRouter(this.myRouter);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/intellij/ui/jcef/JBCefJSQuery$JSQueryFunc", "<init>"));
        }
    }

    public static class Response {
        public static final int ERR_CODE_SUCCESS = 0;
        @Nullable
        private final String myResponse;
        private final int myErrCode;
        @Nullable
        private final String myErrMsg;

        public Response(@Nullable String response) {
            this(response, 0, null);
        }

        public Response(@Nullable String response, int errCode, @Nullable String errMsg) {
            this.myResponse = response;
            this.myErrCode = errCode;
            this.myErrMsg = errMsg;
        }

        @Nullable
        public String response() {
            return this.myResponse;
        }

        public int errCode() {
            return this.myErrCode;
        }

        @Nullable
        public String errMsg() {
            return this.myErrMsg;
        }

        public boolean isSuccess() {
            return this.myErrCode == 0;
        }

        public boolean hasResponse() {
            return this.myResponse != null;
        }
    }
}

