/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.layout.migLayout;

import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.ui.SeparatorComponent;
import com.intellij.ui.layout.GrowPolicy;
import com.intellij.ui.layout.SpacingConfiguration;
import com.intellij.ui.layout.migLayout.ComponentConstraintsKt;
import com.intellij.ui.layout.migLayout.MigLayoutUtilKt;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import net.miginfocom.layout.BoundSize;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.ConstraintParser;
import net.miginfocom.layout.DimConstraint;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Deprecated(message="Mig Layout is going to be removed, IDEA-306719")
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u0003J\u0016\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ui/layout/migLayout/DefaultComponentConstraintCreator;", "", "spacing", "Lcom/intellij/ui/layout/SpacingConfiguration;", "<init>", "(Lcom/intellij/ui/layout/SpacingConfiguration;)V", "shortTextSizeSpec", "Lnet/miginfocom/layout/BoundSize;", "kotlin.jvm.PlatformType", "mediumTextSizeSpec", "vertical1pxGap", "getVertical1pxGap", "()Lnet/miginfocom/layout/BoundSize;", "horizontalUnitSizeGap", "getHorizontalUnitSizeGap", "addGrowIfNeeded", "", "cc", "Lnet/miginfocom/layout/CC;", "component", "Ljava/awt/Component;", "applyGrowPolicy", "growPolicy", "Lcom/intellij/ui/layout/GrowPolicy;", "intellij.platform.ide.impl"})
@ApiStatus.ScheduledForRemoval
public final class DefaultComponentConstraintCreator {
    private final BoundSize shortTextSizeSpec;
    private final BoundSize mediumTextSizeSpec;
    @NotNull
    private final BoundSize vertical1pxGap;
    @NotNull
    private final BoundSize horizontalUnitSizeGap;

    public DefaultComponentConstraintCreator(@NotNull SpacingConfiguration spacing) {
        Intrinsics.checkNotNullParameter((Object)spacing, (String)"spacing");
        this.shortTextSizeSpec = ConstraintParser.parseBoundSize((String)(spacing.getShortTextWidth() + "px!"), (boolean)false, (boolean)true);
        this.mediumTextSizeSpec = ConstraintParser.parseBoundSize((String)(spacing.getShortTextWidth() + "px::" + spacing.getMaxShortTextWidth() + "px"), (boolean)false, (boolean)true);
        BoundSize boundSize = ConstraintParser.parseBoundSize((String)(JBUI.scale((int)1) + "px!"), (boolean)true, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)boundSize, (String)"parseBoundSize(...)");
        this.vertical1pxGap = boundSize;
        this.horizontalUnitSizeGap = MigLayoutUtilKt.gapToBoundSize(spacing.getUnitSize(), true);
    }

    @NotNull
    public final BoundSize getVertical1pxGap() {
        return this.vertical1pxGap;
    }

    @NotNull
    public final BoundSize getHorizontalUnitSizeGap() {
        return this.horizontalUnitSizeGap;
    }

    public final void addGrowIfNeeded(@NotNull CC cc, @NotNull Component component2, @NotNull SpacingConfiguration spacing) {
        Intrinsics.checkNotNullParameter((Object)cc, (String)"cc");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)spacing, (String)"spacing");
        if (component2 instanceof ComponentWithBrowseButton) {
            cc.minWidth(spacing.getMaxShortTextWidth() + "px");
            cc.growX();
        } else {
            Component view2;
            if (component2 instanceof JTextField && ((JTextField)component2).getColumns() != 0) {
                return;
            }
            if (component2 instanceof JTextComponent || component2 instanceof SeparatorComponent || component2 instanceof ComponentWithBrowseButton) {
                cc.growX();
            } else if (component2 instanceof JScrollPane || ComponentConstraintsKt.access$isPanelWithToolbar(component2) || ComponentConstraintsKt.access$isToolbarDecoratorPanel(component2)) {
                cc.grow().pushY();
            } else if (component2 instanceof JScrollPane && (view2 = ((JScrollPane)component2).getViewport().getView()) instanceof JTextArea && ((JTextArea)view2).getRows() == 0) {
                ((JTextArea)view2).setRows(3);
            }
        }
    }

    public final void applyGrowPolicy(@NotNull CC cc, @NotNull GrowPolicy growPolicy) {
        Intrinsics.checkNotNullParameter((Object)cc, (String)"cc");
        Intrinsics.checkNotNullParameter((Object)((Object)growPolicy), (String)"growPolicy");
        DimConstraint dimConstraint = cc.getHorizontal();
        dimConstraint.setSize(switch (WhenMappings.$EnumSwitchMapping$0[growPolicy.ordinal()]) {
            case 1 -> this.shortTextSizeSpec;
            case 2 -> this.mediumTextSizeSpec;
            default -> throw new NoWhenBranchMatchedException();
        });
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GrowPolicy.values().length];
            try {
                nArray[GrowPolicy.SHORT_TEXT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GrowPolicy.MEDIUM_TEXT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

