/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup.list;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.KeepPopupOnPerform;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.client.ClientSystemInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListPopupStepEx;
import com.intellij.openapi.ui.popup.MultiSelectionListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.ui.MouseMovementTracker;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.UiInterceptors;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.ActionGroupPopupActivity;
import com.intellij.ui.popup.ActionPopupStep;
import com.intellij.ui.popup.ClosableByLeftArrow;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.popup.NextStepHandler;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.ui.popup.async.AsyncPopupStep;
import com.intellij.ui.popup.async.AsyncPopupWaiter;
import com.intellij.ui.popup.list.FilterableListPopupStep;
import com.intellij.ui.popup.list.ListPopupModel;
import com.intellij.ui.popup.list.PopupInlineActionsSupport;
import com.intellij.ui.popup.list.PopupInlineActionsSupportKt;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.ui.popup.util.PopupImplUtil;
import com.intellij.ui.wayland.WaylandUtilKt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SlowOperations;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultListSelectionModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import kotlin.Unit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListPopupImpl
extends WizardPopup
implements ListPopup,
NextStepHandler,
ListPopupStep.ListPopupModelListener {
    static final int NEXT_STEP_AREA_WIDTH = 20;
    private static final int DEFAULT_MAX_ROW_COUNT = 30;
    private static final Logger LOG = Logger.getInstance(ListPopupImpl.class);
    protected final PopupInlineActionsSupport myInlineActionsSupport;
    private MyList myList;
    private MyMouseMotionListener myMouseMotionListener;
    private MyMouseListener myMouseListener;
    private final MouseMovementTracker myMouseMovementTracker;
    private ListPopupModel myListModel;
    @Nullable
    private AsyncPopupWaiter myAsyncPopupWaiter;
    private int myIndexForShowingChild;
    private boolean myAutoHandleBeforeShow;
    private boolean myShowSubmenuOnHover;
    private boolean myExecuteExpandedItemOnClick;
    private boolean myRepackWhenEmptyStateChanges;
    @Nullable
    private Dimension myNonEmptySize;

    @Deprecated(forRemoval=true)
    public ListPopupImpl(@NotNull ListPopupStep aStep) {
        if (aStep == null) {
            ListPopupImpl.$$$reportNull$$$0(0);
        }
        this((Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext()), null, aStep, null);
    }

    public ListPopupImpl(@Nullable Project project2, @NotNull ListPopupStep aStep) {
        if (aStep == null) {
            ListPopupImpl.$$$reportNull$$$0(1);
        }
        this(project2, null, aStep, null);
    }

    public ListPopupImpl(@Nullable Project project2, @Nullable WizardPopup aParent, @NotNull ListPopupStep aStep, Object parentValue) {
        ListPopupStepEx stepEx;
        String adText;
        if (aStep == null) {
            ListPopupImpl.$$$reportNull$$$0(2);
        }
        super(project2, aParent, (PopupStep<Object>)aStep);
        this.myInlineActionsSupport = PopupInlineActionsSupportKt.createSupport(this);
        this.myMouseMovementTracker = new MouseMovementTracker();
        this.myIndexForShowingChild = -1;
        this.setParentValue(parentValue);
        this.replacePasteAction();
        aStep.addListener((ListPopupStep.ListPopupModelListener)this);
        if (aStep instanceof ListPopupStepEx && (adText = (stepEx = (ListPopupStepEx)aStep).getAdText()) != null) {
            this.setAdText(adText);
        }
    }

    public void setMaxRowCount(int maxRowCount) {
        if (maxRowCount <= 0) {
            return;
        }
        this.myList.setVisibleRowCount(maxRowCount);
    }

    public void showUnderneathOfLabel(@NotNull JLabel label2) {
        if (label2 == null) {
            ListPopupImpl.$$$reportNull$$$0(3);
        }
        int offset = -UIUtil.getListCellHPadding() - this.getListInsets().left;
        if (label2.getIcon() != null) {
            offset += label2.getIcon().getIconWidth() + label2.getIconTextGap();
        }
        this.show(new RelativePoint((Component)label2, new Point(offset, label2.getHeight() + 1)));
    }

    protected ListPopupModel getListModel() {
        return this.myListModel;
    }

    @Override
    protected boolean beforeShow() {
        this.myList.addMouseMotionListener(this.myMouseMotionListener);
        this.myList.addMouseListener(this.myMouseListener);
        boolean shouldShow = super.beforeShow();
        if (this.myAutoHandleBeforeShow) {
            boolean toDispose = this.tryToAutoSelect(true);
            shouldShow &= !toDispose;
        }
        return shouldShow;
    }

    @Override
    public void goBack() {
        this.myList.clearSelection();
        super.goBack();
    }

    public int getOriginalSelectedIndex() {
        int index = this.myList.getSelectedIndex();
        return index == -1 ? -1 : this.myListModel.getOriginalIndex(index);
    }

    @Override
    protected void afterShowSync() {
        super.afterShowSync();
        this.tryToAutoSelect(false);
    }

    private boolean tryToAutoSelect(boolean handleFinalChoices) {
        ListPopupStep<Object> listStep = this.getListStep();
        boolean selected = false;
        if (listStep instanceof MultiSelectionListPopupStep) {
            MultiSelectionListPopupStep step2 = (MultiSelectionListPopupStep)listStep;
            int[] indices = step2.getDefaultOptionIndices();
            if (indices.length > 0) {
                ScrollingUtil.ensureIndexIsVisible((JList)((Object)this.myList), (int)indices[0], (int)0);
                this.myList.setSelectedIndices(indices);
                selected = true;
            }
        } else {
            int defaultIndex = listStep.getDefaultOptionIndex();
            if (this.isSelectableAt(defaultIndex)) {
                ScrollingUtil.selectItem((JList)((Object)this.myList), (int)defaultIndex);
                selected = true;
            }
        }
        if (!selected) {
            this.selectFirstSelectableItem();
        }
        if (listStep.isAutoSelectionEnabled()) {
            if (!this.isVisible() && this.getSelectableCount() == 1) {
                return this._handleSelect(handleFinalChoices, null);
            }
            if (this.isVisible() && this.hasSingleSelectableItemWithSubmenu()) {
                return this._handleSelect(handleFinalChoices, null);
            }
        }
        return false;
    }

    protected boolean shouldUseStatistics() {
        return true;
    }

    private boolean autoSelectUsingStatistics() {
        String filter2 = this.getSpeedSearch().getFilter();
        if (!StringUtil.isEmpty((String)filter2)) {
            int maxUseCount = -1;
            int mostUsedValue = -1;
            int elementsCount = this.myListModel.getSize();
            for (int i2 = 0; i2 < elementsCount; ++i2) {
                Object value = this.myListModel.getElementAt(i2);
                if (!this.isSelectable(value)) continue;
                String text2 = this.getListStep().getTextFor(value);
                int count = StatisticsManager.getInstance().getUseCount(new StatisticsInfo("#list_popup:" + this.myStep.getTitle() + "#" + filter2, text2));
                if (count <= maxUseCount) continue;
                maxUseCount = count;
                mostUsedValue = i2;
            }
            if (mostUsedValue > 0) {
                ScrollingUtil.selectItem((JList)((Object)this.myList), (int)mostUsedValue);
                return true;
            }
        }
        return false;
    }

    private void selectFirstSelectableItem() {
        for (int i2 = 0; i2 < this.myListModel.getSize(); ++i2) {
            if (!this.getListStep().isSelectable(this.myListModel.getElementAt(i2))) continue;
            this.myList.setSelectedIndex(i2);
            break;
        }
    }

    private boolean hasSingleSelectableItemWithSubmenu() {
        boolean oneSubmenuFound = false;
        int countSelectables = 0;
        for (int i2 = 0; i2 < this.myListModel.getSize(); ++i2) {
            Object elementAt = this.myListModel.getElementAt(i2);
            if (!this.getListStep().isSelectable(elementAt)) continue;
            ++countSelectables;
            if (!this.getStep().hasSubstep(elementAt)) continue;
            if (oneSubmenuFound) {
                return false;
            }
            oneSubmenuFound = true;
        }
        return oneSubmenuFound && countSelectables == 1;
    }

    private int getSelectableCount() {
        int count = 0;
        for (int i2 = 0; i2 < this.myListModel.getSize(); ++i2) {
            Object each = this.myListModel.getElementAt(i2);
            if (!this.getListStep().isSelectable(each)) continue;
            ++count;
        }
        return count;
    }

    public JList getList() {
        return this.myList;
    }

    @Override
    protected JComponent createContent() {
        this.myMouseMotionListener = new MyMouseMotionListener();
        this.myMouseListener = new MyMouseListener();
        ListPopupStep<Object> step2 = this.getListStep();
        this.myListModel = new ListPopupModel<Object>(this, this.getSpeedSearch(), step2);
        this.myList = new MyList();
        this.myList.setVisibleRowCount(30);
        this.getSpeedSearch().installSupplyTo((JComponent)((Object)this.myList), false);
        if (this.myStep.getTitle() != null) {
            this.myList.getAccessibleContext().setAccessibleName(this.myStep.getTitle());
        }
        if (step2 instanceof ListPopupStepEx) {
            ListPopupStepEx o = (ListPopupStepEx)step2;
            o.setEmptyText(this.myList.getEmptyText());
        }
        this.myList.setSelectionModel(new MyListSelectionModel());
        this.selectFirstSelectableItem();
        this.myList.setBorder(new EmptyBorder(this.getListInsets()));
        ScrollingUtil.installActions((JList)((Object)this.myList));
        this.myList.setCellRenderer(this.getListElementRenderer());
        this.registerAction("handleSelection1", 10, 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListPopupImpl.this.handleSelect(true, ListPopupImpl.this.createKeyEvent(e, 10));
            }
        });
        this.myList.getActionMap().put("selectNextColumn", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selected = ListPopupImpl.this.myList.getSelectedValue();
                if (selected != null && ListPopupImpl.this.myInlineActionsSupport.hasExtraButtons(selected) && ListPopupImpl.this.nextExtendedButton(selected)) {
                    return;
                }
                ListPopupImpl.this.handleRightKeyPressed(ListPopupImpl.this.createKeyEvent(e, 39));
            }
        });
        this.myList.getActionMap().put("selectPreviousColumn", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selected = ListPopupImpl.this.myList.getSelectedValue();
                if (selected != null && ListPopupImpl.this.myInlineActionsSupport.hasExtraButtons(selected) && ListPopupImpl.this.prevExtendedButton(selected)) {
                    return;
                }
                ListPopupImpl.this.disposeAsyncPopupWaiter();
                if (ListPopupImpl.this.isClosableByLeftArrow()) {
                    ListPopupImpl.this.goBack();
                } else {
                    ListPopupImpl.this.handleLeftKeyPressed(ListPopupImpl.this.createKeyEvent(e, 37));
                }
            }
        });
        this.myList.addListSelectionListener(new ListSelectionListener(){
            private int prevItemIndex = -1;

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (this.prevItemIndex == ListPopupImpl.this.myList.getSelectedIndex()) {
                    return;
                }
                this.prevItemIndex = ListPopupImpl.this.myList.getSelectedIndex();
                ListPopupImpl.this.myList.setSelectedButtonIndex(null);
                ListPopupImpl.this.disposeAsyncPopupWaiter();
            }
        });
        PopupUtil.applyNewUIBackground((Component)((Object)this.myList));
        this.myList.setCursor(Cursor.getPredefinedCursor(12));
        return this.myList;
    }

    @NotNull
    protected KeyEvent createKeyEvent(@NotNull ActionEvent e, int keyCode) {
        if (e == null) {
            ListPopupImpl.$$$reportNull$$$0(4);
        }
        return new KeyEvent((Component)((Object)this.myList), 401, e.getWhen(), e.getModifiers(), keyCode, '\uffff');
    }

    private boolean nextExtendedButton(Object selected) {
        Integer currentIndex = this.myList.getSelectedButtonIndex();
        int buttonsCount = this.myInlineActionsSupport.calcExtraButtonsCount(selected);
        if (currentIndex == null) {
            currentIndex = -1;
        }
        if (currentIndex >= buttonsCount - 1) {
            return false;
        }
        boolean changed = this.myList.setSelectedButtonIndex(currentIndex = Integer.valueOf(currentIndex + 1));
        if (changed) {
            this.getContent().repaint();
            if (this.myInlineActionsSupport.isMoreButton(selected, currentIndex) && buttonsCount == 1) {
                this.myInlineActionsSupport.performAction(selected, currentIndex, null);
            }
        }
        return true;
    }

    private boolean prevExtendedButton(Object selected) {
        boolean changed;
        Integer currentIndex = this.myList.getSelectedButtonIndex();
        if (currentIndex == null) {
            return false;
        }
        if ((currentIndex = Integer.valueOf(currentIndex - 1)) < 0) {
            currentIndex = null;
        }
        if (changed = this.myList.setSelectedButtonIndex(currentIndex)) {
            this.getContent().repaint();
        }
        return true;
    }

    private boolean isMultiSelectionEnabled() {
        return this.getListStep() instanceof MultiSelectionListPopupStep;
    }

    private boolean isClosableByLeftArrow() {
        return this.getParent() != null || this.myStep instanceof ClosableByLeftArrow;
    }

    @Override
    protected ActionMap getActionMap() {
        return this.myList.getActionMap();
    }

    @Override
    protected InputMap getInputMap() {
        return this.myList.getInputMap();
    }

    protected ListCellRenderer<?> getListElementRenderer() {
        return new PopupListElementRenderer(this);
    }

    public ListPopupStep<Object> getListStep() {
        return (ListPopupStep)this.myStep;
    }

    @Override
    public void dispose() {
        this.myList.removeMouseMotionListener(this.myMouseMotionListener);
        this.myList.removeMouseListener(this.myMouseListener);
        this.getListStep().removeListener((ListPopupStep.ListPopupModelListener)this);
        this.disposeAsyncPopupWaiter();
        super.dispose();
    }

    private void disposeAsyncPopupWaiter() {
        if (this.myAsyncPopupWaiter != null) {
            Disposer.dispose((Disposable)this.myAsyncPopupWaiter);
            this.myAsyncPopupWaiter = null;
        }
    }

    protected int getSelectedIndex() {
        return this.myList.getSelectedIndex();
    }

    protected Rectangle getCellBounds(int i2) {
        return this.myList.getCellBounds(i2, i2);
    }

    @Override
    public void disposeChildren() {
        this.setIndexForShowingChild(-1);
        super.disposeChildren();
    }

    @Override
    protected void onAutoSelectionTimer() {
        if (this.myList.getModel().getSize() > 0 && !this.myList.isSelectionEmpty()) {
            this.handleSelect(false);
        } else {
            this.disposeChildren();
            this.setIndexForShowingChild(-1);
        }
    }

    public void handleSelect(boolean handleFinalChoices) {
        this._handleSelect(handleFinalChoices, null);
    }

    public void handleSelect(boolean handleFinalChoices, InputEvent e) {
        this._handleSelect(handleFinalChoices, e);
    }

    private boolean _handleSelect(boolean handleFinalChoices, @Nullable InputEvent e) {
        ActionPopupStep actionPopupStep;
        PopupFactoryImpl.ActionItem item;
        PopupStep nextStep;
        Integer inlineButtonIndex;
        MultiSelectionListPopupStep o;
        boolean preferExecution;
        if (this.myList.getSelectedIndex() == -1) {
            return false;
        }
        if (this.getSpeedSearch().isHoldingFilter() && this.myList.getModel().getSize() == 0) {
            return false;
        }
        List selection = this.myList.getSelectedValuesList();
        if (selection.isEmpty()) {
            return false;
        }
        ListPopupStep<Object> listStep = this.getListStep();
        Object selectedValue = selection.get(0);
        boolean selectable = listStep.isSelectable(selectedValue);
        boolean bl = preferExecution = listStep.isFinal(selectedValue) && selectable && handleFinalChoices;
        if (!this.myExecuteExpandedItemOnClick && !preferExecution && this.myList.getSelectedIndex() == this.getIndexForShowingChild()) {
            if (this.myChild != null && !this.myChild.isVisible()) {
                this.setIndexForShowingChild(-1);
            }
            return false;
        }
        if (!selectable) {
            return false;
        }
        if ((listStep instanceof MultiSelectionListPopupStep && !(o = (MultiSelectionListPopupStep)listStep).hasSubstep(selection) || !listStep.hasSubstep(selectedValue)) && !handleFinalChoices) {
            return false;
        }
        this.disposeChildren();
        if (this.myListModel.getSize() == 0) {
            this.disposePopup(e);
            return true;
        }
        this.valuesSelected(selection);
        Object onlyItem = ContainerUtil.getOnlyItem((Collection)selection);
        if (e instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)e;
            if (onlyItem != null) {
                this.myMouseMotionListener.updateSelectedButtonIndex(me.getPoint());
            }
        }
        if ((inlineButtonIndex = this.myList.getSelectedButtonIndex()) != null) {
            KeepPopupOnPerform keepPopup = this.myInlineActionsSupport.getKeepPopupOnPerform(selectedValue, inlineButtonIndex);
            if (!Utils.isKeepPopupOpen(keepPopup, e)) {
                this.disposePopup(e);
            }
            this.myInlineActionsSupport.performAction(selectedValue, inlineButtonIndex, e);
            return true;
        }
        try (AccessToken ignore = PopupImplUtil.prohibitFocusEventsInHandleSelect();
             AccessToken ignore2 = SlowOperations.startSection((String)"action.perform");){
            if (listStep instanceof MultiSelectionListPopupStep) {
                MultiSelectionListPopupStep o2 = (MultiSelectionListPopupStep)listStep;
                nextStep = o2.onChosen(selection, handleFinalChoices);
            } else if (e != null && listStep instanceof ListPopupStepEx) {
                ListPopupStepEx o3 = (ListPopupStepEx)listStep;
                nextStep = o3.onChosen(selectedValue, handleFinalChoices, e);
            } else {
                nextStep = listStep.onChosen(selectedValue, handleFinalChoices);
            }
        }
        if (nextStep == PopupStep.FINAL_CHOICE && onlyItem instanceof PopupFactoryImpl.ActionItem && Utils.isKeepPopupOpen((item = (PopupFactoryImpl.ActionItem)onlyItem).getKeepPopupOnPerform(), e) && (actionPopupStep = (ActionPopupStep)ObjectUtils.tryCast(this.getListStep(), ActionPopupStep.class)) != null && actionPopupStep.isSelectable(item)) {
            actionPopupStep.updateStepItems(this.getList());
            return false;
        }
        return this.handleNextStep(nextStep, onlyItem, e);
    }

    protected void handleRightKeyPressed(@NotNull KeyEvent keyEvent) {
        if (keyEvent == null) {
            ListPopupImpl.$$$reportNull$$$0(5);
        }
        this.handleSelect(false, keyEvent);
    }

    protected void handleLeftKeyPressed(@NotNull KeyEvent keyEvent) {
        if (keyEvent == null) {
            ListPopupImpl.$$$reportNull$$$0(6);
        }
    }

    private void disposePopup(@Nullable InputEvent e) {
        if (this.myStep.getFinalRunnable() != null) {
            this.setFinalRunnable(this.myStep.getFinalRunnable());
        }
        this.setOk(true);
        this.disposeAllParents(e);
        this.setIndexForShowingChild(-1);
    }

    private void valuesSelected(List<Object> values2) {
        String filter2;
        if (this.shouldUseStatistics() && !StringUtil.isEmpty((String)(filter2 = this.getSpeedSearch().getFilter()))) {
            for (Object value : values2) {
                String text2 = this.getListStep().getTextFor(value);
                StatisticsManager.getInstance().incUseCount(new StatisticsInfo("#list_popup:" + this.getListStep().getTitle() + "#" + filter2, text2));
            }
        }
    }

    @Override
    public void handleNextStep(PopupStep nextStep, Object parentValue) {
        this.handleNextStep(nextStep, parentValue, null);
    }

    public boolean handleNextStep(PopupStep nextStep, Object parentValue, InputEvent e) {
        this.disposeAsyncPopupWaiter();
        if (nextStep == PopupStep.FINAL_CHOICE) {
            this.disposePopup(e);
            return true;
        }
        if (nextStep instanceof AsyncPopupStep) {
            AsyncPopupStep async2 = (AsyncPopupStep)nextStep;
            Rectangle bounds = this.getCellBounds(this.getSelectedIndex());
            RelativePoint point = new RelativePoint((Component)this.getList(), new Point(bounds.width, bounds.y + bounds.height / 2));
            this.myAsyncPopupWaiter = new AsyncPopupWaiter(async2, point, step2 -> {
                this.handleNextStep((PopupStep)step2, parentValue, e);
                return Unit.INSTANCE;
            });
            return false;
        }
        this.showNextStepPopup(nextStep, parentValue);
        return false;
    }

    void showNextStepPopup(PopupStep nextStep, Object parentValue) {
        if (nextStep == null) {
            String valueText = this.getListStep().getTextFor(parentValue);
            String message = String.format("Cannot open submenu for '%s' item. PopupStep is null", valueText);
            LOG.warn(message);
            return;
        }
        PopupStep popupStep = this.myStep;
        if (popupStep instanceof ActionPopupStep) {
            ActionPopupStep o = (ActionPopupStep)popupStep;
            if (nextStep instanceof ActionPopupStep) {
                ActionPopupStep oo = (ActionPopupStep)nextStep;
                oo.setSubStepContextAdjuster(o.getSubStepContextAdjuster());
            }
        }
        Point point = this.myList.indexToLocation(this.myList.getSelectedIndex());
        SwingUtilities.convertPointToScreen(point, (Component)((Object)this.myList));
        this.myChild = this.createPopup(this, nextStep, parentValue);
        if (ScreenReader.isActive()) {
            this.myChild.setRequestFocus(true);
        }
        if ((popupStep = this.myChild) instanceof ListPopup) {
            ListPopup child = (ListPopup)popupStep;
            for (ListSelectionListener listener2 : this.myList.getListSelectionListeners()) {
                child.addListSelectionListener(listener2);
            }
            child.setShowSubmenuOnHover(this.myShowSubmenuOnHover);
            child.setExecuteExpandedItemOnClick(this.myExecuteExpandedItemOnClick);
        }
        JComponent container = this.getContent();
        int y = point.y;
        if (parentValue != null && this.getListModel().isSeparatorAboveOf(parentValue)) {
            SeparatorWithText swt = new SeparatorWithText();
            swt.setCaption(this.getListModel().getCaptionAboveOf(parentValue));
            y += swt.getPreferredSize().height - 1;
        }
        if (!UiInterceptors.tryIntercept((Object)this.myChild)) {
            Point childLocation = new Point(container.getLocationOnScreen().x + container.getWidth() - 2, y);
            if (StartupUiUtil.isWaylandToolkit()) {
                SwingUtilities.convertPointFromScreen(childLocation, container);
                Rectangle childBounds = new Rectangle(childLocation, this.myChild.getPreferredContentSize());
                WaylandUtilKt.moveToFitChildPopupX((Rectangle)childBounds, (Component)container);
                childLocation = childBounds.getLocation();
                SwingUtilities.convertPointToScreen(childLocation, container);
            }
            this.myChild.show(container, childLocation.x, childLocation.y, true);
        }
        this.setIndexForShowingChild(this.myList.getSelectedIndex());
        this.myMouseMovementTracker.reset();
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.myList.addListSelectionListener(listSelectionListener);
    }

    public void onModelChanged() {
        if (this.isDisposed()) {
            return;
        }
        boolean updateEmptyModel = this.myListModel.getSize() == 0;
        this.myListModel.syncModel();
        if (updateEmptyModel) {
            this.selectFirstSelectableItem();
            this.pack(true, true);
        } else {
            this.resizePopupIfNeeded();
        }
    }

    private void resizePopupIfNeeded() {
        Dimension size2 = this.getContentSize();
        Dimension packedSize = this.calculateSizeForPack(true, true);
        if (packedSize == null) {
            return;
        }
        if (packedSize.width > size2.width || packedSize.height > size2.height) {
            Dimension desiredSize = new Dimension(Math.max(size2.width, packedSize.width), Math.max(size2.height, packedSize.height));
            this.setSize(desiredSize);
        }
    }

    protected boolean isActionClick(MouseEvent e) {
        return UIUtil.isActionClick((MouseEvent)e, (int)502, (boolean)true);
    }

    public Object @NotNull [] getSelectedValues() {
        Object[] objectArray = this.myList.getSelectedValues();
        if (objectArray == null) {
            ListPopupImpl.$$$reportNull$$$0(7);
        }
        return objectArray;
    }

    protected boolean handleFinalChoices(MouseEvent e, Object selectedValue, ListPopupStep<Object> listStep) {
        return selectedValue == null || !listStep.hasSubstep(selectedValue) || !listStep.isSelectable(selectedValue) || !this.isOnNextStepButton(e);
    }

    private boolean isOnNextStepButton(MouseEvent e) {
        int index = this.myList.getSelectedIndex();
        Rectangle bounds = this.myList.getCellBounds(index, index);
        if (bounds != null) {
            JBInsets.removeFrom((Rectangle)bounds, (Insets)UIUtil.getListCellPadding());
        }
        Point point = e.getPoint();
        return bounds != null && point.getX() > (double)bounds.width + bounds.getX() - 20.0;
    }

    @Override
    protected void process(KeyEvent aEvent) {
        this.myList.processKeyEvent(aEvent);
    }

    private int getIndexForShowingChild() {
        return this.myIndexForShowingChild;
    }

    private void setIndexForShowingChild(int aIndexForShowingChild) {
        this.myIndexForShowingChild = aIndexForShowingChild;
    }

    private int findSelectableIndex(int index, int lead) {
        int size2 = this.myListModel.getSize();
        if (index < 0 || size2 <= index) {
            return -1;
        }
        int found = this.findSelectableIndexInModel(index, index < lead ? -1 : size2);
        if (found >= 0) {
            return found;
        }
        UISettings settings = UISettings.getInstanceOrNull();
        return settings != null && settings.getCycleScrolling() && 1 == Math.abs(index - lead) ? this.findSelectableIndexInModel(index < lead ? size2 - 1 : 0, index) : this.findSelectableIndexInModel(index, lead < -1 ? -1 : Math.min(lead, size2));
    }

    private int findSelectableIndexInModel(int index, int stop) {
        while (index != stop) {
            if (this.getListStep().isSelectable(this.myListModel.getElementAt(index))) {
                return index;
            }
            index += index > stop ? -1 : 1;
        }
        return -1;
    }

    @ApiStatus.Internal
    public void setRepackWhenEmptyStateChanges(boolean repackWhenEmptyStateChanges) {
        this.myRepackWhenEmptyStateChanges = repackWhenEmptyStateChanges;
    }

    @Override
    protected void onSpeedSearchPatternChanged() {
        boolean nowEmpty;
        boolean wasEmpty = this.myListModel.getSize() == 0;
        ListPopupStep<Object> step2 = this.getListStep();
        if (step2 instanceof FilterableListPopupStep) {
            FilterableListPopupStep o = (FilterableListPopupStep)step2;
            o.updateFilter(this.mySpeedSearch.getFilter());
        }
        int before = this.myListModel.getSize();
        this.myListModel.refilter();
        int after = this.myListModel.getSize();
        ActionGroupPopupActivity fusActivity = ActionGroupPopupActivity.getCurrentActivity(this);
        if (fusActivity != null) {
            fusActivity.filtered(StringUtil.length((CharSequence)this.mySpeedSearch.getFilter()), before, after);
        }
        boolean bl = nowEmpty = this.myListModel.getSize() == 0;
        if (!(this.myListModel.getSize() <= 0 || this.shouldUseStatistics() && this.autoSelectUsingStatistics())) {
            this.selectBestMatch();
        }
        if (this.myRepackWhenEmptyStateChanges && wasEmpty != nowEmpty) {
            if (nowEmpty) {
                this.myNonEmptySize = this.getSize();
                this.pack(false, true);
            } else if (this.myNonEmptySize != null) {
                this.setSize(this.myNonEmptySize);
            }
        }
    }

    private void selectBestMatch() {
        int fullMatchIndex = this.myListModel.getClosestMatchIndex();
        if (fullMatchIndex != -1 && this.isSelectableAt(fullMatchIndex)) {
            this.myList.setSelectedIndex(fullMatchIndex);
        } else {
            this.selectFirstSelectableItem();
        }
    }

    @Override
    protected void onSelectByMnemonic(Object value) {
        if (this.myListModel.isVisible(value) && this.isSelectable(value)) {
            this.myList.setSelectedValue(value, true);
            this.myList.repaint();
            this.handleSelect(true);
        }
    }

    @Override
    protected JComponent getPreferredFocusableComponent() {
        return this.myList;
    }

    @Override
    protected void onChildSelectedFor(Object value) {
        if (this.myList.getSelectedValue() != value && this.isSelectable(value)) {
            this.myList.setSelectedValue(value, false);
        }
    }

    public void selectAndExpandValue(Object value) {
        this.selectAndChooseNextStep(value, false);
    }

    public void selectAndExecuteValue(Object value) {
        this.selectAndChooseNextStep(value, true);
    }

    private void selectAndChooseNextStep(Object value, boolean finalChoice) {
        if (this.myListModel.isVisible(value) && this.isSelectable(value)) {
            this.myList.setSelectedValue(value, true);
            this.disposeChildren();
            ListPopupStep<Object> listStep = this.getListStep();
            PopupStep nextStep = listStep.onChosen(value, finalChoice);
            this.handleNextStep(nextStep, value);
        }
    }

    public void setHandleAutoSelectionBeforeShow(boolean autoHandle) {
        this.myAutoHandleBeforeShow = autoHandle;
    }

    @Override
    public boolean isModalContext() {
        return true;
    }

    public void setShowSubmenuOnHover(boolean showSubmenuOnHover) {
        this.myShowSubmenuOnHover = showSubmenuOnHover;
    }

    public void setExecuteExpandedItemOnClick(boolean executeExpandedItemOnClick) {
        this.myExecuteExpandedItemOnClick = executeExpandedItemOnClick;
    }

    @Override
    public void showInBestPositionFor(@NotNull Editor editor2) {
        if (editor2 == null) {
            ListPopupImpl.$$$reportNull$$$0(8);
        }
        if (UiInterceptors.tryIntercept((Object)this)) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.handleSelect(true);
            if (!Disposer.isDisposed((Disposable)this)) {
                Disposer.dispose((Disposable)this);
            }
        } else {
            super.showInBestPositionFor(editor2);
        }
    }

    private void replacePasteAction() {
        if (this.myStep.isSpeedSearchEnabled()) {
            this.getList().getActionMap().put(TransferHandler.getPasteAction().getValue("Name"), new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ListPopupImpl.this.getSpeedSearch().type((String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor));
                    ListPopupImpl.this.getSpeedSearch().update();
                }
            });
        }
    }

    private boolean isSelectable(@Nullable Object value) {
        try {
            return this.getListStep().isSelectable(value);
        }
        catch (Exception exception) {
            LOG.error(this.getListStep().getClass().getName(), (Throwable)exception);
            return false;
        }
    }

    private boolean isSelectableAt(int index) {
        Object value;
        return 0 <= index && index < this.myListModel.getSize() && this.isSelectable(value = this.myListModel.getElementAt(index));
    }

    private Insets getListInsets() {
        return PopupUtil.getListInsets((boolean)StringUtil.isNotEmpty((String)this.getStep().getTitle()), (boolean)this.isAdVisible());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aStep";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyEvent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/popup/list/ListPopupImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/popup/list/ListPopupImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showUnderneathOfLabel";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createKeyEvent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleRightKeyPressed";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "handleLeftKeyPressed";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showInBestPositionFor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }

    private final class MyList
    extends JBList
    implements ListWithInlineButtons,
    UiDataProvider {
        @Nullable
        private Integer selectedButtonIndex;

        MyList() {
            super((ListModel)ListPopupImpl.this.myListModel);
            HintUpdateSupply.installSimpleHintUpdateSupply((JComponent)((Object)this));
        }

        public void processKeyEvent(KeyEvent e) {
            e.setSource(this);
            super.processKeyEvent(e);
        }

        protected void processMouseEvent(MouseEvent e) {
            boolean isClick;
            if (!ListPopupImpl.this.isMultiSelectionEnabled() && (e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                e.consume();
            }
            if (UIUtil.isActionClick((MouseEvent)e, (int)501) && ListPopupImpl.this.isOnNextStepButton(e)) {
                e.consume();
            }
            boolean bl = isClick = UIUtil.isActionClick((MouseEvent)e, (int)501) || UIUtil.isActionClick((MouseEvent)e, (int)502);
            if (!isClick || ListPopupImpl.this.myList.locationToIndex(e.getPoint()) == ListPopupImpl.this.myList.getSelectedIndex() || ListPopupImpl.this.isMultiSelectionEnabled() && MyList.hasMultiSelectionModifier(e)) {
                super.processMouseEvent(e);
            }
        }

        private static boolean hasMultiSelectionModifier(@NotNull MouseEvent e) {
            if (e == null) {
                MyList.$$$reportNull$$$0(0);
            }
            return (e.getModifiers() & (ClientSystemInfo.isMac() ? 4 : 2)) != 0;
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            BaseListPopupStep listStep;
            ListPopupStep<Object> listPopupStep;
            if (sink == null) {
                MyList.$$$reportNull$$$0(1);
            }
            boolean lazy = (listPopupStep = ListPopupImpl.this.getListStep()) instanceof BaseListPopupStep && (listStep = (BaseListPopupStep)listPopupStep).isLazyUiSnapshot();
            PopupImplUtil.uiSnapshotForList(ListPopupImpl.this.myList, sink, lazy);
            if (ListPopupImpl.this.mySpeedSearchPatternField != null && ListPopupImpl.this.mySpeedSearchPatternField.isVisible()) {
                sink.set(PlatformDataKeys.SPEED_SEARCH_COMPONENT, (Object)ListPopupImpl.this.mySpeedSearchPatternField);
            }
        }

        @Override
        @Nullable
        public Integer getSelectedButtonIndex() {
            return this.selectedButtonIndex;
        }

        private boolean setSelectedButtonIndex(@Nullable Integer index) {
            if (Objects.compare(index, this.selectedButtonIndex, Comparator.nullsFirst(Integer::compare)) == 0) {
                return false;
            }
            this.selectedButtonIndex = index;
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/popup/list/ListPopupImpl$MyList";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hasMultiSelectionModifier";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "uiDataSnapshot";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MyMouseMotionListener
    extends MouseMotionAdapter {
        private int myLastSelectedIndex = -2;
        private ExtendMode myExtendMode = ExtendMode.NO_EXTEND;
        private Point myLastMouseLocation;
        private Timer myShowSubmenuTimer;

        private MyMouseMotionListener() {
        }

        private boolean isMouseMoved(Point location) {
            if (this.myLastMouseLocation == null) {
                this.myLastMouseLocation = location;
                return false;
            }
            Point prev = this.myLastMouseLocation;
            this.myLastMouseLocation = location;
            return !prev.equals(location);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!this.isMouseMoved(e.getLocationOnScreen())) {
                return;
            }
            Point point = e.getPoint();
            int index = ListPopupImpl.this.myList.locationToIndex(point);
            if (ListPopupImpl.this.isSelectableAt(index)) {
                if (index != this.myLastSelectedIndex && !this.isMovingToSubmenu(e)) {
                    this.myExtendMode = this.calcExtendMode(index);
                    if (!ListPopupImpl.this.isMultiSelectionEnabled() || !UIUtil.isSelectionButtonDown((MouseEvent)e) && ListPopupImpl.this.myList.getSelectedIndices().length <= 1) {
                        ListPopupImpl.this.myList.setSelectedIndex(index);
                        if (ListPopupImpl.this.myShowSubmenuOnHover) {
                            ListPopupImpl.this.disposeChildren();
                        }
                        if (this.myExtendMode == ExtendMode.EXTEND_ON_HOVER) {
                            this.showSubMenu(index, true);
                        }
                    }
                    ListPopupImpl.this.restartTimer();
                    this.myLastSelectedIndex = index;
                }
            } else {
                ListPopupImpl.this.myList.clearSelection();
                this.myLastSelectedIndex = -1;
            }
            if (this.updateSelectedButtonIndex(point)) {
                ListPopupImpl.this.getContent().repaint();
            }
            ListPopupImpl.this.notifyParentOnChildSelection();
        }

        boolean updateSelectedButtonIndex(Point point) {
            int index = ListPopupImpl.this.myList.locationToIndex(point);
            if (index < 0 || !ListPopupImpl.this.isSelectableAt(index)) {
                return ListPopupImpl.this.myList.setSelectedButtonIndex(null);
            }
            Object element = ListPopupImpl.this.myListModel.getElementAt(index);
            if (element != null && ListPopupImpl.this.myInlineActionsSupport.hasExtraButtons(element)) {
                Integer buttonIndex = ListPopupImpl.this.myInlineActionsSupport.calcButtonIndex(element, point);
                return ListPopupImpl.this.myList.setSelectedButtonIndex(buttonIndex);
            }
            return false;
        }

        @NotNull
        private ExtendMode calcExtendMode(int index) {
            ListPopupStep<Object> listStep = ListPopupImpl.this.getListStep();
            Object selectedValue = ListPopupImpl.this.myListModel.getElementAt(index);
            if (selectedValue == null || !listStep.hasSubstep(selectedValue)) {
                ExtendMode extendMode = ExtendMode.NO_EXTEND;
                if (extendMode == null) {
                    MyMouseMotionListener.$$$reportNull$$$0(0);
                }
                return extendMode;
            }
            ExtendMode extendMode = ListPopupImpl.this.myShowSubmenuOnHover ? ExtendMode.EXTEND_ON_HOVER : ExtendMode.NO_EXTEND;
            if (extendMode == null) {
                MyMouseMotionListener.$$$reportNull$$$0(1);
            }
            return extendMode;
        }

        private boolean isMovingToSubmenu(MouseEvent e) {
            if (ListPopupImpl.this.myChild == null || ListPopupImpl.this.myChild.isDisposed()) {
                return false;
            }
            Rectangle childBounds = ListPopupImpl.this.myChild.getBounds();
            childBounds.setLocation(ListPopupImpl.this.myChild.getLocationOnScreen());
            return ListPopupImpl.this.myMouseMovementTracker.isMovingTowards(e, childBounds);
        }

        private void showSubMenu(int forIndex, boolean withTimer) {
            if (ListPopupImpl.this.getIndexForShowingChild() == forIndex) {
                return;
            }
            ListPopupImpl.this.disposeChildren();
            if (this.myShowSubmenuTimer != null && this.myShowSubmenuTimer.isRunning()) {
                this.myShowSubmenuTimer.stop();
                this.myShowSubmenuTimer = null;
            }
            ListPopupStep<Object> listStep = ListPopupImpl.this.getListStep();
            Object selectedValue = ListPopupImpl.this.myListModel.getElementAt(forIndex);
            if (withTimer) {
                ClientId currentClientId = ClientId.getCurrent();
                this.myShowSubmenuTimer = new Timer(250, e -> {
                    try (AccessToken ignore = ClientId.withClientId((ClientId)currentClientId);){
                        if (!ListPopupImpl.this.isDisposed() && this.myLastSelectedIndex == forIndex) {
                            ListPopupImpl.this.disposeChildren();
                            ListPopupImpl.this.showNextStepPopup(listStep.onChosen(selectedValue, false), selectedValue);
                        }
                    }
                });
                this.myShowSubmenuTimer.setRepeats(false);
                this.myShowSubmenuTimer.start();
            } else {
                ListPopupImpl.this.showNextStepPopup(listStep.onChosen(selectedValue, false), selectedValue);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/list/ListPopupImpl$MyMouseMotionListener", "calcExtendMode"));
        }
    }

    private final class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!ListPopupImpl.this.isActionClick(e) || ListPopupImpl.this.isMultiSelectionEnabled() && UIUtil.isSelectionButtonDown((MouseEvent)e)) {
                return;
            }
            IdeEventQueue.getInstance().blockNextEvents(e);
            Object selectedValue = ListPopupImpl.this.myList.getSelectedValue();
            ListPopupStep<Object> listStep = ListPopupImpl.this.getListStep();
            ListPopupImpl.this.handleSelect(ListPopupImpl.this.handleFinalChoices(e, selectedValue, listStep), e);
            ListPopupImpl.this.stopTimer();
        }
    }

    private final class MyListSelectionModel
    extends DefaultListSelectionModel {
        private boolean myInitialSelectionSet = false;

        private MyListSelectionModel() {
            this.setSelectionMode(ListPopupImpl.this.isMultiSelectionEnabled() ? 2 : 0);
        }

        @Override
        public void clearSelection() {
            super.clearSelection();
            this.setAnchorSelectionIndex(-1);
            this.setLeadSelectionIndex(-1);
        }

        @Override
        public void setSelectionInterval(int index0, int index1) {
            if (this.getSelectionMode() == 0) {
                int index = ListPopupImpl.this.findSelectableIndex(index0, this.getLeadSelectionIndex());
                if (0 <= index) {
                    super.setSelectionInterval(index, index);
                }
                if (index == 0 && !this.myInitialSelectionSet) {
                    this.myInitialSelectionSet = true;
                    this.fireValueChanged(0, 0);
                }
            } else {
                super.setSelectionInterval(index0, index1);
            }
        }
    }

    static interface ListWithInlineButtons {
        @Nullable
        public Integer getSelectedButtonIndex();
    }

    private static enum ExtendMode {
        NO_EXTEND,
        EXTEND_ON_HOVER;

    }
}

