/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.cache;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentMapBuilder;
import com.intellij.util.io.cache.ManagedCache;
import com.intellij.util.io.cache.ManagedCacheFactory;
import com.intellij.util.io.cache.ManagedPersistentCache;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003Jd\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u00070\u0005\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00070\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J,\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000b0\u00172\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/util/io/cache/ManagedPersistentCacheFactory;", "Lcom/intellij/util/io/cache/ManagedCacheFactory;", "<init>", "()V", "createCache", "Lcom/intellij/util/io/cache/ManagedCache;", "K", "V", "project", "Lcom/intellij/openapi/project/Project;", "basePath", "Ljava/nio/file/Path;", "cacheName", "", "keySerializer", "Lcom/intellij/util/io/KeyDescriptor;", "valueSerializer", "Lcom/intellij/util/io/DataExternalizer;", "serDeVersion", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "cacheNameAndPath", "Lkotlin/Pair;", "intellij.platform.ide.impl"})
public final class ManagedPersistentCacheFactory
implements ManagedCacheFactory {
    @NotNull
    public static final ManagedPersistentCacheFactory INSTANCE = new ManagedPersistentCacheFactory();

    private ManagedPersistentCacheFactory() {
    }

    @Override
    @NotNull
    public <K, V> ManagedCache<K, V> createCache(@NotNull Project project2, @NotNull Path basePath, @NotNull String cacheName, @NotNull KeyDescriptor<K> keySerializer, @NotNull DataExternalizer<V> valueSerializer, int serDeVersion, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        Intrinsics.checkNotNullParameter((Object)cacheName, (String)"cacheName");
        Intrinsics.checkNotNullParameter(keySerializer, (String)"keySerializer");
        Intrinsics.checkNotNullParameter(valueSerializer, (String)"valueSerializer");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Pair<String, Path> pair = this.cacheNameAndPath(project2, basePath, cacheName);
        String cacheUniqName = (String)pair.component1();
        Path cachePath = (Path)pair.component2();
        PersistentMapBuilder persistentMapBuilder = PersistentMapBuilder.newBuilder((Path)cachePath, keySerializer, valueSerializer).withVersion(serDeVersion);
        Intrinsics.checkNotNullExpressionValue((Object)persistentMapBuilder, (String)"withVersion(...)");
        PersistentMapBuilder builder = persistentMapBuilder;
        return new ManagedPersistentCache(cacheUniqName, builder, coroutineScope, null, false, false, 56, null);
    }

    private final Pair<String, Path> cacheNameAndPath(Project project2, Path basePath, String cacheName) {
        String projectName = ProjectUtil.getProjectCacheFileName$default((Project)project2, (boolean)false, (String)"-", null, (int)5, null);
        Path projectPath = basePath.resolve(projectName);
        String cacheUniqName = cacheName + "-" + projectName;
        Path cachePath = projectPath.resolve(cacheName).resolve(cacheName);
        return TuplesKt.to((Object)cacheUniqName, (Object)cachePath);
    }
}

