/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.net.HttpConfigurable;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IdeHttpClientHelpers {
    private IdeHttpClientHelpers() {
    }

    @NotNull
    private static HttpConfigurable getHttpConfigurable() {
        HttpConfigurable httpConfigurable = HttpConfigurable.getInstance();
        if (httpConfigurable == null) {
            IdeHttpClientHelpers.$$$reportNull$$$0(0);
        }
        return httpConfigurable;
    }

    private static boolean isHttpProxyEnabled() {
        return IdeHttpClientHelpers.getHttpConfigurable().USE_HTTP_PROXY;
    }

    private static boolean isProxyAuthenticationEnabled() {
        return IdeHttpClientHelpers.getHttpConfigurable().PROXY_AUTHENTICATION;
    }

    @NotNull
    private static String getProxyHost() {
        String string = StringUtil.notNullize((String)IdeHttpClientHelpers.getHttpConfigurable().PROXY_HOST);
        if (string == null) {
            IdeHttpClientHelpers.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static int getProxyPort() {
        return IdeHttpClientHelpers.getHttpConfigurable().PROXY_PORT;
    }

    @NotNull
    private static String getProxyLogin() {
        String string = StringUtil.notNullize((String)IdeHttpClientHelpers.getHttpConfigurable().getProxyLogin());
        if (string == null) {
            IdeHttpClientHelpers.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private static String getProxyPassword() {
        String string = StringUtil.notNullize((String)IdeHttpClientHelpers.getHttpConfigurable().getPlainProxyPassword());
        if (string == null) {
            IdeHttpClientHelpers.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/util/net/IdeHttpClientHelpers";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHttpConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProxyHost";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProxyLogin";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProxyPassword";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static final class ApacheHttpClient4 {
        public static void setProxyIfEnabled(@NotNull RequestConfig.Builder builder) {
            if (builder == null) {
                ApacheHttpClient4.$$$reportNull$$$0(0);
            }
            if (IdeHttpClientHelpers.isHttpProxyEnabled()) {
                builder.setProxy(new HttpHost(IdeHttpClientHelpers.getProxyHost(), IdeHttpClientHelpers.getProxyPort()));
            }
        }

        public static void setProxyCredentialsIfEnabled(@NotNull CredentialsProvider provider) {
            if (provider == null) {
                ApacheHttpClient4.$$$reportNull$$$0(1);
            }
            if (IdeHttpClientHelpers.isHttpProxyEnabled() && IdeHttpClientHelpers.isProxyAuthenticationEnabled()) {
                String ntlmUserPassword = IdeHttpClientHelpers.getProxyLogin().replace('\\', '/') + ":" + IdeHttpClientHelpers.getProxyPassword();
                provider.setCredentials(new AuthScope(IdeHttpClientHelpers.getProxyHost(), IdeHttpClientHelpers.getProxyPort(), AuthScope.ANY_REALM, "NTLM"), (Credentials)new NTCredentials(ntlmUserPassword));
                provider.setCredentials(new AuthScope(IdeHttpClientHelpers.getProxyHost(), IdeHttpClientHelpers.getProxyPort()), (Credentials)new UsernamePasswordCredentials(IdeHttpClientHelpers.getProxyLogin(), IdeHttpClientHelpers.getProxyPassword()));
            }
        }

        public static void setProxyForUrlIfEnabled(@NotNull RequestConfig.Builder builder, @Nullable String url) {
            if (builder == null) {
                ApacheHttpClient4.$$$reportNull$$$0(2);
            }
            if (IdeHttpClientHelpers.getHttpConfigurable().isHttpProxyEnabledForUrl(url)) {
                ApacheHttpClient4.setProxyIfEnabled(builder);
            }
        }

        public static void setProxyCredentialsForUrlIfEnabled(@NotNull CredentialsProvider provider, @Nullable String url) {
            if (provider == null) {
                ApacheHttpClient4.$$$reportNull$$$0(3);
            }
            if (IdeHttpClientHelpers.getHttpConfigurable().isHttpProxyEnabledForUrl(url)) {
                ApacheHttpClient4.setProxyCredentialsIfEnabled(provider);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/net/IdeHttpClientHelpers$ApacheHttpClient4";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setProxyIfEnabled";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setProxyCredentialsIfEnabled";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setProxyForUrlIfEnabled";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setProxyCredentialsForUrlIfEnabled";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

