/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.backend.workspace.GlobalWorkspaceModelCache;
import com.intellij.platform.util.coroutines.CollectionsKt;
import com.intellij.platform.workspace.jps.serialization.impl.ApplicationLevelUrlRelativizer;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.InternalEnvironmentName;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.impl.ImmutableEntityStorageImplKt;
import com.intellij.platform.workspace.storage.url.UrlRelativizer;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.workspaceModel.ide.impl.GlobalWorkspaceModel;
import com.intellij.workspaceModel.ide.impl.WorkspaceModelCacheSerializer;
import com.intellij.workspaceModel.ide.impl.WorkspaceModelCacheSerializerKt;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.UninitializedPropertyAccessException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 $2\u00020\u0001:\u0001$B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u001a\u001a\u00020\bH\u0016J\u000e\u0010\u001b\u001a\u00020\bH\u0096@\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\bH\u0016J\u000e\u0010\u001e\u001a\u00020\bH\u0082@\u00a2\u0006\u0002\u0010\u001cJ\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\u0011H\u0016J\u0010\u0010#\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0014\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006%"}, d2={"Lcom/intellij/workspaceModel/ide/impl/GlobalWorkspaceModelCacheImpl;", "Lcom/intellij/platform/backend/workspace/GlobalWorkspaceModelCache;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "saveRequests", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "cacheFiles", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ljava/nio/file/Path;", "cacheFile", "environmentName", "Lcom/intellij/platform/workspace/storage/InternalEnvironmentName;", "virtualFileUrlManager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "urlRelativizer", "Lcom/intellij/platform/workspace/jps/serialization/impl/ApplicationLevelUrlRelativizer;", "cacheSerializer", "Lcom/intellij/workspaceModel/ide/impl/WorkspaceModelCacheSerializer;", "getCacheSerializer", "()Lcom/intellij/workspaceModel/ide/impl/WorkspaceModelCacheSerializer;", "cacheSerializer$delegate", "Lkotlin/Lazy;", "scheduleCacheSave", "saveCacheNow", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "invalidateCaches", "doCacheSaving", "loadCache", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "setVirtualFileUrlManager", "vfuManager", "registerCachePartition", "Companion", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nGlobalWorkspaceModelCacheImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GlobalWorkspaceModelCacheImpl.kt\ncom/intellij/workspaceModel/ide/impl/GlobalWorkspaceModelCacheImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,134:1\n13#2:135\n*S KotlinDebug\n*F\n+ 1 GlobalWorkspaceModelCacheImpl.kt\ncom/intellij/workspaceModel/ide/impl/GlobalWorkspaceModelCacheImpl\n*L\n123#1:135\n*E\n"})
public final class GlobalWorkspaceModelCacheImpl
implements GlobalWorkspaceModelCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MutableSharedFlow<Unit> saveRequests;
    @NotNull
    private final ConcurrentHashMap<String, Path> cacheFiles;
    private VirtualFileUrlManager virtualFileUrlManager;
    @Nullable
    private final ApplicationLevelUrlRelativizer urlRelativizer;
    @NotNull
    private final Lazy cacheSerializer$delegate;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String DATA_DIR_NAME = "global-model-cache";
    @NotNull
    private static final AtomicBoolean cachesInvalidated;
    @NotNull
    private static final Lazy<Path> invalidateCachesMarkerFile$delegate;

    public GlobalWorkspaceModelCacheImpl(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.saveRequests = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
        this.cacheFiles = new ConcurrentHashMap();
        this.urlRelativizer = Registry.Companion.is("ide.workspace.model.store.relative.paths.in.cache", false) ? new ApplicationLevelUrlRelativizer(true) : null;
        this.cacheSerializer$delegate = LazyKt.lazy(() -> GlobalWorkspaceModelCacheImpl.cacheSerializer_delegate$lambda$0(this));
        LOG.debug("Global Model Cache");
        BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ GlobalWorkspaceModelCacheImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FlowKt.debounce-HG0u8IE((Flow)((Flow)this.this$0.saveRequests), (long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS)).collect(new FlowCollector(){

                            public final Object emit(Unit it, Continuation<? super Unit> $completion) {
                                Object object = this$0.doCacheSaving((Continuation<? super Unit>)$completion);
                                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                    return object;
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public Path cacheFile(@NotNull InternalEnvironmentName environmentName) {
        Intrinsics.checkNotNullParameter((Object)environmentName, (String)"environmentName");
        Path path = this.cacheFiles.get(environmentName.getName());
        if (path == null) {
            throw new IllegalArgumentException("Global workspace storage with id " + environmentName + " must be registered with `registerCachePartition` before it can be loaded");
        }
        return path;
    }

    private final WorkspaceModelCacheSerializer getCacheSerializer() {
        Lazy lazy = this.cacheSerializer$delegate;
        return (WorkspaceModelCacheSerializer)lazy.getValue();
    }

    public void scheduleCacheSave() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        LOG.debug("Schedule global cache update");
        if (!this.saveRequests.tryEmit((Object)Unit.INSTANCE)) {
            throw new IllegalStateException("Check failed.");
        }
    }

    @Nullable
    public Object saveCacheNow(@NotNull Continuation<? super Unit> $completion) {
        Object object = this.doCacheSaving($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public void invalidateCaches() {
        Companion.invalidateCaches$intellij_platform_ide_impl();
    }

    private final Object doCacheSaving(Continuation<? super Unit> $completion) {
        Set<Map.Entry<String, Path>> set = this.cacheFiles.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Object object = CollectionsKt.forEachConcurrent$default((Collection)set, (int)0, (Function2)((Function2)new Function2<Map.Entry<String, Path>, Continuation<? super Unit>, Object>(this, null){
            Object L$1;
            Object L$2;
            Object L$3;
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ GlobalWorkspaceModelCacheImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (Map.Entry)this.L$0;
                var6_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Intrinsics.checkNotNull((Object)<destruct>);
                        v0 = <destruct>.getKey();
                        Intrinsics.checkNotNullExpressionValue(v0, (String)"component1(...)");
                        id = (String)v0;
                        v1 = <destruct>.getValue();
                        Intrinsics.checkNotNullExpressionValue(v1, (String)"component2(...)");
                        cacheFile = (Path)v1;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)<destruct>);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)id);
                        this.L$2 = cacheFile;
                        this.label = 1;
                        v2 = GlobalWorkspaceModel.Companion.getInstanceByEnvironmentNameAsync(InternalEnvironmentName.Companion.of(id), (Continuation)this);
                        if (v2 == var6_3) {
                            return var6_3;
                        }
                        ** GOTO lbl26
                    }
                    case 1: {
                        cacheFile = (Path)this.L$2;
                        id = (String)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl26:
                        // 2 sources

                        if (!ImmutableEntityStorageImplKt.isConsistent((EntityStorage)((EntityStorage)(storage = ((GlobalWorkspaceModel)v2).getCurrentSnapshot())))) {
                            this.this$0.invalidateCaches();
                        }
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)<destruct>);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)id);
                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)cacheFile);
                        this.L$3 = SpillingKt.nullOutSpilledVariable((Object)storage);
                        this.label = 2;
                        v3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, storage, cacheFile, null){
                            int label;
                            final /* synthetic */ GlobalWorkspaceModelCacheImpl this$0;
                            final /* synthetic */ ImmutableEntityStorage $storage;
                            final /* synthetic */ Path $cacheFile;
                            {
                                this.this$0 = $receiver;
                                this.$storage = $storage;
                                this.$cacheFile = $cacheFile;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object = !GlobalWorkspaceModelCacheImpl.access$getCachesInvalidated$cp().get() ? GlobalWorkspaceModelCacheImpl.access$getCacheSerializer(this.this$0).saveCacheToFile$intellij_platform_ide_impl(this.$storage, this.$cacheFile) : Boxing.boxBoolean((boolean)Files.deleteIfExists(this.$cacheFile));
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v3 == var6_3) {
                            return var6_3;
                        }
                        ** GOTO lbl43
                    }
                    case 2: {
                        storage = (ImmutableEntityStorage)this.L$3;
                        cacheFile = (Path)this.L$2;
                        id = (String)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl43:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(Map.Entry<String, Path> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion, (int)1, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public MutableEntityStorage loadCache(@NotNull InternalEnvironmentName environmentName) {
        Intrinsics.checkNotNullParameter((Object)environmentName, (String)"environmentName");
        if (ApplicationManager.getApplication().isUnitTestMode() && !Boolean.parseBoolean(System.getProperty("ide.tests.permit.global.workspace.model.serialization", "false"))) {
            return null;
        }
        Path cacheFile = this.cacheFile(environmentName);
        WorkspaceModelCacheSerializer workspaceModelCacheSerializer = this.getCacheSerializer();
        Path path = GlobalWorkspaceModelCacheImpl.Companion.getInvalidateCachesMarkerFile();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"access$getInvalidateCachesMarkerFile(...)");
        Path path2 = GlobalWorkspaceModelCacheImpl.Companion.getInvalidateCachesMarkerFile();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"access$getInvalidateCachesMarkerFile(...)");
        return workspaceModelCacheSerializer.loadCacheFromFile$intellij_platform_ide_impl(cacheFile, path, path2);
    }

    public void setVirtualFileUrlManager(@NotNull VirtualFileUrlManager vfuManager) {
        Intrinsics.checkNotNullParameter((Object)vfuManager, (String)"vfuManager");
        this.virtualFileUrlManager = vfuManager;
    }

    public void registerCachePartition(@NotNull InternalEnvironmentName environmentName) {
        Intrinsics.checkNotNullParameter((Object)environmentName, (String)"environmentName");
        String cacheSuffix = Intrinsics.areEqual((Object)environmentName, (Object)InternalEnvironmentName.Local.INSTANCE) ? "global-model-cache/cache.data" : "global-model-cache/" + environmentName.getName() + "/cache.data";
        Path path = PathManager.getSystemDir().resolve(cacheSuffix);
        ((Map)this.cacheFiles).put(environmentName.getName(), path);
    }

    private static final WorkspaceModelCacheSerializer cacheSerializer_delegate$lambda$0(GlobalWorkspaceModelCacheImpl this$0) {
        if (this$0.virtualFileUrlManager == null) {
            throw new UninitializedPropertyAccessException("VirtualFileUrlManager was not initialized. Please call `GlobalWorkspaceModelCache.setVirtualFileUrlManager` before any other methods.");
        }
        VirtualFileUrlManager virtualFileUrlManager = this$0.virtualFileUrlManager;
        if (virtualFileUrlManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"virtualFileUrlManager");
            virtualFileUrlManager = null;
        }
        return new WorkspaceModelCacheSerializer(virtualFileUrlManager, (UrlRelativizer)this$0.urlRelativizer);
    }

    private static final Path invalidateCachesMarkerFile_delegate$lambda$0() {
        return PathManager.getSystemDir().resolve("global-model-cache/.invalidate");
    }

    public static final /* synthetic */ WorkspaceModelCacheSerializer access$getCacheSerializer(GlobalWorkspaceModelCacheImpl $this) {
        return $this.getCacheSerializer();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(GlobalWorkspaceModelCacheImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
        cachesInvalidated = new AtomicBoolean(false);
        invalidateCachesMarkerFile$delegate = LazyKt.lazy(GlobalWorkspaceModelCacheImpl::invalidateCachesMarkerFile_delegate$lambda$0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lcom/intellij/workspaceModel/ide/impl/GlobalWorkspaceModelCacheImpl$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "DATA_DIR_NAME", "", "cachesInvalidated", "Ljava/util/concurrent/atomic/AtomicBoolean;", "invalidateCachesMarkerFile", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "getInvalidateCachesMarkerFile", "()Ljava/nio/file/Path;", "invalidateCachesMarkerFile$delegate", "Lkotlin/Lazy;", "invalidateCaches", "", "invalidateCaches$intellij_platform_ide_impl", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final Path getInvalidateCachesMarkerFile() {
            Lazy lazy = invalidateCachesMarkerFile$delegate;
            return (Path)lazy.getValue();
        }

        public final void invalidateCaches$intellij_platform_ide_impl() {
            LOG.info("Invalidating global caches by creating " + this.getInvalidateCachesMarkerFile());
            AtomicBoolean atomicBoolean = cachesInvalidated;
            Path path = this.getInvalidateCachesMarkerFile();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"<get-invalidateCachesMarkerFile>(...)");
            WorkspaceModelCacheSerializerKt.invalidateCaches(atomicBoolean, path);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

