/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.StringUtil;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class ByteBufUtilEx {
    private static final byte WRITE_UTF_UNKNOWN = 63;

    public static int writeUtf8(ByteBuf buf, CharSequence seq, int start2, int end) {
        int oldWriterIndex;
        AbstractByteBuf buffer2;
        if (buf == null) {
            throw new NullPointerException("buf");
        }
        if (seq == null) {
            throw new NullPointerException("seq");
        }
        int len = end - start2;
        int maxSize = len * 3;
        buf.ensureWritable(maxSize);
        if (buf instanceof AbstractByteBuf) {
            buffer2 = (AbstractByteBuf)buf;
            oldWriterIndex = buffer2.writerIndex;
        } else {
            ByteBuf underlying = buf.unwrap();
            if (underlying instanceof AbstractByteBuf) {
                buffer2 = (AbstractByteBuf)underlying;
                oldWriterIndex = buf.writerIndex();
            } else {
                byte[] bytes = seq.toString().getBytes(CharsetUtil.UTF_8);
                buf.writeBytes(bytes);
                return bytes.length;
            }
        }
        int writerIndex = oldWriterIndex;
        for (int i2 = start2; i2 < end; ++i2) {
            char c = seq.charAt(i2);
            if (c < '\u0080') {
                buffer2._setByte(writerIndex++, (int)((byte)c));
                continue;
            }
            if (c < '\u0800') {
                buffer2._setByte(writerIndex++, (int)((byte)(0xC0 | c >> 6)));
                buffer2._setByte(writerIndex++, (int)((byte)(0x80 | c & 0x3F)));
                continue;
            }
            if (StringUtil.isSurrogate((char)c)) {
                char c2;
                if (!Character.isHighSurrogate(c)) {
                    buffer2._setByte(writerIndex++, 63);
                    continue;
                }
                try {
                    c2 = seq.charAt(++i2);
                }
                catch (IndexOutOfBoundsException e) {
                    buffer2._setByte(writerIndex++, 63);
                    break;
                }
                if (!Character.isLowSurrogate(c2)) {
                    buffer2._setByte(writerIndex++, 63);
                    buffer2._setByte(writerIndex++, Character.isHighSurrogate(c2) ? 63 : (int)c2);
                    continue;
                }
                int codePoint = Character.toCodePoint(c, c2);
                buffer2._setByte(writerIndex++, (int)((byte)(0xF0 | codePoint >> 18)));
                buffer2._setByte(writerIndex++, (int)((byte)(0x80 | codePoint >> 12 & 0x3F)));
                buffer2._setByte(writerIndex++, (int)((byte)(0x80 | codePoint >> 6 & 0x3F)));
                buffer2._setByte(writerIndex++, (int)((byte)(0x80 | codePoint & 0x3F)));
                continue;
            }
            buffer2._setByte(writerIndex++, (int)((byte)(0xE0 | c >> 12)));
            buffer2._setByte(writerIndex++, (int)((byte)(0x80 | c >> 6 & 0x3F)));
            buffer2._setByte(writerIndex++, (int)((byte)(0x80 | c & 0x3F)));
        }
        if (buf == buffer2) {
            buffer2.writerIndex = writerIndex;
        } else {
            buf.writerIndex(writerIndex);
        }
        return writerIndex - oldWriterIndex;
    }
}

