/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.google.gson.stream.JsonToken;
import com.intellij.util.SmartList;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.ByteBufUtilEx;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.JsonReaderEx;

public final class JsonUtil {
    private static final String[] REPLACEMENT_CHARS = new String[128];

    public static void escape(@NotNull CharSequence value, @NotNull StringBuilder sb) {
        if (value == null) {
            JsonUtil.$$$reportNull$$$0(0);
        }
        if (sb == null) {
            JsonUtil.$$$reportNull$$$0(1);
        }
        int length = value.length();
        sb.ensureCapacity(sb.length() + length + 2);
        sb.append('\"');
        int last = 0;
        for (int i2 = 0; i2 < length; ++i2) {
            String replacement;
            char c = value.charAt(i2);
            if (c < '\u0080') {
                replacement = REPLACEMENT_CHARS[c];
                if (replacement == null) {
                    continue;
                }
            } else if (c == '\u2028') {
                replacement = "\\u2028";
            } else {
                if (c != '\u2029') continue;
                replacement = "\\u2029";
            }
            if (last < i2) {
                sb.append(value, last, i2);
            }
            sb.append(replacement);
            last = i2 + 1;
        }
        if (last < length) {
            sb.append(value, last, length);
        }
        sb.append('\"');
    }

    public static void escape(@NotNull CharSequence value, @NotNull ByteBuf buffer2) {
        if (value == null) {
            JsonUtil.$$$reportNull$$$0(2);
        }
        if (buffer2 == null) {
            JsonUtil.$$$reportNull$$$0(3);
        }
        int length = value.length();
        buffer2.ensureWritable(length * 2);
        buffer2.writeByte(34);
        int last = 0;
        for (int i2 = 0; i2 < length; ++i2) {
            String replacement;
            char c = value.charAt(i2);
            if (c < '\u0080') {
                replacement = REPLACEMENT_CHARS[c];
                if (replacement == null) {
                    continue;
                }
            } else if (c == '\u2028') {
                replacement = "\\u2028";
            } else {
                if (c != '\u2029') continue;
                replacement = "\\u2029";
            }
            if (last < i2) {
                ByteBufUtilEx.writeUtf8(buffer2, value, last, i2);
            }
            ByteBufUtil.writeAscii((ByteBuf)buffer2, (CharSequence)replacement);
            last = i2 + 1;
        }
        if (last < length) {
            ByteBufUtilEx.writeUtf8(buffer2, value, last, length);
        }
        buffer2.writeByte(34);
    }

    @NotNull
    public static <T> List<T> nextList(@NotNull JsonReaderEx reader) {
        if (reader == null) {
            JsonUtil.$$$reportNull$$$0(4);
        }
        reader.beginArray();
        if (!reader.hasNext()) {
            reader.endArray();
            List list2 = Collections.emptyList();
            if (list2 == null) {
                JsonUtil.$$$reportNull$$$0(5);
            }
            return list2;
        }
        SmartList list3 = new SmartList();
        JsonUtil.readListBody(reader, list3);
        reader.endArray();
        SmartList smartList = list3;
        if (smartList == null) {
            JsonUtil.$$$reportNull$$$0(6);
        }
        return smartList;
    }

    @NotNull
    public static List<String> nextStringList(@NotNull JsonReaderEx reader) {
        if (reader == null) {
            JsonUtil.$$$reportNull$$$0(7);
        }
        reader.beginArray();
        if (!reader.hasNext()) {
            reader.endArray();
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                JsonUtil.$$$reportNull$$$0(8);
            }
            return list2;
        }
        ArrayList<String> list3 = new ArrayList<String>(2);
        while (reader.hasNext()) {
            String value = JsonUtil.nextStringOrSkip(reader);
            if (value == null) continue;
            list3.add(value);
        }
        reader.endArray();
        ArrayList<String> arrayList = list3;
        if (arrayList == null) {
            JsonUtil.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @Nullable
    public static String nextStringOrSkip(@NotNull JsonReaderEx reader) {
        JsonToken token;
        if (reader == null) {
            JsonUtil.$$$reportNull$$$0(10);
        }
        if ((token = reader.peek()) == JsonToken.STRING) {
            return reader.nextString();
        }
        reader.skipValue();
        return null;
    }

    @NotNull
    public static Map<String, Object> nextObject(@NotNull JsonReaderEx reader) {
        if (reader == null) {
            JsonUtil.$$$reportNull$$$0(11);
        }
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        reader.beginObject();
        while (reader.hasNext()) {
            map2.put(reader.nextName(), JsonUtil.nextAny(reader));
        }
        reader.endObject();
        HashMap<String, Object> hashMap = map2;
        if (hashMap == null) {
            JsonUtil.$$$reportNull$$$0(12);
        }
        return hashMap;
    }

    @Nullable
    public static Object nextAny(JsonReaderEx reader) {
        return switch (reader.peek()) {
            case JsonToken.BEGIN_ARRAY -> JsonUtil.nextList(reader);
            case JsonToken.BEGIN_OBJECT -> JsonUtil.nextObject(reader);
            case JsonToken.STRING -> reader.nextString();
            case JsonToken.NUMBER -> reader.nextDouble();
            case JsonToken.BOOLEAN -> reader.nextBoolean();
            case JsonToken.NULL -> {
                reader.nextNull();
                yield null;
            }
            default -> throw new IllegalStateException();
        };
    }

    public static <T> void readListBody(JsonReaderEx reader, List<T> list2) {
        do {
            list2.add(JsonUtil.nextAny(reader));
        } while (reader.hasNext());
    }

    static {
        for (int i2 = 0; i2 <= 31; ++i2) {
            JsonUtil.REPLACEMENT_CHARS[i2] = String.format("\\u%04x", i2);
        }
        JsonUtil.REPLACEMENT_CHARS[34] = "\\\"";
        JsonUtil.REPLACEMENT_CHARS[92] = "\\\\";
        JsonUtil.REPLACEMENT_CHARS[9] = "\\t";
        JsonUtil.REPLACEMENT_CHARS[8] = "\\b";
        JsonUtil.REPLACEMENT_CHARS[10] = "\\n";
        JsonUtil.REPLACEMENT_CHARS[13] = "\\r";
        JsonUtil.REPLACEMENT_CHARS[12] = "\\f";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 8, 9, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/io/JsonUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/io/JsonUtil";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "nextList";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "nextStringList";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "nextObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "escape";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "nextList";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 12: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "nextStringList";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "nextStringOrSkip";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "nextObject";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 8, 9, 12 -> new IllegalStateException(string);
        };
    }
}

