/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightFrontbackUtil;
import com.intellij.codeInsight.editorActions.smartEnter.AfterSemicolonEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.BlockBraceFixer;
import com.intellij.codeInsight.editorActions.smartEnter.CatchDeclarationFixer;
import com.intellij.codeInsight.editorActions.smartEnter.CommentBreakerEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.DoWhileConditionFixer;
import com.intellij.codeInsight.editorActions.smartEnter.EnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.EnumFieldFixer;
import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.ForStatementFixer;
import com.intellij.codeInsight.editorActions.smartEnter.IfConditionFixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavadocFixer;
import com.intellij.codeInsight.editorActions.smartEnter.LeaveCodeBlockEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.LiteralFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MethodCallFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingArrayConstructorBracketFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingArrayInitializerBraceFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingCatchBodyFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingClassBodyFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingCommaFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingIfBranchesFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingLambdaBodyFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingLoopBodyFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingMethodBodyFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingReturnExpressionFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingSwitchBodyFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingSynchronizedBodyFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingThrowExpressionFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingTryBodyFixer;
import com.intellij.codeInsight.editorActions.smartEnter.ParameterListFixer;
import com.intellij.codeInsight.editorActions.smartEnter.ParenthesizedFixer;
import com.intellij.codeInsight.editorActions.smartEnter.PlainEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.SemicolonFixer;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.SwitchExpressionFixer;
import com.intellij.codeInsight.editorActions.smartEnter.SwitchLabelColonFixer;
import com.intellij.codeInsight.editorActions.smartEnter.TernaryColonFixer;
import com.intellij.codeInsight.editorActions.smartEnter.WhileConditionFixer;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaSmartEnterProcessor
extends SmartEnterProcessor {
    private static final Logger LOG = Logger.getInstance(JavaSmartEnterProcessor.class);
    private static final List<Fixer> ourFixers = List.of(new LiteralFixer(), new MethodCallFixer(), new IfConditionFixer(), new ForStatementFixer(), new TernaryColonFixer(), new WhileConditionFixer(), new CatchDeclarationFixer(), new SwitchExpressionFixer(), new SwitchLabelColonFixer(), new DoWhileConditionFixer(), new BlockBraceFixer(), new MissingIfBranchesFixer(), new MissingTryBodyFixer(), new MissingSwitchBodyFixer(), new MissingLambdaBodyFixer(), new MissingCatchBodyFixer(), new MissingSynchronizedBodyFixer(), new MissingLoopBodyFixer(), new ParameterListFixer(), new MissingCommaFixer(), new MissingMethodBodyFixer(), new MissingClassBodyFixer(), new MissingReturnExpressionFixer(), new MissingThrowExpressionFixer(), new ParenthesizedFixer(), new SemicolonFixer(), new MissingArrayInitializerBraceFixer(), new MissingArrayConstructorBracketFixer(), new EnumFieldFixer());
    private static final EnterProcessor[] ourEnterProcessors = new EnterProcessor[]{new CommentBreakerEnterProcessor(), new AfterSemicolonEnterProcessor(), new LeaveCodeBlockEnterProcessor(), new PlainEnterProcessor()};
    private static final EnterProcessor[] ourAfterCompletionEnterProcessors = new EnterProcessor[]{new AfterSemicolonEnterProcessor(), new EnterProcessor(){

        @Override
        public boolean doEnter(Editor editor, PsiElement psiElement, boolean isModified) {
            return PlainEnterProcessor.expandCodeBlock(editor, psiElement);
        }
    }};
    private int myFirstErrorOffset = Integer.MAX_VALUE;
    private boolean mySkipEnter;
    private static final int MAX_ATTEMPTS = 20;
    private static final Key<Long> SMART_ENTER_TIMESTAMP = Key.create((String)"smartEnterOriginalTimestamp");
    private final JavadocFixer myJavadocFixer = new JavadocFixer();

    public boolean process(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            JavaSmartEnterProcessor.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            JavaSmartEnterProcessor.$$$reportNull$$$0(1);
        }
        if (psiFile == null) {
            JavaSmartEnterProcessor.$$$reportNull$$$0(2);
        }
        return this.invokeProcessor(editor, psiFile, false);
    }

    public boolean processAfterCompletion(@NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (editor == null) {
            JavaSmartEnterProcessor.$$$reportNull$$$0(3);
        }
        if (psiFile == null) {
            JavaSmartEnterProcessor.$$$reportNull$$$0(4);
        }
        return this.invokeProcessor(editor, psiFile, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean invokeProcessor(Editor editor, PsiFile psiFile, boolean afterCompletion) {
        Document document = editor.getDocument();
        CharSequence textForRollback = document.getImmutableCharSequence();
        try {
            editor.putUserData(SMART_ENTER_TIMESTAMP, (Object)editor.getDocument().getModificationStamp());
            this.myFirstErrorOffset = Integer.MAX_VALUE;
            this.mySkipEnter = false;
            this.process(editor, psiFile, 0, afterCompletion);
        }
        catch (TooManyAttemptsException e) {
            document.replaceString(0, document.getTextLength(), textForRollback);
        }
        finally {
            editor.putUserData(SMART_ENTER_TIMESTAMP, null);
        }
        return true;
    }

    private void process(@NotNull Editor editor, @NotNull PsiFile file, int attempt, boolean afterCompletion) throws TooManyAttemptsException {
        if (editor == null) {
            JavaSmartEnterProcessor.$$$reportNull$$$0(5);
        }
        if (file == null) {
            JavaSmartEnterProcessor.$$$reportNull$$$0(6);
        }
        if (attempt > 20) {
            throw new TooManyAttemptsException();
        }
        try {
            this.commit(editor);
            if (this.myFirstErrorOffset != Integer.MAX_VALUE) {
                editor.getCaretModel().moveToOffset(this.myFirstErrorOffset);
            }
            this.myFirstErrorOffset = Integer.MAX_VALUE;
            PsiElement atCaret = this.getStatementAtCaret(editor, file);
            if (atCaret == null) {
                if (this.myJavadocFixer.process(editor, file)) {
                    return;
                }
                if (!new CommentBreakerEnterProcessor().doEnter(editor, (PsiElement)file, false)) {
                    JavaSmartEnterProcessor.plainEnter(editor);
                }
                return;
            }
            ArrayList<PsiElement> queue = new ArrayList<PsiElement>();
            JavaSmartEnterProcessor.collectAllElements(atCaret, queue, true);
            queue.add(atCaret);
            for (PsiElement psiElement : queue) {
                for (Fixer fixer : ourFixers) {
                    Document document = editor.getDocument();
                    int offset = this.myFirstErrorOffset;
                    long stamp = document.getModificationStamp();
                    fixer.apply(editor, this, psiElement);
                    Project project = file.getProject();
                    if (document.getModificationStamp() != stamp || offset != this.myFirstErrorOffset) {
                        FixerUsageCollector.log(project, fixer);
                    }
                    if (LookupManager.getInstance((Project)project).getActiveLookup() != null) {
                        return;
                    }
                    if (!JavaSmartEnterProcessor.isUncommited((Project)project) && psiElement.isValid()) continue;
                    this.moveCaretInsideBracesIfAny(editor, file);
                    this.process(editor, file, attempt + 1, afterCompletion);
                    return;
                }
            }
            this.doEnter(atCaret, editor, afterCompletion);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    protected void reformat(PsiElement atCaret) throws IncorrectOperationException {
        PsiFile file;
        Document document;
        if (atCaret == null) {
            return;
        }
        PsiElement parent = atCaret.getParent();
        if (parent instanceof PsiForStatement) {
            atCaret = parent;
        }
        if (parent instanceof PsiIfStatement && atCaret == ((PsiIfStatement)parent).getElseBranch() && (document = (file = atCaret.getContainingFile()).getViewProvider().getDocument()) != null) {
            TextRange elseIfRange = atCaret.getTextRange();
            int lineStart = document.getLineStartOffset(document.getLineNumber(elseIfRange.getStartOffset()));
            CodeStyleManager.getInstance((Project)atCaret.getProject()).reformatText(file, lineStart, elseIfRange.getEndOffset());
            return;
        }
        super.reformat(atCaret);
    }

    private void doEnter(PsiElement atCaret, Editor editor, boolean afterCompletion) throws IncorrectOperationException {
        PsiFile psiFile = atCaret.getContainingFile();
        if (this.myFirstErrorOffset != Integer.MAX_VALUE) {
            editor.getCaretModel().moveToOffset(this.myFirstErrorOffset);
            this.reformat((PsiElement)atCaret);
            return;
        }
        RangeMarker rangeMarker = this.createRangeMarker((PsiElement)atCaret);
        this.reformat((PsiElement)atCaret);
        this.commit(editor);
        if (!this.mySkipEnter) {
            atCaret = CodeInsightFrontbackUtil.findElementInRange(psiFile, rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), atCaret.getClass());
            for (EnterProcessor processor : afterCompletion ? ourAfterCompletionEnterProcessors : ourEnterProcessors) {
                if (atCaret == null) break;
                if (!processor.doEnter(editor, (PsiElement)atCaret, JavaSmartEnterProcessor.isModified(editor))) continue;
                rangeMarker.dispose();
                return;
            }
            if (!JavaSmartEnterProcessor.isModified(editor) && !afterCompletion) {
                JavaSmartEnterProcessor.plainEnter(editor);
            } else if (this.myFirstErrorOffset == Integer.MAX_VALUE) {
                editor.getCaretModel().moveToOffset(rangeMarker.getEndOffset());
            } else {
                editor.getCaretModel().moveToOffset(this.myFirstErrorOffset);
            }
        }
        rangeMarker.dispose();
    }

    private static void collectAllElements(PsiElement atCaret, List<? super PsiElement> res, boolean recurse) {
        PsiElement[] children;
        res.addFirst((PsiElement)atCaret);
        if (JavaSmartEnterProcessor.doNotStepInto(atCaret)) {
            if (!recurse) {
                return;
            }
            recurse = false;
        }
        for (PsiElement child : children = atCaret.getChildren()) {
            if (atCaret instanceof PsiStatement && child instanceof PsiStatement && (!(atCaret instanceof PsiForStatement) || child != ((PsiForStatement)atCaret).getInitialization())) continue;
            JavaSmartEnterProcessor.collectAllElements(child, res, recurse);
        }
    }

    private static boolean doNotStepInto(PsiElement element) {
        return element instanceof PsiClass || element instanceof PsiCodeBlock || element instanceof PsiStatement || element instanceof PsiMethod;
    }

    @Nullable
    protected PsiElement getStatementAtCaret(Editor editor, PsiFile psiFile) {
        PsiElement atCaret = super.getStatementAtCaret(editor, psiFile);
        if (atCaret instanceof PsiWhiteSpace) {
            return null;
        }
        if (PsiUtil.isJavaToken(atCaret, JavaTokenType.RBRACE)) {
            boolean expressionEndingWithBrace;
            boolean bl = expressionEndingWithBrace = (atCaret = atCaret.getParent()) instanceof PsiAnonymousClass || atCaret instanceof PsiArrayInitializerExpression || atCaret instanceof PsiCodeBlock && (atCaret.getParent() instanceof PsiLambdaExpression || atCaret.getParent() instanceof PsiSwitchExpression);
            if (!expressionEndingWithBrace) {
                return null;
            }
        }
        for (PsiElement each : SyntaxTraverser.psiApi().parents((Object)atCaret).skip(1)) {
            if (each instanceof PsiMember || each instanceof PsiImportStatementBase || each instanceof PsiPackageStatement || each instanceof PsiAnnotation && PsiTreeUtil.hasErrorElements((PsiElement)each)) {
                return each;
            }
            if (each instanceof PsiCodeBlock || each instanceof PsiComment) {
                return null;
            }
            if (each instanceof PsiStatement) {
                return each.getParent() instanceof PsiForStatement && !PsiTreeUtil.hasErrorElements((PsiElement)each) ? each.getParent() : each;
            }
            if (!(each instanceof PsiConditionalExpression) || !PsiUtilCore.hasErrorElementChild((PsiElement)each)) continue;
            return each;
        }
        return null;
    }

    protected void moveCaretInsideBracesIfAny(@NotNull Editor editor, @NotNull PsiFile file) throws IncorrectOperationException {
        if (editor == null) {
            JavaSmartEnterProcessor.$$$reportNull$$$0(7);
        }
        if (file == null) {
            JavaSmartEnterProcessor.$$$reportNull$$$0(8);
        }
        int caretOffset = editor.getCaretModel().getOffset();
        CharSequence chars = editor.getDocument().getCharsSequence();
        if (CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"{}")) {
            caretOffset += 2;
        } else if (CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"{\n}")) {
            caretOffset += 3;
        }
        caretOffset = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(caretOffset - 1), (String)" \t") + 1;
        if (CharArrayUtil.regionMatches((CharSequence)chars, (int)(caretOffset - "{}".length()), (CharSequence)"{}") || CharArrayUtil.regionMatches((CharSequence)chars, (int)(caretOffset - "{\n}".length()), (CharSequence)"{\n}")) {
            this.commit(editor);
            CommonCodeStyleSettings settings = CodeStyle.getSettings((PsiFile)file).getCommonSettings((Language)JavaLanguage.INSTANCE);
            boolean old = settings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE;
            settings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE = false;
            PsiElement leaf = file.findElementAt(caretOffset - 1);
            PsiElement elt = PsiTreeUtil.getParentOfType((PsiElement)leaf, PsiCodeBlock.class);
            if (elt == null && leaf != null && leaf.getParent() instanceof PsiClass) {
                elt = leaf.getParent();
            }
            this.reformat(elt);
            settings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE = old;
            editor.getCaretModel().moveToOffset(caretOffset - 1);
            this.reformatBlockParentIfNeeded(editor, file);
        }
    }

    private void reformatBlockParentIfNeeded(@NotNull Editor editor, @NotNull PsiFile file) {
        PsiElement psiElement;
        if (editor == null) {
            JavaSmartEnterProcessor.$$$reportNull$$$0(9);
        }
        if (file == null) {
            JavaSmartEnterProcessor.$$$reportNull$$$0(10);
        }
        this.commit(editor);
        PsiCodeBlock block = (PsiCodeBlock)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)editor.getCaretModel().getOffset(), PsiCodeBlock.class, (boolean)false);
        if (block != null && ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParents(new Class[]{PsiBlockStatement.class, PsiForStatement.class})).accepts(block)) {
            this.reformat(block.getParent().getParent());
        }
        if (block != null && (psiElement = block.getParent()) instanceof PsiSwitchExpression) {
            PsiSwitchExpression switchExpression = (PsiSwitchExpression)psiElement;
            this.reformat(switchExpression);
        }
    }

    public void registerUnresolvedError(int offset) {
        if (this.myFirstErrorOffset > offset) {
            this.myFirstErrorOffset = offset;
        }
    }

    public void setSkipEnter(boolean skipEnter) {
        this.mySkipEnter = skipEnter;
    }

    protected static void plainEnter(@NotNull Editor editor) {
        if (editor == null) {
            JavaSmartEnterProcessor.$$$reportNull$$$0(11);
        }
        JavaSmartEnterProcessor.getEnterHandler().execute(editor, editor.getCaretModel().getCurrentCaret(), EditorUtil.getEditorDataContext((Editor)editor));
    }

    protected static EditorActionHandler getEnterHandler() {
        return EditorActionManager.getInstance().getActionHandler("EditorStartNewLine");
    }

    protected static boolean isModified(@NotNull Editor editor) {
        Long timestamp;
        if (editor == null) {
            JavaSmartEnterProcessor.$$$reportNull$$$0(12);
        }
        if ((timestamp = (Long)editor.getUserData(SMART_ENTER_TIMESTAMP)) == null) {
            return true;
        }
        return editor.getDocument().getModificationStamp() != timestamp.longValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/smartEnter/JavaSmartEnterProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processAfterCompletion";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "moveCaretInsideBracesIfAny";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "reformatBlockParentIfNeeded";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "plainEnter";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "isModified";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class TooManyAttemptsException
    extends Exception {
        private TooManyAttemptsException() {
        }
    }

    private static final class FixerUsageCollector
    extends CounterUsagesCollector {
        private static final EventLogGroup GROUP = new EventLogGroup("java.smart.enter.fixer", 3);
        private static final EventId1<String> USED = GROUP.registerEvent("fixer_used", (EventField)new StringEventField.ValidatedByAllowedValues("fixer_used", ContainerUtil.map(ourFixers, f -> f.getClass().getSimpleName())));

        private FixerUsageCollector() {
        }

        public EventLogGroup getGroup() {
            return GROUP;
        }

        static void log(Project project, Fixer fixer) {
            USED.log(project, (Object)fixer.getClass().getSimpleName());
        }
    }
}

