/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiCaseLabelElementList;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class SwitchLabelColonFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor, @NotNull PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement == null) {
            SwitchLabelColonFixer.$$$reportNull$$$0(0);
        }
        if (psiElement instanceof PsiSwitchLabelStatement) {
            PsiCaseLabelElementList labelElementList;
            String token;
            PsiSwitchLabelStatement statement = (PsiSwitchLabelStatement)psiElement;
            PsiSwitchBlock block = statement.getEnclosingSwitchBlock();
            if (block == null) {
                return;
            }
            String string = token = PsiUtil.isRuleFormatSwitch(block) ? "->" : ":";
            if (!psiElement.getText().endsWith(token) && ((labelElementList = statement.getCaseLabelElementList()) != null && labelElementList.getElementCount() != 0 || statement.isDefaultCase())) {
                editor.getDocument().insertString(psiElement.getTextRange().getEndOffset(), (CharSequence)token);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/codeInsight/editorActions/smartEnter/SwitchLabelColonFixer", "apply"));
    }
}

