/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.javadoc;

import com.intellij.codeInsight.javadoc.JavaDocFragmentData;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.pom.PomRenameableTarget;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/codeInsight/javadoc/JavaDocFragmentCacheService;", "", "<init>", "()V", "ID_PATTERN", "Ljava/util/regex/Pattern;", "getAnchors", "Ljava/util/LinkedHashSet;", "Lcom/intellij/codeInsight/javadoc/JavaDocFragmentData;", "Lkotlin/collections/LinkedHashSet;", "project", "Lcom/intellij/openapi/project/Project;", "psiClass", "Lcom/intellij/psi/PsiClass;", "findIdsFromComment", "", "docComment", "Lcom/intellij/psi/javadoc/PsiDocComment;", "findIdsFromText", "docText", "", "intellij.java.psi.impl"})
@SourceDebugExtension(value={"SMAP\nJavaDocFragmentAnchorCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaDocFragmentAnchorCache.kt\ncom/intellij/codeInsight/javadoc/JavaDocFragmentCacheService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n1586#2:82\n1661#2,3:83\n*S KotlinDebug\n*F\n+ 1 JavaDocFragmentAnchorCache.kt\ncom/intellij/codeInsight/javadoc/JavaDocFragmentCacheService\n*L\n45#1:82\n45#1:83,3\n*E\n"})
final class JavaDocFragmentCacheService {
    @NotNull
    private final Pattern ID_PATTERN;

    public JavaDocFragmentCacheService() {
        Pattern pattern = Pattern.compile("<[a-zA-Z0-9\\-]*[^>] id=[\"']?([^\"'> ]+)[\"']?[^>]*>", 2);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        this.ID_PATTERN = pattern;
    }

    @NotNull
    public final LinkedHashSet<JavaDocFragmentData> getAnchors(@NotNull Project project, @NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        CachedValuesManager manager = CachedValuesManager.getManager((Project)project);
        Object object = manager.getCachedValue((UserDataHolder)psiClass, () -> JavaDocFragmentCacheService.getAnchors$lambda$0(this, psiClass));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (LinkedHashSet)object;
    }

    /*
     * WARNING - void declaration
     */
    private final List<JavaDocFragmentData> findIdsFromComment(PsiDocComment docComment) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object = docComment;
        if (object == null || (object = object.getText()) == null) {
            return CollectionsKt.emptyList();
        }
        Object text = object;
        if (!StringsKt.contains$default((CharSequence)((CharSequence)text), (CharSequence)" id=", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)((CharSequence)text), (CharSequence)" ID=", (boolean)false, (int)2, null)) {
            return CollectionsKt.emptyList();
        }
        int offset = docComment.getTextOffset();
        Iterable iterable = this.findIdsFromText((String)text);
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JavaDocFragmentData javaDocFragmentData = (JavaDocFragmentData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new JavaDocFragmentData(it.getName(), it.getOffset() + offset));
        }
        return (List)destination$iv$iv;
    }

    private final List<JavaDocFragmentData> findIdsFromText(String docText) {
        ArrayList<JavaDocFragmentData> results = new ArrayList<JavaDocFragmentData>();
        Matcher matcher = this.ID_PATTERN.matcher(docText);
        while (matcher.find()) {
            String id = matcher.group(1);
            if (id == null || StringsKt.isBlank((CharSequence)id)) continue;
            results.add(new JavaDocFragmentData(id, matcher.start(1)));
        }
        return results;
    }

    private static final CachedValueProvider.Result getAnchors$lambda$0(JavaDocFragmentCacheService this$0, PsiClass $psiClass) {
        Object[] objectArray;
        Object[] $this$getAnchors_u24lambda_u240_u240 = objectArray = new LinkedHashSet();
        boolean bl = false;
        $this$getAnchors_u24lambda_u240_u240.addAll((Collection)this$0.findIdsFromComment($psiClass.getDocComment()));
        PsiMethod[] psiMethodArray = $psiClass.getMethods();
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"getMethods(...)");
        for (PsiMethod psiMethod : psiMethodArray) {
            $this$getAnchors_u24lambda_u240_u240.addAll((Collection)this$0.findIdsFromComment(psiMethod.getDocComment()));
        }
        PsiField[] psiFieldArray = $psiClass.getFields();
        Intrinsics.checkNotNullExpressionValue((Object)psiFieldArray, (String)"getFields(...)");
        for (PomRenameableTarget<PsiElement> pomRenameableTarget : psiFieldArray) {
            $this$getAnchors_u24lambda_u240_u240.addAll((Collection)this$0.findIdsFromComment(pomRenameableTarget.getDocComment()));
        }
        Object[] result = objectArray;
        objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
        return CachedValueProvider.Result.create((Object)result, (Object[])objectArray);
    }
}

