/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.codeInsight.DumbAwareAnnotationUtil;
import com.intellij.lang.ASTNode;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/psi/formatter/java/JavaFormatterAnnotationUtil;", "", "<init>", "()V", "KNOWN_TYPE_ANNOTATIONS", "", "", "isTypeAnnotation", "", "annotation", "Lcom/intellij/lang/ASTNode;", "isFieldWithAnnotations", "node", "field", "Lcom/intellij/psi/PsiModifierListOwner;", "getAllAnnotationsOnPrefix", "", "modifierList", "intellij.java.frontback.impl"})
@SourceDebugExtension(value={"SMAP\nJavaFormatterAnnotationUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaFormatterAnnotationUtil.kt\ncom/intellij/psi/formatter/java/JavaFormatterAnnotationUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n1807#2,3:85\n1807#2,3:88\n*S KotlinDebug\n*F\n+ 1 JavaFormatterAnnotationUtil.kt\ncom/intellij/psi/formatter/java/JavaFormatterAnnotationUtil\n*L\n42#1:85,3\n57#1:88,3\n*E\n"})
public final class JavaFormatterAnnotationUtil {
    @NotNull
    public static final JavaFormatterAnnotationUtil INSTANCE = new JavaFormatterAnnotationUtil();
    @NotNull
    private static final Set<String> KNOWN_TYPE_ANNOTATIONS;

    private JavaFormatterAnnotationUtil() {
    }

    @JvmStatic
    public static final boolean isTypeAnnotation(@NotNull ASTNode annotation) {
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            Class[] classArray = annotation.getPsi();
            PsiAnnotation psiAnnotation = classArray instanceof PsiAnnotation ? (PsiAnnotation)classArray : null;
            if (psiAnnotation == null) {
                return false;
            }
            PsiAnnotation node = psiAnnotation;
            if (!PsiUtil.isAvailable(JavaFeature.TYPE_ANNOTATIONS, node)) {
                return false;
            }
            classArray = new Class[]{PsiWhiteSpace.class, PsiAnnotation.class};
            PsiElement next = PsiTreeUtil.skipSiblingsForward((PsiElement)node, (Class[])classArray);
            if (next instanceof PsiKeyword) {
                return false;
            }
            Iterable $this$any$iv = KNOWN_TYPE_ANNOTATIONS;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!DumbAwareAnnotationUtil.isAnnotationMatchesFqn(node, it)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    @JvmStatic
    public static final boolean isFieldWithAnnotations(@NotNull ASTNode node) {
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (node.getElementType() != JavaElementType.FIELD) {
                return false;
            }
            ASTNode aSTNode = node.getFirstChildNode();
            if (aSTNode == null) {
                return false;
            }
            ASTNode modifierList = aSTNode;
            if (!Intrinsics.areEqual((Object)modifierList.getElementType(), (Object)JavaElementType.MODIFIER_LIST)) {
                return false;
            }
            List<ASTNode> annotationList = INSTANCE.getAllAnnotationsOnPrefix(modifierList);
            Iterable $this$any$iv = annotationList;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ASTNode it = (ASTNode)element$iv;
                    boolean bl2 = false;
                    if (!(!JavaFormatterAnnotationUtil.isTypeAnnotation(it))) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    @JvmStatic
    public static final boolean isFieldWithAnnotations(@NotNull PsiModifierListOwner field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        ASTNode aSTNode = field.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getNode(...)");
        return JavaFormatterAnnotationUtil.isFieldWithAnnotations(aSTNode);
    }

    private final List<ASTNode> getAllAnnotationsOnPrefix(ASTNode modifierList) {
        List result = new ArrayList();
        ASTNode currentNode = modifierList.getFirstChildNode();
        while (true) {
            ASTNode aSTNode = currentNode;
            if (!Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)JavaElementType.ANNOTATION)) break;
            result.add(currentNode);
            currentNode = FormatterUtil.getNextNonWhitespaceSibling((ASTNode)currentNode);
        }
        return result;
    }

    static {
        Object[] objectArray = new String[]{"org.jetbrains.annotations.NotNull", "org.jetbrains.annotations.Nullable", "org.jspecify.annotations.NonNull", "org.jspecify.annotations.Nullable"};
        KNOWN_TYPE_ANNOTATIONS = SetsKt.setOf((Object[])objectArray);
    }
}

