/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiImportStatementStub;
import com.intellij.psi.impl.source.PsiImportStatementBaseImpl;
import com.intellij.util.ArrayFactory;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiImportStaticStatementImpl
extends PsiImportStatementBaseImpl
implements PsiImportStaticStatement {
    public static final PsiImportStaticStatementImpl[] EMPTY_ARRAY = new PsiImportStaticStatementImpl[0];
    public static final ArrayFactory<PsiImportStaticStatementImpl> ARRAY_FACTORY = count -> count == 0 ? EMPTY_ARRAY : new PsiImportStaticStatementImpl[count];

    public PsiImportStaticStatementImpl(PsiImportStatementStub stub) {
        super(stub, JavaStubElementTypes.IMPORT_STATIC_STATEMENT);
    }

    public PsiImportStaticStatementImpl(ASTNode node) {
        super(node);
    }

    @Override
    public PsiClass resolveTargetClass() {
        PsiJavaCodeReferenceElement classReference = this.getClassReference();
        if (classReference == null) {
            return null;
        }
        PsiElement result = classReference.resolve();
        if (result instanceof PsiClass) {
            return (PsiClass)result;
        }
        return null;
    }

    @Override
    public String getReferenceName() {
        if (this.isOnDemand()) {
            return null;
        }
        PsiImportStaticReferenceElement memberReference = this.getMemberReference();
        if (memberReference != null) {
            return memberReference.getReferenceName();
        }
        return null;
    }

    @Nullable
    private PsiImportStaticReferenceElement getMemberReference() {
        if (this.isOnDemand()) {
            return null;
        }
        return (PsiImportStaticReferenceElement)this.getImportReference();
    }

    @Nullable
    public PsiJavaCodeReferenceElement getClassReference() {
        if (this.isOnDemand()) {
            return this.getImportReference();
        }
        PsiImportStaticReferenceElement memberReference = this.getMemberReference();
        if (memberReference != null) {
            return memberReference.getClassReference();
        }
        return null;
    }

    @Override
    @Nullable
    public String getQualifiedName() {
        PsiJavaCodeReferenceElement reference = this.getImportReference();
        if (reference == null) {
            return null;
        }
        return reference.getCanonicalText();
    }

    @Override
    public boolean isReplaceEquivalent(PsiImportStatementBase other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PsiImportStaticStatementImpl)) {
            return false;
        }
        PsiImportStaticStatementImpl statement = (PsiImportStaticStatementImpl)other;
        return this.isOnDemand() == statement.isOnDemand() && Objects.equals(this.getQualifiedName(), statement.getQualifiedName());
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PsiImportStaticStatementImpl.$$$reportNull$$$0(0);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitImportStaticStatement(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiImportStaticStatement";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/PsiImportStaticStatementImpl", "accept"));
    }
}

