/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.presentation.java;

import com.intellij.core.JavaPsiBundle;
import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiImplicitClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.java.stubs.FunctionalExpressionStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class ClassPresentationUtil {
    private ClassPresentationUtil() {
    }

    @Nls
    public static String getNameForClass(@NotNull PsiClass aClass, boolean qualified) {
        String qName;
        if (aClass == null) {
            ClassPresentationUtil.$$$reportNull$$$0(0);
        }
        if (aClass instanceof PsiImplicitClass) {
            String name = aClass.getQualifiedName();
            if (name != null) {
                return name;
            }
            return JavaPsiBundle.message("implicit.class.context.display", new Object[0]);
        }
        if (aClass instanceof PsiAnonymousClass) {
            if (aClass instanceof PsiEnumConstantInitializer) {
                PsiEnumConstant enumConstant = ((PsiEnumConstantInitializer)aClass).getEnumConstant();
                String name = enumConstant.getName();
                return JavaPsiBundle.message("enum.constant.context", name, ClassPresentationUtil.getContextName(enumConstant, qualified, false));
            }
            return JavaPsiBundle.message("anonymous.class.context.display", ClassPresentationUtil.getContextName(aClass, qualified, false));
        }
        if (qualified && (qName = aClass.getQualifiedName()) != null) {
            return qName;
        }
        String className = aClass.getName();
        String contextName = ClassPresentationUtil.getContextName(aClass, qualified);
        return contextName != null ? JavaPsiBundle.message("class.context.display", className, contextName) : className;
    }

    private static String getNameForElement(@NotNull PsiElement element, boolean qualified, boolean ignorePsiClassOwner) {
        if (element == null) {
            ClassPresentationUtil.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiClass) {
            return ClassPresentationUtil.getNameForClass((PsiClass)element, qualified);
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            String methodName = method.getName();
            return JavaPsiBundle.message("method.context.display", methodName, ClassPresentationUtil.getContextName(method, qualified, false));
        }
        if (element instanceof PsiClassOwner && ignorePsiClassOwner) {
            return null;
        }
        if (element instanceof PsiFile) {
            return ((PsiFile)element).getName();
        }
        if (element instanceof PsiField) {
            return ((PsiField)element).getName() + " in " + ClassPresentationUtil.getContextName(element, qualified, false);
        }
        return null;
    }

    public static String getContextName(@NotNull PsiElement element, boolean qualified) {
        if (element == null) {
            ClassPresentationUtil.$$$reportNull$$$0(2);
        }
        return ClassPresentationUtil.getContextName(element, qualified, true);
    }

    public static String getContextName(@NotNull PsiElement element, boolean qualified, boolean ignorePsiClassOwner) {
        PsiElement parent;
        if (element == null) {
            ClassPresentationUtil.$$$reportNull$$$0(3);
        }
        if ((parent = PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)element, PsiMember.class)) == null) {
            parent = element.getContainingFile();
        }
        while (parent != null) {
            String name = ClassPresentationUtil.getNameForElement(parent, qualified, ignorePsiClassOwner);
            if (name != null) {
                return name;
            }
            if (parent instanceof PsiFile) {
                return null;
            }
            parent = PsiTreeUtil.getStubOrPsiParent((PsiElement)parent);
        }
        return null;
    }

    @Nls
    @NotNull
    public static String getFunctionalExpressionPresentation(PsiFunctionalExpression functionalExpression, boolean qualified) {
        StubElement stub = ((StubBasedPsiElementBase)functionalExpression).getGreenStub();
        String lambdaText = stub instanceof FunctionalExpressionStub ? ((FunctionalExpressionStub)stub).getPresentableText() : PsiExpressionTrimRenderer.render(functionalExpression);
        String string = JavaPsiBundle.message("class.context.display", lambdaText, ClassPresentationUtil.getContextName(functionalExpression, qualified, false));
        if (string == null) {
            ClassPresentationUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/presentation/java/ClassPresentationUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/presentation/java/ClassPresentationUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionalExpressionPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNameForClass";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getNameForElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getContextName";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

