/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.codeInsight.runner.JavaMainMethodProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class JvmMainMethodSearcher {
    public static final Condition<@NotNull PsiClass> MAIN_CLASS = psiClass -> {
        if (PsiUtil.isLocalOrAnonymousClass(psiClass)) {
            return false;
        }
        if (psiClass.isAnnotationType()) {
            return false;
        }
        if (psiClass.isInterface() && !PsiUtil.isAvailable(JavaFeature.EXTENSION_METHODS, psiClass)) {
            return false;
        }
        return psiClass.getContainingClass() == null || psiClass.hasModifierProperty("static");
    };
    protected static final String MAIN_METHOD_IDENTIFIER = "main";
    private final Comparator<PsiMethod> mainCandidateComparator = (o1, o2) -> {
        boolean isO1Static = o1.hasModifierProperty("static");
        boolean isO2Static = o2.hasModifierProperty("static");
        int o1Parameters = o1.getParameterList().getParametersCount();
        int o2Parameters = o2.getParameterList().getParametersCount();
        boolean isInheritedStaticMethodEnabled = this.inheritedStaticMainEnabled((PsiElement)o1);
        if (isInheritedStaticMethodEnabled) {
            return Integer.compare(o2Parameters, o1Parameters);
        }
        if (isO1Static == isO2Static) {
            return Integer.compare(o2Parameters, o1Parameters);
        }
        if (isO1Static) {
            return -1;
        }
        return 1;
    };

    protected Comparator<PsiMethod> getMainCandidateComparator() {
        return this.mainCandidateComparator;
    }

    @Nullable
    public PsiMethod findMainMethod(@NotNull PsiClass aClass) {
        JavaMainMethodProvider mainMethodProvider;
        if (aClass == null) {
            JvmMainMethodSearcher.$$$reportNull$$$0(0);
        }
        if ((mainMethodProvider = JvmMainMethodSearcher.getApplicableMainMethodProvider(aClass)) != null) {
            return mainMethodProvider.findMainInClass(aClass);
        }
        return this.findMainMethodInClassOrParent(aClass);
    }

    @Nullable
    public PsiMethod findMainMethodInClassOrParent(PsiClass aClass) {
        DumbService dumbService = DumbService.getInstance((Project)aClass.getProject());
        try {
            return (PsiMethod)dumbService.computeWithAlternativeResolveEnabled(() -> {
                PsiMethod[] mainMethods = this.findMainMethodsInClassByName(aClass);
                return this.findMainMethod(mainMethods, aClass, false);
            });
        }
        catch (IndexNotReadyException e) {
            return null;
        }
    }

    @Nullable
    private PsiMethod findMainMethod(PsiMethod[] mainMethods, PsiClass aClass, boolean first) {
        ArrayList<@NotNull PsiMethod> candidates = new ArrayList<PsiMethod>();
        boolean chooseMainMethodByParametersEnabled = this.inheritedStaticMainEnabled(aClass);
        for (PsiMethod mainMethod : mainMethods) {
            PsiClass containingClass;
            if (mainMethod.hasModifierProperty("abstract") || aClass.hasModifierProperty("abstract") && !mainMethod.hasModifierProperty("static") && !chooseMainMethodByParametersEnabled || (containingClass = mainMethod.getContainingClass()) != null && containingClass != aClass && (containingClass.isInterface() && !this.instanceMainMethodsEnabled(containingClass) || containingClass.isInterface() && mainMethod.hasModifierProperty("static")) || !this.isMainMethod(mainMethod, false)) continue;
            if (first && !chooseMainMethodByParametersEnabled && (mainMethod.hasModifierProperty("static") || JvmMainMethodSearcher.hasDefaultNonPrivateConstructor(aClass))) {
                return mainMethod;
            }
            candidates.add(mainMethod);
        }
        if (candidates.isEmpty()) {
            return null;
        }
        candidates.sort(this.getMainCandidateComparator());
        PsiMethod method = (PsiMethod)candidates.get(0);
        if (!method.hasModifierProperty("static")) {
            if (aClass.hasModifierProperty("abstract")) {
                return null;
            }
            if (!JvmMainMethodSearcher.hasDefaultNonPrivateConstructor(aClass)) {
                return null;
            }
        }
        return method;
    }

    public PsiMethod[] findMainMethodsInClassByName(@NotNull PsiClass aClass) {
        if (aClass == null) {
            JvmMainMethodSearcher.$$$reportNull$$$0(1);
        }
        return aClass.findMethodsByName(MAIN_METHOD_IDENTIFIER, true);
    }

    private static boolean hasDefaultNonPrivateConstructor(@NotNull PsiClass clazz) {
        PsiMethod[] constructors;
        if (clazz == null) {
            JvmMainMethodSearcher.$$$reportNull$$$0(2);
        }
        if ((constructors = clazz.getConstructors()).length == 0) {
            return true;
        }
        for (PsiMethod constr : constructors) {
            if (!constr.hasModifierProperty("public") && !constr.hasModifierProperty("protected") && !constr.hasModifierProperty("packageLocal") || !constr.getParameterList().isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Contract(value="null, _ -> false")
    private boolean isMainMethod(@Nullable PsiMethod mainMethod, boolean checkNoArgsConstructor) {
        if (mainMethod == null || mainMethod.getContainingClass() == null) {
            return false;
        }
        PsiClass containingClass = mainMethod.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        if (!PsiTypes.voidType().equals(mainMethod.getReturnType())) {
            return false;
        }
        PsiParameter[] parameters = mainMethod.getParameterList().getParameters();
        if (this.instanceMainMethodsEnabled(mainMethod)) {
            if (!(mainMethod.hasModifierProperty("public") || mainMethod.hasModifierProperty("packageLocal") || mainMethod.hasModifierProperty("protected"))) {
                return false;
            }
            if (containingClass.getContainingClass() != null && !containingClass.hasModifierProperty("static")) {
                return false;
            }
            if (checkNoArgsConstructor && !mainMethod.hasModifierProperty("static") && !JvmMainMethodSearcher.hasDefaultNonPrivateConstructor(containingClass)) {
                return false;
            }
            if (parameters.length == 1) {
                return JvmMainMethodSearcher.isJavaLangStringArray(parameters[0]);
            }
            return parameters.length == 0;
        }
        if (!mainMethod.hasModifierProperty("static")) {
            return false;
        }
        if (!mainMethod.hasModifierProperty("public")) {
            return false;
        }
        if (parameters.length != 1) {
            return false;
        }
        return JvmMainMethodSearcher.isJavaLangStringArray(parameters[0]);
    }

    @Contract(value="null -> false")
    public boolean isMainMethod(@Nullable PsiMethod method) {
        return this.isMainMethod(method, true);
    }

    protected static boolean isJavaLangStringArray(@NotNull PsiParameter parameter) {
        if (parameter == null) {
            JvmMainMethodSearcher.$$$reportNull$$$0(3);
        }
        try {
            PsiType type = parameter.getType();
            if (!(type instanceof PsiArrayType)) {
                return false;
            }
            return (Boolean)DumbService.getInstance((Project)parameter.getProject()).computeWithAlternativeResolveEnabled(() -> {
                PsiType componentType = ((PsiArrayType)type).getComponentType();
                return componentType.equalsToText("java.lang.String");
            });
        }
        catch (IndexNotReadyException e) {
            return false;
        }
    }

    public boolean hasMainMethod(PsiClass psiClass) {
        JavaMainMethodProvider mainMethodProvider = JvmMainMethodSearcher.getApplicableMainMethodProvider(psiClass);
        if (mainMethodProvider != null) {
            return mainMethodProvider.hasMainMethod(psiClass);
        }
        DumbService dumbService = DumbService.getInstance((Project)psiClass.getProject());
        try {
            return (Boolean)dumbService.computeWithAlternativeResolveEnabled(() -> {
                PsiMethod[] mainMethods = this.findMainMethodsInClassByName(psiClass);
                return this.findMainMethod(mainMethods, psiClass, true) != null;
            });
        }
        catch (IndexNotReadyException e) {
            return false;
        }
    }

    public boolean isMainMethodWithProvider(@NotNull PsiClass psiClass, @NotNull PsiElement psiElement) {
        JavaMainMethodProvider mainMethodProvider;
        if (psiClass == null) {
            JvmMainMethodSearcher.$$$reportNull$$$0(4);
        }
        if (psiElement == null) {
            JvmMainMethodSearcher.$$$reportNull$$$0(5);
        }
        if ((mainMethodProvider = JvmMainMethodSearcher.getApplicableMainMethodProvider(psiClass)) != null) {
            return mainMethodProvider.isMain(psiElement);
        }
        DumbService dumbService = DumbService.getInstance((Project)psiElement.getProject());
        try {
            return (Boolean)dumbService.computeWithAlternativeResolveEnabled(() -> {
                PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiMethod.class);
                if (psiMethod == null) {
                    return false;
                }
                return MAIN_METHOD_IDENTIFIER.equals(psiMethod.getName()) && this.isMainMethod(psiMethod);
            });
        }
        catch (IndexNotReadyException e) {
            return false;
        }
    }

    @Nullable
    public String getMainJVMClassName(@NotNull PsiClass psiClass) {
        JavaMainMethodProvider mainMethodProvider;
        if (psiClass == null) {
            JvmMainMethodSearcher.$$$reportNull$$$0(6);
        }
        if ((mainMethodProvider = JvmMainMethodSearcher.getApplicableMainMethodProvider(psiClass)) != null) {
            return mainMethodProvider.getMainClassName(psiClass);
        }
        return ClassUtil.getJVMClassName(psiClass);
    }

    @Nullable
    public String getMainClassQualifiedName(@NotNull PsiClass psiClass) {
        JavaMainMethodProvider mainMethodProvider;
        if (psiClass == null) {
            JvmMainMethodSearcher.$$$reportNull$$$0(7);
        }
        if ((mainMethodProvider = JvmMainMethodSearcher.getApplicableMainMethodProvider(psiClass)) != null) {
            return mainMethodProvider.getMainClassQualifiedName(psiClass);
        }
        return psiClass.getQualifiedName();
    }

    @Nullable
    public PsiMethod findMainInClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            JvmMainMethodSearcher.$$$reportNull$$$0(8);
        }
        if (!MAIN_CLASS.value((Object)aClass)) {
            return null;
        }
        return this.findMainMethod(aClass);
    }

    public boolean hasMainInClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            JvmMainMethodSearcher.$$$reportNull$$$0(9);
        }
        if (!MAIN_CLASS.value((Object)aClass)) {
            return false;
        }
        return this.hasMainMethod(aClass);
    }

    @Nullable
    private static JavaMainMethodProvider getApplicableMainMethodProvider(@NotNull PsiClass aClass) {
        if (aClass == null) {
            JvmMainMethodSearcher.$$$reportNull$$$0(10);
        }
        DumbService dumbService = DumbService.getInstance((Project)aClass.getProject());
        List javaMainMethodProviders = dumbService.filterByDumbAwareness((Collection)JavaMainMethodProvider.EP_NAME.getExtensionList());
        return (JavaMainMethodProvider)ContainerUtil.find((Iterable)javaMainMethodProviders, provider -> provider.isApplicable(aClass));
    }

    public abstract boolean instanceMainMethodsEnabled(@NotNull PsiElement var1);

    protected abstract boolean inheritedStaticMainEnabled(@NotNull PsiElement var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/util/JvmMainMethodSearcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findMainMethod";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findMainMethodsInClassByName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "hasDefaultNonPrivateConstructor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isJavaLangStringArray";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isMainMethodWithProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getMainJVMClassName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getMainClassQualifiedName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "findMainInClass";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "hasMainInClass";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getApplicableMainMethodProvider";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

