/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.dependency.BackDependencyIndex;
import org.jetbrains.jps.dependency.CompositeBackDependencyIndex;
import org.jetbrains.jps.dependency.Graph;
import org.jetbrains.jps.dependency.Node;
import org.jetbrains.jps.dependency.NodeSource;
import org.jetbrains.jps.dependency.ReferenceID;
import org.jetbrains.jps.util.Iterators;

public interface CompositeGraph
extends Graph {
    public static CompositeGraph create(final Iterable<Graph> parts) {
        final HashMap<String, List> indexMap = new HashMap<String, List>();
        for (BackDependencyIndex index : Iterators.flat(Iterators.map(parts, Graph::getIndices))) {
            indexMap.computeIfAbsent(index.getName(), n -> new ArrayList()).add(index);
        }
        return new CompositeGraph(){
            final Map<String, CompositeBackDependencyIndex> myIndices = new HashMap<String, CompositeBackDependencyIndex>();

            @Override
            public Iterable<BackDependencyIndex> getIndices() {
                return Iterators.map(indexMap.keySet(), this::getIndex);
            }

            @Override
            @Nullable
            public BackDependencyIndex getIndex(String name) {
                List indices = (List)indexMap.get(name);
                return indices != null ? (BackDependencyIndex)this.myIndices.computeIfAbsent(name, n -> CompositeBackDependencyIndex.create(n, indices)) : null;
            }

            @Override
            @NotNull
            public Iterable<ReferenceID> getDependingNodes(@NotNull ReferenceID id) {
                if (id == null) {
                    1.$$$reportNull$$$0(0);
                }
                Iterable<ReferenceID> iterable = Iterators.unique(Iterators.flat(Iterators.map(parts, gr -> gr.getDependingNodes(id))));
                if (iterable == null) {
                    1.$$$reportNull$$$0(1);
                }
                return iterable;
            }

            @Override
            public Iterable<NodeSource> getSources(@NotNull ReferenceID id) {
                if (id == null) {
                    1.$$$reportNull$$$0(2);
                }
                return Iterators.unique(Iterators.flat(Iterators.map(parts, gr -> gr.getSources(id))));
            }

            @Override
            public Iterable<ReferenceID> getRegisteredNodes() {
                return Iterators.unique(Iterators.flat(Iterators.map(parts, Graph::getRegisteredNodes)));
            }

            @Override
            public Iterable<NodeSource> getSources() {
                return Iterators.unique(Iterators.flat(Iterators.map(parts, Graph::getSources)));
            }

            @Override
            public Iterable<Node<?, ?>> getNodes(@NotNull NodeSource source) {
                if (source == null) {
                    1.$$$reportNull$$$0(3);
                }
                return Iterators.unique(Iterators.flat(Iterators.map(parts, gr -> gr.getNodes(source))));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "id";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/jps/dependency/CompositeGraph$1";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "source";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/jps/dependency/CompositeGraph$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDependingNodes";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getDependingNodes";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getSources";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getNodes";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }
}

