/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.impl;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.dependency.ComparableTypeExternalizer;
import org.jetbrains.jps.dependency.Maplet;
import org.jetbrains.jps.dependency.MapletFactory;
import org.jetbrains.jps.dependency.MultiMaplet;
import org.jetbrains.jps.dependency.impl.MemoryMaplet;
import org.jetbrains.jps.dependency.impl.MemoryMultiMaplet;

public final class Containers {
    public static final MapletFactory MEMORY_CONTAINER_FACTORY = new MapletFactory(){

        @Override
        public <K, V> MultiMaplet<K, V> createSetMultiMaplet(String storageName, ComparableTypeExternalizer<K> keyExternalizer, ComparableTypeExternalizer<V> valueExternalizer) {
            return new MemoryMultiMaplet(() -> new HashSet());
        }

        @Override
        public <K, V> Maplet<K, V> createMaplet(String storageName, ComparableTypeExternalizer<K> keyExternalizer, ComparableTypeExternalizer<V> valueExternalizer) {
            return new MemoryMaplet();
        }
    };

    public static <K, V> Map<K, V> createCustomPolicyMap(BiFunction<? super K, ? super K, Boolean> keyEqualsImpl, Function<? super K, Integer> keyHashCodeImpl) {
        return new Object2ObjectOpenCustomHashMap(Containers.asHashStrategy(keyEqualsImpl, keyHashCodeImpl));
    }

    public static <T> Set<T> createCustomPolicySet(BiFunction<? super T, ? super T, Boolean> equalsImpl, Function<? super T, Integer> hashCodeImpl) {
        return new ObjectOpenCustomHashSet(Containers.asHashStrategy(equalsImpl, hashCodeImpl));
    }

    public static <T> Set<T> createCustomPolicySet(Collection<? extends T> col, BiFunction<? super T, ? super T, Boolean> equalsImpl, Function<? super T, Integer> hashCodeImpl) {
        return new ObjectOpenCustomHashSet(col, Containers.asHashStrategy(equalsImpl, hashCodeImpl));
    }

    @NotNull
    private static <T> Hash.Strategy<T> asHashStrategy(final BiFunction<? super T, ? super T, Boolean> equalsImpl, final Function<? super T, Integer> hashCodeImpl) {
        return new Hash.Strategy<T>(){

            public int hashCode(@Nullable T o) {
                return (Integer)hashCodeImpl.apply(o);
            }

            public boolean equals(@Nullable T a, @Nullable T b) {
                return (Boolean)equalsImpl.apply(a, b);
            }
        };
    }
}

