/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes;

import com.intellij.icons.AllIcons;
import com.intellij.kubernetes.KubernetesModelAccessor;
import com.intellij.kubernetes.MiscUtilKt;
import com.intellij.kubernetes.config.KubernetesIdeSettings;
import com.intellij.kubernetes.config.KubernetesProjectOptions;
import com.intellij.kubernetes.config.KubernetesProjectSettings;
import com.intellij.kubernetes.config.SpecSource;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.ui.NotificationsKt;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a3\u0010\u0006\u001a\"\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007j\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b`\n2\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u000b\u00a8\u0006\f"}, d2={"addCrdSpecToProjectConfiguration", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getAllExternalSpecPathsOrUrls", "Ljava/util/HashSet;", "", "kotlin.jvm.PlatformType", "Lkotlin/collections/HashSet;", "Lorg/jetbrains/annotations/NotNull;", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nKubernetesConfigurationUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesConfigurationUtil.kt\ncom/intellij/kubernetes/KubernetesConfigurationUtilKt\n+ 2 MiscUtil.kt\ncom/intellij/kubernetes/MiscUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,49:1\n133#2:50\n1642#3,10:51\n1915#3:61\n1916#3:63\n1652#3:64\n1#4:62\n*S KotlinDebug\n*F\n+ 1 KubernetesConfigurationUtil.kt\ncom/intellij/kubernetes/KubernetesConfigurationUtilKt\n*L\n29#1:50\n48#1:51,10\n48#1:61\n48#1:63\n48#1:64\n48#1:62\n*E\n"})
public final class KubernetesConfigurationUtilKt {
    public static final void addCrdSpecToProjectConfiguration(@NotNull Project project, @NotNull VirtualFile file) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        boolean bl = file.getFileSystem() instanceof LocalFileSystem;
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        String string4 = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getPath(...)");
        String fullFilePath = string4;
        ((KubernetesProjectOptions)KubernetesProjectSettings.Companion.getInstance(project).getState()).getSpecSources().add(new SpecSource(fullFilePath));
        KubernetesModelAccessor.Companion.getInstance(project).reset();
        String string5 = project.getBasePath();
        Intrinsics.checkNotNull((Object)string5);
        String projectPath = PathUtil.toSystemIndependentName((String)string5);
        Intrinsics.checkNotNull((Object)projectPath);
        boolean condition$iv = StringsKt.startsWith$default((String)fullFilePath, (String)projectPath, (boolean)false, (int)2, null);
        boolean $i$f$doIf = false;
        if (condition$iv) {
            boolean bl2 = false;
            String string6 = fullFilePath.substring(projectPath.length());
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
            string2 = StringUtil.trimLeading((String)string6, (char)'/');
        } else {
            string2 = string = null;
        }
        if (string2 == null) {
            String string7 = StringUtil.shortenPathWithEllipsis((String)file.getPresentableUrl(), (int)80);
            string = string7;
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"shortenPathWithEllipsis(...)");
        }
        String presentablePath = string;
        NotificationGroup notificationGroup = NotificationsKt.getKubernetesNotificationGroup();
        String string8 = KubernetesBundle.message((String)KubernetesBundle.message((String)"KubernetesNotification.title", (Object[])new Object[0]), (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"message(...)");
        Object object = new Object[]{presentablePath};
        String string9 = KubernetesBundle.message((String)"KubernetesNotification.external.spec.added.message", (Object[])object);
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"message(...)");
        String string10 = KubernetesBundle.message((String)"action.Kubernetes.go.to.file.text", (Object[])new Object[0]);
        object = AllIcons.FileTypes.Any_type;
        notificationGroup.createNotification(string8, string9, NotificationType.INFORMATION).addAction(ActionManager.getInstance().getAction("Kubernetes.ConfigureExternalSchema")).addAction((AnAction)new DumbAwareAction(project, file, string10, (Icon)object){
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $file;
            {
                this.$project = $project;
                this.$file = $file;
                super($super_call_param$1, null, $super_call_param$2);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                MiscUtilKt.openInEditor((Project)this.$project, (VirtualFile)this.$file, null);
            }
        }).notify(project);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final HashSet<String> getAllExternalSpecPathsOrUrls(@NotNull Project project) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterable $this$mapNotNull$iv = CollectionsKt.plus((Collection)KubernetesProjectSettings.Companion.getInstance(project).getEffectiveCrdSpecSources(), (Iterable)KubernetesIdeSettings.Companion.getInstance().getEffectiveCrdSpecSources());
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            SpecSource it = (SpecSource)element$iv$iv;
            boolean bl2 = false;
            if (it.getPathOrUrl() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Collection collection = (List)destination$iv$iv;
        return new HashSet<String>(collection);
    }
}

