/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.database;

import com.intellij.kubernetes.database.KubernetesPortForwardingDatabaseType;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0006J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u0006R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/intellij/kubernetes/database/KubernetesDatabaseTypes;", "", "<init>", "()V", "DATABASE_TYPES", "", "", "Lcom/intellij/kubernetes/database/KubernetesPortForwardingDatabaseType;", "getDATABASE_TYPES", "()Ljava/util/Map;", "isDatabaseImage", "", "image", "getDatabaseType", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nKubernetesDatabaseTypes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesDatabaseTypes.kt\ncom/intellij/kubernetes/database/KubernetesDatabaseTypes\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,166:1\n1807#2,3:167\n296#2,2:170\n*S KotlinDebug\n*F\n+ 1 KubernetesDatabaseTypes.kt\ncom/intellij/kubernetes/database/KubernetesDatabaseTypes\n*L\n154#1:167,3\n162#1:170,2\n*E\n"})
public final class KubernetesDatabaseTypes {
    @NotNull
    public static final KubernetesDatabaseTypes INSTANCE = new KubernetesDatabaseTypes();
    @NotNull
    private static final Map<String, KubernetesPortForwardingDatabaseType> DATABASE_TYPES;

    private KubernetesDatabaseTypes() {
    }

    @NotNull
    public final Map<String, KubernetesPortForwardingDatabaseType> getDATABASE_TYPES() {
        return DATABASE_TYPES;
    }

    public final boolean isDatabaseImage(@Nullable String image) {
        boolean bl;
        block4: {
            if (image == null) {
                return false;
            }
            Iterable $this$any$iv = DATABASE_TYPES.keySet();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String pattern = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.contains((CharSequence)image, (CharSequence)pattern, (boolean)true)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public final KubernetesPortForwardingDatabaseType getDatabaseType(@Nullable String image) {
        Object v0;
        block2: {
            if (image == null) {
                return null;
            }
            Iterable $this$firstOrNull$iv = DATABASE_TYPES.entrySet();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Map.Entry entry = (Map.Entry)element$iv;
                boolean bl = false;
                String pattern = (String)entry.getKey();
                if (!StringsKt.contains((CharSequence)image, (CharSequence)pattern, (boolean)true)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        Map.Entry entry = v0;
        return entry != null ? (KubernetesPortForwardingDatabaseType)entry.getValue() : null;
    }

    private static final String DATABASE_TYPES$lambda$0(String address, int port) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return "jdbc:postgresql://" + address + ":" + port + "/postgres";
    }

    private static final String DATABASE_TYPES$lambda$1(String address, int port) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return "jdbc:mysql://" + address + ":" + port;
    }

    private static final String DATABASE_TYPES$lambda$2(String address, int port) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return "jdbc:mariadb://" + address + ":" + port;
    }

    private static final String DATABASE_TYPES$lambda$3(String address, int port) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return "mongodb://" + address + ":" + port;
    }

    private static final String DATABASE_TYPES$lambda$4(String address, int port) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return "jdbc:redis://" + address + ":" + port + "/0";
    }

    private static final String DATABASE_TYPES$lambda$5(String address, int port) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return "jdbc:redshift://" + address + ":" + port;
    }

    private static final String DATABASE_TYPES$lambda$6(String address, int port) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return "jdbc:cassandra://" + address + ":" + port;
    }

    private static final String DATABASE_TYPES$lambda$7(String address, int port) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return "jdbc:hive2://" + address + ":" + port;
    }

    private static final String DATABASE_TYPES$lambda$8(String address, int port) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return "jdbc:sqlserver://" + address + ":" + port;
    }

    private static final String DATABASE_TYPES$lambda$9(String address, int port) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return "jdbc:sqlserver://" + address + ":" + port;
    }

    private static final String DATABASE_TYPES$lambda$10(String address, int port) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return "jdbc:bigquery://https://" + address + ":" + port;
    }

    private static final String DATABASE_TYPES$lambda$11(String address, int port) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return "jdbc:clickhouse://" + address + ":" + port;
    }

    private static final String DATABASE_TYPES$lambda$12(String address, int port) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return "jdbc:postgresql://" + address + ":" + port + "/defaultdb";
    }

    private static final String DATABASE_TYPES$lambda$13(String address, int port) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return "jdbc:couchbase://" + address + ":" + port;
    }

    private static final String DATABASE_TYPES$lambda$14(String address, int port) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return "jdbc:mongodb://" + address + ":" + port;
    }

    private static final String DATABASE_TYPES$lambda$15(String address, int port) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return "jdbc:dynamodb://" + address + ":" + port + "?region=eu-west-1";
    }

    private static final String DATABASE_TYPES$lambda$16(String address, int port) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return "jdbc:exa:" + address + ":" + port;
    }

    private static final String DATABASE_TYPES$lambda$17(String address, int port) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return "jdbc:postgresql://" + address + ":" + port + "/postgres";
    }

    private static final String DATABASE_TYPES$lambda$18(String address, int port) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return "jdbc:h2:tcp://" + address + ":" + port + "/default";
    }

    private static final String DATABASE_TYPES$lambda$19(String address, int port) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return "jdbc:db2://" + address + ":" + port;
    }

    private static final String DATABASE_TYPES$lambda$20(String address, int port) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return "jdbc:sqlserver://" + address + ":" + port;
    }

    private static final String DATABASE_TYPES$lambda$21(String address, int port) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return "jdbc:oracle:thin:@//" + address + ":" + port + "/XE";
    }

    private static final String DATABASE_TYPES$lambda$22(String address, int port) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return "jdbc:snowflake://" + address + ":" + port;
    }

    private static final String DATABASE_TYPES$lambda$23(String address, int port) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return "jdbc:sybase:Tds:" + address + ":" + port;
    }

    private static final String DATABASE_TYPES$lambda$24(String address, int port) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return "jdbc:vertica://" + address + ":" + port;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"postgres", (Object)new KubernetesPortForwardingDatabaseType("PostgreSQL", "postgresql", KubernetesDatabaseTypes::DATABASE_TYPES$lambda$0, null, 8, null)), TuplesKt.to((Object)"mysql", (Object)new KubernetesPortForwardingDatabaseType("MySQL", "mysql.8", KubernetesDatabaseTypes::DATABASE_TYPES$lambda$1, null, 8, null)), TuplesKt.to((Object)"mariadb", (Object)new KubernetesPortForwardingDatabaseType("MariaDB", "mariadb", KubernetesDatabaseTypes::DATABASE_TYPES$lambda$2, null, 8, null)), TuplesKt.to((Object)"mongo", (Object)new KubernetesPortForwardingDatabaseType("MongoDB", "mongo.4", KubernetesDatabaseTypes::DATABASE_TYPES$lambda$3, null, 8, null)), TuplesKt.to((Object)"redis", (Object)new KubernetesPortForwardingDatabaseType("Redis", "redis", KubernetesDatabaseTypes::DATABASE_TYPES$lambda$4, null, 8, null)), TuplesKt.to((Object)"redshift", (Object)new KubernetesPortForwardingDatabaseType("Amazon Redshift", "redshift", KubernetesDatabaseTypes::DATABASE_TYPES$lambda$5, null, 8, null)), TuplesKt.to((Object)"cassandra", (Object)new KubernetesPortForwardingDatabaseType("Apache Cassandra", "cassandra", KubernetesDatabaseTypes::DATABASE_TYPES$lambda$6, null, 8, null)), TuplesKt.to((Object)"hive", (Object)new KubernetesPortForwardingDatabaseType("Apache Hive", "hive", KubernetesDatabaseTypes::DATABASE_TYPES$lambda$7, null, 8, null)), TuplesKt.to((Object)"azuresql", (Object)new KubernetesPortForwardingDatabaseType("Azure SQL Database", "sqlserver.ms", KubernetesDatabaseTypes::DATABASE_TYPES$lambda$8, null, 8, null)), TuplesKt.to((Object)"azure-sql", (Object)new KubernetesPortForwardingDatabaseType("Azure SQL Database", "sqlserver.ms", KubernetesDatabaseTypes::DATABASE_TYPES$lambda$9, null, 8, null)), TuplesKt.to((Object)"bigquery", (Object)new KubernetesPortForwardingDatabaseType("Google BigQuery", "bigquery", KubernetesDatabaseTypes::DATABASE_TYPES$lambda$10, null, 8, null)), TuplesKt.to((Object)"clickhouse", (Object)new KubernetesPortForwardingDatabaseType("ClickHouse", "clickhouse", KubernetesDatabaseTypes::DATABASE_TYPES$lambda$11, null, 8, null)), TuplesKt.to((Object)"cockroach", (Object)new KubernetesPortForwardingDatabaseType("CockroachDB", "cockroach", KubernetesDatabaseTypes::DATABASE_TYPES$lambda$12, null, 8, null)), TuplesKt.to((Object)"couchbase", (Object)new KubernetesPortForwardingDatabaseType("Couchbase Query", "couchbase_query", KubernetesDatabaseTypes::DATABASE_TYPES$lambda$13, null, 8, null)), TuplesKt.to((Object)"documentdb", (Object)new KubernetesPortForwardingDatabaseType("Amazon DocumentDB", "mongo.4", KubernetesDatabaseTypes::DATABASE_TYPES$lambda$14, null, 8, null)), TuplesKt.to((Object)"dynamodb", (Object)new KubernetesPortForwardingDatabaseType("Amazon DynamoDB", "dynamo", KubernetesDatabaseTypes::DATABASE_TYPES$lambda$15, null, 8, null)), TuplesKt.to((Object)"exasol", (Object)new KubernetesPortForwardingDatabaseType("Exasol", "exasol", KubernetesDatabaseTypes::DATABASE_TYPES$lambda$16, null, 8, null)), TuplesKt.to((Object)"greenplum", (Object)new KubernetesPortForwardingDatabaseType("Greenplum", "greenplum", KubernetesDatabaseTypes::DATABASE_TYPES$lambda$17, null, 8, null)), TuplesKt.to((Object)"h2", (Object)new KubernetesPortForwardingDatabaseType("H2", "h2.unified", KubernetesDatabaseTypes::DATABASE_TYPES$lambda$18, null, 8, null)), TuplesKt.to((Object)"db2", (Object)new KubernetesPortForwardingDatabaseType("IBM Db2 LUW", "db2.11", KubernetesDatabaseTypes::DATABASE_TYPES$lambda$19, null, 8, null)), TuplesKt.to((Object)"sqlserver", (Object)new KubernetesPortForwardingDatabaseType("Microsoft SQL Server", "sqlserver.ms", KubernetesDatabaseTypes::DATABASE_TYPES$lambda$20, null, 8, null)), TuplesKt.to((Object)"oracle", (Object)new KubernetesPortForwardingDatabaseType("Oracle", "oracle.19", KubernetesDatabaseTypes::DATABASE_TYPES$lambda$21, null, 8, null)), TuplesKt.to((Object)"snowflake", (Object)new KubernetesPortForwardingDatabaseType("Snowflake", "snowflake", KubernetesDatabaseTypes::DATABASE_TYPES$lambda$22, null, 8, null)), TuplesKt.to((Object)"sybase", (Object)new KubernetesPortForwardingDatabaseType("Sybase ASE", "sybase.ase", KubernetesDatabaseTypes::DATABASE_TYPES$lambda$23, null, 8, null)), TuplesKt.to((Object)"vertica", (Object)new KubernetesPortForwardingDatabaseType("Vertica", "vertica", KubernetesDatabaseTypes::DATABASE_TYPES$lambda$24, null, 8, null))};
        DATABASE_TYPES = MapsKt.mapOf((Pair[])pairArray);
    }
}

