/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm.model;

import com.intellij.kubernetes.helm.model.HelmValuePomTarget;
import com.intellij.kubernetes.helm.model.PathInChart;
import com.intellij.kubernetes.helm.model.SimpleHelmObject;
import com.intellij.openapi.project.Project;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\r\u001a\u00020\u000eH\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lcom/intellij/kubernetes/helm/model/SimpleSearchableObject;", "Lcom/intellij/kubernetes/helm/model/SimpleHelmObject;", "position", "Lcom/intellij/kubernetes/helm/model/PathInChart;", "<init>", "(Lcom/intellij/kubernetes/helm/model/PathInChart;)V", "getPosition", "()Lcom/intellij/kubernetes/helm/model/PathInChart;", "declarationElements", "", "Lcom/intellij/psi/PsiElement;", "getDeclarationElements", "()Ljava/util/Collection;", "createPomTarget", "Lcom/intellij/kubernetes/helm/model/HelmValuePomTarget;", "intellij.clouds.kubernetes.backend"})
public class SimpleSearchableObject
extends SimpleHelmObject {
    @NotNull
    private final PathInChart position;

    public SimpleSearchableObject(@NotNull PathInChart position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        String string = (String)CollectionsKt.lastOrNull(position.getObjectPath().getFullPath());
        if (string == null) {
            string = "<root>";
        }
        super(string);
        this.position = position;
    }

    @NotNull
    protected final PathInChart getPosition() {
        return this.position;
    }

    @Override
    @NotNull
    public Collection<PsiElement> getDeclarationElements() {
        return CollectionsKt.listOf((Object)PomService.convertToPsi((Project)this.position.getChart().getProject(), (PomTarget)((PomTarget)this.createPomTarget())));
    }

    @NotNull
    protected HelmValuePomTarget createPomTarget() {
        return new HelmValuePomTarget(this.getName(), this.position, this.isRenameable());
    }
}

