/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.ui.actions;

import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.chart.ChartManager;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.ui.actions.KubernetesActionBase;
import com.intellij.kubernetes.ui.actions.SlowHelmActionBase;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0014J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000b\u001a\u00020\bH\u0014J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\bH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/intellij/kubernetes/ui/actions/HelmLintAction;", "Lcom/intellij/kubernetes/ui/actions/SlowHelmActionBase;", "<init>", "()V", "getHelmCommand", "", "", "ctx", "Lcom/intellij/kubernetes/ui/actions/KubernetesActionBase$ActionContext;", "isApplicable", "", "context", "getChart", "Lcom/intellij/kubernetes/helm/chart/Chart;", "onProcessFinished", "", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nHelmLintAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmLintAction.kt\ncom/intellij/kubernetes/ui/actions/HelmLintAction\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,22:1\n30#2,2:23\n1#3:25\n*S KotlinDebug\n*F\n+ 1 HelmLintAction.kt\ncom/intellij/kubernetes/ui/actions/HelmLintAction\n*L\n16#1:23,2\n*E\n"})
public final class HelmLintAction
extends SlowHelmActionBase {
    public HelmLintAction() {
        String string = KubernetesBundle.message((String)"HelmLintAction.task.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(string, true);
    }

    @Override
    @NotNull
    protected List<String> getHelmCommand(@NotNull KubernetesActionBase.ActionContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return CollectionsKt.listOf((Object)"lint");
    }

    @Override
    protected boolean isApplicable(@NotNull KubernetesActionBase.ActionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return this.getChart(context2) != null;
    }

    @Override
    @Nullable
    protected Chart getChart(@NotNull KubernetesActionBase.ActionContext context2) {
        Chart chart;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ComponentManager $this$service$iv = (ComponentManager)context2.getProject();
        boolean $i$f$service = false;
        Class<ChartManager> serviceClass$iv = ChartManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Chart chart2 = ((ChartManager)object).findChartByRelatedFile(context2.getCurrentFile());
        if (chart2 != null) {
            Chart chart3;
            Chart it = chart3 = chart2;
            boolean bl = false;
            chart = !it.isDownloaded() && it.getChartFile() != null ? chart3 : null;
        } else {
            chart = null;
        }
        return chart;
    }

    @Override
    protected void onProcessFinished(@NotNull KubernetesActionBase.ActionContext context2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Chart chart = this.getChart(context2);
            if (chart == null || (chart = chart.getBaseDir()) == null) break block0;
            chart.refresh(false, true);
        }
    }
}

