/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui.actions;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0001\u001a\b\u0010\u0006\u001a\u00020\u0005H\u0002\u00a8\u0006\u0007"}, d2={"createLightImmutableCopy", "Lcom/intellij/testFramework/LightVirtualFile;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "content", "", "currentTimestamp", "intellij.clouds.kubernetes.backend"})
public final class KubernetesCompareWithClusterActionKt {
    @RequiresReadLock
    @NotNull
    public static final LightVirtualFile createLightImmutableCopy(@NotNull VirtualFile virtualFile, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        String string = virtualFile.getNameWithoutExtension() + "_" + KubernetesCompareWithClusterActionKt.currentTimestamp() + "." + virtualFile.getExtension();
        FileType fileType = virtualFile.getFileType();
        return new LightVirtualFile(virtualFile, content, string, fileType){
            {
                this.setOriginalFile($virtualFile);
                this.setCharset($virtualFile.getCharset());
                this.setWritable(false);
            }
        };
    }

    private static final String currentTimestamp() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH:mm:ss.SSS").withLocale(Locale.getDefault()).withZone(ZoneId.systemDefault());
        String string = LocalDateTime.now().format(formatter);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }
}

