/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.util.io.NioFiles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\b\u0010\u0016\u001a\u00020\u0012H\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/openapi/diagnostic/InMemoryHandler;", "Ljava/util/logging/Handler;", "outputPath", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "getOutputPath", "()Ljava/nio/file/Path;", "buildFailed", "", "getBuildFailed", "()Z", "setBuildFailed", "(Z)V", "messages", "", "", "publish", "", "record", "Ljava/util/logging/LogRecord;", "flush", "close", "removeOldFiles", "directory", "Companion", "intellij.platform.util"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nInMemoryHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InMemoryHandler.kt\ncom/intellij/openapi/diagnostic/InMemoryHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n777#2:81\n873#2,2:82\n1068#2:84\n1915#2,2:85\n*S KotlinDebug\n*F\n+ 1 InMemoryHandler.kt\ncom/intellij/openapi/diagnostic/InMemoryHandler\n*L\n71#1:81\n71#1:82,2\n74#1:84\n76#1:85,2\n*E\n"})
public final class InMemoryHandler
extends Handler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path outputPath;
    private boolean buildFailed;
    @NotNull
    private final List<String> messages;
    @NotNull
    public static final String FAILED_BUILD_LOG_FILE_NAME_PREFIX = "failed-build_";
    public static final int MAX_REPORT_NUMBER = 3;
    @NotNull
    public static final String IN_MEMORY_LOGGER_ADVANCED_SETTINGS_NAME = "compiler.inMemoryLogger";

    public InMemoryHandler(@NotNull Path outputPath) {
        Intrinsics.checkNotNullParameter(outputPath, "outputPath");
        this.outputPath = outputPath;
        this.messages = new ArrayList();
        Path path = this.outputPath.getParent();
        Intrinsics.checkNotNullExpressionValue(path, "getParent(...)");
        this.removeOldFiles(path);
    }

    @NotNull
    public final Path getOutputPath() {
        return this.outputPath;
    }

    public final boolean getBuildFailed() {
        return this.buildFailed;
    }

    public final void setBuildFailed(boolean bl) {
        this.buildFailed = bl;
    }

    @Override
    public void publish(@Nullable LogRecord record) {
        try {
            String string = this.getFormatter().format(record);
            if (string != null) {
                String it = string;
                boolean bl = false;
                if (StringsKt.contains$default((CharSequence)it, "Compiled with errors", false, 2, null)) {
                    this.buildFailed = true;
                }
                this.messages.add(it);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        if (this.buildFailed) {
            Path outputFile = Paths.get(((Object)this.outputPath).toString(), new String[0]);
            Intrinsics.checkNotNull(outputFile);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(outputFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                Files.delete(outputFile);
            } else {
                Path path = outputFile.getParent();
                Intrinsics.checkNotNullExpressionValue(path, "getParent(...)");
                Path path2 = path;
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (!Files.exists(path2, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                    PathsKt.createParentDirectories(outputFile, new FileAttribute[0]);
                }
            }
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue(Files.createFile(outputFile, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), "createFile(...)");
            String it = CollectionsKt.joinToString$default(this.messages, "", null, null, 0, null, null, 62, null);
            boolean bl = false;
            PathsKt.appendText$default(outputFile, it, null, 2, null);
        }
        this.messages.clear();
        this.buildFailed = false;
    }

    /*
     * WARNING - void declaration
     */
    private final void removeOldFiles(Path directory) {
        void $this$filterTo$iv$iv;
        List<Path> list = NioFiles.list(directory);
        Intrinsics.checkNotNullExpressionValue(list, "list(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Path it = (Path)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            if (!StringsKt.startsWith$default(PathsKt.getName(it), FAILED_BUILD_LOG_FILE_NAME_PREFIX, false, 2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List logFiles = (List)destination$iv$iv;
        if (logFiles.size() >= 3) {
            Iterable $this$sortedBy$iv = logFiles;
            boolean $i$f$sortedBy = false;
            Iterable $this$forEach$iv = CollectionsKt.take(CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    Path it = (Path)a;
                    boolean bl = false;
                    Intrinsics.checkNotNull(it);
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    FileTime fileTime = Files.getLastModifiedTime(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
                    Intrinsics.checkNotNullExpressionValue(fileTime, "getLastModifiedTime(...)");
                    it = (Path)b;
                    Comparable comparable = fileTime;
                    bl = false;
                    Intrinsics.checkNotNull(it);
                    LinkOption[] linkOptionArray2 = new LinkOption[]{};
                    FileTime fileTime2 = Files.getLastModifiedTime(it, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length));
                    Intrinsics.checkNotNullExpressionValue(fileTime2, "getLastModifiedTime(...)");
                    return ComparisonsKt.compareValues(comparable, (Comparable)fileTime2);
                }
            }), logFiles.size() - 3 + 1);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Path it = (Path)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                Files.deleteIfExists(it);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/diagnostic/InMemoryHandler$Companion;", "", "<init>", "()V", "FAILED_BUILD_LOG_FILE_NAME_PREFIX", "", "MAX_REPORT_NUMBER", "", "IN_MEMORY_LOGGER_ADVANCED_SETTINGS_NAME", "intellij.platform.util"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

