/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xmlb.annotations.Transient;
import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.jdom.Element;
import org.jdom.Verifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public final class DefaultJDOMExternalizer {
    private static final Logger LOG = Logger.getInstance(DefaultJDOMExternalizer.class);
    private static final ClassValue<Map<String, Field>> fieldCache = new DefaultJDOMExternalizerMapClassValue();

    private DefaultJDOMExternalizer() {
    }

    public static void writeExternal(@NotNull Object data, @NotNull Element parentNode) throws WriteExternalException {
        if (data == null) {
            DefaultJDOMExternalizer.$$$reportNull$$$0(0);
        }
        if (parentNode == null) {
            DefaultJDOMExternalizer.$$$reportNull$$$0(1);
        }
        DefaultJDOMExternalizer.write(data, parentNode, null);
    }

    public static void writeExternal(@NotNull Object data, @NotNull Element parentNode, @Nullable(value="null means all elements are accepted") @Nullable(value="null means all elements are accepted") JDOMFilter filter) throws WriteExternalException {
        if (data == null) {
            DefaultJDOMExternalizer.$$$reportNull$$$0(2);
        }
        if (parentNode == null) {
            DefaultJDOMExternalizer.$$$reportNull$$$0(3);
        }
        if (filter instanceof Predicate) {
            DefaultJDOMExternalizer.write(data, parentNode, (Predicate)((Object)filter));
        } else {
            DefaultJDOMExternalizer.write(data, parentNode, filter == null ? null : field -> filter.isAccept((Field)field));
        }
    }

    public static void write(@NotNull Object data, @NotNull Element parentNode, @Nullable(value="null means all elements are accepted") @Nullable(value="null means all elements are accepted") Predicate<? super Field> filter) throws WriteExternalException {
        if (data == null) {
            DefaultJDOMExternalizer.$$$reportNull$$$0(4);
        }
        if (parentNode == null) {
            DefaultJDOMExternalizer.$$$reportNull$$$0(5);
        }
        for (Field field : fieldCache.get(data.getClass()).values()) {
            Element element;
            String value;
            block25: {
                if (filter != null && !filter.test(field)) continue;
                Class<?> type = field.getType();
                value = null;
                try {
                    if (type.isPrimitive()) {
                        if (type.equals(Byte.TYPE)) {
                            value = Byte.toString(field.getByte(data));
                        } else if (type.equals(Short.TYPE)) {
                            value = Short.toString(field.getShort(data));
                        } else if (type.equals(Integer.TYPE)) {
                            value = Integer.toString(field.getInt(data));
                        } else if (type.equals(Long.TYPE)) {
                            value = Long.toString(field.getLong(data));
                        } else if (type.equals(Float.TYPE)) {
                            value = Float.toString(field.getFloat(data));
                        } else if (type.equals(Double.TYPE)) {
                            value = Double.toString(field.getDouble(data));
                        } else if (type.equals(Character.TYPE)) {
                            value = String.valueOf(field.getChar(data));
                        } else {
                            if (!type.equals(Boolean.TYPE)) continue;
                            value = Boolean.toString(field.getBoolean(data));
                        }
                        break block25;
                    }
                    if (type.equals(String.class)) {
                        value = DefaultJDOMExternalizer.filterXMLCharacters((String)field.get(data));
                        break block25;
                    }
                    if (type.isEnum()) {
                        value = field.get(data).toString();
                        break block25;
                    }
                    if (type.equals(Color.class)) {
                        Color color = (Color)field.get(data);
                        if (color != null) {
                            value = Integer.toString(color.getRGB() & 0xFFFFFF, 16);
                        }
                        break block25;
                    }
                    if (ReflectionUtil.isAssignable(JDOMExternalizable.class, type)) {
                        element = new Element("option");
                        parentNode.addContent(element);
                        element.setAttribute("name", field.getName());
                        JDOMExternalizable domValue = (JDOMExternalizable)field.get(data);
                        if (domValue == null) continue;
                        Element valueElement = new Element("value");
                        element.addContent(valueElement);
                        domValue.writeExternal(valueElement);
                        continue;
                    }
                    LOG.debug("Wrong field type: " + type);
                }
                catch (IllegalAccessException e) {}
                continue;
            }
            element = new Element("option");
            parentNode.addContent(element);
            element.setAttribute("name", field.getName());
            if (value == null) continue;
            element.setAttribute("value", value);
        }
    }

    @Nullable
    static String filterXMLCharacters(@Nullable String value) {
        if (value == null) {
            return null;
        }
        StringBuilder builder = null;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (Verifier.isXMLCharacter(c)) {
                if (builder == null) continue;
                builder.append(c);
                continue;
            }
            if (builder != null) continue;
            builder = new StringBuilder(value.length() + 5);
            builder.append(value, 0, i);
        }
        if (builder != null) {
            value = builder.toString();
        }
        return value;
    }

    public static void readExternal(@NotNull Object data, Element parentNode) throws InvalidDataException {
        if (data == null) {
            DefaultJDOMExternalizer.$$$reportNull$$$0(6);
        }
        if (parentNode == null) {
            return;
        }
        Map<String, Field> fields = fieldCache.get(data.getClass());
        block12: for (Element e : parentNode.getChildren("option")) {
            String fieldName = e.getAttributeValue("name");
            if (fieldName == null) {
                throw new InvalidDataException();
            }
            try {
                Object value;
                Field field = fields.get(fieldName);
                if (field == null) continue;
                if (Modifier.isFinal(field.getModifiers())) {
                    value = field.get(data);
                    if (!(value instanceof JDOMExternalizable)) continue;
                    List<Element> children = e.getChildren("value");
                    Iterator<Element> iterator2 = children.iterator();
                    while (iterator2.hasNext()) {
                        Element child;
                        Element valueTag = child = iterator2.next();
                        ((JDOMExternalizable)value).readExternal(valueTag);
                    }
                    continue;
                }
                value = e.getAttributeValue("value");
                Class<?> type = field.getType();
                if (type.isPrimitive()) {
                    if (value == null) continue;
                    if (type.equals(Byte.TYPE)) {
                        try {
                            field.setByte(data, Byte.parseByte((String)value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type.equals(Short.TYPE)) {
                        try {
                            field.setShort(data, Short.parseShort((String)value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type.equals(Integer.TYPE)) {
                        int i = DefaultJDOMExternalizer.toInt((String)value);
                        field.setInt(data, i);
                        continue;
                    }
                    if (type.equals(Long.TYPE)) {
                        try {
                            field.setLong(data, Long.parseLong((String)value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type.equals(Float.TYPE)) {
                        try {
                            field.setFloat(data, Float.parseFloat((String)value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type.equals(Double.TYPE)) {
                        try {
                            field.setDouble(data, Double.parseDouble((String)value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type.equals(Character.TYPE)) {
                        if (((String)value).length() != 1) {
                            throw new InvalidDataException();
                        }
                        field.setChar(data, ((String)value).charAt(0));
                        continue;
                    }
                    if (type.equals(Boolean.TYPE)) {
                        if (((String)value).equals("true")) {
                            field.setBoolean(data, true);
                            continue;
                        }
                        if (((String)value).equals("false")) {
                            field.setBoolean(data, false);
                            continue;
                        }
                        throw new InvalidDataException();
                    }
                    throw new InvalidDataException();
                }
                if (type.isEnum()) {
                    for (Object enumValue : type.getEnumConstants()) {
                        if (!enumValue.toString().equals(value)) continue;
                        field.set(data, enumValue);
                        continue block12;
                    }
                    continue;
                }
                if (type.equals(String.class)) {
                    field.set(data, value);
                    continue;
                }
                if (type.equals(Color.class)) {
                    Color color = DefaultJDOMExternalizer.toColor((String)value);
                    field.set(data, color);
                    continue;
                }
                if (ReflectionUtil.isAssignable(JDOMExternalizable.class, type)) {
                    List<Element> children = e.getChildren("value");
                    if (children.isEmpty()) continue;
                    JDOMExternalizable object = null;
                    for (Element element : children) {
                        object = (JDOMExternalizable)type.newInstance();
                        object.readExternal(element);
                    }
                    field.set(data, object);
                    continue;
                }
                throw new InvalidDataException("wrong type: " + type);
            }
            catch (IllegalAccessException | InstantiationException | SecurityException ex) {
                throw new InvalidDataException(ex);
            }
        }
    }

    public static int toInt(@NotNull String value) throws InvalidDataException {
        int i;
        if (value == null) {
            DefaultJDOMExternalizer.$$$reportNull$$$0(7);
        }
        try {
            i = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new InvalidDataException(value, e);
        }
        return i;
    }

    public static Color toColor(@Nullable String value) {
        Color color;
        if (value == null) {
            return null;
        }
        try {
            int rgb = Integer.parseInt(value, 16);
            color = new Color(rgb);
        }
        catch (NumberFormatException e) {
            LOG.debug("Wrong color value: " + value, e);
            throw new InvalidDataException("Wrong color value: " + value, e);
        }
        return color;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/util/DefaultJDOMExternalizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "writeExternal";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "write";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "readExternal";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "toInt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface JDOMFilter {
        public boolean isAccept(@NotNull Field var1);
    }

    private static final class DefaultJDOMExternalizerMapClassValue
    extends ClassValue<Map<String, Field>> {
        private DefaultJDOMExternalizerMapClassValue() {
        }

        @Override
        protected Map<String, Field> computeValue(Class<?> type) {
            LinkedHashMap<String, Field> result = new LinkedHashMap<String, Field>();
            for (Field field : type.getFields()) {
                int modifiers;
                String name = field.getName();
                if (name.indexOf(36) >= 0 || result.containsKey(name) || !Modifier.isPublic(modifiers = field.getModifiers()) || Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers) || field.isAnnotationPresent(Transient.class)) continue;
                field.setAccessible(true);
                if (field.getDeclaringClass().isAnnotationPresent(Transient.class)) continue;
                result.put(name, field);
            }
            return result;
        }
    }
}

