/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.concurrency.ContextAwareCallable;
import com.intellij.concurrency.ContextAwareRunnable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.AppDelayQueue;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.AppScheduledExecutorService;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.concurrency.Propagation;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public class SchedulingWrapper
implements ScheduledExecutorService {
    private static final Logger LOG = Logger.getInstance(SchedulingWrapper.class);
    private final AtomicBoolean shutdown;
    @NotNull
    final ExecutorService backendExecutorService;
    final AppDelayQueue delayQueue;
    private final MyScheduledFutureTask<Void> myLaxativePill;
    private static final AtomicLong sequencer = new AtomicLong();

    SchedulingWrapper(@NotNull ExecutorService backendExecutorService, @NotNull AppDelayQueue delayQueue) {
        if (backendExecutorService == null) {
            SchedulingWrapper.$$$reportNull$$$0(0);
        }
        if (delayQueue == null) {
            SchedulingWrapper.$$$reportNull$$$0(1);
        }
        this.shutdown = new AtomicBoolean();
        this.myLaxativePill = new MyScheduledFutureTask<Void>(EmptyRunnable.getInstance(), null, 0L){

            @Override
            public void executeMeInBackendExecutor() {
                SchedulingWrapper.this.onDelayQueuePurgedOnShutdown();
                this.set(null);
            }

            @Override
            public String toString() {
                return "laxative for " + SchedulingWrapper.this;
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }
        };
        this.delayQueue = delayQueue;
        if (backendExecutorService instanceof ScheduledExecutorService) {
            throw new IllegalArgumentException("backendExecutorService: " + backendExecutorService + " is already ScheduledExecutorService");
        }
        this.backendExecutorService = backendExecutorService;
    }

    protected SchedulingWrapper(@NotNull ExecutorService backendExecutorService) {
        if (backendExecutorService == null) {
            SchedulingWrapper.$$$reportNull$$$0(2);
        }
        this(backendExecutorService, ((AppScheduledExecutorService)AppExecutorUtil.getAppScheduledExecutorService()).getDelayQueue());
    }

    @NotNull
    AppDelayQueue getDelayQueue() {
        AppDelayQueue appDelayQueue = this.delayQueue;
        if (appDelayQueue == null) {
            SchedulingWrapper.$$$reportNull$$$0(3);
        }
        return appDelayQueue;
    }

    @Override
    public @Unmodifiable @NotNull List<Runnable> shutdownNow() {
        List<Runnable> canceled = this.doShutdown(true);
        try {
            this.myLaxativePill.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        List<Runnable> list = canceled;
        if (list == null) {
            SchedulingWrapper.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    public void shutdown() {
        this.doShutdown(false);
    }

    @NotNull
    List<Runnable> doShutdown(boolean cancelBackendTasks) {
        if (!this.shutdown.compareAndSet(false, true)) {
            List<Runnable> list = Collections.emptyList();
            if (list == null) {
                SchedulingWrapper.$$$reportNull$$$0(5);
            }
            return list;
        }
        List<MyScheduledFutureTask<?>> toCancel = this.getMyTasksFromDelayQueue();
        for (MyScheduledFutureTask<?> task : toCancel) {
            task.cancel(false);
        }
        this.delayQueue.removeAll(toCancel);
        this.delayQueue.offer(this.myLaxativePill);
        List backEndCanceled = cancelBackendTasks && this.backendExecutorService instanceof BoundedTaskExecutor ? ((BoundedTaskExecutor)this.backendExecutorService).cancelAllQueuedTasks() : Collections.emptyList();
        List<Runnable> list = ContainerUtil.concat(toCancel, backEndCanceled);
        if (list == null) {
            SchedulingWrapper.$$$reportNull$$$0(6);
        }
        return list;
    }

    void onDelayQueuePurgedOnShutdown() {
    }

    @NotNull
    private List<MyScheduledFutureTask<?>> getMyTasksFromDelayQueue() {
        ArrayList result = new ArrayList();
        for (MyScheduledFutureTask task : this.delayQueue) {
            if (task.getBackendExecutorService() != this.backendExecutorService || task == this.myLaxativePill) continue;
            result.add(task);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            SchedulingWrapper.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown.get();
    }

    @Override
    public boolean isTerminated() {
        return this.isShutdown() && this.backendExecutorService.isTerminated() && this.getMyTasksFromDelayQueue().isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean awaitTermination(long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException {
        void unit;
        if (timeUnit == null) {
            SchedulingWrapper.$$$reportNull$$$0(8);
        }
        if (!this.isShutdown()) {
            throw new IllegalStateException("must await termination after shutdown() or shutdownNow() only");
        }
        long deadline = System.nanoTime() + unit.toNanos(timeout);
        try {
            this.myLaxativePill.get(deadline - System.nanoTime(), TimeUnit.NANOSECONDS);
        }
        catch (TimeoutException e) {
            return false;
        }
        catch (CancellationException | ExecutionException e) {
            // empty catch block
        }
        List<MyScheduledFutureTask<?>> tasks = this.getMyTasksFromDelayQueue();
        for (MyScheduledFutureTask<?> task : tasks) {
            try {
                task.get(deadline - System.nanoTime(), TimeUnit.NANOSECONDS);
            }
            catch (CancellationException | ExecutionException exception) {
            }
            catch (TimeoutException e) {
                return false;
            }
        }
        this.delayQueue.removeAll(tasks);
        return this.backendExecutorService.awaitTermination(deadline - System.nanoTime(), TimeUnit.NANOSECONDS);
    }

    protected void futureDone(@NotNull Future<?> task) {
        if (task == null) {
            SchedulingWrapper.$$$reportNull$$$0(9);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    protected long triggerTime(long delay, @NotNull TimeUnit timeUnit) {
        void unit;
        if (timeUnit == null) {
            SchedulingWrapper.$$$reportNull$$$0(10);
        }
        return this.triggerTime(unit.toNanos(delay < 0L ? 0L : delay));
    }

    private long triggerTime(long delay) {
        return System.nanoTime() + (delay < 0x3FFFFFFFFFFFFFFFL ? delay : this.overflowFree(delay));
    }

    private long overflowFree(long delay) {
        long headDelay;
        Object head = this.delayQueue.peek();
        if (head != null && (headDelay = head.getDelay(TimeUnit.NANOSECONDS)) < 0L && delay - headDelay < 0L) {
            delay = Long.MAX_VALUE + headDelay;
        }
        return delay;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ScheduledFuture<?> schedule(@NotNull Runnable command, long delay, @NotNull TimeUnit timeUnit) {
        void unit;
        if (command == null) {
            SchedulingWrapper.$$$reportNull$$$0(11);
        }
        if (timeUnit == null) {
            SchedulingWrapper.$$$reportNull$$$0(12);
        }
        ScheduledFuture<Object> scheduledFuture = this.schedule(SchedulingWrapper.callableFromRunnable(command), delay, (TimeUnit)unit);
        if (scheduledFuture == null) {
            SchedulingWrapper.$$$reportNull$$$0(13);
        }
        return scheduledFuture;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <V> ScheduledFuture<V> schedule(@NotNull Callable<V> callable, long delay, @NotNull TimeUnit timeUnit) {
        void unit;
        if (callable == null) {
            SchedulingWrapper.$$$reportNull$$$0(14);
        }
        if (timeUnit == null) {
            SchedulingWrapper.$$$reportNull$$$0(15);
        }
        MyScheduledFutureTask<V> myScheduledFutureTask = this.delayedExecute(this.createTask(callable, this.triggerTime(delay, (TimeUnit)unit)));
        if (myScheduledFutureTask == null) {
            SchedulingWrapper.$$$reportNull$$$0(16);
        }
        return myScheduledFutureTask;
    }

    private static @NotNull Callable<@Nullable Object> callableFromRunnable(@NotNull Runnable command) {
        if (command == null) {
            SchedulingWrapper.$$$reportNull$$$0(17);
        }
        if (command instanceof ContextAwareRunnable) {
            return new ContextAwareRunnableToCallableAdapter((ContextAwareRunnable)command);
        }
        Callable<Object> callable = Executors.callable(command);
        if (callable == null) {
            SchedulingWrapper.$$$reportNull$$$0(18);
        }
        return callable;
    }

    @NotNull
    private <V> MyScheduledFutureTask<V> createTask(@NotNull Callable<V> callable, long ns) {
        if (callable == null) {
            SchedulingWrapper.$$$reportNull$$$0(19);
        }
        if (!AppExecutorUtil.propagateContext()) {
            return new MyScheduledFutureTask<V>(callable, ns);
        }
        MyScheduledFutureTask myScheduledFutureTask = (MyScheduledFutureTask)Propagation.capturePropagationContext(this, callable, ns);
        if (myScheduledFutureTask == null) {
            SchedulingWrapper.$$$reportNull$$$0(20);
        }
        return myScheduledFutureTask;
    }

    @NotNull
    protected <T> MyScheduledFutureTask<T> delayedExecute(@NotNull MyScheduledFutureTask<T> t) {
        if (t == null) {
            SchedulingWrapper.$$$reportNull$$$0(21);
        }
        this.assertNotShutdown();
        this.delayQueue.offer(t);
        if (t.getDelay(TimeUnit.DAYS) > 31L && !t.isPeriodic()) {
            throw new IllegalArgumentException("Unsupported crazy delay " + t.getDelay(TimeUnit.DAYS) + " days: " + BoundedTaskExecutor.info(t));
        }
        MyScheduledFutureTask<T> myScheduledFutureTask = t;
        if (myScheduledFutureTask == null) {
            SchedulingWrapper.$$$reportNull$$$0(22);
        }
        return myScheduledFutureTask;
    }

    private void assertNotShutdown() {
        if (this.isShutdown()) {
            throw new RejectedExecutionException("Already shutdown");
        }
    }

    @Override
    @NotNull
    public ScheduledFuture<?> scheduleAtFixedRate(@NotNull Runnable command, long initialDelay, long period, @NotNull TimeUnit timeUnit) {
        if (command == null) {
            SchedulingWrapper.$$$reportNull$$$0(23);
        }
        if (timeUnit == null) {
            SchedulingWrapper.$$$reportNull$$$0(24);
        }
        throw new IncorrectOperationException("Not supported because it's bad for hibernation; use scheduleWithFixedDelay() with the same parameters instead.");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ScheduledFuture<?> scheduleWithFixedDelay(@NotNull Runnable command, long initialDelay, long delay, @NotNull TimeUnit timeUnit) {
        void unit;
        if (command == null) {
            SchedulingWrapper.$$$reportNull$$$0(25);
        }
        if (timeUnit == null) {
            SchedulingWrapper.$$$reportNull$$$0(26);
        }
        if (delay <= 0L) {
            throw new IllegalArgumentException("delay must be positive but got: " + delay);
        }
        MyScheduledFutureTask<?> myScheduledFutureTask = this.delayedExecute(this.createTask(command, this.triggerTime(initialDelay, (TimeUnit)unit), unit.toNanos(-delay)));
        if (myScheduledFutureTask == null) {
            SchedulingWrapper.$$$reportNull$$$0(27);
        }
        return myScheduledFutureTask;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private MyScheduledFutureTask<?> createTask(@NotNull Runnable command, long ns, long l) {
        void period;
        if (command == null) {
            SchedulingWrapper.$$$reportNull$$$0(28);
        }
        if (!AppExecutorUtil.propagateContext()) {
            return new MyScheduledFutureTask<Object>(command, null, ns, (long)period);
        }
        MyScheduledFutureTask myScheduledFutureTask = (MyScheduledFutureTask)Propagation.capturePropagationContext(this, command, ns, (long)period);
        if (myScheduledFutureTask == null) {
            SchedulingWrapper.$$$reportNull$$$0(29);
        }
        return myScheduledFutureTask;
    }

    @Override
    @NotNull
    public <T> Future<T> submit(@NotNull Callable<T> task) {
        if (task == null) {
            SchedulingWrapper.$$$reportNull$$$0(30);
        }
        this.assertNotShutdown();
        Future<T> future = this.backendExecutorService.submit(task);
        if (future == null) {
            SchedulingWrapper.$$$reportNull$$$0(31);
        }
        return future;
    }

    @Override
    @NotNull
    public <T> Future<T> submit(@NotNull Runnable task, T result) {
        if (task == null) {
            SchedulingWrapper.$$$reportNull$$$0(32);
        }
        this.assertNotShutdown();
        Future<T> future = this.backendExecutorService.submit(task, result);
        if (future == null) {
            SchedulingWrapper.$$$reportNull$$$0(33);
        }
        return future;
    }

    @Override
    @NotNull
    public Future<?> submit(@NotNull Runnable task) {
        if (task == null) {
            SchedulingWrapper.$$$reportNull$$$0(34);
        }
        this.assertNotShutdown();
        Future<?> future = this.backendExecutorService.submit(task);
        if (future == null) {
            SchedulingWrapper.$$$reportNull$$$0(35);
        }
        return future;
    }

    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> tasks) throws InterruptedException {
        if (tasks == null) {
            SchedulingWrapper.$$$reportNull$$$0(36);
        }
        this.assertNotShutdown();
        List list = this.backendExecutorService.invokeAll(tasks);
        if (list == null) {
            SchedulingWrapper.$$$reportNull$$$0(37);
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> tasks, long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException {
        void unit;
        if (tasks == null) {
            SchedulingWrapper.$$$reportNull$$$0(38);
        }
        if (timeUnit == null) {
            SchedulingWrapper.$$$reportNull$$$0(39);
        }
        this.assertNotShutdown();
        List list = this.backendExecutorService.invokeAll(tasks, timeout, (TimeUnit)unit);
        if (list == null) {
            SchedulingWrapper.$$$reportNull$$$0(40);
        }
        return list;
    }

    @Override
    @NotNull
    public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        if (tasks == null) {
            SchedulingWrapper.$$$reportNull$$$0(41);
        }
        this.assertNotShutdown();
        Object t = this.backendExecutorService.invokeAny(tasks);
        if (t == null) {
            SchedulingWrapper.$$$reportNull$$$0(42);
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> tasks, long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        void unit;
        if (tasks == null) {
            SchedulingWrapper.$$$reportNull$$$0(43);
        }
        if (timeUnit == null) {
            SchedulingWrapper.$$$reportNull$$$0(44);
        }
        this.assertNotShutdown();
        return this.backendExecutorService.invokeAny(tasks, timeout, (TimeUnit)unit);
    }

    @Override
    public void execute(@NotNull Runnable command) {
        if (command == null) {
            SchedulingWrapper.$$$reportNull$$$0(45);
        }
        this.assertNotShutdown();
        this.backendExecutorService.execute(command);
    }

    @TestOnly
    @ApiStatus.Internal
    public void assertTerminatedWithBackendExecutorInTests() {
        assert (this.isShutdown());
        assert (this.backendExecutorService.isTerminated()) : this.backendExecutorService;
        List<MyScheduledFutureTask<?>> tasks = this.getMyTasksFromDelayQueue();
        assert (tasks.isEmpty()) : tasks;
        assert (this.backendExecutorService instanceof BoundedTaskExecutor);
        assert (((BoundedTaskExecutor)this.backendExecutorService).isEmpty());
        String s = ((BoundedTaskExecutor)this.backendExecutorService).toString();
        assert (this.backendExecutorService.isTerminated()) : s;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 40: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 40: 
            case 42: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backendExecutorService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delayQueue";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/concurrency/SchedulingWrapper";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 24: 
            case 26: 
            case 39: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 9: 
            case 30: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 11: 
            case 17: 
            case 23: 
            case 25: 
            case 28: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 36: 
            case 38: 
            case 41: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/concurrency/SchedulingWrapper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelayQueue";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "shutdownNow";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "doShutdown";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMyTasksFromDelayQueue";
                break;
            }
            case 13: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "schedule";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "callableFromRunnable";
                break;
            }
            case 20: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createTask";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "delayedExecute";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "scheduleWithFixedDelay";
                break;
            }
            case 31: 
            case 33: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "submit";
                break;
            }
            case 37: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeAll";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeAny";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 40: 
            case 42: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "awaitTermination";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "futureDone";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "triggerTime";
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "schedule";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "callableFromRunnable";
                break;
            }
            case 19: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createTask";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "delayedExecute";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "scheduleAtFixedRate";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "scheduleWithFixedDelay";
                break;
            }
            case 30: 
            case 32: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "submit";
                break;
            }
            case 36: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "invokeAll";
                break;
            }
            case 41: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "invokeAny";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 40: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @ApiStatus.Internal
    protected class MyScheduledFutureTask<V>
    extends FutureTask<V>
    implements RunnableScheduledFuture<V>,
    ContextAwareRunnable {
        private final long sequenceNumber;
        private long time;
        private final long period;

        protected MyScheduledFutureTask(Runnable r, V result, long ns) {
            if (r == null) {
                MyScheduledFutureTask.$$$reportNull$$$0(0);
            }
            super(r, result);
            this.time = ns;
            this.period = 0L;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        /*
         * WARNING - void declaration
         */
        MyScheduledFutureTask(Runnable r, V result, long ns, long l) {
            void period;
            if (r == null) {
                MyScheduledFutureTask.$$$reportNull$$$0(1);
            }
            super(r, result);
            this.time = ns;
            this.period = period;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        MyScheduledFutureTask(Callable<V> callable, long ns) {
            if (callable == null) {
                MyScheduledFutureTask.$$$reportNull$$$0(2);
            }
            super(callable);
            this.time = ns;
            this.period = 0L;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean canceled = super.cancel(mayInterruptIfRunning);
            SchedulingWrapper.this.delayQueue.remove(this);
            return canceled;
        }

        @Override
        public long getDelay(@NotNull TimeUnit unit) {
            if (unit == null) {
                MyScheduledFutureTask.$$$reportNull$$$0(3);
            }
            return unit.convert(this.time - System.nanoTime(), TimeUnit.NANOSECONDS);
        }

        @Override
        public int compareTo(@NotNull Delayed other) {
            if (other == null) {
                MyScheduledFutureTask.$$$reportNull$$$0(4);
            }
            if (other == this) {
                return 0;
            }
            if (other instanceof MyScheduledFutureTask) {
                MyScheduledFutureTask x = (MyScheduledFutureTask)other;
                long diff = this.time - x.time;
                if (diff < 0L) {
                    return -1;
                }
                if (diff > 0L) {
                    return 1;
                }
                if (this.sequenceNumber < x.sequenceNumber) {
                    return -1;
                }
                return 1;
            }
            long diff = this.getDelay(TimeUnit.NANOSECONDS) - other.getDelay(TimeUnit.NANOSECONDS);
            return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
        }

        @Override
        public boolean isPeriodic() {
            return this.period != 0L;
        }

        private void setNextRunTime() {
            long p = this.period;
            this.time = p > 0L ? (this.time += p) : SchedulingWrapper.this.triggerTime(-p);
        }

        @Override
        public void run() {
            if (!this.isPeriodic()) {
                super.run();
                SchedulingWrapper.this.futureDone(this);
            } else if (this.runAndReset() && !SchedulingWrapper.this.isShutdown()) {
                this.setNextRunTime();
                SchedulingWrapper.this.delayQueue.offer(this);
                if (SchedulingWrapper.this.isShutdown()) {
                    SchedulingWrapper.this.delayQueue.remove(this);
                    this.cancel(false);
                }
            }
        }

        @Override
        protected void setException(Throwable t) {
            try {
                if (!Logger.shouldRethrow(t)) {
                    LOG.error(t);
                }
            }
            finally {
                super.setException(t);
            }
        }

        @Override
        public String toString() {
            Object info = BoundedTaskExecutor.info(this);
            return "Delay: " + this.getDelay(TimeUnit.MILLISECONDS) + "ms; " + (info == this ? super.toString() : info) + " backendExecutorService: " + SchedulingWrapper.this.backendExecutorService;
        }

        @NotNull
        private ExecutorService getBackendExecutorService() {
            ExecutorService executorService = SchedulingWrapper.this.backendExecutorService;
            if (executorService == null) {
                MyScheduledFutureTask.$$$reportNull$$$0(5);
            }
            return executorService;
        }

        public void executeMeInBackendExecutor() {
            if (!this.isDone()) {
                SchedulingWrapper.this.backendExecutorService.execute(this);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callable";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unit";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/concurrency/SchedulingWrapper$MyScheduledFutureTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/concurrency/SchedulingWrapper$MyScheduledFutureTask";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBackendExecutorService";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getDelay";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ContextAwareRunnableToCallableAdapter
    implements ContextAwareCallable<Object> {
        @NotNull
        private final ContextAwareRunnable myRunnable;

        ContextAwareRunnableToCallableAdapter(@NotNull ContextAwareRunnable runnable) {
            if (runnable == null) {
                ContextAwareRunnableToCallableAdapter.$$$reportNull$$$0(0);
            }
            this.myRunnable = runnable;
        }

        @Override
        @Nullable
        public Object call() {
            this.myRunnable.run();
            return null;
        }

        public String toString() {
            return "ContextAwareRunnableWrapper{myRunnable=" + this.myRunnable + '}';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/util/concurrency/SchedulingWrapper$ContextAwareRunnableToCallableAdapter", "<init>"));
        }
    }
}

