/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.DigestUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u0019\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0016\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b\u001a\u0010\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u0001H\u0002\u001a\u0006\u0010\u000b\u001a\u00020\b\u001a\u0006\u0010\u0013\u001a\u00020\b\u001a\u0006\u0010\u0016\u001a\u00020\b\u001a\u0006\u0010\u0019\u001a\u00020\b\u001a\u0010\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u000e\u0010\u001f\u001a\u00020\u00012\u0006\u0010 \u001a\u00020\u0006\"\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u000b\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\"\u001b\u0010\u0010\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u000f\u001a\u0004\b\u0011\u0010\r\"\u001b\u0010\u0013\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u000f\u001a\u0004\b\u0014\u0010\r\"\u001b\u0010\u0016\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u000f\u001a\u0004\b\u0017\u0010\r\"\u001b\u0010\u0019\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u000f\u001a\u0004\b\u001a\u0010\r\"\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"sha256Hex", "", "file", "Ljava/nio/file/Path;", "hashToHexString", "input", "", "digest", "Ljava/security/MessageDigest;", "sunSecurityProvider", "Ljava/security/Provider;", "sha2_512", "getSha2_512", "()Ljava/security/MessageDigest;", "sha2_512$delegate", "Lkotlin/Lazy;", "sha2_256", "getSha2_256", "sha2_256$delegate", "sha3_224", "getSha3_224", "sha3_224$delegate", "sha3_256", "getSha3_256", "sha3_256$delegate", "sha3_512", "getSha3_512", "sha3_512$delegate", "getMessageDigest", "algorithm", "cloneDigest", "bytesToHex", "data", "HEX_ARRAY", "", "intellij.platform.util"})
public final class DigestUtilKt {
    @NotNull
    private static final Provider sunSecurityProvider;
    @NotNull
    private static final Lazy sha2_512$delegate;
    @NotNull
    private static final Lazy sha2_256$delegate;
    @NotNull
    private static final Lazy sha3_224$delegate;
    @NotNull
    private static final Lazy sha3_256$delegate;
    @NotNull
    private static final Lazy sha3_512$delegate;
    @NotNull
    private static final char[] HEX_ARRAY;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String sha256Hex(@NotNull Path file) {
        Intrinsics.checkNotNullParameter(file, "file");
        try {
            MessageDigest digest = DigestUtilKt.cloneDigest(DigestUtilKt.getSha2_256());
            byte[] buffer = new byte[524288];
            Closeable closeable = Files.newInputStream(file, new OpenOption[0]);
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                DigestUtil.updateContentHash(digest, it, buffer);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
            byte[] byArray = digest.digest();
            Intrinsics.checkNotNullExpressionValue(byArray, "digest(...)");
            return DigestUtilKt.bytesToHex(byArray);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read " + file + ". " + e.getMessage(), e);
        }
    }

    @NotNull
    public static final String hashToHexString(@NotNull byte[] input, @NotNull MessageDigest digest) {
        Intrinsics.checkNotNullParameter(input, "input");
        Intrinsics.checkNotNullParameter(digest, "digest");
        byte[] byArray = digest.digest(input);
        Intrinsics.checkNotNullExpressionValue(byArray, "digest(...)");
        return DigestUtilKt.bytesToHex(byArray);
    }

    @NotNull
    public static final String hashToHexString(@NotNull String input, @NotNull MessageDigest digest) {
        Intrinsics.checkNotNullParameter(input, "input");
        Intrinsics.checkNotNullParameter(digest, "digest");
        String string = input;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        byte[] byArray2 = digest.digest(byArray);
        Intrinsics.checkNotNullExpressionValue(byArray2, "digest(...)");
        return DigestUtilKt.bytesToHex(byArray2);
    }

    private static final MessageDigest getSha2_512() {
        Lazy lazy = sha2_512$delegate;
        return (MessageDigest)lazy.getValue();
    }

    private static final MessageDigest getSha2_256() {
        Lazy lazy = sha2_256$delegate;
        return (MessageDigest)lazy.getValue();
    }

    private static final MessageDigest getSha3_224() {
        Lazy lazy = sha3_224$delegate;
        return (MessageDigest)lazy.getValue();
    }

    private static final MessageDigest getSha3_256() {
        Lazy lazy = sha3_256$delegate;
        return (MessageDigest)lazy.getValue();
    }

    private static final MessageDigest getSha3_512() {
        Lazy lazy = sha3_512$delegate;
        return (MessageDigest)lazy.getValue();
    }

    private static final MessageDigest getMessageDigest(String algorithm) {
        MessageDigest messageDigest = MessageDigest.getInstance(algorithm, sunSecurityProvider);
        Intrinsics.checkNotNullExpressionValue(messageDigest, "getInstance(...)");
        return messageDigest;
    }

    @NotNull
    public static final MessageDigest sha2_512() {
        return DigestUtilKt.cloneDigest(DigestUtilKt.getSha2_512());
    }

    @NotNull
    public static final MessageDigest sha3_224() {
        return DigestUtilKt.cloneDigest(DigestUtilKt.getSha3_224());
    }

    @NotNull
    public static final MessageDigest sha3_256() {
        return DigestUtilKt.cloneDigest(DigestUtilKt.getSha3_256());
    }

    @NotNull
    public static final MessageDigest sha3_512() {
        return DigestUtilKt.cloneDigest(DigestUtilKt.getSha3_512());
    }

    private static final MessageDigest cloneDigest(MessageDigest digest) {
        try {
            Object object = digest.clone();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type java.security.MessageDigest");
            return (MessageDigest)object;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException("Message digest is not cloneable: " + digest);
        }
    }

    @NotNull
    public static final String bytesToHex(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter(data, "data");
        int l = data.length;
        char[] chars = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            byte v = data[i];
            chars[j++] = HEX_ARRAY[(0xF0 & v) >>> 4];
            chars[j++] = HEX_ARRAY[0xF & v];
        }
        return new String(chars);
    }

    private static final MessageDigest sha2_512_delegate$lambda$0() {
        return DigestUtilKt.getMessageDigest("SHA-512");
    }

    private static final MessageDigest sha2_256_delegate$lambda$0() {
        return DigestUtilKt.getMessageDigest("SHA-256");
    }

    private static final MessageDigest sha3_224_delegate$lambda$0() {
        return DigestUtilKt.getMessageDigest("SHA3-224");
    }

    private static final MessageDigest sha3_256_delegate$lambda$0() {
        return DigestUtilKt.getMessageDigest("SHA3-256");
    }

    private static final MessageDigest sha3_512_delegate$lambda$0() {
        return DigestUtilKt.getMessageDigest("SHA3-512");
    }

    public static final /* synthetic */ MessageDigest access$cloneDigest(MessageDigest digest) {
        return DigestUtilKt.cloneDigest(digest);
    }

    public static final /* synthetic */ MessageDigest access$getSha2_256() {
        return DigestUtilKt.getSha2_256();
    }

    public static final /* synthetic */ MessageDigest access$getMessageDigest(String algorithm) {
        return DigestUtilKt.getMessageDigest(algorithm);
    }

    static {
        Provider provider = Security.getProvider("SUN");
        Intrinsics.checkNotNullExpressionValue(provider, "getProvider(...)");
        sunSecurityProvider = provider;
        sha2_512$delegate = LazyKt.lazy(LazyThreadSafetyMode.PUBLICATION, DigestUtilKt::sha2_512_delegate$lambda$0);
        sha2_256$delegate = LazyKt.lazy(LazyThreadSafetyMode.PUBLICATION, DigestUtilKt::sha2_256_delegate$lambda$0);
        sha3_224$delegate = LazyKt.lazy(LazyThreadSafetyMode.PUBLICATION, DigestUtilKt::sha3_224_delegate$lambda$0);
        sha3_256$delegate = LazyKt.lazy(LazyThreadSafetyMode.PUBLICATION, DigestUtilKt::sha3_256_delegate$lambda$0);
        sha3_512$delegate = LazyKt.lazy(LazyThreadSafetyMode.PUBLICATION, DigestUtilKt::sha3_512_delegate$lambda$0);
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        HEX_ARRAY = cArray;
    }
}

