/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.OnePixelSplitter;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0016\u0018\u0000 *2\u00020\u0001:\u0001*B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J6\u0010\u001e\u001a\u00020\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030 2\u0006\u0010!\u001a\u00020\u001b2\b\b\u0002\u0010\"\u001a\u00020\u00142\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001d0 H\u0002J\b\u0010$\u001a\u00020\u0005H\u0003J\b\u0010%\u001a\u00020\u0003H\u0002J\u0010\u0010&\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020\u0007H\u0016J\b\u0010(\u001a\u00020\u001dH\u0014J\b\u0010)\u001a\u00020\u001dH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u000e\u0010\u0019\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/openapi/ui/NonProportionalOnePixelSplitter;", "Lcom/intellij/ui/OnePixelSplitter;", "vertical", "", "proportionKey", "", "defaultProportion", "", "disposable", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(ZLjava/lang/String;FLcom/intellij/openapi/Disposable;Lcom/intellij/openapi/project/Project;)V", "propertiesComponent", "Lcom/intellij/ide/util/PropertiesComponent;", "kotlin.jvm.PlatformType", "getPropertiesComponent", "()Lcom/intellij/ide/util/PropertiesComponent;", "size", "", "getSize", "()I", "minSize", "getMinSize", "maxRetryCount", "addNotifyTimestamp", "", "addNotify", "", "invokeLaterWhen", "condition", "Lkotlin/Function0;", "timestamp", "count", "action", "dump", "checkSize", "setProportion", "proportion", "loadProportion", "saveProportion", "Companion", "intellij.platform.ide"})
@SourceDebugExtension(value={"SMAP\nNonProportionalOnePixelSplitter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NonProportionalOnePixelSplitter.kt\ncom/intellij/openapi/ui/NonProportionalOnePixelSplitter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,92:1\n13#2:93\n*S KotlinDebug\n*F\n+ 1 NonProportionalOnePixelSplitter.kt\ncom/intellij/openapi/ui/NonProportionalOnePixelSplitter\n*L\n23#1:93\n*E\n"})
public class NonProportionalOnePixelSplitter
extends OnePixelSplitter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String proportionKey;
    private final float defaultProportion;
    @NotNull
    private final Disposable disposable;
    @Nullable
    private final Project project;
    private int maxRetryCount;
    private long addNotifyTimestamp;
    @NotNull
    private static final Logger logger;

    public NonProportionalOnePixelSplitter(boolean vertical, @NonNls @NotNull String proportionKey, float defaultProportion, @NotNull Disposable disposable, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)proportionKey, (String)"proportionKey");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        super(vertical, proportionKey, defaultProportion);
        this.proportionKey = proportionKey;
        this.defaultProportion = defaultProportion;
        this.disposable = disposable;
        this.project = project;
        this.maxRetryCount = 100;
        Disposer.register((Disposable)this.disposable, () -> NonProportionalOnePixelSplitter._init_$lambda$0(this));
        this.setDividerPositionStrategy(Splitter.DividerPositionStrategy.KEEP_FIRST_SIZE);
    }

    public /* synthetic */ NonProportionalOnePixelSplitter(boolean bl, String string, float f, Disposable disposable, Project project, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            f = 0.5f;
        }
        this(bl, string, f, disposable, project);
    }

    private final PropertiesComponent getPropertiesComponent() {
        return this.project != null ? PropertiesComponent.getInstance((Project)this.project) : PropertiesComponent.getInstance();
    }

    private final int getSize() {
        return this.getOrientation() ? this.getHeight() : this.getWidth();
    }

    private final int getMinSize() {
        return this.getOrientation() ? this.getMinimumSize().height : this.getMinimumSize().width;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.setDividerPositionStrategy(Splitter.DividerPositionStrategy.KEEP_PROPORTION);
        ++this.addNotifyTimestamp;
        NonProportionalOnePixelSplitter.invokeLaterWhen$default(this, () -> NonProportionalOnePixelSplitter.addNotify$lambda$0(this), this.addNotifyTimestamp, 0, () -> NonProportionalOnePixelSplitter.addNotify$lambda$1(this), 4, null);
    }

    private final void invokeLaterWhen(Function0<Boolean> condition, long timestamp, int count, Function0<Unit> action) {
        if (this.addNotifyTimestamp != timestamp) {
            return;
        }
        SwingUtilities.invokeLater(() -> NonProportionalOnePixelSplitter.invokeLaterWhen$lambda$0(this, condition, action, count, timestamp));
    }

    static /* synthetic */ void invokeLaterWhen$default(NonProportionalOnePixelSplitter nonProportionalOnePixelSplitter, Function0 function0, long l, int n, Function0 function02, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: invokeLaterWhen");
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        nonProportionalOnePixelSplitter.invokeLaterWhen((Function0<Boolean>)function0, l, n, (Function0<Unit>)function02);
    }

    @NonNls
    private final String dump() {
        return this.getSize() + "=" + this.getSize() + ", minSize=" + this.getMinSize();
    }

    private final boolean checkSize() {
        return this.getSize() != 0 && this.getMinSize() < this.getSize();
    }

    @Override
    public void setProportion(float proportion) {
        if (proportion < 0.0f || proportion > 1.0f) {
            return;
        }
        super.setProportion(proportion);
    }

    @Override
    protected void loadProportion() {
        if (!StringUtil.isEmpty((String)this.proportionKey)) {
            this.setProportion(this.getPropertiesComponent().getFloat(this.proportionKey, this.myProportion));
        }
    }

    @Override
    public void saveProportion() {
        if (!StringUtil.isEmpty((String)this.proportionKey)) {
            this.getPropertiesComponent().setValue(this.proportionKey, this.myProportion, this.defaultProportion);
        }
    }

    private static final void _init_$lambda$0(NonProportionalOnePixelSplitter this$0) {
        this$0.saveProportion();
    }

    private static final boolean addNotify$lambda$0(NonProportionalOnePixelSplitter this$0) {
        return this$0.checkSize();
    }

    private static final Unit addNotify$lambda$1(NonProportionalOnePixelSplitter this$0) {
        this$0.loadProportion();
        this$0.setDividerPositionStrategy(Splitter.DividerPositionStrategy.KEEP_FIRST_SIZE);
        return Unit.INSTANCE;
    }

    private static final void invokeLaterWhen$lambda$0(NonProportionalOnePixelSplitter this$0, Function0 $condition, Function0 $action, int $count, long $timestamp) {
        if (Disposer.isDisposed((Disposable)this$0.disposable)) {
            return;
        }
        if (((Boolean)$condition.invoke()).booleanValue()) {
            $action.invoke();
        } else if ($count > this$0.maxRetryCount) {
            logger.error("Could not restore proportions in " + this$0.maxRetryCount + " times. " + this$0.dump());
            $action.invoke();
        } else {
            this$0.invokeLaterWhen((Function0<Boolean>)$condition, $timestamp, $count + 1, (Function0<Unit>)$action);
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(NonProportionalOnePixelSplitter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        NonProportionalOnePixelSplitter.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/ui/NonProportionalOnePixelSplitter$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.ide"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

