/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.client.ClientSystemInfo;
import com.intellij.openapi.ui.Divider;
import com.intellij.openapi.ui.Splittable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Weighted;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.MathUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OnePixelDivider
extends Divider {
    public static final Color BACKGROUND = JBColor.border();
    private boolean myVertical;
    private final Splittable mySplitter;
    private boolean myResizeEnabled;
    private boolean mySwitchOrientationEnabled;
    protected Point myPoint;
    private IdeGlassPane myGlassPane;
    private final MouseAdapter myListener = new MyMouseAdapter();
    private Disposable myDisposable;
    protected boolean myDragging = false;

    public OnePixelDivider(boolean vertical, Splittable splitter) {
        super((LayoutManager)new GridBagLayout());
        this.mySplitter = splitter;
        this.myResizeEnabled = true;
        this.mySwitchOrientationEnabled = false;
        this.setFocusable(false);
        this.enableEvents(48L);
        this.setOrientation(vertical);
        this.setBackground(BACKGROUND);
    }

    public void paint(Graphics g) {
        Insets insets;
        Supplier<Insets> blindZone;
        Rectangle bounds = g.getClipBounds();
        if (this.mySplitter instanceof OnePixelSplitter && (blindZone = ((OnePixelSplitter)this.mySplitter).getBlindZone()) != null && (insets = blindZone.get()) != null && bounds != null) {
            bounds.x += insets.left;
            bounds.y += insets.top;
            bounds.width -= insets.left + insets.right;
            bounds.height -= insets.top + insets.bottom;
            g.setColor(this.getBackground());
            g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
            return;
        }
        super.paint(g);
    }

    public void addNotify() {
        super.addNotify();
        this.init();
    }

    public void removeNotify() {
        if (this.myDisposable != null && !Disposer.isDisposed((Disposable)this.myDisposable)) {
            Disposer.dispose((Disposable)this.myDisposable);
        }
        this.myGlassPane = null;
        super.removeNotify();
    }

    private void setDragging(boolean dragging) {
        if (this.myDragging != dragging) {
            this.myDragging = dragging;
            this.mySplitter.setDragging(dragging);
        }
    }

    private boolean isBothComponentsVisibleAndOneOfComponentsShowing() {
        if (this.isShowing()) {
            return true;
        }
        if (this.mySplitter instanceof JBSplitter) {
            JComponent first = ((JBSplitter)this.mySplitter).getFirstComponent();
            JComponent second = ((JBSplitter)this.mySplitter).getSecondComponent();
            if (first == null || second == null || !first.isVisible() || !second.isVisible()) {
                return false;
            }
            if (first.isShowing()) {
                return true;
            }
            if (second.isShowing()) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    private MouseEvent getTargetEvent(MouseEvent e) {
        Component eventComponent = e.getComponent();
        if (eventComponent == null) {
            return null;
        }
        Component deepestComponentAt = UIUtil.getDeepestComponentAt((Component)eventComponent, (int)e.getX(), (int)e.getY());
        if (this.noDeepestComponent(e, deepestComponentAt)) {
            return null;
        }
        return SwingUtilities.convertMouseEvent(eventComponent, e, (Component)((Object)this));
    }

    protected boolean noDeepestComponent(@NotNull MouseEvent e, @Nullable Component deepestComponentAt) {
        if (e == null) {
            OnePixelDivider.$$$reportNull$$$0(0);
        }
        return deepestComponentAt == null || !SwingUtilities.isDescendingFrom(deepestComponentAt, this.getParent());
    }

    private void init() {
        this.myGlassPane = IdeGlassPaneUtil.find((Component)((Object)this));
        this.myDisposable = Disposer.newDisposable();
        Application application = ApplicationManager.getApplication();
        if (application != null) {
            Disposer.register((Disposable)application, (Disposable)this.myDisposable);
        }
        this.myGlassPane.addMouseMotionPreprocessor(this.myListener, this.myDisposable);
        this.myGlassPane.addMousePreprocessor(this.myListener, this.myDisposable);
    }

    public void setOrientation(boolean vertical) {
        this.removeAll();
        this.myVertical = vertical;
        int cursorType = this.isVertical() ? 8 : 10;
        UIUtil.setCursor((Component)((Object)this), (Cursor)Cursor.getPredefinedCursor(cursorType));
    }

    protected void processMouseMotionEvent(MouseEvent e) {
        super.processMouseMotionEvent(e);
        if (!this.myResizeEnabled) {
            return;
        }
        if (506 == e.getID() && this.myDragging) {
            float thickness;
            this.myPoint = SwingUtilities.convertPoint((Component)((Object)this), e.getPoint(), this.mySplitter.asComponent());
            float firstMinProportion = this.mySplitter.getMinProportion(true);
            float secondMinProportion = this.mySplitter.getMinProportion(false);
            Component comp = this.mySplitter.asComponent();
            float f = thickness = this.isVertical() ? (float)comp.getHeight() : (float)comp.getWidth();
            if (thickness == 0.0f) {
                thickness = 1.0f;
            }
            float position = this.isVertical() ? (float)this.myPoint.y : (float)this.myPoint.x;
            float ratio = position / thickness;
            float proportion = MathUtil.clamp((float)Math.min(Math.max(firstMinProportion, ratio), 1.0f - secondMinProportion), (float)0.0f, (float)1.0f);
            this.mySplitter.setProportion(proportion);
            e.consume();
        }
    }

    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        if (e.getID() == 500) {
            if (this.mySwitchOrientationEnabled && e.getClickCount() == 1 && SwingUtilities.isLeftMouseButton(e) && (ClientSystemInfo.isMac() ? e.isMetaDown() : e.isControlDown())) {
                this.mySplitter.setOrientation(!this.mySplitter.getOrientation());
            }
            if (this.myResizeEnabled && e.getClickCount() == 2) {
                this.mySplitter.setProportion(0.5f);
            }
        }
    }

    public void setResizeEnabled(boolean resizeEnabled) {
        this.myResizeEnabled = resizeEnabled;
        if (!this.myResizeEnabled) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        } else {
            this.setCursor(this.isVertical() ? Cursor.getPredefinedCursor(8) : Cursor.getPredefinedCursor(10));
        }
    }

    public void setSwitchOrientationEnabled(boolean switchOrientationEnabled) {
        this.mySwitchOrientationEnabled = switchOrientationEnabled;
    }

    public boolean isVertical() {
        return this.myVertical;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/ui/OnePixelDivider", "noDeepestComponent"));
    }

    private class MyMouseAdapter
    extends MouseAdapter
    implements Weighted {
        private MyMouseAdapter() {
        }

        private boolean skipEventProcessing() {
            if (OnePixelDivider.this.isBothComponentsVisibleAndOneOfComponentsShowing()) {
                return false;
            }
            OnePixelDivider.this.setDragging(false);
            OnePixelDivider.this.myGlassPane.setCursor(null, this);
            return true;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this.skipEventProcessing()) {
                return;
            }
            OnePixelDivider.this.setDragging(this.isInDragZone(e));
            this._processMouseEvent(e);
            if (OnePixelDivider.this.myDragging) {
                e.consume();
            }
        }

        boolean isInDragZone(MouseEvent e) {
            MouseEvent event = OnePixelDivider.this.getTargetEvent(e);
            if (event == null) {
                return false;
            }
            Point p = event.getPoint();
            boolean vertical = OnePixelDivider.this.isVertical();
            OnePixelDivider d = OnePixelDivider.this;
            if ((vertical ? p.x : p.y) < 0 || vertical && p.x > d.getWidth() || !vertical && p.y > d.getHeight()) {
                return false;
            }
            int r = Math.abs(vertical ? p.y : p.x);
            return r < JBUIScale.scale((int)Registry.intValue((String)"ide.splitter.mouseZone"));
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.skipEventProcessing()) {
                return;
            }
            this._processMouseEvent(e);
            if (OnePixelDivider.this.myDragging) {
                e.consume();
            }
            OnePixelDivider.this.setDragging(false);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (this.skipEventProcessing() || OnePixelDivider.this.getTargetEvent(e) == null) {
                return;
            }
            OnePixelDivider divider = OnePixelDivider.this;
            if (this.isInDragZone(e)) {
                OnePixelDivider.this.myGlassPane.setCursor(divider.getCursor(), (Object)divider);
            } else {
                OnePixelDivider.this.myGlassPane.setCursor(null, (Object)divider);
            }
            this._processMouseMotionEvent(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.skipEventProcessing()) {
                return;
            }
            this._processMouseMotionEvent(e);
        }

        @Override
        public double getWeight() {
            return 1.0;
        }

        private void _processMouseMotionEvent(MouseEvent e) {
            MouseEvent event = OnePixelDivider.this.getTargetEvent(e);
            if (event == null) {
                OnePixelDivider.this.myGlassPane.setCursor(null, OnePixelDivider.this.myListener);
                return;
            }
            OnePixelDivider.this.processMouseMotionEvent(event);
            if (event.isConsumed()) {
                e.consume();
            }
        }

        private void _processMouseEvent(MouseEvent e) {
            MouseEvent event = OnePixelDivider.this.getTargetEvent(e);
            if (event == null) {
                OnePixelDivider.this.myGlassPane.setCursor(null, OnePixelDivider.this.myListener);
                return;
            }
            OnePixelDivider.this.processMouseEvent(event);
            if (event.isConsumed()) {
                e.consume();
            }
        }
    }
}

