/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.Key;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckboxTreeListener;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0001 B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u001f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/ui/CheckboxTreeHelper;", "", "myCheckPolicy", "Lcom/intellij/ui/CheckboxTreeBase$CheckPolicy;", "myEventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/ui/CheckboxTreeListener;", "<init>", "(Lcom/intellij/ui/CheckboxTreeBase$CheckPolicy;Lcom/intellij/util/EventDispatcher;)V", "initTree", "", "tree", "Lcom/intellij/ui/treeStructure/Tree;", "mainComponent", "Ljavax/swing/JComponent;", "cellRenderer", "Lcom/intellij/ui/CheckboxTreeBase$CheckboxTreeCellRendererBase;", "setNodeState", "node", "Lcom/intellij/ui/CheckedTreeNode;", "checked", "", "toggleNode", "adjustParentsAndChildren", "changeNodeState", "uncheckChildren", "checkChildren", "setupKeyListener", "Ljava/awt/event/KeyListener;", "setupMouseListener", "Lcom/intellij/ui/ClickListener;", "removeTreeListeners", "Companion", "intellij.platform.ide"})
public final class CheckboxTreeHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CheckboxTreeBase.CheckPolicy myCheckPolicy;
    @NotNull
    private final EventDispatcher<CheckboxTreeListener> myEventDispatcher;
    @NotNull
    private static final Key<Runnable> TREE_LISTENERS_REMOVER;
    @JvmField
    @NotNull
    public static final CheckboxTreeBase.CheckPolicy DEFAULT_POLICY;

    public CheckboxTreeHelper(@NotNull CheckboxTreeBase.CheckPolicy myCheckPolicy, @NotNull EventDispatcher<CheckboxTreeListener> myEventDispatcher) {
        Intrinsics.checkNotNullParameter((Object)myCheckPolicy, (String)"myCheckPolicy");
        Intrinsics.checkNotNullParameter(myEventDispatcher, (String)"myEventDispatcher");
        this.myCheckPolicy = myCheckPolicy;
        this.myEventDispatcher = myEventDispatcher;
    }

    public final void initTree(@NotNull Tree tree, @NotNull JComponent mainComponent, @NotNull CheckboxTreeBase.CheckboxTreeCellRendererBase cellRenderer) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)mainComponent, (String)"mainComponent");
        Intrinsics.checkNotNullParameter((Object)cellRenderer, (String)"cellRenderer");
        this.removeTreeListeners(mainComponent);
        tree.setCellRenderer(cellRenderer);
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        TreeUtil.installActions(tree);
        KeyListener keyListener = this.setupKeyListener(tree, mainComponent);
        ClickListener clickListener = this.setupMouseListener(tree, mainComponent, cellRenderer);
        ComponentUtil.putClientProperty((JComponent)mainComponent, TREE_LISTENERS_REMOVER, () -> CheckboxTreeHelper.initTree$lambda$0(mainComponent, keyListener, clickListener));
    }

    public final void setNodeState(@NotNull Tree tree, @NotNull CheckedTreeNode node, boolean checked) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.changeNodeState(node, checked);
        this.adjustParentsAndChildren(node, checked);
        tree.repaint();
        TreeModel model = tree.getModel();
        model.valueForPathChanged(new TreePath(node.getPath()), node.getUserObject());
    }

    private final void toggleNode(Tree tree, CheckedTreeNode node) {
        this.setNodeState(tree, node, !node.isChecked());
    }

    private final void adjustParentsAndChildren(CheckedTreeNode node, boolean checked) {
        if (!checked) {
            if (this.myCheckPolicy.getUncheckParentWithUncheckedChild()) {
                for (TreeNode parent = node.getParent(); parent != null; parent = parent.getParent()) {
                    if (!(parent instanceof CheckedTreeNode)) continue;
                    this.changeNodeState((CheckedTreeNode)parent, false);
                }
            }
            if (this.myCheckPolicy.getUncheckChildrenWithUncheckedParent()) {
                this.uncheckChildren(node);
            }
        } else {
            if (this.myCheckPolicy.getCheckChildrenWithCheckedParent()) {
                this.checkChildren(node);
            }
            if (this.myCheckPolicy.getCheckParentWithCheckedChild()) {
                for (TreeNode parent = node.getParent(); parent != null; parent = parent.getParent()) {
                    if (!(parent instanceof CheckedTreeNode)) continue;
                    this.changeNodeState((CheckedTreeNode)parent, true);
                }
            }
        }
    }

    private final void changeNodeState(CheckedTreeNode node, boolean checked) {
        if (node.isChecked() != checked) {
            ((CheckboxTreeListener)this.myEventDispatcher.getMulticaster()).beforeNodeStateChanged(node);
            node.setChecked(checked);
            ((CheckboxTreeListener)this.myEventDispatcher.getMulticaster()).nodeStateChanged(node);
        }
    }

    private final void uncheckChildren(CheckedTreeNode node) {
        Enumeration enumeration = node.children();
        Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"children(...)");
        Enumeration children = enumeration;
        while (children.hasMoreElements()) {
            Object o = children.nextElement();
            if (!(o instanceof CheckedTreeNode)) continue;
            this.changeNodeState((CheckedTreeNode)o, false);
            this.uncheckChildren((CheckedTreeNode)o);
        }
    }

    private final void checkChildren(CheckedTreeNode node) {
        Enumeration enumeration = node.children();
        Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"children(...)");
        Enumeration children = enumeration;
        while (children.hasMoreElements()) {
            Object o = children.nextElement();
            if (!(o instanceof CheckedTreeNode)) continue;
            this.changeNodeState((CheckedTreeNode)o, true);
            this.checkChildren((CheckedTreeNode)o);
        }
    }

    private final KeyListener setupKeyListener(Tree tree, JComponent mainComponent) {
        KeyListener listener2 = new KeyAdapter(mainComponent, tree, this){
            final /* synthetic */ JComponent $mainComponent;
            final /* synthetic */ Tree $tree;
            final /* synthetic */ CheckboxTreeHelper this$0;
            {
                this.$mainComponent = $mainComponent;
                this.$tree = $tree;
                this.this$0 = $receiver;
            }

            public void keyPressed(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (CheckboxTreeHelper.Companion.isToggleEvent(e, this.$mainComponent)) {
                    Object o;
                    TreePath[] selectionPaths = this.$tree.getSelectionPaths();
                    if (selectionPaths == null || selectionPaths.length == 0) {
                        return;
                    }
                    TreePath treePath = this.$tree.getLeadSelectionPath();
                    if (treePath == null) {
                        return;
                    }
                    int nodesToChange = selectionPaths.length - 1;
                    if (!this.$tree.isPathSelected(treePath)) {
                        treePath = selectionPaths[nodesToChange];
                        --nodesToChange;
                    }
                    if (!((o = treePath.getLastPathComponent()) instanceof CheckedTreeNode)) {
                        return;
                    }
                    if (!((CheckedTreeNode)o).isEnabled()) {
                        return;
                    }
                    CheckboxTreeHelper.access$toggleNode(this.this$0, this.$tree, (CheckedTreeNode)o);
                    boolean checked = ((CheckedTreeNode)o).isChecked();
                    int i = 0;
                    int n = nodesToChange;
                    if (i <= n) {
                        while (true) {
                            TreePath selectionPath;
                            Object o1;
                            if ((o1 = (selectionPath = selectionPaths[i]).getLastPathComponent()) instanceof CheckedTreeNode) {
                                this.this$0.setNodeState(this.$tree, (CheckedTreeNode)o1, checked);
                            }
                            if (i == n) break;
                            ++i;
                        }
                    }
                    e.consume();
                }
            }
        };
        mainComponent.addKeyListener(listener2);
        return listener2;
    }

    private final ClickListener setupMouseListener(Tree tree, JComponent mainComponent, CheckboxTreeBase.CheckboxTreeCellRendererBase cellRenderer) {
        ClickListener listener2 = new ClickListener(tree, cellRenderer, this){
            final /* synthetic */ Tree $tree;
            final /* synthetic */ CheckboxTreeBase.CheckboxTreeCellRendererBase $cellRenderer;
            final /* synthetic */ CheckboxTreeHelper this$0;
            {
                this.$tree = $tree;
                this.$cellRenderer = $cellRenderer;
                this.this$0 = $receiver;
            }

            public boolean onClick(MouseEvent e, int clickCount) {
                Rectangle clickableArea;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int row = this.$tree.getRowForLocation(e.getX(), e.getY());
                if (row < 0) {
                    return false;
                }
                Object o = this.$tree.getPathForRow(row).getLastPathComponent();
                if (!(o instanceof CheckedTreeNode)) {
                    return false;
                }
                Rectangle rowBounds = this.$tree.getRowBounds(row);
                this.$cellRenderer.setBounds(rowBounds);
                this.$cellRenderer.validate();
                Rectangle checkBounds = this.$cellRenderer.myCheckbox.getBounds();
                checkBounds.setLocation(rowBounds.getLocation());
                if (checkBounds.height == 0) {
                    checkBounds.height = checkBounds.width = rowBounds.height;
                }
                Rectangle rectangle = clickableArea = CheckboxTreeHelper.access$getMyCheckPolicy$p(this.this$0).getCheckByRowClick() ? rowBounds : checkBounds;
                if (clickableArea.contains(e.getPoint()) && this.$cellRenderer.myCheckbox.isVisible()) {
                    if (((CheckedTreeNode)o).isEnabled()) {
                        CheckboxTreeHelper.access$toggleNode(this.this$0, this.$tree, (CheckedTreeNode)o);
                        this.$tree.setSelectionRow(row);
                        return true;
                    }
                } else if (clickCount > 1 && clickCount % 2 == 0) {
                    ((CheckboxTreeListener)CheckboxTreeHelper.access$getMyEventDispatcher$p(this.this$0).getMulticaster()).mouseDoubleClicked((CheckedTreeNode)o);
                    return true;
                }
                return false;
            }
        };
        listener2.installOn((Component)mainComponent);
        return listener2;
    }

    private final void removeTreeListeners(JComponent mainComponent) {
        block0: {
            Runnable runnable = (Runnable)ComponentUtil.getClientProperty((JComponent)mainComponent, TREE_LISTENERS_REMOVER);
            if (runnable == null) break block0;
            runnable.run();
        }
    }

    private static final void initTree$lambda$0(JComponent $mainComponent, KeyListener $keyListener, ClickListener $clickListener) {
        $mainComponent.removeKeyListener($keyListener);
        $clickListener.uninstall((Component)$mainComponent);
    }

    @JvmStatic
    public static final boolean isToggleEvent(@NotNull KeyEvent e, @NotNull JComponent mainComponent) {
        return Companion.isToggleEvent(e, mainComponent);
    }

    @JvmStatic
    @NotNull
    public static final <T> T[] getCheckedNodes(@NotNull Class<? extends T> nodeType, @Nullable Tree.NodeFilter<? super T> filter, @NotNull TreeModel model) {
        return Companion.getCheckedNodes(nodeType, filter, model);
    }

    public static final /* synthetic */ void access$toggleNode(CheckboxTreeHelper $this, Tree tree, CheckedTreeNode node) {
        $this.toggleNode(tree, node);
    }

    public static final /* synthetic */ CheckboxTreeBase.CheckPolicy access$getMyCheckPolicy$p(CheckboxTreeHelper $this) {
        return $this.myCheckPolicy;
    }

    public static final /* synthetic */ EventDispatcher access$getMyEventDispatcher$p(CheckboxTreeHelper $this) {
        return $this.myEventDispatcher;
    }

    static {
        Key key = Key.create((String)"TREE_LISTENERS_REMOVER");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        TREE_LISTENERS_REMOVER = key;
        DEFAULT_POLICY = new CheckboxTreeBase.CheckPolicy(true, true, false, true, false, 16, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007JC\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0013\"\u0004\b\u0000\u0010\u00142\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00140\u00162\u0010\u0010\u0017\u001a\f\u0012\u0006\b\u0000\u0012\u0002H\u0014\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0007\u00a2\u0006\u0002\u0010\u001bR!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000b\u0010\u0003\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ui/CheckboxTreeHelper$Companion;", "", "<init>", "()V", "TREE_LISTENERS_REMOVER", "Lcom/intellij/openapi/util/Key;", "Ljava/lang/Runnable;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "DEFAULT_POLICY", "Lcom/intellij/ui/CheckboxTreeBase$CheckPolicy;", "getDEFAULT_POLICY$annotations", "isToggleEvent", "", "e", "Ljava/awt/event/KeyEvent;", "mainComponent", "Ljavax/swing/JComponent;", "getCheckedNodes", "", "T", "nodeType", "Ljava/lang/Class;", "filter", "Lcom/intellij/ui/treeStructure/Tree$NodeFilter;", "model", "Ljavax/swing/tree/TreeModel;", "(Ljava/lang/Class;Lcom/intellij/ui/treeStructure/Tree$NodeFilter;Ljavax/swing/tree/TreeModel;)[Ljava/lang/Object;", "intellij.platform.ide"})
    public static final class Companion {
        private Companion() {
        }

        @Deprecated(message="This value has been special-cased to retain a defect, and should not be used for new code. See `PROPAGATE_EVERYTHING_POLICY` .see IJPL-199505")
        public static /* synthetic */ void getDEFAULT_POLICY$annotations() {
        }

        @JvmStatic
        public final boolean isToggleEvent(@NotNull KeyEvent e, @NotNull JComponent mainComponent) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)mainComponent, (String)"mainComponent");
            return e.getKeyCode() == 32 && SpeedSearchSupply.getSupply(mainComponent) == null;
        }

        @JvmStatic
        @NotNull
        public final <T> T[] getCheckedNodes(@NotNull Class<? extends T> nodeType, @Nullable Tree.NodeFilter<? super T> filter, @NotNull TreeModel model) {
            Intrinsics.checkNotNullParameter(nodeType, (String)"nodeType");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            ArrayList nodes = new ArrayList();
            Object root = model.getRoot();
            if (!(root instanceof CheckedTreeNode)) {
                boolean bl = false;
                String string = "The root must be instance of the " + CheckedTreeNode.class.getName() + ": " + root.getClass().getName();
                throw new IllegalStateException(string.toString());
            }
            new Object(nodeType, filter, nodes){
                final /* synthetic */ Class<? extends T> $nodeType;
                final /* synthetic */ Tree.NodeFilter<? super T> $filter;
                final /* synthetic */ ArrayList<T> $nodes;
                {
                    this.$nodeType = $nodeType;
                    this.$filter = $filter;
                    this.$nodes = $nodes;
                }

                public final void collect(CheckedTreeNode node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    if (node.isLeaf()) {
                        Object userObject = node.getUserObject();
                        if (node.isChecked() && userObject != null && this.$nodeType.isAssignableFrom(userObject.getClass())) {
                            Object value2 = userObject;
                            if (this.$filter != null && !this.$filter.accept(value2)) {
                                return;
                            }
                            this.$nodes.add(value2);
                        }
                    } else {
                        int n = node.getChildCount();
                        for (int i = 0; i < n; ++i) {
                            TreeNode child = node.getChildAt(i);
                            if (!(child instanceof CheckedTreeNode)) continue;
                            this.collect((CheckedTreeNode)child);
                        }
                    }
                }
            }.collect((CheckedTreeNode)root);
            Object[] objectArray = nodes.toArray(ArrayUtil.newArray(nodeType, (int)nodes.size()));
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"toArray(...)");
            return objectArray;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

